"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.styles = exports.Strict = exports.Same = exports.MatchStrict = exports.MatchOnly = exports.Match = exports.HasStrict = exports.Has = exports.Format = exports.matchStrict = exports.matchOnly = exports.match = exports.hasStrict = exports.has = exports.strict = exports.same = exports.format = void 0;
const format_js_1 = require("./format.js");
const has_js_1 = require("./has.js");
const has_strict_js_1 = require("./has-strict.js");
const match_js_1 = require("./match.js");
const match_only_js_1 = require("./match-only.js");
const match_strict_js_1 = require("./match-strict.js");
const same_js_1 = require("./same.js");
const strict_js_1 = require("./strict.js");
const simple = (o) => ({
    diff: o.print(),
    match: o.match,
});
const fn = (Cls) => (obj, pattern, options = {}) => simple(new Cls(obj, {
    ...options,
    expect: pattern,
    parent: undefined,
}));
const format = (obj, options = {}) => new format_js_1.Format(obj, options).print();
exports.format = format;
exports.same = fn(same_js_1.Same);
exports.strict = fn(strict_js_1.Strict);
exports.has = fn(has_js_1.Has);
exports.hasStrict = fn(has_strict_js_1.HasStrict);
exports.match = fn(match_js_1.Match);
exports.matchOnly = fn(match_only_js_1.MatchOnly);
exports.matchStrict = fn(match_strict_js_1.MatchStrict);
var format_js_2 = require("./format.js");
Object.defineProperty(exports, "Format", { enumerable: true, get: function () { return format_js_2.Format; } });
var has_js_2 = require("./has.js");
Object.defineProperty(exports, "Has", { enumerable: true, get: function () { return has_js_2.Has; } });
var has_strict_js_2 = require("./has-strict.js");
Object.defineProperty(exports, "HasStrict", { enumerable: true, get: function () { return has_strict_js_2.HasStrict; } });
var match_js_2 = require("./match.js");
Object.defineProperty(exports, "Match", { enumerable: true, get: function () { return match_js_2.Match; } });
var match_only_js_2 = require("./match-only.js");
Object.defineProperty(exports, "MatchOnly", { enumerable: true, get: function () { return match_only_js_2.MatchOnly; } });
var match_strict_js_2 = require("./match-strict.js");
Object.defineProperty(exports, "MatchStrict", { enumerable: true, get: function () { return match_strict_js_2.MatchStrict; } });
var same_js_2 = require("./same.js");
Object.defineProperty(exports, "Same", { enumerable: true, get: function () { return same_js_2.Same; } });
var strict_js_2 = require("./strict.js");
Object.defineProperty(exports, "Strict", { enumerable: true, get: function () { return strict_js_2.Strict; } });
var styles_js_1 = require("./styles.js");
Object.defineProperty(exports, "styles", { enumerable: true, get: function () { return styles_js_1.styles; } });
//# sourceMappingURL=index.js.map