"use strict";
var __getOwnPropNames = Object.getOwnPropertyNames;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};

// lib/core/symbols.js
var require_symbols = __commonJS({
  "lib/core/symbols.js"(exports2, module2) {
    module2.exports = {
      kClose: Symbol("close"),
      kDestroy: Symbol("destroy"),
      kDispatch: Symbol("dispatch"),
      kUrl: Symbol("url"),
      kWriting: Symbol("writing"),
      kResuming: Symbol("resuming"),
      kQueue: Symbol("queue"),
      kConnect: Symbol("connect"),
      kConnecting: Symbol("connecting"),
      kHeadersList: Symbol("headers list"),
      kKeepAliveDefaultTimeout: Symbol("default keep alive timeout"),
      kKeepAliveMaxTimeout: Symbol("max keep alive timeout"),
      kKeepAliveTimeoutThreshold: Symbol("keep alive timeout threshold"),
      kKeepAliveTimeoutValue: Symbol("keep alive timeout"),
      kKeepAlive: Symbol("keep alive"),
      kHeadersTimeout: Symbol("headers timeout"),
      kBodyTimeout: Symbol("body timeout"),
      kServerName: Symbol("server name"),
      kLocalAddress: Symbol("local address"),
      kHost: Symbol("host"),
      kNoRef: Symbol("no ref"),
      kBodyUsed: Symbol("used"),
      kRunning: Symbol("running"),
      kBlocking: Symbol("blocking"),
      kPending: Symbol("pending"),
      kSize: Symbol("size"),
      kBusy: Symbol("busy"),
      kQueued: Symbol("queued"),
      kFree: Symbol("free"),
      kConnected: Symbol("connected"),
      kClosed: Symbol("closed"),
      kNeedDrain: Symbol("need drain"),
      kReset: Symbol("reset"),
      kDestroyed: Symbol.for("nodejs.stream.destroyed"),
      kMaxHeadersSize: Symbol("max headers size"),
      kRunningIdx: Symbol("running index"),
      kPendingIdx: Symbol("pending index"),
      kError: Symbol("error"),
      kClients: Symbol("clients"),
      kClient: Symbol("client"),
      kParser: Symbol("parser"),
      kOnDestroyed: Symbol("destroy callbacks"),
      kPipelining: Symbol("pipelining"),
      kSocket: Symbol("socket"),
      kHostHeader: Symbol("host header"),
      kConnector: Symbol("connector"),
      kStrictContentLength: Symbol("strict content length"),
      kMaxRedirections: Symbol("maxRedirections"),
      kMaxRequests: Symbol("maxRequestsPerClient"),
      kProxy: Symbol("proxy agent options"),
      kCounter: Symbol("socket request counter"),
      kInterceptors: Symbol("dispatch interceptors"),
      kMaxResponseSize: Symbol("max response size"),
      kHTTP2Session: Symbol("http2Session"),
      kHTTP2SessionState: Symbol("http2Session state"),
      kHTTP2BuildRequest: Symbol("http2 build request"),
      kHTTP1BuildRequest: Symbol("http1 build request"),
      kHTTP2CopyHeaders: Symbol("http2 copy headers"),
      kHTTPConnVersion: Symbol("http connection version")
    };
  }
});

// lib/fetch/symbols.js
var require_symbols2 = __commonJS({
  "lib/fetch/symbols.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      kUrl: Symbol("url"),
      kHeaders: Symbol("headers"),
      kSignal: Symbol("signal"),
      kState: Symbol("state"),
      kGuard: Symbol("guard"),
      kRealm: Symbol("realm")
    };
  }
});

// lib/core/errors.js
var require_errors = __commonJS({
  "lib/core/errors.js"(exports2, module2) {
    "use strict";
    var UndiciError = class extends Error {
      constructor(message) {
        super(message);
        this.name = "UndiciError";
        this.code = "UND_ERR";
      }
    };
    var ConnectTimeoutError = class extends UndiciError {
      constructor(message) {
        super(message);
        Error.captureStackTrace(this, ConnectTimeoutError);
        this.name = "ConnectTimeoutError";
        this.message = message || "Connect Timeout Error";
        this.code = "UND_ERR_CONNECT_TIMEOUT";
      }
    };
    var HeadersTimeoutError = class extends UndiciError {
      constructor(message) {
        super(message);
        Error.captureStackTrace(this, HeadersTimeoutError);
        this.name = "HeadersTimeoutError";
        this.message = message || "Headers Timeout Error";
        this.code = "UND_ERR_HEADERS_TIMEOUT";
      }
    };
    var HeadersOverflowError = class extends UndiciError {
      constructor(message) {
        super(message);
        Error.captureStackTrace(this, HeadersOverflowError);
        this.name = "HeadersOverflowError";
        this.message = message || "Headers Overflow Error";
        this.code = "UND_ERR_HEADERS_OVERFLOW";
      }
    };
    var BodyTimeoutError = class extends UndiciError {
      constructor(message) {
        super(message);
        Error.captureStackTrace(this, BodyTimeoutError);
        this.name = "BodyTimeoutError";
        this.message = message || "Body Timeout Error";
        this.code = "UND_ERR_BODY_TIMEOUT";
      }
    };
    var ResponseStatusCodeError = class extends UndiciError {
      constructor(message, statusCode, headers, body) {
        super(message);
        Error.captureStackTrace(this, ResponseStatusCodeError);
        this.name = "ResponseStatusCodeError";
        this.message = message || "Response Status Code Error";
        this.code = "UND_ERR_RESPONSE_STATUS_CODE";
        this.body = body;
        this.status = statusCode;
        this.statusCode = statusCode;
        this.headers = headers;
      }
    };
    var InvalidArgumentError = class extends UndiciError {
      constructor(message) {
        super(message);
        Error.captureStackTrace(this, InvalidArgumentError);
        this.name = "InvalidArgumentError";
        this.message = message || "Invalid Argument Error";
        this.code = "UND_ERR_INVALID_ARG";
      }
    };
    var InvalidReturnValueError = class extends UndiciError {
      constructor(message) {
        super(message);
        Error.captureStackTrace(this, InvalidReturnValueError);
        this.name = "InvalidReturnValueError";
        this.message = message || "Invalid Return Value Error";
        this.code = "UND_ERR_INVALID_RETURN_VALUE";
      }
    };
    var RequestAbortedError = class extends UndiciError {
      constructor(message) {
        super(message);
        Error.captureStackTrace(this, RequestAbortedError);
        this.name = "AbortError";
        this.message = message || "Request aborted";
        this.code = "UND_ERR_ABORTED";
      }
    };
    var InformationalError = class extends UndiciError {
      constructor(message) {
        super(message);
        Error.captureStackTrace(this, InformationalError);
        this.name = "InformationalError";
        this.message = message || "Request information";
        this.code = "UND_ERR_INFO";
      }
    };
    var RequestContentLengthMismatchError = class extends UndiciError {
      constructor(message) {
        super(message);
        Error.captureStackTrace(this, RequestContentLengthMismatchError);
        this.name = "RequestContentLengthMismatchError";
        this.message = message || "Request body length does not match content-length header";
        this.code = "UND_ERR_REQ_CONTENT_LENGTH_MISMATCH";
      }
    };
    var ResponseContentLengthMismatchError = class extends UndiciError {
      constructor(message) {
        super(message);
        Error.captureStackTrace(this, ResponseContentLengthMismatchError);
        this.name = "ResponseContentLengthMismatchError";
        this.message = message || "Response body length does not match content-length header";
        this.code = "UND_ERR_RES_CONTENT_LENGTH_MISMATCH";
      }
    };
    var ClientDestroyedError = class extends UndiciError {
      constructor(message) {
        super(message);
        Error.captureStackTrace(this, ClientDestroyedError);
        this.name = "ClientDestroyedError";
        this.message = message || "The client is destroyed";
        this.code = "UND_ERR_DESTROYED";
      }
    };
    var ClientClosedError = class extends UndiciError {
      constructor(message) {
        super(message);
        Error.captureStackTrace(this, ClientClosedError);
        this.name = "ClientClosedError";
        this.message = message || "The client is closed";
        this.code = "UND_ERR_CLOSED";
      }
    };
    var SocketError = class extends UndiciError {
      constructor(message, socket) {
        super(message);
        Error.captureStackTrace(this, SocketError);
        this.name = "SocketError";
        this.message = message || "Socket error";
        this.code = "UND_ERR_SOCKET";
        this.socket = socket;
      }
    };
    var NotSupportedError = class extends UndiciError {
      constructor(message) {
        super(message);
        Error.captureStackTrace(this, NotSupportedError);
        this.name = "NotSupportedError";
        this.message = message || "Not supported error";
        this.code = "UND_ERR_NOT_SUPPORTED";
      }
    };
    var BalancedPoolMissingUpstreamError = class extends UndiciError {
      constructor(message) {
        super(message);
        Error.captureStackTrace(this, NotSupportedError);
        this.name = "MissingUpstreamError";
        this.message = message || "No upstream has been added to the BalancedPool";
        this.code = "UND_ERR_BPL_MISSING_UPSTREAM";
      }
    };
    var HTTPParserError = class extends Error {
      constructor(message, code, data) {
        super(message);
        Error.captureStackTrace(this, HTTPParserError);
        this.name = "HTTPParserError";
        this.code = code ? `HPE_${code}` : void 0;
        this.data = data ? data.toString() : void 0;
      }
    };
    var ResponseExceededMaxSizeError = class extends UndiciError {
      constructor(message) {
        super(message);
        Error.captureStackTrace(this, ResponseExceededMaxSizeError);
        this.name = "ResponseExceededMaxSizeError";
        this.message = message || "Response content exceeded max size";
        this.code = "UND_ERR_RES_EXCEEDED_MAX_SIZE";
      }
    };
    module2.exports = {
      HTTPParserError,
      UndiciError,
      HeadersTimeoutError,
      HeadersOverflowError,
      BodyTimeoutError,
      RequestContentLengthMismatchError,
      ConnectTimeoutError,
      ResponseStatusCodeError,
      InvalidArgumentError,
      InvalidReturnValueError,
      RequestAbortedError,
      ClientDestroyedError,
      ClientClosedError,
      InformationalError,
      SocketError,
      NotSupportedError,
      ResponseContentLengthMismatchError,
      BalancedPoolMissingUpstreamError,
      ResponseExceededMaxSizeError
    };
  }
});

// lib/core/util.js
var require_util = __commonJS({
  "lib/core/util.js"(exports2, module2) {
    "use strict";
    var assert = require("assert");
    var { kDestroyed, kBodyUsed } = require_symbols();
    var { IncomingMessage } = require("http");
    var stream = require("stream");
    var net = require("net");
    var { InvalidArgumentError } = require_errors();
    var { Blob: Blob2 } = require("buffer");
    var nodeUtil = require("util");
    var { stringify } = require("querystring");
    var [nodeMajor, nodeMinor] = process.versions.node.split(".").map((v) => Number(v));
    function nop() {
    }
    function isStream(obj) {
      return obj && typeof obj === "object" && typeof obj.pipe === "function" && typeof obj.on === "function";
    }
    function isBlobLike(object) {
      return Blob2 && object instanceof Blob2 || object && typeof object === "object" && (typeof object.stream === "function" || typeof object.arrayBuffer === "function") && /^(Blob|File)$/.test(object[Symbol.toStringTag]);
    }
    function buildURL(url, queryParams) {
      if (url.includes("?") || url.includes("#")) {
        throw new Error('Query params cannot be passed when url already contains "?" or "#".');
      }
      const stringified = stringify(queryParams);
      if (stringified) {
        url += "?" + stringified;
      }
      return url;
    }
    function parseURL(url) {
      if (typeof url === "string") {
        url = new URL(url);
        if (!/^https?:/.test(url.origin || url.protocol)) {
          throw new InvalidArgumentError("Invalid URL protocol: the URL must start with `http:` or `https:`.");
        }
        return url;
      }
      if (!url || typeof url !== "object") {
        throw new InvalidArgumentError("Invalid URL: The URL argument must be a non-null object.");
      }
      if (!/^https?:/.test(url.origin || url.protocol)) {
        throw new InvalidArgumentError("Invalid URL protocol: the URL must start with `http:` or `https:`.");
      }
      if (!(url instanceof URL)) {
        if (url.port != null && url.port !== "" && !Number.isFinite(parseInt(url.port))) {
          throw new InvalidArgumentError("Invalid URL: port must be a valid integer or a string representation of an integer.");
        }
        if (url.path != null && typeof url.path !== "string") {
          throw new InvalidArgumentError("Invalid URL path: the path must be a string or null/undefined.");
        }
        if (url.pathname != null && typeof url.pathname !== "string") {
          throw new InvalidArgumentError("Invalid URL pathname: the pathname must be a string or null/undefined.");
        }
        if (url.hostname != null && typeof url.hostname !== "string") {
          throw new InvalidArgumentError("Invalid URL hostname: the hostname must be a string or null/undefined.");
        }
        if (url.origin != null && typeof url.origin !== "string") {
          throw new InvalidArgumentError("Invalid URL origin: the origin must be a string or null/undefined.");
        }
        const port = url.port != null ? url.port : url.protocol === "https:" ? 443 : 80;
        let origin = url.origin != null ? url.origin : `${url.protocol}//${url.hostname}:${port}`;
        let path = url.path != null ? url.path : `${url.pathname || ""}${url.search || ""}`;
        if (origin.endsWith("/")) {
          origin = origin.substring(0, origin.length - 1);
        }
        if (path && !path.startsWith("/")) {
          path = `/${path}`;
        }
        url = new URL(origin + path);
      }
      return url;
    }
    function parseOrigin(url) {
      url = parseURL(url);
      if (url.pathname !== "/" || url.search || url.hash) {
        throw new InvalidArgumentError("invalid url");
      }
      return url;
    }
    function getHostname(host) {
      if (host[0] === "[") {
        const idx2 = host.indexOf("]");
        assert(idx2 !== -1);
        return host.substr(1, idx2 - 1);
      }
      const idx = host.indexOf(":");
      if (idx === -1)
        return host;
      return host.substr(0, idx);
    }
    function getServerName(host) {
      if (!host) {
        return null;
      }
      assert.strictEqual(typeof host, "string");
      const servername = getHostname(host);
      if (net.isIP(servername)) {
        return "";
      }
      return servername;
    }
    function deepClone(obj) {
      return JSON.parse(JSON.stringify(obj));
    }
    function isAsyncIterable(obj) {
      return !!(obj != null && typeof obj[Symbol.asyncIterator] === "function");
    }
    function isIterable(obj) {
      return !!(obj != null && (typeof obj[Symbol.iterator] === "function" || typeof obj[Symbol.asyncIterator] === "function"));
    }
    function bodyLength(body) {
      if (body == null) {
        return 0;
      } else if (isStream(body)) {
        const state = body._readableState;
        return state && state.objectMode === false && state.ended === true && Number.isFinite(state.length) ? state.length : null;
      } else if (isBlobLike(body)) {
        return body.size != null ? body.size : null;
      } else if (isBuffer(body)) {
        return body.byteLength;
      }
      return null;
    }
    function isDestroyed(stream2) {
      return !stream2 || !!(stream2.destroyed || stream2[kDestroyed]);
    }
    function isReadableAborted(stream2) {
      const state = stream2 && stream2._readableState;
      return isDestroyed(stream2) && state && !state.endEmitted;
    }
    function destroy(stream2, err) {
      if (!isStream(stream2) || isDestroyed(stream2)) {
        return;
      }
      if (typeof stream2.destroy === "function") {
        if (Object.getPrototypeOf(stream2).constructor === IncomingMessage) {
          stream2.socket = null;
        }
        stream2.destroy(err);
      } else if (err) {
        process.nextTick((stream3, err2) => {
          stream3.emit("error", err2);
        }, stream2, err);
      }
      if (stream2.destroyed !== true) {
        stream2[kDestroyed] = true;
      }
    }
    var KEEPALIVE_TIMEOUT_EXPR = /timeout=(\d+)/;
    function parseKeepAliveTimeout(val) {
      const m = val.toString().match(KEEPALIVE_TIMEOUT_EXPR);
      return m ? parseInt(m[1], 10) * 1e3 : null;
    }
    function parseHeaders(headers, obj = {}) {
      if (!Array.isArray(headers))
        return headers;
      for (let i = 0; i < headers.length; i += 2) {
        const key = headers[i].toString().toLowerCase();
        let val = obj[key];
        if (!val) {
          if (Array.isArray(headers[i + 1])) {
            obj[key] = headers[i + 1];
          } else {
            obj[key] = headers[i + 1].toString("utf8");
          }
        } else {
          if (!Array.isArray(val)) {
            val = [val];
            obj[key] = val;
          }
          val.push(headers[i + 1].toString("utf8"));
        }
      }
      if ("content-length" in obj && "content-disposition" in obj) {
        obj["content-disposition"] = Buffer.from(obj["content-disposition"]).toString("latin1");
      }
      return obj;
    }
    function parseRawHeaders(headers) {
      const ret = [];
      let hasContentLength = false;
      let contentDispositionIdx = -1;
      for (let n = 0; n < headers.length; n += 2) {
        const key = headers[n + 0].toString();
        const val = headers[n + 1].toString("utf8");
        if (key.length === 14 && (key === "content-length" || key.toLowerCase() === "content-length")) {
          ret.push(key, val);
          hasContentLength = true;
        } else if (key.length === 19 && (key === "content-disposition" || key.toLowerCase() === "content-disposition")) {
          contentDispositionIdx = ret.push(key, val) - 1;
        } else {
          ret.push(key, val);
        }
      }
      if (hasContentLength && contentDispositionIdx !== -1) {
        ret[contentDispositionIdx] = Buffer.from(ret[contentDispositionIdx]).toString("latin1");
      }
      return ret;
    }
    function isBuffer(buffer) {
      return buffer instanceof Uint8Array || Buffer.isBuffer(buffer);
    }
    function validateHandler(handler, method, upgrade) {
      if (!handler || typeof handler !== "object") {
        throw new InvalidArgumentError("handler must be an object");
      }
      if (typeof handler.onConnect !== "function") {
        throw new InvalidArgumentError("invalid onConnect method");
      }
      if (typeof handler.onError !== "function") {
        throw new InvalidArgumentError("invalid onError method");
      }
      if (typeof handler.onBodySent !== "function" && handler.onBodySent !== void 0) {
        throw new InvalidArgumentError("invalid onBodySent method");
      }
      if (upgrade || method === "CONNECT") {
        if (typeof handler.onUpgrade !== "function") {
          throw new InvalidArgumentError("invalid onUpgrade method");
        }
      } else {
        if (typeof handler.onHeaders !== "function") {
          throw new InvalidArgumentError("invalid onHeaders method");
        }
        if (typeof handler.onData !== "function") {
          throw new InvalidArgumentError("invalid onData method");
        }
        if (typeof handler.onComplete !== "function") {
          throw new InvalidArgumentError("invalid onComplete method");
        }
      }
    }
    function isDisturbed(body) {
      return !!(body && (stream.isDisturbed ? stream.isDisturbed(body) || body[kBodyUsed] : body[kBodyUsed] || body.readableDidRead || body._readableState && body._readableState.dataEmitted || isReadableAborted(body)));
    }
    function isErrored(body) {
      return !!(body && (stream.isErrored ? stream.isErrored(body) : /state: 'errored'/.test(
        nodeUtil.inspect(body)
      )));
    }
    function isReadable(body) {
      return !!(body && (stream.isReadable ? stream.isReadable(body) : /state: 'readable'/.test(
        nodeUtil.inspect(body)
      )));
    }
    function getSocketInfo(socket) {
      return {
        localAddress: socket.localAddress,
        localPort: socket.localPort,
        remoteAddress: socket.remoteAddress,
        remotePort: socket.remotePort,
        remoteFamily: socket.remoteFamily,
        timeout: socket.timeout,
        bytesWritten: socket.bytesWritten,
        bytesRead: socket.bytesRead
      };
    }
    async function* convertIterableToBuffer(iterable) {
      for await (const chunk of iterable) {
        yield Buffer.isBuffer(chunk) ? chunk : Buffer.from(chunk);
      }
    }
    var ReadableStream;
    function ReadableStreamFrom(iterable) {
      if (!ReadableStream) {
        ReadableStream = require("stream/web").ReadableStream;
      }
      if (ReadableStream.from) {
        return ReadableStream.from(convertIterableToBuffer(iterable));
      }
      let iterator;
      return new ReadableStream(
        {
          async start() {
            iterator = iterable[Symbol.asyncIterator]();
          },
          async pull(controller) {
            const { done, value } = await iterator.next();
            if (done) {
              queueMicrotask(() => {
                controller.close();
              });
            } else {
              const buf = Buffer.isBuffer(value) ? value : Buffer.from(value);
              controller.enqueue(new Uint8Array(buf));
            }
            return controller.desiredSize > 0;
          },
          async cancel(reason) {
            await iterator.return();
          }
        },
        0
      );
    }
    function isFormDataLike(object) {
      return object && typeof object === "object" && typeof object.append === "function" && typeof object.delete === "function" && typeof object.get === "function" && typeof object.getAll === "function" && typeof object.has === "function" && typeof object.set === "function" && object[Symbol.toStringTag] === "FormData";
    }
    function throwIfAborted(signal) {
      if (!signal) {
        return;
      }
      if (typeof signal.throwIfAborted === "function") {
        signal.throwIfAborted();
      } else {
        if (signal.aborted) {
          const err = new Error("The operation was aborted");
          err.name = "AbortError";
          throw err;
        }
      }
    }
    var events;
    function addAbortListener(signal, listener) {
      if (typeof Symbol.dispose === "symbol") {
        if (!events) {
          events = require("events");
        }
        if (typeof events.addAbortListener === "function" && "aborted" in signal) {
          return events.addAbortListener(signal, listener);
        }
      }
      if ("addEventListener" in signal) {
        signal.addEventListener("abort", listener, { once: true });
        return () => signal.removeEventListener("abort", listener);
      }
      signal.addListener("abort", listener);
      return () => signal.removeListener("abort", listener);
    }
    var hasToWellFormed = !!String.prototype.toWellFormed;
    function toUSVString(val) {
      if (hasToWellFormed) {
        return `${val}`.toWellFormed();
      } else if (nodeUtil.toUSVString) {
        return nodeUtil.toUSVString(val);
      }
      return `${val}`;
    }
    var kEnumerableProperty = /* @__PURE__ */ Object.create(null);
    kEnumerableProperty.enumerable = true;
    module2.exports = {
      kEnumerableProperty,
      nop,
      isDisturbed,
      isErrored,
      isReadable,
      toUSVString,
      isReadableAborted,
      isBlobLike,
      parseOrigin,
      parseURL,
      getServerName,
      isStream,
      isIterable,
      isAsyncIterable,
      isDestroyed,
      parseRawHeaders,
      parseHeaders,
      parseKeepAliveTimeout,
      destroy,
      bodyLength,
      deepClone,
      ReadableStreamFrom,
      isBuffer,
      validateHandler,
      getSocketInfo,
      isFormDataLike,
      buildURL,
      throwIfAborted,
      addAbortListener,
      nodeMajor,
      nodeMinor,
      nodeHasAutoSelectFamily: nodeMajor > 18 || nodeMajor === 18 && nodeMinor >= 13
    };
  }
});

// lib/fetch/constants.js
var require_constants = __commonJS({
  "lib/fetch/constants.js"(exports2, module2) {
    "use strict";
    var { MessageChannel, receiveMessageOnPort } = require("worker_threads");
    var corsSafeListedMethods = ["GET", "HEAD", "POST"];
    var nullBodyStatus = [101, 204, 205, 304];
    var redirectStatus = [301, 302, 303, 307, 308];
    var badPorts = [
      "1",
      "7",
      "9",
      "11",
      "13",
      "15",
      "17",
      "19",
      "20",
      "21",
      "22",
      "23",
      "25",
      "37",
      "42",
      "43",
      "53",
      "69",
      "77",
      "79",
      "87",
      "95",
      "101",
      "102",
      "103",
      "104",
      "109",
      "110",
      "111",
      "113",
      "115",
      "117",
      "119",
      "123",
      "135",
      "137",
      "139",
      "143",
      "161",
      "179",
      "389",
      "427",
      "465",
      "512",
      "513",
      "514",
      "515",
      "526",
      "530",
      "531",
      "532",
      "540",
      "548",
      "554",
      "556",
      "563",
      "587",
      "601",
      "636",
      "989",
      "990",
      "993",
      "995",
      "1719",
      "1720",
      "1723",
      "2049",
      "3659",
      "4045",
      "5060",
      "5061",
      "6000",
      "6566",
      "6665",
      "6666",
      "6667",
      "6668",
      "6669",
      "6697",
      "10080"
    ];
    var referrerPolicy = [
      "",
      "no-referrer",
      "no-referrer-when-downgrade",
      "same-origin",
      "origin",
      "strict-origin",
      "origin-when-cross-origin",
      "strict-origin-when-cross-origin",
      "unsafe-url"
    ];
    var requestRedirect = ["follow", "manual", "error"];
    var safeMethods = ["GET", "HEAD", "OPTIONS", "TRACE"];
    var requestMode = ["navigate", "same-origin", "no-cors", "cors"];
    var requestCredentials = ["omit", "same-origin", "include"];
    var requestCache = [
      "default",
      "no-store",
      "reload",
      "no-cache",
      "force-cache",
      "only-if-cached"
    ];
    var requestBodyHeader = [
      "content-encoding",
      "content-language",
      "content-location",
      "content-type",
      // See https://github.com/nodejs/undici/issues/2021
      // 'Content-Length' is a forbidden header name, which is typically
      // removed in the Headers implementation. However, undici doesn't
      // filter out headers, so we add it here.
      "content-length"
    ];
    var requestDuplex = [
      "half"
    ];
    var forbiddenMethods = ["CONNECT", "TRACE", "TRACK"];
    var subresource = [
      "audio",
      "audioworklet",
      "font",
      "image",
      "manifest",
      "paintworklet",
      "script",
      "style",
      "track",
      "video",
      "xslt",
      ""
    ];
    var DOMException = globalThis.DOMException ?? (() => {
      try {
        atob("~");
      } catch (err) {
        return Object.getPrototypeOf(err).constructor;
      }
    })();
    var channel;
    var structuredClone = globalThis.structuredClone ?? // https://github.com/nodejs/node/blob/b27ae24dcc4251bad726d9d84baf678d1f707fed/lib/internal/structured_clone.js
    // structuredClone was added in v17.0.0, but fetch supports v16.8
    function structuredClone2(value, options = void 0) {
      if (arguments.length === 0) {
        throw new TypeError("missing argument");
      }
      if (!channel) {
        channel = new MessageChannel();
      }
      channel.port1.unref();
      channel.port2.unref();
      channel.port1.postMessage(value, options?.transfer);
      return receiveMessageOnPort(channel.port2).message;
    };
    module2.exports = {
      DOMException,
      structuredClone,
      subresource,
      forbiddenMethods,
      requestBodyHeader,
      referrerPolicy,
      requestRedirect,
      requestMode,
      requestCredentials,
      requestCache,
      redirectStatus,
      corsSafeListedMethods,
      nullBodyStatus,
      safeMethods,
      badPorts,
      requestDuplex
    };
  }
});

// lib/fetch/global.js
var require_global = __commonJS({
  "lib/fetch/global.js"(exports2, module2) {
    "use strict";
    var globalOrigin = Symbol.for("undici.globalOrigin.1");
    function getGlobalOrigin() {
      return globalThis[globalOrigin];
    }
    function setGlobalOrigin(newOrigin) {
      if (newOrigin === void 0) {
        Object.defineProperty(globalThis, globalOrigin, {
          value: void 0,
          writable: true,
          enumerable: false,
          configurable: false
        });
        return;
      }
      const parsedURL = new URL(newOrigin);
      if (parsedURL.protocol !== "http:" && parsedURL.protocol !== "https:") {
        throw new TypeError(`Only http & https urls are allowed, received ${parsedURL.protocol}`);
      }
      Object.defineProperty(globalThis, globalOrigin, {
        value: parsedURL,
        writable: true,
        enumerable: false,
        configurable: false
      });
    }
    module2.exports = {
      getGlobalOrigin,
      setGlobalOrigin
    };
  }
});

// lib/fetch/util.js
var require_util2 = __commonJS({
  "lib/fetch/util.js"(exports2, module2) {
    "use strict";
    var { redirectStatus, badPorts, referrerPolicy: referrerPolicyTokens } = require_constants();
    var { getGlobalOrigin } = require_global();
    var { performance: performance2 } = require("perf_hooks");
    var { isBlobLike, toUSVString, ReadableStreamFrom } = require_util();
    var assert = require("assert");
    var { isUint8Array } = require("util/types");
    var crypto;
    try {
      crypto = require("crypto");
    } catch {
    }
    function responseURL(response) {
      const urlList = response.urlList;
      const length = urlList.length;
      return length === 0 ? null : urlList[length - 1].toString();
    }
    function responseLocationURL(response, requestFragment) {
      if (!redirectStatus.includes(response.status)) {
        return null;
      }
      let location = response.headersList.get("location");
      if (location !== null && isValidHeaderValue(location)) {
        location = new URL(location, responseURL(response));
      }
      if (location && !location.hash) {
        location.hash = requestFragment;
      }
      return location;
    }
    function requestCurrentURL(request) {
      return request.urlList[request.urlList.length - 1];
    }
    function requestBadPort(request) {
      const url = requestCurrentURL(request);
      if (urlIsHttpHttpsScheme(url) && badPorts.includes(url.port)) {
        return "blocked";
      }
      return "allowed";
    }
    function isErrorLike(object) {
      return object instanceof Error || (object?.constructor?.name === "Error" || object?.constructor?.name === "DOMException");
    }
    function isValidReasonPhrase(statusText) {
      for (let i = 0; i < statusText.length; ++i) {
        const c = statusText.charCodeAt(i);
        if (!(c === 9 || // HTAB
        c >= 32 && c <= 126 || // SP / VCHAR
        c >= 128 && c <= 255)) {
          return false;
        }
      }
      return true;
    }
    function isTokenChar(c) {
      return !(c >= 127 || c <= 32 || c === "(" || c === ")" || c === "<" || c === ">" || c === "@" || c === "," || c === ";" || c === ":" || c === "\\" || c === '"' || c === "/" || c === "[" || c === "]" || c === "?" || c === "=" || c === "{" || c === "}");
    }
    function isValidHTTPToken(characters) {
      if (!characters || typeof characters !== "string") {
        return false;
      }
      for (let i = 0; i < characters.length; ++i) {
        const c = characters.charCodeAt(i);
        if (c > 127 || !isTokenChar(c)) {
          return false;
        }
      }
      return true;
    }
    function isValidHeaderName(potentialValue) {
      if (potentialValue.length === 0) {
        return false;
      }
      return isValidHTTPToken(potentialValue);
    }
    function isValidHeaderValue(potentialValue) {
      if (potentialValue.startsWith("	") || potentialValue.startsWith(" ") || potentialValue.endsWith("	") || potentialValue.endsWith(" ")) {
        return false;
      }
      if (potentialValue.includes("\0") || potentialValue.includes("\r") || potentialValue.includes("\n")) {
        return false;
      }
      return true;
    }
    function setRequestReferrerPolicyOnRedirect(request, actualResponse) {
      const { headersList } = actualResponse;
      const policyHeader = (headersList.get("referrer-policy") ?? "").split(",");
      let policy = "";
      if (policyHeader.length > 0) {
        for (let i = policyHeader.length; i !== 0; i--) {
          const token = policyHeader[i - 1].trim();
          if (referrerPolicyTokens.includes(token)) {
            policy = token;
            break;
          }
        }
      }
      if (policy !== "") {
        request.referrerPolicy = policy;
      }
    }
    function crossOriginResourcePolicyCheck() {
      return "allowed";
    }
    function corsCheck() {
      return "success";
    }
    function TAOCheck() {
      return "success";
    }
    function appendFetchMetadata(httpRequest) {
      let header = null;
      header = httpRequest.mode;
      httpRequest.headersList.set("sec-fetch-mode", header);
    }
    function appendRequestOriginHeader(request) {
      let serializedOrigin = request.origin;
      if (request.responseTainting === "cors" || request.mode === "websocket") {
        if (serializedOrigin) {
          request.headersList.append("origin", serializedOrigin);
        }
      } else if (request.method !== "GET" && request.method !== "HEAD") {
        switch (request.referrerPolicy) {
          case "no-referrer":
            serializedOrigin = null;
            break;
          case "no-referrer-when-downgrade":
          case "strict-origin":
          case "strict-origin-when-cross-origin":
            if (request.origin && urlHasHttpsScheme(request.origin) && !urlHasHttpsScheme(requestCurrentURL(request))) {
              serializedOrigin = null;
            }
            break;
          case "same-origin":
            if (!sameOrigin(request, requestCurrentURL(request))) {
              serializedOrigin = null;
            }
            break;
          default:
        }
        if (serializedOrigin) {
          request.headersList.append("origin", serializedOrigin);
        }
      }
    }
    function coarsenedSharedCurrentTime(crossOriginIsolatedCapability) {
      return performance2.now();
    }
    function createOpaqueTimingInfo(timingInfo) {
      return {
        startTime: timingInfo.startTime ?? 0,
        redirectStartTime: 0,
        redirectEndTime: 0,
        postRedirectStartTime: timingInfo.startTime ?? 0,
        finalServiceWorkerStartTime: 0,
        finalNetworkResponseStartTime: 0,
        finalNetworkRequestStartTime: 0,
        endTime: 0,
        encodedBodySize: 0,
        decodedBodySize: 0,
        finalConnectionTimingInfo: null
      };
    }
    function makePolicyContainer() {
      return {
        referrerPolicy: "strict-origin-when-cross-origin"
      };
    }
    function clonePolicyContainer(policyContainer) {
      return {
        referrerPolicy: policyContainer.referrerPolicy
      };
    }
    function determineRequestsReferrer(request) {
      const policy = request.referrerPolicy;
      assert(policy);
      let referrerSource = null;
      if (request.referrer === "client") {
        const globalOrigin = getGlobalOrigin();
        if (!globalOrigin || globalOrigin.origin === "null") {
          return "no-referrer";
        }
        referrerSource = new URL(globalOrigin);
      } else if (request.referrer instanceof URL) {
        referrerSource = request.referrer;
      }
      let referrerURL = stripURLForReferrer(referrerSource);
      const referrerOrigin = stripURLForReferrer(referrerSource, true);
      if (referrerURL.toString().length > 4096) {
        referrerURL = referrerOrigin;
      }
      const areSameOrigin = sameOrigin(request, referrerURL);
      const isNonPotentiallyTrustWorthy = isURLPotentiallyTrustworthy(referrerURL) && !isURLPotentiallyTrustworthy(request.url);
      switch (policy) {
        case "origin":
          return referrerOrigin != null ? referrerOrigin : stripURLForReferrer(referrerSource, true);
        case "unsafe-url":
          return referrerURL;
        case "same-origin":
          return areSameOrigin ? referrerOrigin : "no-referrer";
        case "origin-when-cross-origin":
          return areSameOrigin ? referrerURL : referrerOrigin;
        case "strict-origin-when-cross-origin": {
          const currentURL = requestCurrentURL(request);
          if (sameOrigin(referrerURL, currentURL)) {
            return referrerURL;
          }
          if (isURLPotentiallyTrustworthy(referrerURL) && !isURLPotentiallyTrustworthy(currentURL)) {
            return "no-referrer";
          }
          return referrerOrigin;
        }
        case "strict-origin":
        case "no-referrer-when-downgrade":
        default:
          return isNonPotentiallyTrustWorthy ? "no-referrer" : referrerOrigin;
      }
    }
    function stripURLForReferrer(url, originOnly) {
      assert(url instanceof URL);
      if (url.protocol === "file:" || url.protocol === "about:" || url.protocol === "blank:") {
        return "no-referrer";
      }
      url.username = "";
      url.password = "";
      url.hash = "";
      if (originOnly) {
        url.pathname = "";
        url.search = "";
      }
      return url;
    }
    function isURLPotentiallyTrustworthy(url) {
      if (!(url instanceof URL)) {
        return false;
      }
      if (url.href === "about:blank" || url.href === "about:srcdoc") {
        return true;
      }
      if (url.protocol === "data:")
        return true;
      if (url.protocol === "file:")
        return true;
      return isOriginPotentiallyTrustworthy(url.origin);
      function isOriginPotentiallyTrustworthy(origin) {
        if (origin == null || origin === "null")
          return false;
        const originAsURL = new URL(origin);
        if (originAsURL.protocol === "https:" || originAsURL.protocol === "wss:") {
          return true;
        }
        if (/^127(?:\.[0-9]+){0,2}\.[0-9]+$|^\[(?:0*:)*?:?0*1\]$/.test(originAsURL.hostname) || (originAsURL.hostname === "localhost" || originAsURL.hostname.includes("localhost.")) || originAsURL.hostname.endsWith(".localhost")) {
          return true;
        }
        return false;
      }
    }
    function bytesMatch(bytes, metadataList) {
      if (crypto === void 0) {
        return true;
      }
      const parsedMetadata = parseMetadata(metadataList);
      if (parsedMetadata === "no metadata") {
        return true;
      }
      if (parsedMetadata.length === 0) {
        return true;
      }
      const list = parsedMetadata.sort((c, d) => d.algo.localeCompare(c.algo));
      const strongest = list[0].algo;
      const metadata = list.filter((item) => item.algo === strongest);
      for (const item of metadata) {
        const algorithm = item.algo;
        let expectedValue = item.hash;
        if (expectedValue.endsWith("==")) {
          expectedValue = expectedValue.slice(0, -2);
        }
        let actualValue = crypto.createHash(algorithm).update(bytes).digest("base64");
        if (actualValue.endsWith("==")) {
          actualValue = actualValue.slice(0, -2);
        }
        if (actualValue === expectedValue) {
          return true;
        }
        let actualBase64URL = crypto.createHash(algorithm).update(bytes).digest("base64url");
        if (actualBase64URL.endsWith("==")) {
          actualBase64URL = actualBase64URL.slice(0, -2);
        }
        if (actualBase64URL === expectedValue) {
          return true;
        }
      }
      return false;
    }
    var parseHashWithOptions = /((?<algo>sha256|sha384|sha512)-(?<hash>[A-z0-9+/]{1}.*={0,2}))( +[\x21-\x7e]?)?/i;
    function parseMetadata(metadata) {
      const result = [];
      let empty = true;
      const supportedHashes = crypto.getHashes();
      for (const token of metadata.split(" ")) {
        empty = false;
        const parsedToken = parseHashWithOptions.exec(token);
        if (parsedToken === null || parsedToken.groups === void 0) {
          continue;
        }
        const algorithm = parsedToken.groups.algo;
        if (supportedHashes.includes(algorithm.toLowerCase())) {
          result.push(parsedToken.groups);
        }
      }
      if (empty === true) {
        return "no metadata";
      }
      return result;
    }
    function tryUpgradeRequestToAPotentiallyTrustworthyURL(request) {
    }
    function sameOrigin(A, B) {
      if (A.origin === B.origin && A.origin === "null") {
        return true;
      }
      if (A.protocol === B.protocol && A.hostname === B.hostname && A.port === B.port) {
        return true;
      }
      return false;
    }
    function createDeferredPromise() {
      let res;
      let rej;
      const promise = new Promise((resolve, reject) => {
        res = resolve;
        rej = reject;
      });
      return { promise, resolve: res, reject: rej };
    }
    function isAborted(fetchParams) {
      return fetchParams.controller.state === "aborted";
    }
    function isCancelled(fetchParams) {
      return fetchParams.controller.state === "aborted" || fetchParams.controller.state === "terminated";
    }
    function normalizeMethod(method) {
      return /^(DELETE|GET|HEAD|OPTIONS|POST|PUT)$/i.test(method) ? method.toUpperCase() : method;
    }
    function serializeJavascriptValueToJSONString(value) {
      const result = JSON.stringify(value);
      if (result === void 0) {
        throw new TypeError("Value is not JSON serializable");
      }
      assert(typeof result === "string");
      return result;
    }
    var esIteratorPrototype = Object.getPrototypeOf(Object.getPrototypeOf([][Symbol.iterator]()));
    function makeIterator(iterator, name, kind) {
      const object = {
        index: 0,
        kind,
        target: iterator
      };
      const i = {
        next() {
          if (Object.getPrototypeOf(this) !== i) {
            throw new TypeError(
              `'next' called on an object that does not implement interface ${name} Iterator.`
            );
          }
          const { index, kind: kind2, target } = object;
          const values = target();
          const len = values.length;
          if (index >= len) {
            return { value: void 0, done: true };
          }
          const pair = values[index];
          object.index = index + 1;
          return iteratorResult(pair, kind2);
        },
        // The class string of an iterator prototype object for a given interface is the
        // result of concatenating the identifier of the interface and the string " Iterator".
        [Symbol.toStringTag]: `${name} Iterator`
      };
      Object.setPrototypeOf(i, esIteratorPrototype);
      return Object.setPrototypeOf({}, i);
    }
    function iteratorResult(pair, kind) {
      let result;
      switch (kind) {
        case "key": {
          result = pair[0];
          break;
        }
        case "value": {
          result = pair[1];
          break;
        }
        case "key+value": {
          result = pair;
          break;
        }
      }
      return { value: result, done: false };
    }
    async function fullyReadBody(body, processBody, processBodyError) {
      const successSteps = processBody;
      const errorSteps = processBodyError;
      let reader;
      try {
        reader = body.stream.getReader();
      } catch (e) {
        errorSteps(e);
        return;
      }
      try {
        const result = await readAllBytes(reader);
        successSteps(result);
      } catch (e) {
        errorSteps(e);
      }
    }
    var ReadableStream = globalThis.ReadableStream;
    function isReadableStreamLike(stream) {
      if (!ReadableStream) {
        ReadableStream = require("stream/web").ReadableStream;
      }
      return stream instanceof ReadableStream || stream[Symbol.toStringTag] === "ReadableStream" && typeof stream.tee === "function";
    }
    var MAXIMUM_ARGUMENT_LENGTH = 65535;
    function isomorphicDecode(input) {
      if (input.length < MAXIMUM_ARGUMENT_LENGTH) {
        return String.fromCharCode(...input);
      }
      return input.reduce((previous, current) => previous + String.fromCharCode(current), "");
    }
    function readableStreamClose(controller) {
      try {
        controller.close();
      } catch (err) {
        if (!err.message.includes("Controller is already closed")) {
          throw err;
        }
      }
    }
    function isomorphicEncode(input) {
      for (let i = 0; i < input.length; i++) {
        assert(input.charCodeAt(i) <= 255);
      }
      return input;
    }
    async function readAllBytes(reader) {
      const bytes = [];
      let byteLength = 0;
      while (true) {
        const { done, value: chunk } = await reader.read();
        if (done) {
          return Buffer.concat(bytes, byteLength);
        }
        if (!isUint8Array(chunk)) {
          throw new TypeError("Received non-Uint8Array chunk");
        }
        bytes.push(chunk);
        byteLength += chunk.length;
      }
    }
    function urlIsLocal(url) {
      assert("protocol" in url);
      const protocol = url.protocol;
      return protocol === "about:" || protocol === "blob:" || protocol === "data:";
    }
    function urlHasHttpsScheme(url) {
      if (typeof url === "string") {
        return url.startsWith("https:");
      }
      return url.protocol === "https:";
    }
    function urlIsHttpHttpsScheme(url) {
      assert("protocol" in url);
      const protocol = url.protocol;
      return protocol === "http:" || protocol === "https:";
    }
    var hasOwn = Object.hasOwn || ((dict, key) => Object.prototype.hasOwnProperty.call(dict, key));
    module2.exports = {
      isAborted,
      isCancelled,
      createDeferredPromise,
      ReadableStreamFrom,
      toUSVString,
      tryUpgradeRequestToAPotentiallyTrustworthyURL,
      coarsenedSharedCurrentTime,
      determineRequestsReferrer,
      makePolicyContainer,
      clonePolicyContainer,
      appendFetchMetadata,
      appendRequestOriginHeader,
      TAOCheck,
      corsCheck,
      crossOriginResourcePolicyCheck,
      createOpaqueTimingInfo,
      setRequestReferrerPolicyOnRedirect,
      isValidHTTPToken,
      requestBadPort,
      requestCurrentURL,
      responseURL,
      responseLocationURL,
      isBlobLike,
      isURLPotentiallyTrustworthy,
      isValidReasonPhrase,
      sameOrigin,
      normalizeMethod,
      serializeJavascriptValueToJSONString,
      makeIterator,
      isValidHeaderName,
      isValidHeaderValue,
      hasOwn,
      isErrorLike,
      fullyReadBody,
      bytesMatch,
      isReadableStreamLike,
      readableStreamClose,
      isomorphicEncode,
      isomorphicDecode,
      urlIsLocal,
      urlHasHttpsScheme,
      urlIsHttpHttpsScheme,
      readAllBytes
    };
  }
});

// lib/fetch/webidl.js
var require_webidl = __commonJS({
  "lib/fetch/webidl.js"(exports2, module2) {
    "use strict";
    var { types } = require("util");
    var { hasOwn, toUSVString } = require_util2();
    var webidl = {};
    webidl.converters = {};
    webidl.util = {};
    webidl.errors = {};
    webidl.errors.exception = function(message) {
      return new TypeError(`${message.header}: ${message.message}`);
    };
    webidl.errors.conversionFailed = function(context) {
      const plural = context.types.length === 1 ? "" : " one of";
      const message = `${context.argument} could not be converted to${plural}: ${context.types.join(", ")}.`;
      return webidl.errors.exception({
        header: context.prefix,
        message
      });
    };
    webidl.errors.invalidArgument = function(context) {
      return webidl.errors.exception({
        header: context.prefix,
        message: `"${context.value}" is an invalid ${context.type}.`
      });
    };
    webidl.brandCheck = function(V, I, opts = void 0) {
      if (opts?.strict !== false && !(V instanceof I)) {
        throw new TypeError("Illegal invocation");
      } else {
        return V?.[Symbol.toStringTag] === I.prototype[Symbol.toStringTag];
      }
    };
    webidl.argumentLengthCheck = function({ length }, min, ctx) {
      if (length < min) {
        throw webidl.errors.exception({
          message: `${min} argument${min !== 1 ? "s" : ""} required, but${length ? " only" : ""} ${length} found.`,
          ...ctx
        });
      }
    };
    webidl.illegalConstructor = function() {
      throw webidl.errors.exception({
        header: "TypeError",
        message: "Illegal constructor"
      });
    };
    webidl.util.Type = function(V) {
      switch (typeof V) {
        case "undefined":
          return "Undefined";
        case "boolean":
          return "Boolean";
        case "string":
          return "String";
        case "symbol":
          return "Symbol";
        case "number":
          return "Number";
        case "bigint":
          return "BigInt";
        case "function":
        case "object": {
          if (V === null) {
            return "Null";
          }
          return "Object";
        }
      }
    };
    webidl.util.ConvertToInt = function(V, bitLength, signedness, opts = {}) {
      let upperBound;
      let lowerBound;
      if (bitLength === 64) {
        upperBound = Math.pow(2, 53) - 1;
        if (signedness === "unsigned") {
          lowerBound = 0;
        } else {
          lowerBound = Math.pow(-2, 53) + 1;
        }
      } else if (signedness === "unsigned") {
        lowerBound = 0;
        upperBound = Math.pow(2, bitLength) - 1;
      } else {
        lowerBound = Math.pow(-2, bitLength) - 1;
        upperBound = Math.pow(2, bitLength - 1) - 1;
      }
      let x = Number(V);
      if (x === 0) {
        x = 0;
      }
      if (opts.enforceRange === true) {
        if (Number.isNaN(x) || x === Number.POSITIVE_INFINITY || x === Number.NEGATIVE_INFINITY) {
          throw webidl.errors.exception({
            header: "Integer conversion",
            message: `Could not convert ${V} to an integer.`
          });
        }
        x = webidl.util.IntegerPart(x);
        if (x < lowerBound || x > upperBound) {
          throw webidl.errors.exception({
            header: "Integer conversion",
            message: `Value must be between ${lowerBound}-${upperBound}, got ${x}.`
          });
        }
        return x;
      }
      if (!Number.isNaN(x) && opts.clamp === true) {
        x = Math.min(Math.max(x, lowerBound), upperBound);
        if (Math.floor(x) % 2 === 0) {
          x = Math.floor(x);
        } else {
          x = Math.ceil(x);
        }
        return x;
      }
      if (Number.isNaN(x) || x === 0 && Object.is(0, x) || x === Number.POSITIVE_INFINITY || x === Number.NEGATIVE_INFINITY) {
        return 0;
      }
      x = webidl.util.IntegerPart(x);
      x = x % Math.pow(2, bitLength);
      if (signedness === "signed" && x >= Math.pow(2, bitLength) - 1) {
        return x - Math.pow(2, bitLength);
      }
      return x;
    };
    webidl.util.IntegerPart = function(n) {
      const r = Math.floor(Math.abs(n));
      if (n < 0) {
        return -1 * r;
      }
      return r;
    };
    webidl.sequenceConverter = function(converter) {
      return (V) => {
        if (webidl.util.Type(V) !== "Object") {
          throw webidl.errors.exception({
            header: "Sequence",
            message: `Value of type ${webidl.util.Type(V)} is not an Object.`
          });
        }
        const method = V?.[Symbol.iterator]?.();
        const seq = [];
        if (method === void 0 || typeof method.next !== "function") {
          throw webidl.errors.exception({
            header: "Sequence",
            message: "Object is not an iterator."
          });
        }
        while (true) {
          const { done, value } = method.next();
          if (done) {
            break;
          }
          seq.push(converter(value));
        }
        return seq;
      };
    };
    webidl.recordConverter = function(keyConverter, valueConverter) {
      return (O) => {
        if (webidl.util.Type(O) !== "Object") {
          throw webidl.errors.exception({
            header: "Record",
            message: `Value of type ${webidl.util.Type(O)} is not an Object.`
          });
        }
        const result = {};
        if (!types.isProxy(O)) {
          const keys2 = Object.keys(O);
          for (const key of keys2) {
            const typedKey = keyConverter(key);
            const typedValue = valueConverter(O[key]);
            result[typedKey] = typedValue;
          }
          return result;
        }
        const keys = Reflect.ownKeys(O);
        for (const key of keys) {
          const desc = Reflect.getOwnPropertyDescriptor(O, key);
          if (desc?.enumerable) {
            const typedKey = keyConverter(key);
            const typedValue = valueConverter(O[key]);
            result[typedKey] = typedValue;
          }
        }
        return result;
      };
    };
    webidl.interfaceConverter = function(i) {
      return (V, opts = {}) => {
        if (opts.strict !== false && !(V instanceof i)) {
          throw webidl.errors.exception({
            header: i.name,
            message: `Expected ${V} to be an instance of ${i.name}.`
          });
        }
        return V;
      };
    };
    webidl.dictionaryConverter = function(converters) {
      return (dictionary) => {
        const type = webidl.util.Type(dictionary);
        const dict = {};
        if (type === "Null" || type === "Undefined") {
          return dict;
        } else if (type !== "Object") {
          throw webidl.errors.exception({
            header: "Dictionary",
            message: `Expected ${dictionary} to be one of: Null, Undefined, Object.`
          });
        }
        for (const options of converters) {
          const { key, defaultValue, required, converter } = options;
          if (required === true) {
            if (!hasOwn(dictionary, key)) {
              throw webidl.errors.exception({
                header: "Dictionary",
                message: `Missing required key "${key}".`
              });
            }
          }
          let value = dictionary[key];
          const hasDefault = hasOwn(options, "defaultValue");
          if (hasDefault && value !== null) {
            value = value ?? defaultValue;
          }
          if (required || hasDefault || value !== void 0) {
            value = converter(value);
            if (options.allowedValues && !options.allowedValues.includes(value)) {
              throw webidl.errors.exception({
                header: "Dictionary",
                message: `${value} is not an accepted type. Expected one of ${options.allowedValues.join(", ")}.`
              });
            }
            dict[key] = value;
          }
        }
        return dict;
      };
    };
    webidl.nullableConverter = function(converter) {
      return (V) => {
        if (V === null) {
          return V;
        }
        return converter(V);
      };
    };
    webidl.converters.DOMString = function(V, opts = {}) {
      if (V === null && opts.legacyNullToEmptyString) {
        return "";
      }
      if (typeof V === "symbol") {
        throw new TypeError("Could not convert argument of type symbol to string.");
      }
      return String(V);
    };
    webidl.converters.ByteString = function(V) {
      const x = webidl.converters.DOMString(V);
      for (let index = 0; index < x.length; index++) {
        const charCode = x.charCodeAt(index);
        if (charCode > 255) {
          throw new TypeError(
            `Cannot convert argument to a ByteString because the character at index ${index} has a value of ${charCode} which is greater than 255.`
          );
        }
      }
      return x;
    };
    webidl.converters.USVString = toUSVString;
    webidl.converters.boolean = function(V) {
      const x = Boolean(V);
      return x;
    };
    webidl.converters.any = function(V) {
      return V;
    };
    webidl.converters["long long"] = function(V) {
      const x = webidl.util.ConvertToInt(V, 64, "signed");
      return x;
    };
    webidl.converters["unsigned long long"] = function(V) {
      const x = webidl.util.ConvertToInt(V, 64, "unsigned");
      return x;
    };
    webidl.converters["unsigned long"] = function(V) {
      const x = webidl.util.ConvertToInt(V, 32, "unsigned");
      return x;
    };
    webidl.converters["unsigned short"] = function(V, opts) {
      const x = webidl.util.ConvertToInt(V, 16, "unsigned", opts);
      return x;
    };
    webidl.converters.ArrayBuffer = function(V, opts = {}) {
      if (webidl.util.Type(V) !== "Object" || !types.isAnyArrayBuffer(V)) {
        throw webidl.errors.conversionFailed({
          prefix: `${V}`,
          argument: `${V}`,
          types: ["ArrayBuffer"]
        });
      }
      if (opts.allowShared === false && types.isSharedArrayBuffer(V)) {
        throw webidl.errors.exception({
          header: "ArrayBuffer",
          message: "SharedArrayBuffer is not allowed."
        });
      }
      return V;
    };
    webidl.converters.TypedArray = function(V, T, opts = {}) {
      if (webidl.util.Type(V) !== "Object" || !types.isTypedArray(V) || V.constructor.name !== T.name) {
        throw webidl.errors.conversionFailed({
          prefix: `${T.name}`,
          argument: `${V}`,
          types: [T.name]
        });
      }
      if (opts.allowShared === false && types.isSharedArrayBuffer(V.buffer)) {
        throw webidl.errors.exception({
          header: "ArrayBuffer",
          message: "SharedArrayBuffer is not allowed."
        });
      }
      return V;
    };
    webidl.converters.DataView = function(V, opts = {}) {
      if (webidl.util.Type(V) !== "Object" || !types.isDataView(V)) {
        throw webidl.errors.exception({
          header: "DataView",
          message: "Object is not a DataView."
        });
      }
      if (opts.allowShared === false && types.isSharedArrayBuffer(V.buffer)) {
        throw webidl.errors.exception({
          header: "ArrayBuffer",
          message: "SharedArrayBuffer is not allowed."
        });
      }
      return V;
    };
    webidl.converters.BufferSource = function(V, opts = {}) {
      if (types.isAnyArrayBuffer(V)) {
        return webidl.converters.ArrayBuffer(V, opts);
      }
      if (types.isTypedArray(V)) {
        return webidl.converters.TypedArray(V, V.constructor);
      }
      if (types.isDataView(V)) {
        return webidl.converters.DataView(V, opts);
      }
      throw new TypeError(`Could not convert ${V} to a BufferSource.`);
    };
    webidl.converters["sequence<ByteString>"] = webidl.sequenceConverter(
      webidl.converters.ByteString
    );
    webidl.converters["sequence<sequence<ByteString>>"] = webidl.sequenceConverter(
      webidl.converters["sequence<ByteString>"]
    );
    webidl.converters["record<ByteString, ByteString>"] = webidl.recordConverter(
      webidl.converters.ByteString,
      webidl.converters.ByteString
    );
    module2.exports = {
      webidl
    };
  }
});

// lib/fetch/headers.js
var require_headers = __commonJS({
  "lib/fetch/headers.js"(exports2, module2) {
    "use strict";
    var { kHeadersList } = require_symbols();
    var { kGuard } = require_symbols2();
    var { kEnumerableProperty } = require_util();
    var {
      makeIterator,
      isValidHeaderName,
      isValidHeaderValue
    } = require_util2();
    var { webidl } = require_webidl();
    var assert = require("assert");
    var kHeadersMap = Symbol("headers map");
    var kHeadersSortedMap = Symbol("headers map sorted");
    function headerValueNormalize(potentialValue) {
      let i = potentialValue.length;
      while (/[\r\n\t ]/.test(potentialValue.charAt(--i)))
        ;
      return potentialValue.slice(0, i + 1).replace(/^[\r\n\t ]+/, "");
    }
    function fill(headers, object) {
      if (Array.isArray(object)) {
        for (const header of object) {
          if (header.length !== 2) {
            throw webidl.errors.exception({
              header: "Headers constructor",
              message: `expected name/value pair to be length 2, found ${header.length}.`
            });
          }
          headers.append(header[0], header[1]);
        }
      } else if (typeof object === "object" && object !== null) {
        for (const [key, value] of Object.entries(object)) {
          headers.append(key, value);
        }
      } else {
        throw webidl.errors.conversionFailed({
          prefix: "Headers constructor",
          argument: "Argument 1",
          types: ["sequence<sequence<ByteString>>", "record<ByteString, ByteString>"]
        });
      }
    }
    var HeadersList = class {
      /** @type {[string, string][]|null} */
      cookies = null;
      constructor(init) {
        if (init instanceof HeadersList) {
          this[kHeadersMap] = new Map(init[kHeadersMap]);
          this[kHeadersSortedMap] = init[kHeadersSortedMap];
          this.cookies = init.cookies;
        } else {
          this[kHeadersMap] = new Map(init);
          this[kHeadersSortedMap] = null;
        }
      }
      // https://fetch.spec.whatwg.org/#header-list-contains
      contains(name) {
        name = name.toLowerCase();
        return this[kHeadersMap].has(name);
      }
      clear() {
        this[kHeadersMap].clear();
        this[kHeadersSortedMap] = null;
        this.cookies = null;
      }
      // https://fetch.spec.whatwg.org/#concept-header-list-append
      append(name, value) {
        this[kHeadersSortedMap] = null;
        const lowercaseName = name.toLowerCase();
        const exists = this[kHeadersMap].get(lowercaseName);
        if (exists) {
          const delimiter = lowercaseName === "cookie" ? "; " : ", ";
          this[kHeadersMap].set(lowercaseName, {
            name: exists.name,
            value: `${exists.value}${delimiter}${value}`
          });
        } else {
          this[kHeadersMap].set(lowercaseName, { name, value });
        }
        if (lowercaseName === "set-cookie") {
          this.cookies ??= [];
          this.cookies.push(value);
        }
      }
      // https://fetch.spec.whatwg.org/#concept-header-list-set
      set(name, value) {
        this[kHeadersSortedMap] = null;
        const lowercaseName = name.toLowerCase();
        if (lowercaseName === "set-cookie") {
          this.cookies = [value];
        }
        return this[kHeadersMap].set(lowercaseName, { name, value });
      }
      // https://fetch.spec.whatwg.org/#concept-header-list-delete
      delete(name) {
        this[kHeadersSortedMap] = null;
        name = name.toLowerCase();
        if (name === "set-cookie") {
          this.cookies = null;
        }
        return this[kHeadersMap].delete(name);
      }
      // https://fetch.spec.whatwg.org/#concept-header-list-get
      get(name) {
        if (!this.contains(name)) {
          return null;
        }
        return this[kHeadersMap].get(name.toLowerCase())?.value ?? null;
      }
      *[Symbol.iterator]() {
        for (const [name, { value }] of this[kHeadersMap]) {
          yield [name, value];
        }
      }
      get entries() {
        const headers = {};
        if (this[kHeadersMap].size) {
          for (const { name, value } of this[kHeadersMap].values()) {
            headers[name] = value;
          }
        }
        return headers;
      }
    };
    var Headers = class {
      constructor(init = void 0) {
        this[kHeadersList] = new HeadersList();
        this[kGuard] = "none";
        if (init !== void 0) {
          init = webidl.converters.HeadersInit(init);
          fill(this, init);
        }
      }
      // https://fetch.spec.whatwg.org/#dom-headers-append
      append(name, value) {
        webidl.brandCheck(this, Headers);
        webidl.argumentLengthCheck(arguments, 2, { header: "Headers.append" });
        name = webidl.converters.ByteString(name);
        value = webidl.converters.ByteString(value);
        value = headerValueNormalize(value);
        if (!isValidHeaderName(name)) {
          throw webidl.errors.invalidArgument({
            prefix: "Headers.append",
            value: name,
            type: "header name"
          });
        } else if (!isValidHeaderValue(value)) {
          throw webidl.errors.invalidArgument({
            prefix: "Headers.append",
            value,
            type: "header value"
          });
        }
        if (this[kGuard] === "immutable") {
          throw new TypeError("immutable");
        } else if (this[kGuard] === "request-no-cors") {
        }
        return this[kHeadersList].append(name, value);
      }
      // https://fetch.spec.whatwg.org/#dom-headers-delete
      delete(name) {
        webidl.brandCheck(this, Headers);
        webidl.argumentLengthCheck(arguments, 1, { header: "Headers.delete" });
        name = webidl.converters.ByteString(name);
        if (!isValidHeaderName(name)) {
          throw webidl.errors.invalidArgument({
            prefix: "Headers.delete",
            value: name,
            type: "header name"
          });
        }
        if (this[kGuard] === "immutable") {
          throw new TypeError("immutable");
        } else if (this[kGuard] === "request-no-cors") {
        }
        if (!this[kHeadersList].contains(name)) {
          return;
        }
        return this[kHeadersList].delete(name);
      }
      // https://fetch.spec.whatwg.org/#dom-headers-get
      get(name) {
        webidl.brandCheck(this, Headers);
        webidl.argumentLengthCheck(arguments, 1, { header: "Headers.get" });
        name = webidl.converters.ByteString(name);
        if (!isValidHeaderName(name)) {
          throw webidl.errors.invalidArgument({
            prefix: "Headers.get",
            value: name,
            type: "header name"
          });
        }
        return this[kHeadersList].get(name);
      }
      // https://fetch.spec.whatwg.org/#dom-headers-has
      has(name) {
        webidl.brandCheck(this, Headers);
        webidl.argumentLengthCheck(arguments, 1, { header: "Headers.has" });
        name = webidl.converters.ByteString(name);
        if (!isValidHeaderName(name)) {
          throw webidl.errors.invalidArgument({
            prefix: "Headers.has",
            value: name,
            type: "header name"
          });
        }
        return this[kHeadersList].contains(name);
      }
      // https://fetch.spec.whatwg.org/#dom-headers-set
      set(name, value) {
        webidl.brandCheck(this, Headers);
        webidl.argumentLengthCheck(arguments, 2, { header: "Headers.set" });
        name = webidl.converters.ByteString(name);
        value = webidl.converters.ByteString(value);
        value = headerValueNormalize(value);
        if (!isValidHeaderName(name)) {
          throw webidl.errors.invalidArgument({
            prefix: "Headers.set",
            value: name,
            type: "header name"
          });
        } else if (!isValidHeaderValue(value)) {
          throw webidl.errors.invalidArgument({
            prefix: "Headers.set",
            value,
            type: "header value"
          });
        }
        if (this[kGuard] === "immutable") {
          throw new TypeError("immutable");
        } else if (this[kGuard] === "request-no-cors") {
        }
        return this[kHeadersList].set(name, value);
      }
      // https://fetch.spec.whatwg.org/#dom-headers-getsetcookie
      getSetCookie() {
        webidl.brandCheck(this, Headers);
        const list = this[kHeadersList].cookies;
        if (list) {
          return [...list];
        }
        return [];
      }
      // https://fetch.spec.whatwg.org/#concept-header-list-sort-and-combine
      get [kHeadersSortedMap]() {
        if (this[kHeadersList][kHeadersSortedMap]) {
          return this[kHeadersList][kHeadersSortedMap];
        }
        const headers = [];
        const names = [...this[kHeadersList]].sort((a, b) => a[0] < b[0] ? -1 : 1);
        const cookies = this[kHeadersList].cookies;
        for (const [name, value] of names) {
          if (name === "set-cookie") {
            for (const value2 of cookies) {
              headers.push([name, value2]);
            }
          } else {
            assert(value !== null);
            headers.push([name, value]);
          }
        }
        this[kHeadersList][kHeadersSortedMap] = headers;
        return headers;
      }
      keys() {
        webidl.brandCheck(this, Headers);
        return makeIterator(
          () => [...this[kHeadersSortedMap].values()],
          "Headers",
          "key"
        );
      }
      values() {
        webidl.brandCheck(this, Headers);
        return makeIterator(
          () => [...this[kHeadersSortedMap].values()],
          "Headers",
          "value"
        );
      }
      entries() {
        webidl.brandCheck(this, Headers);
        return makeIterator(
          () => [...this[kHeadersSortedMap].values()],
          "Headers",
          "key+value"
        );
      }
      /**
       * @param {(value: string, key: string, self: Headers) => void} callbackFn
       * @param {unknown} thisArg
       */
      forEach(callbackFn, thisArg = globalThis) {
        webidl.brandCheck(this, Headers);
        webidl.argumentLengthCheck(arguments, 1, { header: "Headers.forEach" });
        if (typeof callbackFn !== "function") {
          throw new TypeError(
            "Failed to execute 'forEach' on 'Headers': parameter 1 is not of type 'Function'."
          );
        }
        for (const [key, value] of this) {
          callbackFn.apply(thisArg, [value, key, this]);
        }
      }
      [Symbol.for("nodejs.util.inspect.custom")]() {
        webidl.brandCheck(this, Headers);
        return this[kHeadersList];
      }
    };
    Headers.prototype[Symbol.iterator] = Headers.prototype.entries;
    Object.defineProperties(Headers.prototype, {
      append: kEnumerableProperty,
      delete: kEnumerableProperty,
      get: kEnumerableProperty,
      has: kEnumerableProperty,
      set: kEnumerableProperty,
      getSetCookie: kEnumerableProperty,
      keys: kEnumerableProperty,
      values: kEnumerableProperty,
      entries: kEnumerableProperty,
      forEach: kEnumerableProperty,
      [Symbol.iterator]: { enumerable: false },
      [Symbol.toStringTag]: {
        value: "Headers",
        configurable: true
      }
    });
    webidl.converters.HeadersInit = function(V) {
      if (webidl.util.Type(V) === "Object") {
        if (V[Symbol.iterator]) {
          return webidl.converters["sequence<sequence<ByteString>>"](V);
        }
        return webidl.converters["record<ByteString, ByteString>"](V);
      }
      throw webidl.errors.conversionFailed({
        prefix: "Headers constructor",
        argument: "Argument 1",
        types: ["sequence<sequence<ByteString>>", "record<ByteString, ByteString>"]
      });
    };
    module2.exports = {
      fill,
      Headers,
      HeadersList
    };
  }
});

// fastify-busboy/deps/streamsearch/sbmh.js
var require_sbmh = __commonJS({
  "fastify-busboy/deps/streamsearch/sbmh.js"(exports2, module2) {
    "use strict";
    var EventEmitter = require("events").EventEmitter;
    var inherits = require("util").inherits;
    function SBMH(needle) {
      if (typeof needle === "string") {
        needle = Buffer.from(needle);
      }
      if (!Buffer.isBuffer(needle)) {
        throw new TypeError("The needle has to be a String or a Buffer.");
      }
      const needleLength = needle.length;
      if (needleLength === 0) {
        throw new Error("The needle cannot be an empty String/Buffer.");
      }
      if (needleLength > 256) {
        throw new Error("The needle cannot have a length bigger than 256.");
      }
      this.maxMatches = Infinity;
      this.matches = 0;
      this._occ = new Array(256).fill(needleLength);
      this._lookbehind_size = 0;
      this._needle = needle;
      this._bufpos = 0;
      this._lookbehind = Buffer.alloc(needleLength);
      for (var i = 0; i < needleLength - 1; ++i) {
        this._occ[needle[i]] = needleLength - 1 - i;
      }
    }
    inherits(SBMH, EventEmitter);
    SBMH.prototype.reset = function() {
      this._lookbehind_size = 0;
      this.matches = 0;
      this._bufpos = 0;
    };
    SBMH.prototype.push = function(chunk, pos) {
      if (!Buffer.isBuffer(chunk)) {
        chunk = Buffer.from(chunk, "binary");
      }
      const chlen = chunk.length;
      this._bufpos = pos || 0;
      let r;
      while (r !== chlen && this.matches < this.maxMatches) {
        r = this._sbmh_feed(chunk);
      }
      return r;
    };
    SBMH.prototype._sbmh_feed = function(data) {
      const len = data.length;
      const needle = this._needle;
      const needleLength = needle.length;
      const lastNeedleChar = needle[needleLength - 1];
      let pos = -this._lookbehind_size;
      let ch;
      if (pos < 0) {
        while (pos < 0 && pos <= len - needleLength) {
          ch = this._sbmh_lookup_char(data, pos + needleLength - 1);
          if (ch === lastNeedleChar && this._sbmh_memcmp(data, pos, needleLength - 1)) {
            this._lookbehind_size = 0;
            ++this.matches;
            this.emit("info", true);
            return this._bufpos = pos + needleLength;
          }
          pos += this._occ[ch];
        }
        if (pos < 0) {
          while (pos < 0 && !this._sbmh_memcmp(data, pos, len - pos)) {
            ++pos;
          }
        }
        if (pos >= 0) {
          this.emit("info", false, this._lookbehind, 0, this._lookbehind_size);
          this._lookbehind_size = 0;
        } else {
          const bytesToCutOff = this._lookbehind_size + pos;
          if (bytesToCutOff > 0) {
            this.emit("info", false, this._lookbehind, 0, bytesToCutOff);
          }
          this._lookbehind.copy(
            this._lookbehind,
            0,
            bytesToCutOff,
            this._lookbehind_size - bytesToCutOff
          );
          this._lookbehind_size -= bytesToCutOff;
          data.copy(this._lookbehind, this._lookbehind_size);
          this._lookbehind_size += len;
          this._bufpos = len;
          return len;
        }
      }
      pos += (pos >= 0) * this._bufpos;
      if (data.indexOf(needle, pos) !== -1) {
        pos = data.indexOf(needle, pos);
        ++this.matches;
        if (pos > 0) {
          this.emit("info", true, data, this._bufpos, pos);
        } else {
          this.emit("info", true);
        }
        return this._bufpos = pos + needleLength;
      } else {
        pos = len - needleLength;
      }
      while (pos < len && (data[pos] !== needle[0] || Buffer.compare(
        data.subarray(pos, pos + len - pos),
        needle.subarray(0, len - pos)
      ) !== 0)) {
        ++pos;
      }
      if (pos < len) {
        data.copy(this._lookbehind, 0, pos, pos + (len - pos));
        this._lookbehind_size = len - pos;
      }
      if (pos > 0) {
        this.emit("info", false, data, this._bufpos, pos < len ? pos : len);
      }
      this._bufpos = len;
      return len;
    };
    SBMH.prototype._sbmh_lookup_char = function(data, pos) {
      return pos < 0 ? this._lookbehind[this._lookbehind_size + pos] : data[pos];
    };
    SBMH.prototype._sbmh_memcmp = function(data, pos, len) {
      for (var i = 0; i < len; ++i) {
        if (this._sbmh_lookup_char(data, pos + i) !== this._needle[i]) {
          return false;
        }
      }
      return true;
    };
    module2.exports = SBMH;
  }
});

// fastify-busboy/deps/dicer/lib/PartStream.js
var require_PartStream = __commonJS({
  "fastify-busboy/deps/dicer/lib/PartStream.js"(exports2, module2) {
    "use strict";
    var inherits = require("util").inherits;
    var ReadableStream = require("stream").Readable;
    function PartStream(opts) {
      ReadableStream.call(this, opts);
    }
    inherits(PartStream, ReadableStream);
    PartStream.prototype._read = function(n) {
    };
    module2.exports = PartStream;
  }
});

// fastify-busboy/lib/utils/getLimit.js
var require_getLimit = __commonJS({
  "fastify-busboy/lib/utils/getLimit.js"(exports2, module2) {
    "use strict";
    module2.exports = function getLimit(limits, name, defaultLimit) {
      if (!limits || limits[name] === void 0 || limits[name] === null) {
        return defaultLimit;
      }
      if (typeof limits[name] !== "number" || isNaN(limits[name])) {
        throw new TypeError("Limit " + name + " is not a valid number");
      }
      return limits[name];
    };
  }
});

// fastify-busboy/deps/dicer/lib/HeaderParser.js
var require_HeaderParser = __commonJS({
  "fastify-busboy/deps/dicer/lib/HeaderParser.js"(exports2, module2) {
    "use strict";
    var EventEmitter = require("events").EventEmitter;
    var inherits = require("util").inherits;
    var getLimit = require_getLimit();
    var StreamSearch = require_sbmh();
    var B_DCRLF = Buffer.from("\r\n\r\n");
    var RE_CRLF = /\r\n/g;
    var RE_HDR = /^([^:]+):[ \t]?([\x00-\xFF]+)?$/;
    function HeaderParser(cfg) {
      EventEmitter.call(this);
      cfg = cfg || {};
      const self = this;
      this.nread = 0;
      this.maxed = false;
      this.npairs = 0;
      this.maxHeaderPairs = getLimit(cfg, "maxHeaderPairs", 2e3);
      this.maxHeaderSize = getLimit(cfg, "maxHeaderSize", 80 * 1024);
      this.buffer = "";
      this.header = {};
      this.finished = false;
      this.ss = new StreamSearch(B_DCRLF);
      this.ss.on("info", function(isMatch, data, start, end) {
        if (data && !self.maxed) {
          if (self.nread + end - start >= self.maxHeaderSize) {
            end = self.maxHeaderSize - self.nread + start;
            self.nread = self.maxHeaderSize;
            self.maxed = true;
          } else {
            self.nread += end - start;
          }
          self.buffer += data.toString("binary", start, end);
        }
        if (isMatch) {
          self._finish();
        }
      });
    }
    inherits(HeaderParser, EventEmitter);
    HeaderParser.prototype.push = function(data) {
      const r = this.ss.push(data);
      if (this.finished) {
        return r;
      }
    };
    HeaderParser.prototype.reset = function() {
      this.finished = false;
      this.buffer = "";
      this.header = {};
      this.ss.reset();
    };
    HeaderParser.prototype._finish = function() {
      if (this.buffer) {
        this._parseHeader();
      }
      this.ss.matches = this.ss.maxMatches;
      const header = this.header;
      this.header = {};
      this.buffer = "";
      this.finished = true;
      this.nread = this.npairs = 0;
      this.maxed = false;
      this.emit("header", header);
    };
    HeaderParser.prototype._parseHeader = function() {
      if (this.npairs === this.maxHeaderPairs) {
        return;
      }
      const lines = this.buffer.split(RE_CRLF);
      const len = lines.length;
      let m, h;
      for (var i = 0; i < len; ++i) {
        if (lines[i].length === 0) {
          continue;
        }
        if (lines[i][0] === "	" || lines[i][0] === " ") {
          if (h) {
            this.header[h][this.header[h].length - 1] += lines[i];
            continue;
          }
        }
        const posColon = lines[i].indexOf(":");
        if (posColon === -1 || posColon === 0) {
          return;
        }
        m = RE_HDR.exec(lines[i]);
        h = m[1].toLowerCase();
        this.header[h] = this.header[h] || [];
        this.header[h].push(m[2] || "");
        if (++this.npairs === this.maxHeaderPairs) {
          break;
        }
      }
    };
    module2.exports = HeaderParser;
  }
});

// fastify-busboy/deps/dicer/lib/Dicer.js
var require_Dicer = __commonJS({
  "fastify-busboy/deps/dicer/lib/Dicer.js"(exports2, module2) {
    "use strict";
    var WritableStream = require("stream").Writable;
    var inherits = require("util").inherits;
    var StreamSearch = require_sbmh();
    var PartStream = require_PartStream();
    var HeaderParser = require_HeaderParser();
    var DASH = 45;
    var B_ONEDASH = Buffer.from("-");
    var B_CRLF = Buffer.from("\r\n");
    var EMPTY_FN = function() {
    };
    function Dicer(cfg) {
      if (!(this instanceof Dicer)) {
        return new Dicer(cfg);
      }
      WritableStream.call(this, cfg);
      if (!cfg || !cfg.headerFirst && typeof cfg.boundary !== "string") {
        throw new TypeError("Boundary required");
      }
      if (typeof cfg.boundary === "string") {
        this.setBoundary(cfg.boundary);
      } else {
        this._bparser = void 0;
      }
      this._headerFirst = cfg.headerFirst;
      this._dashes = 0;
      this._parts = 0;
      this._finished = false;
      this._realFinish = false;
      this._isPreamble = true;
      this._justMatched = false;
      this._firstWrite = true;
      this._inHeader = true;
      this._part = void 0;
      this._cb = void 0;
      this._ignoreData = false;
      this._partOpts = { highWaterMark: cfg.partHwm };
      this._pause = false;
      const self = this;
      this._hparser = new HeaderParser(cfg);
      this._hparser.on("header", function(header) {
        self._inHeader = false;
        self._part.emit("header", header);
      });
    }
    inherits(Dicer, WritableStream);
    Dicer.prototype.emit = function(ev) {
      if (ev === "finish" && !this._realFinish) {
        if (!this._finished) {
          const self = this;
          process.nextTick(function() {
            self.emit("error", new Error("Unexpected end of multipart data"));
            if (self._part && !self._ignoreData) {
              const type = self._isPreamble ? "Preamble" : "Part";
              self._part.emit("error", new Error(type + " terminated early due to unexpected end of multipart data"));
              self._part.push(null);
              process.nextTick(function() {
                self._realFinish = true;
                self.emit("finish");
                self._realFinish = false;
              });
              return;
            }
            self._realFinish = true;
            self.emit("finish");
            self._realFinish = false;
          });
        }
      } else {
        WritableStream.prototype.emit.apply(this, arguments);
      }
    };
    Dicer.prototype._write = function(data, encoding, cb) {
      if (!this._hparser && !this._bparser) {
        return cb();
      }
      if (this._headerFirst && this._isPreamble) {
        if (!this._part) {
          this._part = new PartStream(this._partOpts);
          if (this._events.preamble) {
            this.emit("preamble", this._part);
          } else {
            this._ignore();
          }
        }
        const r = this._hparser.push(data);
        if (!this._inHeader && r !== void 0 && r < data.length) {
          data = data.slice(r);
        } else {
          return cb();
        }
      }
      if (this._firstWrite) {
        this._bparser.push(B_CRLF);
        this._firstWrite = false;
      }
      this._bparser.push(data);
      if (this._pause) {
        this._cb = cb;
      } else {
        cb();
      }
    };
    Dicer.prototype.reset = function() {
      this._part = void 0;
      this._bparser = void 0;
      this._hparser = void 0;
    };
    Dicer.prototype.setBoundary = function(boundary) {
      const self = this;
      this._bparser = new StreamSearch("\r\n--" + boundary);
      this._bparser.on("info", function(isMatch, data, start, end) {
        self._oninfo(isMatch, data, start, end);
      });
    };
    Dicer.prototype._ignore = function() {
      if (this._part && !this._ignoreData) {
        this._ignoreData = true;
        this._part.on("error", EMPTY_FN);
        this._part.resume();
      }
    };
    Dicer.prototype._oninfo = function(isMatch, data, start, end) {
      let buf;
      const self = this;
      let i = 0;
      let r;
      let shouldWriteMore = true;
      if (!this._part && this._justMatched && data) {
        while (this._dashes < 2 && start + i < end) {
          if (data[start + i] === DASH) {
            ++i;
            ++this._dashes;
          } else {
            if (this._dashes) {
              buf = B_ONEDASH;
            }
            this._dashes = 0;
            break;
          }
        }
        if (this._dashes === 2) {
          if (start + i < end && this._events.trailer) {
            this.emit("trailer", data.slice(start + i, end));
          }
          this.reset();
          this._finished = true;
          if (self._parts === 0) {
            self._realFinish = true;
            self.emit("finish");
            self._realFinish = false;
          }
        }
        if (this._dashes) {
          return;
        }
      }
      if (this._justMatched) {
        this._justMatched = false;
      }
      if (!this._part) {
        this._part = new PartStream(this._partOpts);
        this._part._read = function(n) {
          self._unpause();
        };
        if (this._isPreamble && this._events.preamble) {
          this.emit("preamble", this._part);
        } else if (this._isPreamble !== true && this._events.part) {
          this.emit("part", this._part);
        } else {
          this._ignore();
        }
        if (!this._isPreamble) {
          this._inHeader = true;
        }
      }
      if (data && start < end && !this._ignoreData) {
        if (this._isPreamble || !this._inHeader) {
          if (buf) {
            shouldWriteMore = this._part.push(buf);
          }
          shouldWriteMore = this._part.push(data.slice(start, end));
          if (!shouldWriteMore) {
            this._pause = true;
          }
        } else if (!this._isPreamble && this._inHeader) {
          if (buf) {
            this._hparser.push(buf);
          }
          r = this._hparser.push(data.slice(start, end));
          if (!this._inHeader && r !== void 0 && r < end) {
            this._oninfo(false, data, start + r, end);
          }
        }
      }
      if (isMatch) {
        this._hparser.reset();
        if (this._isPreamble) {
          this._isPreamble = false;
        } else {
          if (start !== end) {
            ++this._parts;
            this._part.on("end", function() {
              if (--self._parts === 0) {
                if (self._finished) {
                  self._realFinish = true;
                  self.emit("finish");
                  self._realFinish = false;
                } else {
                  self._unpause();
                }
              }
            });
          }
        }
        this._part.push(null);
        this._part = void 0;
        this._ignoreData = false;
        this._justMatched = true;
        this._dashes = 0;
      }
    };
    Dicer.prototype._unpause = function() {
      if (!this._pause) {
        return;
      }
      this._pause = false;
      if (this._cb) {
        const cb = this._cb;
        this._cb = void 0;
        cb();
      }
    };
    module2.exports = Dicer;
  }
});

// fastify-busboy/lib/utils/decodeText.js
var require_decodeText = __commonJS({
  "fastify-busboy/lib/utils/decodeText.js"(exports2, module2) {
    "use strict";
    var utf8Decoder = new TextDecoder("utf-8");
    var textDecoders = /* @__PURE__ */ new Map([
      ["utf-8", utf8Decoder],
      ["utf8", utf8Decoder]
    ]);
    function decodeText(text, textEncoding, destEncoding) {
      if (text) {
        if (textDecoders.has(destEncoding)) {
          try {
            return textDecoders.get(destEncoding).decode(Buffer.from(text, textEncoding));
          } catch (e) {
          }
        } else {
          try {
            textDecoders.set(destEncoding, new TextDecoder(destEncoding));
            return textDecoders.get(destEncoding).decode(Buffer.from(text, textEncoding));
          } catch (e) {
          }
        }
      }
      return text;
    }
    module2.exports = decodeText;
  }
});

// fastify-busboy/lib/utils/parseParams.js
var require_parseParams = __commonJS({
  "fastify-busboy/lib/utils/parseParams.js"(exports2, module2) {
    "use strict";
    var decodeText = require_decodeText();
    var RE_ENCODED = /%([a-fA-F0-9]{2})/g;
    function encodedReplacer(match, byte) {
      return String.fromCharCode(parseInt(byte, 16));
    }
    function parseParams(str) {
      const res = [];
      let state = "key";
      let charset = "";
      let inquote = false;
      let escaping = false;
      let p = 0;
      let tmp = "";
      for (var i = 0, len = str.length; i < len; ++i) {
        const char = str[i];
        if (char === "\\" && inquote) {
          if (escaping) {
            escaping = false;
          } else {
            escaping = true;
            continue;
          }
        } else if (char === '"') {
          if (!escaping) {
            if (inquote) {
              inquote = false;
              state = "key";
            } else {
              inquote = true;
            }
            continue;
          } else {
            escaping = false;
          }
        } else {
          if (escaping && inquote) {
            tmp += "\\";
          }
          escaping = false;
          if ((state === "charset" || state === "lang") && char === "'") {
            if (state === "charset") {
              state = "lang";
              charset = tmp.substring(1);
            } else {
              state = "value";
            }
            tmp = "";
            continue;
          } else if (state === "key" && (char === "*" || char === "=") && res.length) {
            if (char === "*") {
              state = "charset";
            } else {
              state = "value";
            }
            res[p] = [tmp, void 0];
            tmp = "";
            continue;
          } else if (!inquote && char === ";") {
            state = "key";
            if (charset) {
              if (tmp.length) {
                tmp = decodeText(
                  tmp.replace(RE_ENCODED, encodedReplacer),
                  "binary",
                  charset
                );
              }
              charset = "";
            } else if (tmp.length) {
              tmp = decodeText(tmp, "binary", "utf8");
            }
            if (res[p] === void 0) {
              res[p] = tmp;
            } else {
              res[p][1] = tmp;
            }
            tmp = "";
            ++p;
            continue;
          } else if (!inquote && (char === " " || char === "	")) {
            continue;
          }
        }
        tmp += char;
      }
      if (charset && tmp.length) {
        tmp = decodeText(
          tmp.replace(RE_ENCODED, encodedReplacer),
          "binary",
          charset
        );
      } else if (tmp) {
        tmp = decodeText(tmp, "binary", "utf8");
      }
      if (res[p] === void 0) {
        if (tmp) {
          res[p] = tmp;
        }
      } else {
        res[p][1] = tmp;
      }
      return res;
    }
    module2.exports = parseParams;
  }
});

// fastify-busboy/lib/utils/basename.js
var require_basename = __commonJS({
  "fastify-busboy/lib/utils/basename.js"(exports2, module2) {
    "use strict";
    module2.exports = function basename(path) {
      if (typeof path !== "string") {
        return "";
      }
      for (var i = path.length - 1; i >= 0; --i) {
        switch (path.charCodeAt(i)) {
          case 47:
          case 92:
            path = path.slice(i + 1);
            return path === ".." || path === "." ? "" : path;
        }
      }
      return path === ".." || path === "." ? "" : path;
    };
  }
});

// fastify-busboy/lib/types/multipart.js
var require_multipart = __commonJS({
  "fastify-busboy/lib/types/multipart.js"(exports2, module2) {
    "use strict";
    var { Readable } = require("stream");
    var { inherits } = require("util");
    var Dicer = require_Dicer();
    var parseParams = require_parseParams();
    var decodeText = require_decodeText();
    var basename = require_basename();
    var getLimit = require_getLimit();
    var RE_BOUNDARY = /^boundary$/i;
    var RE_FIELD = /^form-data$/i;
    var RE_CHARSET = /^charset$/i;
    var RE_FILENAME = /^filename$/i;
    var RE_NAME = /^name$/i;
    Multipart.detect = /^multipart\/form-data/i;
    function Multipart(boy, cfg) {
      let i;
      let len;
      const self = this;
      let boundary;
      const limits = cfg.limits;
      const isPartAFile = cfg.isPartAFile || ((fieldName, contentType, fileName) => contentType === "application/octet-stream" || fileName !== void 0);
      const parsedConType = cfg.parsedConType || [];
      const defCharset = cfg.defCharset || "utf8";
      const preservePath = cfg.preservePath;
      const fileOpts = { highWaterMark: cfg.fileHwm };
      for (i = 0, len = parsedConType.length; i < len; ++i) {
        if (Array.isArray(parsedConType[i]) && RE_BOUNDARY.test(parsedConType[i][0])) {
          boundary = parsedConType[i][1];
          break;
        }
      }
      function checkFinished() {
        if (nends === 0 && finished && !boy._done) {
          finished = false;
          self.end();
        }
      }
      if (typeof boundary !== "string") {
        throw new Error("Multipart: Boundary not found");
      }
      const fieldSizeLimit = getLimit(limits, "fieldSize", 1 * 1024 * 1024);
      const fileSizeLimit = getLimit(limits, "fileSize", Infinity);
      const filesLimit = getLimit(limits, "files", Infinity);
      const fieldsLimit = getLimit(limits, "fields", Infinity);
      const partsLimit = getLimit(limits, "parts", Infinity);
      const headerPairsLimit = getLimit(limits, "headerPairs", 2e3);
      const headerSizeLimit = getLimit(limits, "headerSize", 80 * 1024);
      let nfiles = 0;
      let nfields = 0;
      let nends = 0;
      let curFile;
      let curField;
      let finished = false;
      this._needDrain = false;
      this._pause = false;
      this._cb = void 0;
      this._nparts = 0;
      this._boy = boy;
      const parserCfg = {
        boundary,
        maxHeaderPairs: headerPairsLimit,
        maxHeaderSize: headerSizeLimit,
        partHwm: fileOpts.highWaterMark,
        highWaterMark: cfg.highWaterMark
      };
      this.parser = new Dicer(parserCfg);
      this.parser.on("drain", function() {
        self._needDrain = false;
        if (self._cb && !self._pause) {
          const cb = self._cb;
          self._cb = void 0;
          cb();
        }
      }).on("part", function onPart(part) {
        if (++self._nparts > partsLimit) {
          self.parser.removeListener("part", onPart);
          self.parser.on("part", skipPart);
          boy.hitPartsLimit = true;
          boy.emit("partsLimit");
          return skipPart(part);
        }
        if (curField) {
          const field = curField;
          field.emit("end");
          field.removeAllListeners("end");
        }
        part.on("header", function(header) {
          let contype;
          let fieldname;
          let parsed;
          let charset;
          let encoding;
          let filename;
          let nsize = 0;
          if (header["content-type"]) {
            parsed = parseParams(header["content-type"][0]);
            if (parsed[0]) {
              contype = parsed[0].toLowerCase();
              for (i = 0, len = parsed.length; i < len; ++i) {
                if (RE_CHARSET.test(parsed[i][0])) {
                  charset = parsed[i][1].toLowerCase();
                  break;
                }
              }
            }
          }
          if (contype === void 0) {
            contype = "text/plain";
          }
          if (charset === void 0) {
            charset = defCharset;
          }
          if (header["content-disposition"]) {
            parsed = parseParams(header["content-disposition"][0]);
            if (!RE_FIELD.test(parsed[0])) {
              return skipPart(part);
            }
            for (i = 0, len = parsed.length; i < len; ++i) {
              if (RE_NAME.test(parsed[i][0])) {
                fieldname = parsed[i][1];
              } else if (RE_FILENAME.test(parsed[i][0])) {
                filename = parsed[i][1];
                if (!preservePath) {
                  filename = basename(filename);
                }
              }
            }
          } else {
            return skipPart(part);
          }
          if (header["content-transfer-encoding"]) {
            encoding = header["content-transfer-encoding"][0].toLowerCase();
          } else {
            encoding = "7bit";
          }
          let onData, onEnd;
          if (isPartAFile(fieldname, contype, filename)) {
            if (nfiles === filesLimit) {
              if (!boy.hitFilesLimit) {
                boy.hitFilesLimit = true;
                boy.emit("filesLimit");
              }
              return skipPart(part);
            }
            ++nfiles;
            if (!boy._events.file) {
              self.parser._ignore();
              return;
            }
            ++nends;
            const file = new FileStream(fileOpts);
            curFile = file;
            file.on("end", function() {
              --nends;
              self._pause = false;
              checkFinished();
              if (self._cb && !self._needDrain) {
                const cb = self._cb;
                self._cb = void 0;
                cb();
              }
            });
            file._read = function(n) {
              if (!self._pause) {
                return;
              }
              self._pause = false;
              if (self._cb && !self._needDrain) {
                const cb = self._cb;
                self._cb = void 0;
                cb();
              }
            };
            boy.emit("file", fieldname, file, filename, encoding, contype);
            onData = function(data) {
              if ((nsize += data.length) > fileSizeLimit) {
                const extralen = fileSizeLimit - nsize + data.length;
                if (extralen > 0) {
                  file.push(data.slice(0, extralen));
                }
                file.truncated = true;
                file.bytesRead = fileSizeLimit;
                part.removeAllListeners("data");
                file.emit("limit");
                return;
              } else if (!file.push(data)) {
                self._pause = true;
              }
              file.bytesRead = nsize;
            };
            onEnd = function() {
              curFile = void 0;
              file.push(null);
            };
          } else {
            if (nfields === fieldsLimit) {
              if (!boy.hitFieldsLimit) {
                boy.hitFieldsLimit = true;
                boy.emit("fieldsLimit");
              }
              return skipPart(part);
            }
            ++nfields;
            ++nends;
            let buffer = "";
            let truncated = false;
            curField = part;
            onData = function(data) {
              if ((nsize += data.length) > fieldSizeLimit) {
                const extralen = fieldSizeLimit - (nsize - data.length);
                buffer += data.toString("binary", 0, extralen);
                truncated = true;
                part.removeAllListeners("data");
              } else {
                buffer += data.toString("binary");
              }
            };
            onEnd = function() {
              curField = void 0;
              if (buffer.length) {
                buffer = decodeText(buffer, "binary", charset);
              }
              boy.emit("field", fieldname, buffer, false, truncated, encoding, contype);
              --nends;
              checkFinished();
            };
          }
          part._readableState.sync = false;
          part.on("data", onData);
          part.on("end", onEnd);
        }).on("error", function(err) {
          if (curFile) {
            curFile.emit("error", err);
          }
        });
      }).on("error", function(err) {
        boy.emit("error", err);
      }).on("finish", function() {
        finished = true;
        checkFinished();
      });
    }
    Multipart.prototype.write = function(chunk, cb) {
      const r = this.parser.write(chunk);
      if (r && !this._pause) {
        cb();
      } else {
        this._needDrain = !r;
        this._cb = cb;
      }
    };
    Multipart.prototype.end = function() {
      const self = this;
      if (self.parser.writable) {
        self.parser.end();
      } else if (!self._boy._done) {
        process.nextTick(function() {
          self._boy._done = true;
          self._boy.emit("finish");
        });
      }
    };
    function skipPart(part) {
      part.resume();
    }
    function FileStream(opts) {
      Readable.call(this, opts);
      this.bytesRead = 0;
      this.truncated = false;
    }
    inherits(FileStream, Readable);
    FileStream.prototype._read = function(n) {
    };
    module2.exports = Multipart;
  }
});

// fastify-busboy/lib/utils/Decoder.js
var require_Decoder = __commonJS({
  "fastify-busboy/lib/utils/Decoder.js"(exports2, module2) {
    "use strict";
    var RE_PLUS = /\+/g;
    var HEX = [
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    ];
    function Decoder() {
      this.buffer = void 0;
    }
    Decoder.prototype.write = function(str) {
      str = str.replace(RE_PLUS, " ");
      let res = "";
      let i = 0;
      let p = 0;
      const len = str.length;
      for (; i < len; ++i) {
        if (this.buffer !== void 0) {
          if (!HEX[str.charCodeAt(i)]) {
            res += "%" + this.buffer;
            this.buffer = void 0;
            --i;
          } else {
            this.buffer += str[i];
            ++p;
            if (this.buffer.length === 2) {
              res += String.fromCharCode(parseInt(this.buffer, 16));
              this.buffer = void 0;
            }
          }
        } else if (str[i] === "%") {
          if (i > p) {
            res += str.substring(p, i);
            p = i;
          }
          this.buffer = "";
          ++p;
        }
      }
      if (p < len && this.buffer === void 0) {
        res += str.substring(p);
      }
      return res;
    };
    Decoder.prototype.reset = function() {
      this.buffer = void 0;
    };
    module2.exports = Decoder;
  }
});

// fastify-busboy/lib/types/urlencoded.js
var require_urlencoded = __commonJS({
  "fastify-busboy/lib/types/urlencoded.js"(exports2, module2) {
    "use strict";
    var Decoder = require_Decoder();
    var decodeText = require_decodeText();
    var getLimit = require_getLimit();
    var RE_CHARSET = /^charset$/i;
    UrlEncoded.detect = /^application\/x-www-form-urlencoded/i;
    function UrlEncoded(boy, cfg) {
      const limits = cfg.limits;
      const parsedConType = cfg.parsedConType;
      this.boy = boy;
      this.fieldSizeLimit = getLimit(limits, "fieldSize", 1 * 1024 * 1024);
      this.fieldNameSizeLimit = getLimit(limits, "fieldNameSize", 100);
      this.fieldsLimit = getLimit(limits, "fields", Infinity);
      let charset;
      for (var i = 0, len = parsedConType.length; i < len; ++i) {
        if (Array.isArray(parsedConType[i]) && RE_CHARSET.test(parsedConType[i][0])) {
          charset = parsedConType[i][1].toLowerCase();
          break;
        }
      }
      if (charset === void 0) {
        charset = cfg.defCharset || "utf8";
      }
      this.decoder = new Decoder();
      this.charset = charset;
      this._fields = 0;
      this._state = "key";
      this._checkingBytes = true;
      this._bytesKey = 0;
      this._bytesVal = 0;
      this._key = "";
      this._val = "";
      this._keyTrunc = false;
      this._valTrunc = false;
      this._hitLimit = false;
    }
    UrlEncoded.prototype.write = function(data, cb) {
      if (this._fields === this.fieldsLimit) {
        if (!this.boy.hitFieldsLimit) {
          this.boy.hitFieldsLimit = true;
          this.boy.emit("fieldsLimit");
        }
        return cb();
      }
      let idxeq;
      let idxamp;
      let i;
      let p = 0;
      const len = data.length;
      while (p < len) {
        if (this._state === "key") {
          idxeq = idxamp = void 0;
          for (i = p; i < len; ++i) {
            if (!this._checkingBytes) {
              ++p;
            }
            if (data[i] === 61) {
              idxeq = i;
              break;
            } else if (data[i] === 38) {
              idxamp = i;
              break;
            }
            if (this._checkingBytes && this._bytesKey === this.fieldNameSizeLimit) {
              this._hitLimit = true;
              break;
            } else if (this._checkingBytes) {
              ++this._bytesKey;
            }
          }
          if (idxeq !== void 0) {
            if (idxeq > p) {
              this._key += this.decoder.write(data.toString("binary", p, idxeq));
            }
            this._state = "val";
            this._hitLimit = false;
            this._checkingBytes = true;
            this._val = "";
            this._bytesVal = 0;
            this._valTrunc = false;
            this.decoder.reset();
            p = idxeq + 1;
          } else if (idxamp !== void 0) {
            ++this._fields;
            let key;
            const keyTrunc = this._keyTrunc;
            if (idxamp > p) {
              key = this._key += this.decoder.write(data.toString("binary", p, idxamp));
            } else {
              key = this._key;
            }
            this._hitLimit = false;
            this._checkingBytes = true;
            this._key = "";
            this._bytesKey = 0;
            this._keyTrunc = false;
            this.decoder.reset();
            if (key.length) {
              this.boy.emit(
                "field",
                decodeText(key, "binary", this.charset),
                "",
                keyTrunc,
                false
              );
            }
            p = idxamp + 1;
            if (this._fields === this.fieldsLimit) {
              return cb();
            }
          } else if (this._hitLimit) {
            if (i > p) {
              this._key += this.decoder.write(data.toString("binary", p, i));
            }
            p = i;
            if ((this._bytesKey = this._key.length) === this.fieldNameSizeLimit) {
              this._checkingBytes = false;
              this._keyTrunc = true;
            }
          } else {
            if (p < len) {
              this._key += this.decoder.write(data.toString("binary", p));
            }
            p = len;
          }
        } else {
          idxamp = void 0;
          for (i = p; i < len; ++i) {
            if (!this._checkingBytes) {
              ++p;
            }
            if (data[i] === 38) {
              idxamp = i;
              break;
            }
            if (this._checkingBytes && this._bytesVal === this.fieldSizeLimit) {
              this._hitLimit = true;
              break;
            } else if (this._checkingBytes) {
              ++this._bytesVal;
            }
          }
          if (idxamp !== void 0) {
            ++this._fields;
            if (idxamp > p) {
              this._val += this.decoder.write(data.toString("binary", p, idxamp));
            }
            this.boy.emit(
              "field",
              decodeText(this._key, "binary", this.charset),
              decodeText(this._val, "binary", this.charset),
              this._keyTrunc,
              this._valTrunc
            );
            this._state = "key";
            this._hitLimit = false;
            this._checkingBytes = true;
            this._key = "";
            this._bytesKey = 0;
            this._keyTrunc = false;
            this.decoder.reset();
            p = idxamp + 1;
            if (this._fields === this.fieldsLimit) {
              return cb();
            }
          } else if (this._hitLimit) {
            if (i > p) {
              this._val += this.decoder.write(data.toString("binary", p, i));
            }
            p = i;
            if (this._val === "" && this.fieldSizeLimit === 0 || (this._bytesVal = this._val.length) === this.fieldSizeLimit) {
              this._checkingBytes = false;
              this._valTrunc = true;
            }
          } else {
            if (p < len) {
              this._val += this.decoder.write(data.toString("binary", p));
            }
            p = len;
          }
        }
      }
      cb();
    };
    UrlEncoded.prototype.end = function() {
      if (this.boy._done) {
        return;
      }
      if (this._state === "key" && this._key.length > 0) {
        this.boy.emit(
          "field",
          decodeText(this._key, "binary", this.charset),
          "",
          this._keyTrunc,
          false
        );
      } else if (this._state === "val") {
        this.boy.emit(
          "field",
          decodeText(this._key, "binary", this.charset),
          decodeText(this._val, "binary", this.charset),
          this._keyTrunc,
          this._valTrunc
        );
      }
      this.boy._done = true;
      this.boy.emit("finish");
    };
    module2.exports = UrlEncoded;
  }
});

// fastify-busboy/lib/main.js
var require_main = __commonJS({
  "fastify-busboy/lib/main.js"(exports2, module2) {
    "use strict";
    var WritableStream = require("stream").Writable;
    var { inherits } = require("util");
    var Dicer = require_Dicer();
    var MultipartParser = require_multipart();
    var UrlencodedParser = require_urlencoded();
    var parseParams = require_parseParams();
    function Busboy(opts) {
      if (!(this instanceof Busboy)) {
        return new Busboy(opts);
      }
      if (typeof opts !== "object") {
        throw new TypeError("Busboy expected an options-Object.");
      }
      if (typeof opts.headers !== "object") {
        throw new TypeError("Busboy expected an options-Object with headers-attribute.");
      }
      if (typeof opts.headers["content-type"] !== "string") {
        throw new TypeError("Missing Content-Type-header.");
      }
      const {
        headers,
        ...streamOptions
      } = opts;
      this.opts = {
        autoDestroy: false,
        ...streamOptions
      };
      WritableStream.call(this, this.opts);
      this._done = false;
      this._parser = this.getParserByHeaders(headers);
      this._finished = false;
    }
    inherits(Busboy, WritableStream);
    Busboy.prototype.emit = function(ev) {
      if (ev === "finish") {
        if (!this._done) {
          this._parser?.end();
          return;
        } else if (this._finished) {
          return;
        }
        this._finished = true;
      }
      WritableStream.prototype.emit.apply(this, arguments);
    };
    Busboy.prototype.getParserByHeaders = function(headers) {
      const parsed = parseParams(headers["content-type"]);
      const cfg = {
        defCharset: this.opts.defCharset,
        fileHwm: this.opts.fileHwm,
        headers,
        highWaterMark: this.opts.highWaterMark,
        isPartAFile: this.opts.isPartAFile,
        limits: this.opts.limits,
        parsedConType: parsed,
        preservePath: this.opts.preservePath
      };
      if (MultipartParser.detect.test(parsed[0])) {
        return new MultipartParser(this, cfg);
      }
      if (UrlencodedParser.detect.test(parsed[0])) {
        return new UrlencodedParser(this, cfg);
      }
      throw new Error("Unsupported Content-Type.");
    };
    Busboy.prototype._write = function(chunk, encoding, cb) {
      this._parser.write(chunk, cb);
    };
    module2.exports = Busboy;
    module2.exports.default = Busboy;
    module2.exports.Busboy = Busboy;
    module2.exports.Dicer = Dicer;
  }
});

// lib/fetch/dataURL.js
var require_dataURL = __commonJS({
  "lib/fetch/dataURL.js"(exports2, module2) {
    var assert = require("assert");
    var { atob: atob2 } = require("buffer");
    var { isomorphicDecode } = require_util2();
    var encoder = new TextEncoder();
    var HTTP_TOKEN_CODEPOINTS = /^[!#$%&'*+-.^_|~A-Za-z0-9]+$/;
    var HTTP_WHITESPACE_REGEX = /(\u000A|\u000D|\u0009|\u0020)/;
    var HTTP_QUOTED_STRING_TOKENS = /[\u0009|\u0020-\u007E|\u0080-\u00FF]/;
    function dataURLProcessor(dataURL) {
      assert(dataURL.protocol === "data:");
      let input = URLSerializer(dataURL, true);
      input = input.slice(5);
      const position = { position: 0 };
      let mimeType = collectASequenceOfCodePointsFast(
        ",",
        input,
        position
      );
      const mimeTypeLength = mimeType.length;
      mimeType = removeASCIIWhitespace(mimeType, true, true);
      if (position.position >= input.length) {
        return "failure";
      }
      position.position++;
      const encodedBody = input.slice(mimeTypeLength + 1);
      let body = stringPercentDecode(encodedBody);
      if (/;(\u0020){0,}base64$/i.test(mimeType)) {
        const stringBody = isomorphicDecode(body);
        body = forgivingBase64(stringBody);
        if (body === "failure") {
          return "failure";
        }
        mimeType = mimeType.slice(0, -6);
        mimeType = mimeType.replace(/(\u0020)+$/, "");
        mimeType = mimeType.slice(0, -1);
      }
      if (mimeType.startsWith(";")) {
        mimeType = "text/plain" + mimeType;
      }
      let mimeTypeRecord = parseMIMEType(mimeType);
      if (mimeTypeRecord === "failure") {
        mimeTypeRecord = parseMIMEType("text/plain;charset=US-ASCII");
      }
      return { mimeType: mimeTypeRecord, body };
    }
    function URLSerializer(url, excludeFragment = false) {
      const href = url.href;
      if (!excludeFragment) {
        return href;
      }
      const hash = href.lastIndexOf("#");
      if (hash === -1) {
        return href;
      }
      return href.slice(0, hash);
    }
    function collectASequenceOfCodePoints(condition, input, position) {
      let result = "";
      while (position.position < input.length && condition(input[position.position])) {
        result += input[position.position];
        position.position++;
      }
      return result;
    }
    function collectASequenceOfCodePointsFast(char, input, position) {
      const idx = input.indexOf(char, position.position);
      const start = position.position;
      if (idx === -1) {
        position.position = input.length;
        return input.slice(start);
      }
      position.position = idx;
      return input.slice(start, position.position);
    }
    function stringPercentDecode(input) {
      const bytes = encoder.encode(input);
      return percentDecode(bytes);
    }
    function percentDecode(input) {
      const output = [];
      for (let i = 0; i < input.length; i++) {
        const byte = input[i];
        if (byte !== 37) {
          output.push(byte);
        } else if (byte === 37 && !/^[0-9A-Fa-f]{2}$/i.test(String.fromCharCode(input[i + 1], input[i + 2]))) {
          output.push(37);
        } else {
          const nextTwoBytes = String.fromCharCode(input[i + 1], input[i + 2]);
          const bytePoint = Number.parseInt(nextTwoBytes, 16);
          output.push(bytePoint);
          i += 2;
        }
      }
      return Uint8Array.from(output);
    }
    function parseMIMEType(input) {
      input = removeHTTPWhitespace(input, true, true);
      const position = { position: 0 };
      const type = collectASequenceOfCodePointsFast(
        "/",
        input,
        position
      );
      if (type.length === 0 || !HTTP_TOKEN_CODEPOINTS.test(type)) {
        return "failure";
      }
      if (position.position > input.length) {
        return "failure";
      }
      position.position++;
      let subtype = collectASequenceOfCodePointsFast(
        ";",
        input,
        position
      );
      subtype = removeHTTPWhitespace(subtype, false, true);
      if (subtype.length === 0 || !HTTP_TOKEN_CODEPOINTS.test(subtype)) {
        return "failure";
      }
      const typeLowercase = type.toLowerCase();
      const subtypeLowercase = subtype.toLowerCase();
      const mimeType = {
        type: typeLowercase,
        subtype: subtypeLowercase,
        /** @type {Map<string, string>} */
        parameters: /* @__PURE__ */ new Map(),
        // https://mimesniff.spec.whatwg.org/#mime-type-essence
        essence: `${typeLowercase}/${subtypeLowercase}`
      };
      while (position.position < input.length) {
        position.position++;
        collectASequenceOfCodePoints(
          // https://fetch.spec.whatwg.org/#http-whitespace
          (char) => HTTP_WHITESPACE_REGEX.test(char),
          input,
          position
        );
        let parameterName = collectASequenceOfCodePoints(
          (char) => char !== ";" && char !== "=",
          input,
          position
        );
        parameterName = parameterName.toLowerCase();
        if (position.position < input.length) {
          if (input[position.position] === ";") {
            continue;
          }
          position.position++;
        }
        if (position.position > input.length) {
          break;
        }
        let parameterValue = null;
        if (input[position.position] === '"') {
          parameterValue = collectAnHTTPQuotedString(input, position, true);
          collectASequenceOfCodePointsFast(
            ";",
            input,
            position
          );
        } else {
          parameterValue = collectASequenceOfCodePointsFast(
            ";",
            input,
            position
          );
          parameterValue = removeHTTPWhitespace(parameterValue, false, true);
          if (parameterValue.length === 0) {
            continue;
          }
        }
        if (parameterName.length !== 0 && HTTP_TOKEN_CODEPOINTS.test(parameterName) && (parameterValue.length === 0 || HTTP_QUOTED_STRING_TOKENS.test(parameterValue)) && !mimeType.parameters.has(parameterName)) {
          mimeType.parameters.set(parameterName, parameterValue);
        }
      }
      return mimeType;
    }
    function forgivingBase64(data) {
      data = data.replace(/[\u0009\u000A\u000C\u000D\u0020]/g, "");
      if (data.length % 4 === 0) {
        data = data.replace(/=?=$/, "");
      }
      if (data.length % 4 === 1) {
        return "failure";
      }
      if (/[^+/0-9A-Za-z]/.test(data)) {
        return "failure";
      }
      const binary = atob2(data);
      const bytes = new Uint8Array(binary.length);
      for (let byte = 0; byte < binary.length; byte++) {
        bytes[byte] = binary.charCodeAt(byte);
      }
      return bytes;
    }
    function collectAnHTTPQuotedString(input, position, extractValue) {
      const positionStart = position.position;
      let value = "";
      assert(input[position.position] === '"');
      position.position++;
      while (true) {
        value += collectASequenceOfCodePoints(
          (char) => char !== '"' && char !== "\\",
          input,
          position
        );
        if (position.position >= input.length) {
          break;
        }
        const quoteOrBackslash = input[position.position];
        position.position++;
        if (quoteOrBackslash === "\\") {
          if (position.position >= input.length) {
            value += "\\";
            break;
          }
          value += input[position.position];
          position.position++;
        } else {
          assert(quoteOrBackslash === '"');
          break;
        }
      }
      if (extractValue) {
        return value;
      }
      return input.slice(positionStart, position.position);
    }
    function serializeAMimeType(mimeType) {
      assert(mimeType !== "failure");
      const { parameters, essence } = mimeType;
      let serialization = essence;
      for (let [name, value] of parameters.entries()) {
        serialization += ";";
        serialization += name;
        serialization += "=";
        if (!HTTP_TOKEN_CODEPOINTS.test(value)) {
          value = value.replace(/(\\|")/g, "\\$1");
          value = '"' + value;
          value += '"';
        }
        serialization += value;
      }
      return serialization;
    }
    function isHTTPWhiteSpace(char) {
      return char === "\r" || char === "\n" || char === "	" || char === " ";
    }
    function removeHTTPWhitespace(str, leading = true, trailing = true) {
      let lead = 0;
      let trail = str.length - 1;
      if (leading) {
        for (; lead < str.length && isHTTPWhiteSpace(str[lead]); lead++)
          ;
      }
      if (trailing) {
        for (; trail > 0 && isHTTPWhiteSpace(str[trail]); trail--)
          ;
      }
      return str.slice(lead, trail + 1);
    }
    function isASCIIWhitespace(char) {
      return char === "\r" || char === "\n" || char === "	" || char === "\f" || char === " ";
    }
    function removeASCIIWhitespace(str, leading = true, trailing = true) {
      let lead = 0;
      let trail = str.length - 1;
      if (leading) {
        for (; lead < str.length && isASCIIWhitespace(str[lead]); lead++)
          ;
      }
      if (trailing) {
        for (; trail > 0 && isASCIIWhitespace(str[trail]); trail--)
          ;
      }
      return str.slice(lead, trail + 1);
    }
    module2.exports = {
      dataURLProcessor,
      URLSerializer,
      collectASequenceOfCodePoints,
      collectASequenceOfCodePointsFast,
      stringPercentDecode,
      parseMIMEType,
      collectAnHTTPQuotedString,
      serializeAMimeType
    };
  }
});

// lib/fetch/file.js
var require_file = __commonJS({
  "lib/fetch/file.js"(exports2, module2) {
    "use strict";
    var { Blob: Blob2, File: NativeFile } = require("buffer");
    var { types } = require("util");
    var { kState } = require_symbols2();
    var { isBlobLike } = require_util2();
    var { webidl } = require_webidl();
    var { parseMIMEType, serializeAMimeType } = require_dataURL();
    var { kEnumerableProperty } = require_util();
    var File = class extends Blob2 {
      constructor(fileBits, fileName, options = {}) {
        webidl.argumentLengthCheck(arguments, 2, { header: "File constructor" });
        fileBits = webidl.converters["sequence<BlobPart>"](fileBits);
        fileName = webidl.converters.USVString(fileName);
        options = webidl.converters.FilePropertyBag(options);
        const n = fileName;
        let t = options.type;
        let d;
        substep: {
          if (t) {
            t = parseMIMEType(t);
            if (t === "failure") {
              t = "";
              break substep;
            }
            t = serializeAMimeType(t).toLowerCase();
          }
          d = options.lastModified;
        }
        super(processBlobParts(fileBits, options), { type: t });
        this[kState] = {
          name: n,
          lastModified: d,
          type: t
        };
      }
      get name() {
        webidl.brandCheck(this, File);
        return this[kState].name;
      }
      get lastModified() {
        webidl.brandCheck(this, File);
        return this[kState].lastModified;
      }
      get type() {
        webidl.brandCheck(this, File);
        return this[kState].type;
      }
    };
    var FileLike = class {
      constructor(blobLike, fileName, options = {}) {
        const n = fileName;
        const t = options.type;
        const d = options.lastModified ?? Date.now();
        this[kState] = {
          blobLike,
          name: n,
          type: t,
          lastModified: d
        };
      }
      stream(...args) {
        webidl.brandCheck(this, FileLike);
        return this[kState].blobLike.stream(...args);
      }
      arrayBuffer(...args) {
        webidl.brandCheck(this, FileLike);
        return this[kState].blobLike.arrayBuffer(...args);
      }
      slice(...args) {
        webidl.brandCheck(this, FileLike);
        return this[kState].blobLike.slice(...args);
      }
      text(...args) {
        webidl.brandCheck(this, FileLike);
        return this[kState].blobLike.text(...args);
      }
      get size() {
        webidl.brandCheck(this, FileLike);
        return this[kState].blobLike.size;
      }
      get type() {
        webidl.brandCheck(this, FileLike);
        return this[kState].blobLike.type;
      }
      get name() {
        webidl.brandCheck(this, FileLike);
        return this[kState].name;
      }
      get lastModified() {
        webidl.brandCheck(this, FileLike);
        return this[kState].lastModified;
      }
      get [Symbol.toStringTag]() {
        return "File";
      }
    };
    Object.defineProperties(File.prototype, {
      [Symbol.toStringTag]: {
        value: "File",
        configurable: true
      },
      name: kEnumerableProperty,
      lastModified: kEnumerableProperty
    });
    webidl.converters.Blob = webidl.interfaceConverter(Blob2);
    webidl.converters.BlobPart = function(V, opts) {
      if (webidl.util.Type(V) === "Object") {
        if (isBlobLike(V)) {
          return webidl.converters.Blob(V, { strict: false });
        }
        if (ArrayBuffer.isView(V) || types.isAnyArrayBuffer(V)) {
          return webidl.converters.BufferSource(V, opts);
        }
      }
      return webidl.converters.USVString(V, opts);
    };
    webidl.converters["sequence<BlobPart>"] = webidl.sequenceConverter(
      webidl.converters.BlobPart
    );
    webidl.converters.FilePropertyBag = webidl.dictionaryConverter([
      {
        key: "lastModified",
        converter: webidl.converters["long long"],
        get defaultValue() {
          return Date.now();
        }
      },
      {
        key: "type",
        converter: webidl.converters.DOMString,
        defaultValue: ""
      },
      {
        key: "endings",
        converter: (value) => {
          value = webidl.converters.DOMString(value);
          value = value.toLowerCase();
          if (value !== "native") {
            value = "transparent";
          }
          return value;
        },
        defaultValue: "transparent"
      }
    ]);
    function processBlobParts(parts, options) {
      const bytes = [];
      for (const element of parts) {
        if (typeof element === "string") {
          let s = element;
          if (options.endings === "native") {
            s = convertLineEndingsNative(s);
          }
          bytes.push(new TextEncoder().encode(s));
        } else if (types.isAnyArrayBuffer(element) || types.isTypedArray(element)) {
          if (!element.buffer) {
            bytes.push(new Uint8Array(element));
          } else {
            bytes.push(
              new Uint8Array(element.buffer, element.byteOffset, element.byteLength)
            );
          }
        } else if (isBlobLike(element)) {
          bytes.push(element);
        }
      }
      return bytes;
    }
    function convertLineEndingsNative(s) {
      let nativeLineEnding = "\n";
      if (process.platform === "win32") {
        nativeLineEnding = "\r\n";
      }
      return s.replace(/\r?\n/g, nativeLineEnding);
    }
    function isFileLike(object) {
      return NativeFile && object instanceof NativeFile || object instanceof File || object && (typeof object.stream === "function" || typeof object.arrayBuffer === "function") && object[Symbol.toStringTag] === "File";
    }
    module2.exports = { File, FileLike, isFileLike };
  }
});

// lib/fetch/formdata.js
var require_formdata = __commonJS({
  "lib/fetch/formdata.js"(exports2, module2) {
    "use strict";
    var { isBlobLike, toUSVString, makeIterator } = require_util2();
    var { kState } = require_symbols2();
    var { File: UndiciFile, FileLike, isFileLike } = require_file();
    var { webidl } = require_webidl();
    var { Blob: Blob2, File: NativeFile } = require("buffer");
    var File = NativeFile ?? UndiciFile;
    var FormData = class {
      constructor(form) {
        if (form !== void 0) {
          throw webidl.errors.conversionFailed({
            prefix: "FormData constructor",
            argument: "Argument 1",
            types: ["undefined"]
          });
        }
        this[kState] = [];
      }
      append(name, value, filename = void 0) {
        webidl.brandCheck(this, FormData);
        webidl.argumentLengthCheck(arguments, 2, { header: "FormData.append" });
        if (arguments.length === 3 && !isBlobLike(value)) {
          throw new TypeError(
            "Failed to execute 'append' on 'FormData': parameter 2 is not of type 'Blob'"
          );
        }
        name = webidl.converters.USVString(name);
        value = isBlobLike(value) ? webidl.converters.Blob(value, { strict: false }) : webidl.converters.USVString(value);
        filename = arguments.length === 3 ? webidl.converters.USVString(filename) : void 0;
        const entry = makeEntry(name, value, filename);
        this[kState].push(entry);
      }
      delete(name) {
        webidl.brandCheck(this, FormData);
        webidl.argumentLengthCheck(arguments, 1, { header: "FormData.delete" });
        name = webidl.converters.USVString(name);
        this[kState] = this[kState].filter((entry) => entry.name !== name);
      }
      get(name) {
        webidl.brandCheck(this, FormData);
        webidl.argumentLengthCheck(arguments, 1, { header: "FormData.get" });
        name = webidl.converters.USVString(name);
        const idx = this[kState].findIndex((entry) => entry.name === name);
        if (idx === -1) {
          return null;
        }
        return this[kState][idx].value;
      }
      getAll(name) {
        webidl.brandCheck(this, FormData);
        webidl.argumentLengthCheck(arguments, 1, { header: "FormData.getAll" });
        name = webidl.converters.USVString(name);
        return this[kState].filter((entry) => entry.name === name).map((entry) => entry.value);
      }
      has(name) {
        webidl.brandCheck(this, FormData);
        webidl.argumentLengthCheck(arguments, 1, { header: "FormData.has" });
        name = webidl.converters.USVString(name);
        return this[kState].findIndex((entry) => entry.name === name) !== -1;
      }
      set(name, value, filename = void 0) {
        webidl.brandCheck(this, FormData);
        webidl.argumentLengthCheck(arguments, 2, { header: "FormData.set" });
        if (arguments.length === 3 && !isBlobLike(value)) {
          throw new TypeError(
            "Failed to execute 'set' on 'FormData': parameter 2 is not of type 'Blob'"
          );
        }
        name = webidl.converters.USVString(name);
        value = isBlobLike(value) ? webidl.converters.Blob(value, { strict: false }) : webidl.converters.USVString(value);
        filename = arguments.length === 3 ? toUSVString(filename) : void 0;
        const entry = makeEntry(name, value, filename);
        const idx = this[kState].findIndex((entry2) => entry2.name === name);
        if (idx !== -1) {
          this[kState] = [
            ...this[kState].slice(0, idx),
            entry,
            ...this[kState].slice(idx + 1).filter((entry2) => entry2.name !== name)
          ];
        } else {
          this[kState].push(entry);
        }
      }
      entries() {
        webidl.brandCheck(this, FormData);
        return makeIterator(
          () => this[kState].map((pair) => [pair.name, pair.value]),
          "FormData",
          "key+value"
        );
      }
      keys() {
        webidl.brandCheck(this, FormData);
        return makeIterator(
          () => this[kState].map((pair) => [pair.name, pair.value]),
          "FormData",
          "key"
        );
      }
      values() {
        webidl.brandCheck(this, FormData);
        return makeIterator(
          () => this[kState].map((pair) => [pair.name, pair.value]),
          "FormData",
          "value"
        );
      }
      /**
       * @param {(value: string, key: string, self: FormData) => void} callbackFn
       * @param {unknown} thisArg
       */
      forEach(callbackFn, thisArg = globalThis) {
        webidl.brandCheck(this, FormData);
        webidl.argumentLengthCheck(arguments, 1, { header: "FormData.forEach" });
        if (typeof callbackFn !== "function") {
          throw new TypeError(
            "Failed to execute 'forEach' on 'FormData': parameter 1 is not of type 'Function'."
          );
        }
        for (const [key, value] of this) {
          callbackFn.apply(thisArg, [value, key, this]);
        }
      }
    };
    FormData.prototype[Symbol.iterator] = FormData.prototype.entries;
    Object.defineProperties(FormData.prototype, {
      [Symbol.toStringTag]: {
        value: "FormData",
        configurable: true
      }
    });
    function makeEntry(name, value, filename) {
      name = Buffer.from(name).toString("utf8");
      if (typeof value === "string") {
        value = Buffer.from(value).toString("utf8");
      } else {
        if (!isFileLike(value)) {
          value = value instanceof Blob2 ? new File([value], "blob", { type: value.type }) : new FileLike(value, "blob", { type: value.type });
        }
        if (filename !== void 0) {
          const options = {
            type: value.type,
            lastModified: value.lastModified
          };
          value = NativeFile && value instanceof NativeFile || value instanceof UndiciFile ? new File([value], filename, options) : new FileLike(value, filename, options);
        }
      }
      return { name, value };
    }
    module2.exports = { FormData };
  }
});

// lib/fetch/body.js
var require_body = __commonJS({
  "lib/fetch/body.js"(exports2, module2) {
    "use strict";
    var Busboy = require_main();
    var util = require_util();
    var {
      ReadableStreamFrom,
      isBlobLike,
      isReadableStreamLike,
      readableStreamClose,
      createDeferredPromise,
      fullyReadBody
    } = require_util2();
    var { FormData } = require_formdata();
    var { kState } = require_symbols2();
    var { webidl } = require_webidl();
    var { DOMException, structuredClone } = require_constants();
    var { Blob: Blob2, File: NativeFile } = require("buffer");
    var { kBodyUsed } = require_symbols();
    var assert = require("assert");
    var { isErrored } = require_util();
    var { isUint8Array, isArrayBuffer } = require("util/types");
    var { File: UndiciFile } = require_file();
    var { parseMIMEType, serializeAMimeType } = require_dataURL();
    var ReadableStream = globalThis.ReadableStream;
    var File = NativeFile ?? UndiciFile;
    function extractBody(object, keepalive = false) {
      if (!ReadableStream) {
        ReadableStream = require("stream/web").ReadableStream;
      }
      let stream = null;
      if (object instanceof ReadableStream) {
        stream = object;
      } else if (isBlobLike(object)) {
        stream = object.stream();
      } else {
        stream = new ReadableStream({
          async pull(controller) {
            controller.enqueue(
              typeof source === "string" ? new TextEncoder().encode(source) : source
            );
            queueMicrotask(() => readableStreamClose(controller));
          },
          start() {
          },
          type: void 0
        });
      }
      assert(isReadableStreamLike(stream));
      let action = null;
      let source = null;
      let length = null;
      let type = null;
      if (typeof object === "string") {
        source = object;
        type = "text/plain;charset=UTF-8";
      } else if (object instanceof URLSearchParams) {
        source = object.toString();
        type = "application/x-www-form-urlencoded;charset=UTF-8";
      } else if (isArrayBuffer(object)) {
        source = new Uint8Array(object.slice());
      } else if (ArrayBuffer.isView(object)) {
        source = new Uint8Array(object.buffer.slice(object.byteOffset, object.byteOffset + object.byteLength));
      } else if (util.isFormDataLike(object)) {
        const boundary = `----formdata-undici-0${`${Math.floor(Math.random() * 1e11)}`.padStart(11, "0")}`;
        const prefix = `--${boundary}\r
Content-Disposition: form-data`;
        const escape = (str) => str.replace(/\n/g, "%0A").replace(/\r/g, "%0D").replace(/"/g, "%22");
        const normalizeLinefeeds = (value) => value.replace(/\r?\n|\r/g, "\r\n");
        const enc = new TextEncoder();
        const blobParts = [];
        const rn = new Uint8Array([13, 10]);
        length = 0;
        let hasUnknownSizeValue = false;
        for (const [name, value] of object) {
          if (typeof value === "string") {
            const chunk2 = enc.encode(prefix + `; name="${escape(normalizeLinefeeds(name))}"\r
\r
${normalizeLinefeeds(value)}\r
`);
            blobParts.push(chunk2);
            length += chunk2.byteLength;
          } else {
            const chunk2 = enc.encode(`${prefix}; name="${escape(normalizeLinefeeds(name))}"` + (value.name ? `; filename="${escape(value.name)}"` : "") + `\r
Content-Type: ${value.type || "application/octet-stream"}\r
\r
`);
            blobParts.push(chunk2, value, rn);
            if (typeof value.size === "number") {
              length += chunk2.byteLength + value.size + rn.byteLength;
            } else {
              hasUnknownSizeValue = true;
            }
          }
        }
        const chunk = enc.encode(`--${boundary}--`);
        blobParts.push(chunk);
        length += chunk.byteLength;
        if (hasUnknownSizeValue) {
          length = null;
        }
        source = object;
        action = async function* () {
          for (const part of blobParts) {
            if (part.stream) {
              yield* part.stream();
            } else {
              yield part;
            }
          }
        };
        type = "multipart/form-data; boundary=" + boundary;
      } else if (isBlobLike(object)) {
        source = object;
        length = object.size;
        if (object.type) {
          type = object.type;
        }
      } else if (typeof object[Symbol.asyncIterator] === "function") {
        if (keepalive) {
          throw new TypeError("keepalive");
        }
        if (util.isDisturbed(object) || object.locked) {
          throw new TypeError(
            "Response body object should not be disturbed or locked"
          );
        }
        stream = object instanceof ReadableStream ? object : ReadableStreamFrom(object);
      }
      if (typeof source === "string" || util.isBuffer(source)) {
        length = Buffer.byteLength(source);
      }
      if (action != null) {
        let iterator;
        stream = new ReadableStream({
          async start() {
            iterator = action(object)[Symbol.asyncIterator]();
          },
          async pull(controller) {
            const { value, done } = await iterator.next();
            if (done) {
              queueMicrotask(() => {
                controller.close();
              });
            } else {
              if (!isErrored(stream)) {
                controller.enqueue(new Uint8Array(value));
              }
            }
            return controller.desiredSize > 0;
          },
          async cancel(reason) {
            await iterator.return();
          },
          type: void 0
        });
      }
      const body = { stream, source, length };
      return [body, type];
    }
    function safelyExtractBody(object, keepalive = false) {
      if (!ReadableStream) {
        ReadableStream = require("stream/web").ReadableStream;
      }
      if (object instanceof ReadableStream) {
        assert(!util.isDisturbed(object), "The body has already been consumed.");
        assert(!object.locked, "The stream is locked.");
      }
      return extractBody(object, keepalive);
    }
    function cloneBody(body) {
      const [out1, out2] = body.stream.tee();
      const out2Clone = structuredClone(out2, { transfer: [out2] });
      const [, finalClone] = out2Clone.tee();
      body.stream = out1;
      return {
        stream: finalClone,
        length: body.length,
        source: body.source
      };
    }
    async function* consumeBody(body) {
      if (body) {
        if (isUint8Array(body)) {
          yield body;
        } else {
          const stream = body.stream;
          if (util.isDisturbed(stream)) {
            throw new TypeError("The body has already been consumed.");
          }
          if (stream.locked) {
            throw new TypeError("The stream is locked.");
          }
          stream[kBodyUsed] = true;
          yield* stream;
        }
      }
    }
    function throwIfAborted(state) {
      if (state.aborted) {
        throw new DOMException("The operation was aborted.", "AbortError");
      }
    }
    function bodyMixinMethods(instance) {
      const methods = {
        blob() {
          return specConsumeBody(this, (bytes) => {
            let mimeType = bodyMimeType(this);
            if (mimeType === "failure") {
              mimeType = "";
            } else if (mimeType) {
              mimeType = serializeAMimeType(mimeType);
            }
            return new Blob2([bytes], { type: mimeType });
          }, instance);
        },
        arrayBuffer() {
          return specConsumeBody(this, (bytes) => {
            return new Uint8Array(bytes).buffer;
          }, instance);
        },
        text() {
          return specConsumeBody(this, utf8DecodeBytes, instance);
        },
        json() {
          return specConsumeBody(this, parseJSONFromBytes, instance);
        },
        async formData() {
          webidl.brandCheck(this, instance);
          throwIfAborted(this[kState]);
          const contentType = this.headers.get("Content-Type");
          if (/multipart\/form-data/.test(contentType)) {
            const headers = {};
            for (const [key, value] of this.headers)
              headers[key.toLowerCase()] = value;
            const responseFormData = new FormData();
            let busboy;
            try {
              busboy = new Busboy({
                headers,
                preservePath: true
              });
            } catch (err) {
              throw new DOMException(`${err}`, "AbortError");
            }
            busboy.on("field", (name, value) => {
              responseFormData.append(name, value);
            });
            busboy.on("file", (name, value, filename, encoding, mimeType) => {
              const chunks = [];
              if (encoding === "base64" || encoding.toLowerCase() === "base64") {
                let base64chunk = "";
                value.on("data", (chunk) => {
                  base64chunk += chunk.toString().replace(/[\r\n]/gm, "");
                  const end = base64chunk.length - base64chunk.length % 4;
                  chunks.push(Buffer.from(base64chunk.slice(0, end), "base64"));
                  base64chunk = base64chunk.slice(end);
                });
                value.on("end", () => {
                  chunks.push(Buffer.from(base64chunk, "base64"));
                  responseFormData.append(name, new File(chunks, filename, { type: mimeType }));
                });
              } else {
                value.on("data", (chunk) => {
                  chunks.push(chunk);
                });
                value.on("end", () => {
                  responseFormData.append(name, new File(chunks, filename, { type: mimeType }));
                });
              }
            });
            const busboyResolve = new Promise((resolve, reject) => {
              busboy.on("finish", resolve);
              busboy.on("error", (err) => reject(new TypeError(err)));
            });
            if (this.body !== null)
              for await (const chunk of consumeBody(this[kState].body))
                busboy.write(chunk);
            busboy.end();
            await busboyResolve;
            return responseFormData;
          } else if (/application\/x-www-form-urlencoded/.test(contentType)) {
            let entries;
            try {
              let text = "";
              const textDecoder = new TextDecoder("utf-8", { ignoreBOM: true });
              for await (const chunk of consumeBody(this[kState].body)) {
                if (!isUint8Array(chunk)) {
                  throw new TypeError("Expected Uint8Array chunk");
                }
                text += textDecoder.decode(chunk, { stream: true });
              }
              text += textDecoder.decode();
              entries = new URLSearchParams(text);
            } catch (err) {
              throw Object.assign(new TypeError(), { cause: err });
            }
            const formData = new FormData();
            for (const [name, value] of entries) {
              formData.append(name, value);
            }
            return formData;
          } else {
            await Promise.resolve();
            throwIfAborted(this[kState]);
            throw webidl.errors.exception({
              header: `${instance.name}.formData`,
              message: "Could not parse content as FormData."
            });
          }
        }
      };
      return methods;
    }
    function mixinBody(prototype) {
      Object.assign(prototype.prototype, bodyMixinMethods(prototype));
    }
    async function specConsumeBody(object, convertBytesToJSValue, instance) {
      webidl.brandCheck(object, instance);
      throwIfAborted(object[kState]);
      if (bodyUnusable(object[kState].body)) {
        throw new TypeError("Body is unusable");
      }
      const promise = createDeferredPromise();
      const errorSteps = (error) => promise.reject(error);
      const successSteps = (data) => {
        try {
          promise.resolve(convertBytesToJSValue(data));
        } catch (e) {
          errorSteps(e);
        }
      };
      if (object[kState].body == null) {
        successSteps(new Uint8Array());
        return promise.promise;
      }
      await fullyReadBody(object[kState].body, successSteps, errorSteps);
      return promise.promise;
    }
    function bodyUnusable(body) {
      return body != null && (body.stream.locked || util.isDisturbed(body.stream));
    }
    function utf8DecodeBytes(buffer) {
      if (buffer.length === 0) {
        return "";
      }
      if (buffer[0] === 239 && buffer[1] === 187 && buffer[2] === 191) {
        buffer = buffer.subarray(3);
      }
      const output = new TextDecoder().decode(buffer);
      return output;
    }
    function parseJSONFromBytes(bytes) {
      return JSON.parse(utf8DecodeBytes(bytes));
    }
    function bodyMimeType(object) {
      const { headersList } = object[kState];
      const contentType = headersList.get("content-type");
      if (contentType === null) {
        return "failure";
      }
      return parseMIMEType(contentType);
    }
    module2.exports = {
      extractBody,
      safelyExtractBody,
      cloneBody,
      mixinBody
    };
  }
});

// lib/fetch/response.js
var require_response = __commonJS({
  "lib/fetch/response.js"(exports2, module2) {
    "use strict";
    var { Headers, HeadersList, fill } = require_headers();
    var { extractBody, cloneBody, mixinBody } = require_body();
    var util = require_util();
    var { kEnumerableProperty } = util;
    var {
      isValidReasonPhrase,
      isCancelled,
      isAborted,
      isBlobLike,
      serializeJavascriptValueToJSONString,
      isErrorLike,
      isomorphicEncode
    } = require_util2();
    var {
      redirectStatus,
      nullBodyStatus,
      DOMException
    } = require_constants();
    var { kState, kHeaders, kGuard, kRealm } = require_symbols2();
    var { webidl } = require_webidl();
    var { FormData } = require_formdata();
    var { getGlobalOrigin } = require_global();
    var { URLSerializer } = require_dataURL();
    var { kHeadersList } = require_symbols();
    var assert = require("assert");
    var { types } = require("util");
    var ReadableStream = globalThis.ReadableStream || require("stream/web").ReadableStream;
    var Response = class {
      // Creates network error Response.
      static error() {
        const relevantRealm = { settingsObject: {} };
        const responseObject = new Response();
        responseObject[kState] = makeNetworkError();
        responseObject[kRealm] = relevantRealm;
        responseObject[kHeaders][kHeadersList] = responseObject[kState].headersList;
        responseObject[kHeaders][kGuard] = "immutable";
        responseObject[kHeaders][kRealm] = relevantRealm;
        return responseObject;
      }
      // https://fetch.spec.whatwg.org/#dom-response-json
      static json(data, init = {}) {
        webidl.argumentLengthCheck(arguments, 1, { header: "Response.json" });
        if (init !== null) {
          init = webidl.converters.ResponseInit(init);
        }
        const bytes = new TextEncoder("utf-8").encode(
          serializeJavascriptValueToJSONString(data)
        );
        const body = extractBody(bytes);
        const relevantRealm = { settingsObject: {} };
        const responseObject = new Response();
        responseObject[kRealm] = relevantRealm;
        responseObject[kHeaders][kGuard] = "response";
        responseObject[kHeaders][kRealm] = relevantRealm;
        initializeResponse(responseObject, init, { body: body[0], type: "application/json" });
        return responseObject;
      }
      // Creates a redirect Response that redirects to url with status status.
      static redirect(url, status = 302) {
        const relevantRealm = { settingsObject: {} };
        webidl.argumentLengthCheck(arguments, 1, { header: "Response.redirect" });
        url = webidl.converters.USVString(url);
        status = webidl.converters["unsigned short"](status);
        let parsedURL;
        try {
          parsedURL = new URL(url, getGlobalOrigin());
        } catch (err) {
          throw Object.assign(new TypeError("Failed to parse URL from " + url), {
            cause: err
          });
        }
        if (!redirectStatus.includes(status)) {
          throw new RangeError("Invalid status code " + status);
        }
        const responseObject = new Response();
        responseObject[kRealm] = relevantRealm;
        responseObject[kHeaders][kGuard] = "immutable";
        responseObject[kHeaders][kRealm] = relevantRealm;
        responseObject[kState].status = status;
        const value = isomorphicEncode(URLSerializer(parsedURL));
        responseObject[kState].headersList.append("location", value);
        return responseObject;
      }
      // https://fetch.spec.whatwg.org/#dom-response
      constructor(body = null, init = {}) {
        if (body !== null) {
          body = webidl.converters.BodyInit(body);
        }
        init = webidl.converters.ResponseInit(init);
        this[kRealm] = { settingsObject: {} };
        this[kState] = makeResponse({});
        this[kHeaders] = new Headers();
        this[kHeaders][kGuard] = "response";
        this[kHeaders][kHeadersList] = this[kState].headersList;
        this[kHeaders][kRealm] = this[kRealm];
        let bodyWithType = null;
        if (body != null) {
          const [extractedBody, type] = extractBody(body);
          bodyWithType = { body: extractedBody, type };
        }
        initializeResponse(this, init, bodyWithType);
      }
      // Returns response’s type, e.g., "cors".
      get type() {
        webidl.brandCheck(this, Response);
        return this[kState].type;
      }
      // Returns response’s URL, if it has one; otherwise the empty string.
      get url() {
        webidl.brandCheck(this, Response);
        const urlList = this[kState].urlList;
        const url = urlList[urlList.length - 1] ?? null;
        if (url === null) {
          return "";
        }
        return URLSerializer(url, true);
      }
      // Returns whether response was obtained through a redirect.
      get redirected() {
        webidl.brandCheck(this, Response);
        return this[kState].urlList.length > 1;
      }
      // Returns response’s status.
      get status() {
        webidl.brandCheck(this, Response);
        return this[kState].status;
      }
      // Returns whether response’s status is an ok status.
      get ok() {
        webidl.brandCheck(this, Response);
        return this[kState].status >= 200 && this[kState].status <= 299;
      }
      // Returns response’s status message.
      get statusText() {
        webidl.brandCheck(this, Response);
        return this[kState].statusText;
      }
      // Returns response’s headers as Headers.
      get headers() {
        webidl.brandCheck(this, Response);
        return this[kHeaders];
      }
      get body() {
        webidl.brandCheck(this, Response);
        return this[kState].body ? this[kState].body.stream : null;
      }
      get bodyUsed() {
        webidl.brandCheck(this, Response);
        return !!this[kState].body && util.isDisturbed(this[kState].body.stream);
      }
      // Returns a clone of response.
      clone() {
        webidl.brandCheck(this, Response);
        if (this.bodyUsed || this.body && this.body.locked) {
          throw webidl.errors.exception({
            header: "Response.clone",
            message: "Body has already been consumed."
          });
        }
        const clonedResponse = cloneResponse(this[kState]);
        const clonedResponseObject = new Response();
        clonedResponseObject[kState] = clonedResponse;
        clonedResponseObject[kRealm] = this[kRealm];
        clonedResponseObject[kHeaders][kHeadersList] = clonedResponse.headersList;
        clonedResponseObject[kHeaders][kGuard] = this[kHeaders][kGuard];
        clonedResponseObject[kHeaders][kRealm] = this[kHeaders][kRealm];
        return clonedResponseObject;
      }
    };
    mixinBody(Response);
    Object.defineProperties(Response.prototype, {
      type: kEnumerableProperty,
      url: kEnumerableProperty,
      status: kEnumerableProperty,
      ok: kEnumerableProperty,
      redirected: kEnumerableProperty,
      statusText: kEnumerableProperty,
      headers: kEnumerableProperty,
      clone: kEnumerableProperty,
      body: kEnumerableProperty,
      bodyUsed: kEnumerableProperty,
      [Symbol.toStringTag]: {
        value: "Response",
        configurable: true
      }
    });
    Object.defineProperties(Response, {
      json: kEnumerableProperty,
      redirect: kEnumerableProperty,
      error: kEnumerableProperty
    });
    function cloneResponse(response) {
      if (response.internalResponse) {
        return filterResponse(
          cloneResponse(response.internalResponse),
          response.type
        );
      }
      const newResponse = makeResponse({ ...response, body: null });
      if (response.body != null) {
        newResponse.body = cloneBody(response.body);
      }
      return newResponse;
    }
    function makeResponse(init) {
      return {
        aborted: false,
        rangeRequested: false,
        timingAllowPassed: false,
        requestIncludesCredentials: false,
        type: "default",
        status: 200,
        timingInfo: null,
        cacheState: "",
        statusText: "",
        ...init,
        headersList: init.headersList ? new HeadersList(init.headersList) : new HeadersList(),
        urlList: init.urlList ? [...init.urlList] : []
      };
    }
    function makeNetworkError(reason) {
      const isError = isErrorLike(reason);
      return makeResponse({
        type: "error",
        status: 0,
        error: isError ? reason : new Error(reason ? String(reason) : reason),
        aborted: reason && reason.name === "AbortError"
      });
    }
    function makeFilteredResponse(response, state) {
      state = {
        internalResponse: response,
        ...state
      };
      return new Proxy(response, {
        get(target, p) {
          return p in state ? state[p] : target[p];
        },
        set(target, p, value) {
          assert(!(p in state));
          target[p] = value;
          return true;
        }
      });
    }
    function filterResponse(response, type) {
      if (type === "basic") {
        return makeFilteredResponse(response, {
          type: "basic",
          headersList: response.headersList
        });
      } else if (type === "cors") {
        return makeFilteredResponse(response, {
          type: "cors",
          headersList: response.headersList
        });
      } else if (type === "opaque") {
        return makeFilteredResponse(response, {
          type: "opaque",
          urlList: Object.freeze([]),
          status: 0,
          statusText: "",
          body: null
        });
      } else if (type === "opaqueredirect") {
        return makeFilteredResponse(response, {
          type: "opaqueredirect",
          status: 0,
          statusText: "",
          headersList: [],
          body: null
        });
      } else {
        assert(false);
      }
    }
    function makeAppropriateNetworkError(fetchParams, err = null) {
      assert(isCancelled(fetchParams));
      return isAborted(fetchParams) ? makeNetworkError(Object.assign(new DOMException("The operation was aborted.", "AbortError"), { cause: err })) : makeNetworkError(Object.assign(new DOMException("Request was cancelled."), { cause: err }));
    }
    function initializeResponse(response, init, body) {
      if (init.status !== null && (init.status < 200 || init.status > 599)) {
        throw new RangeError('init["status"] must be in the range of 200 to 599, inclusive.');
      }
      if ("statusText" in init && init.statusText != null) {
        if (!isValidReasonPhrase(String(init.statusText))) {
          throw new TypeError("Invalid statusText");
        }
      }
      if ("status" in init && init.status != null) {
        response[kState].status = init.status;
      }
      if ("statusText" in init && init.statusText != null) {
        response[kState].statusText = init.statusText;
      }
      if ("headers" in init && init.headers != null) {
        fill(response[kHeaders], init.headers);
      }
      if (body) {
        if (nullBodyStatus.includes(response.status)) {
          throw webidl.errors.exception({
            header: "Response constructor",
            message: "Invalid response status code " + response.status
          });
        }
        response[kState].body = body.body;
        if (body.type != null && !response[kState].headersList.contains("Content-Type")) {
          response[kState].headersList.append("content-type", body.type);
        }
      }
    }
    webidl.converters.ReadableStream = webidl.interfaceConverter(
      ReadableStream
    );
    webidl.converters.FormData = webidl.interfaceConverter(
      FormData
    );
    webidl.converters.URLSearchParams = webidl.interfaceConverter(
      URLSearchParams
    );
    webidl.converters.XMLHttpRequestBodyInit = function(V) {
      if (typeof V === "string") {
        return webidl.converters.USVString(V);
      }
      if (isBlobLike(V)) {
        return webidl.converters.Blob(V, { strict: false });
      }
      if (types.isAnyArrayBuffer(V) || types.isTypedArray(V) || types.isDataView(V)) {
        return webidl.converters.BufferSource(V);
      }
      if (util.isFormDataLike(V)) {
        return webidl.converters.FormData(V, { strict: false });
      }
      if (V instanceof URLSearchParams) {
        return webidl.converters.URLSearchParams(V);
      }
      return webidl.converters.DOMString(V);
    };
    webidl.converters.BodyInit = function(V) {
      if (V instanceof ReadableStream) {
        return webidl.converters.ReadableStream(V);
      }
      if (V?.[Symbol.asyncIterator]) {
        return V;
      }
      return webidl.converters.XMLHttpRequestBodyInit(V);
    };
    webidl.converters.ResponseInit = webidl.dictionaryConverter([
      {
        key: "status",
        converter: webidl.converters["unsigned short"],
        defaultValue: 200
      },
      {
        key: "statusText",
        converter: webidl.converters.ByteString,
        defaultValue: ""
      },
      {
        key: "headers",
        converter: webidl.converters.HeadersInit
      }
    ]);
    module2.exports = {
      makeNetworkError,
      makeResponse,
      makeAppropriateNetworkError,
      filterResponse,
      Response,
      cloneResponse
    };
  }
});

// lib/compat/dispatcher-weakref.js
var require_dispatcher_weakref = __commonJS({
  "lib/compat/dispatcher-weakref.js"(exports2, module2) {
    "use strict";
    var { kConnected, kSize } = require_symbols();
    var CompatWeakRef = class {
      constructor(value) {
        this.value = value;
      }
      deref() {
        return this.value[kConnected] === 0 && this.value[kSize] === 0 ? void 0 : this.value;
      }
    };
    var CompatFinalizer = class {
      constructor(finalizer) {
        this.finalizer = finalizer;
      }
      register(dispatcher, key) {
        if (dispatcher.on) {
          dispatcher.on("disconnect", () => {
            if (dispatcher[kConnected] === 0 && dispatcher[kSize] === 0) {
              this.finalizer(key);
            }
          });
        }
      }
    };
    module2.exports = function() {
      if (process.env.NODE_V8_COVERAGE) {
        return {
          WeakRef: CompatWeakRef,
          FinalizationRegistry: CompatFinalizer
        };
      }
      return {
        WeakRef: global.WeakRef || CompatWeakRef,
        FinalizationRegistry: global.FinalizationRegistry || CompatFinalizer
      };
    };
  }
});

// lib/fetch/request.js
var require_request = __commonJS({
  "lib/fetch/request.js"(exports2, module2) {
    "use strict";
    var { extractBody, mixinBody, cloneBody } = require_body();
    var { Headers, fill: fillHeaders, HeadersList } = require_headers();
    var { FinalizationRegistry } = require_dispatcher_weakref()();
    var util = require_util();
    var {
      isValidHTTPToken,
      sameOrigin,
      normalizeMethod,
      makePolicyContainer
    } = require_util2();
    var {
      forbiddenMethods,
      corsSafeListedMethods,
      referrerPolicy,
      requestRedirect,
      requestMode,
      requestCredentials,
      requestCache,
      requestDuplex
    } = require_constants();
    var { kEnumerableProperty } = util;
    var { kHeaders, kSignal, kState, kGuard, kRealm } = require_symbols2();
    var { webidl } = require_webidl();
    var { getGlobalOrigin } = require_global();
    var { URLSerializer } = require_dataURL();
    var { kHeadersList } = require_symbols();
    var assert = require("assert");
    var { getMaxListeners, setMaxListeners, getEventListeners, defaultMaxListeners } = require("events");
    var TransformStream = globalThis.TransformStream;
    var kInit = Symbol("init");
    var kAbortController = Symbol("abortController");
    var requestFinalizer = new FinalizationRegistry(({ signal, abort }) => {
      signal.removeEventListener("abort", abort);
    });
    var Request = class {
      // https://fetch.spec.whatwg.org/#dom-request
      constructor(input, init = {}) {
        if (input === kInit) {
          return;
        }
        webidl.argumentLengthCheck(arguments, 1, { header: "Request constructor" });
        input = webidl.converters.RequestInfo(input);
        init = webidl.converters.RequestInit(init);
        this[kRealm] = {
          settingsObject: {
            baseUrl: getGlobalOrigin(),
            get origin() {
              return this.baseUrl?.origin;
            },
            policyContainer: makePolicyContainer()
          }
        };
        let request = null;
        let fallbackMode = null;
        const baseUrl = this[kRealm].settingsObject.baseUrl;
        let signal = null;
        if (typeof input === "string") {
          let parsedURL;
          try {
            parsedURL = new URL(input, baseUrl);
          } catch (err) {
            throw new TypeError("Failed to parse URL from " + input, { cause: err });
          }
          if (parsedURL.username || parsedURL.password) {
            throw new TypeError(
              "Request cannot be constructed from a URL that includes credentials: " + input
            );
          }
          request = makeRequest({ urlList: [parsedURL] });
          fallbackMode = "cors";
        } else {
          assert(input instanceof Request);
          request = input[kState];
          signal = input[kSignal];
        }
        const origin = this[kRealm].settingsObject.origin;
        let window = "client";
        if (request.window?.constructor?.name === "EnvironmentSettingsObject" && sameOrigin(request.window, origin)) {
          window = request.window;
        }
        if (init.window != null) {
          throw new TypeError(`'window' option '${window}' must be null`);
        }
        if ("window" in init) {
          window = "no-window";
        }
        request = makeRequest({
          // URL request’s URL.
          // undici implementation note: this is set as the first item in request's urlList in makeRequest
          // method request’s method.
          method: request.method,
          // header list A copy of request’s header list.
          // undici implementation note: headersList is cloned in makeRequest
          headersList: request.headersList,
          // unsafe-request flag Set.
          unsafeRequest: request.unsafeRequest,
          // client This’s relevant settings object.
          client: this[kRealm].settingsObject,
          // window window.
          window,
          // priority request’s priority.
          priority: request.priority,
          // origin request’s origin. The propagation of the origin is only significant for navigation requests
          // being handled by a service worker. In this scenario a request can have an origin that is different
          // from the current client.
          origin: request.origin,
          // referrer request’s referrer.
          referrer: request.referrer,
          // referrer policy request’s referrer policy.
          referrerPolicy: request.referrerPolicy,
          // mode request’s mode.
          mode: request.mode,
          // credentials mode request’s credentials mode.
          credentials: request.credentials,
          // cache mode request’s cache mode.
          cache: request.cache,
          // redirect mode request’s redirect mode.
          redirect: request.redirect,
          // integrity metadata request’s integrity metadata.
          integrity: request.integrity,
          // keepalive request’s keepalive.
          keepalive: request.keepalive,
          // reload-navigation flag request’s reload-navigation flag.
          reloadNavigation: request.reloadNavigation,
          // history-navigation flag request’s history-navigation flag.
          historyNavigation: request.historyNavigation,
          // URL list A clone of request’s URL list.
          urlList: [...request.urlList]
        });
        if (Object.keys(init).length > 0) {
          if (request.mode === "navigate") {
            request.mode = "same-origin";
          }
          request.reloadNavigation = false;
          request.historyNavigation = false;
          request.origin = "client";
          request.referrer = "client";
          request.referrerPolicy = "";
          request.url = request.urlList[request.urlList.length - 1];
          request.urlList = [request.url];
        }
        if (init.referrer !== void 0) {
          const referrer = init.referrer;
          if (referrer === "") {
            request.referrer = "no-referrer";
          } else {
            let parsedReferrer;
            try {
              parsedReferrer = new URL(referrer, baseUrl);
            } catch (err) {
              throw new TypeError(`Referrer "${referrer}" is not a valid URL.`, { cause: err });
            }
            if (parsedReferrer.protocol === "about:" && parsedReferrer.hostname === "client" || origin && !sameOrigin(parsedReferrer, this[kRealm].settingsObject.baseUrl)) {
              request.referrer = "client";
            } else {
              request.referrer = parsedReferrer;
            }
          }
        }
        if (init.referrerPolicy !== void 0) {
          request.referrerPolicy = init.referrerPolicy;
        }
        let mode;
        if (init.mode !== void 0) {
          mode = init.mode;
        } else {
          mode = fallbackMode;
        }
        if (mode === "navigate") {
          throw webidl.errors.exception({
            header: "Request constructor",
            message: "invalid request mode navigate."
          });
        }
        if (mode != null) {
          request.mode = mode;
        }
        if (init.credentials !== void 0) {
          request.credentials = init.credentials;
        }
        if (init.cache !== void 0) {
          request.cache = init.cache;
        }
        if (request.cache === "only-if-cached" && request.mode !== "same-origin") {
          throw new TypeError(
            "'only-if-cached' can be set only with 'same-origin' mode"
          );
        }
        if (init.redirect !== void 0) {
          request.redirect = init.redirect;
        }
        if (init.integrity !== void 0 && init.integrity != null) {
          request.integrity = String(init.integrity);
        }
        if (init.keepalive !== void 0) {
          request.keepalive = Boolean(init.keepalive);
        }
        if (init.method !== void 0) {
          let method = init.method;
          if (!isValidHTTPToken(init.method)) {
            throw TypeError(`'${init.method}' is not a valid HTTP method.`);
          }
          if (forbiddenMethods.indexOf(method.toUpperCase()) !== -1) {
            throw TypeError(`'${init.method}' HTTP method is unsupported.`);
          }
          method = normalizeMethod(init.method);
          request.method = method;
        }
        if (init.signal !== void 0) {
          signal = init.signal;
        }
        this[kState] = request;
        const ac = new AbortController();
        this[kSignal] = ac.signal;
        this[kSignal][kRealm] = this[kRealm];
        if (signal != null) {
          if (!signal || typeof signal.aborted !== "boolean" || typeof signal.addEventListener !== "function") {
            throw new TypeError(
              "Failed to construct 'Request': member signal is not of type AbortSignal."
            );
          }
          if (signal.aborted) {
            ac.abort(signal.reason);
          } else {
            this[kAbortController] = ac;
            const acRef = new WeakRef(ac);
            const abort = function() {
              const ac2 = acRef.deref();
              if (ac2 !== void 0) {
                ac2.abort(this.reason);
              }
            };
            try {
              if (typeof getMaxListeners === "function" && getMaxListeners(signal) === defaultMaxListeners) {
                setMaxListeners(100, signal);
              } else if (getEventListeners(signal, "abort").length >= defaultMaxListeners) {
                setMaxListeners(100, signal);
              }
            } catch {
            }
            util.addAbortListener(signal, abort);
            requestFinalizer.register(ac, { signal, abort });
          }
        }
        this[kHeaders] = new Headers();
        this[kHeaders][kHeadersList] = request.headersList;
        this[kHeaders][kGuard] = "request";
        this[kHeaders][kRealm] = this[kRealm];
        if (mode === "no-cors") {
          if (!corsSafeListedMethods.includes(request.method)) {
            throw new TypeError(
              `'${request.method} is unsupported in no-cors mode.`
            );
          }
          this[kHeaders][kGuard] = "request-no-cors";
        }
        if (Object.keys(init).length !== 0) {
          let headers = new Headers(this[kHeaders]);
          if (init.headers !== void 0) {
            headers = init.headers;
          }
          this[kHeaders][kHeadersList].clear();
          if (headers.constructor.name === "Headers") {
            for (const [key, val] of headers) {
              this[kHeaders].append(key, val);
            }
          } else {
            fillHeaders(this[kHeaders], headers);
          }
        }
        const inputBody = input instanceof Request ? input[kState].body : null;
        if ((init.body != null || inputBody != null) && (request.method === "GET" || request.method === "HEAD")) {
          throw new TypeError("Request with GET/HEAD method cannot have body.");
        }
        let initBody = null;
        if (init.body != null) {
          const [extractedBody, contentType] = extractBody(
            init.body,
            request.keepalive
          );
          initBody = extractedBody;
          if (contentType && !this[kHeaders][kHeadersList].contains("content-type")) {
            this[kHeaders].append("content-type", contentType);
          }
        }
        const inputOrInitBody = initBody ?? inputBody;
        if (inputOrInitBody != null && inputOrInitBody.source == null) {
          if (initBody != null && init.duplex == null) {
            throw new TypeError("RequestInit: duplex option is required when sending a body.");
          }
          if (request.mode !== "same-origin" && request.mode !== "cors") {
            throw new TypeError(
              'If request is made from ReadableStream, mode should be "same-origin" or "cors"'
            );
          }
          request.useCORSPreflightFlag = true;
        }
        let finalBody = inputOrInitBody;
        if (initBody == null && inputBody != null) {
          if (util.isDisturbed(inputBody.stream) || inputBody.stream.locked) {
            throw new TypeError(
              "Cannot construct a Request with a Request object that has already been used."
            );
          }
          if (!TransformStream) {
            TransformStream = require("stream/web").TransformStream;
          }
          const identityTransform = new TransformStream();
          inputBody.stream.pipeThrough(identityTransform);
          finalBody = {
            source: inputBody.source,
            length: inputBody.length,
            stream: identityTransform.readable
          };
        }
        this[kState].body = finalBody;
      }
      // Returns request’s HTTP method, which is "GET" by default.
      get method() {
        webidl.brandCheck(this, Request);
        return this[kState].method;
      }
      // Returns the URL of request as a string.
      get url() {
        webidl.brandCheck(this, Request);
        return URLSerializer(this[kState].url);
      }
      // Returns a Headers object consisting of the headers associated with request.
      // Note that headers added in the network layer by the user agent will not
      // be accounted for in this object, e.g., the "Host" header.
      get headers() {
        webidl.brandCheck(this, Request);
        return this[kHeaders];
      }
      // Returns the kind of resource requested by request, e.g., "document"
      // or "script".
      get destination() {
        webidl.brandCheck(this, Request);
        return this[kState].destination;
      }
      // Returns the referrer of request. Its value can be a same-origin URL if
      // explicitly set in init, the empty string to indicate no referrer, and
      // "about:client" when defaulting to the global’s default. This is used
      // during fetching to determine the value of the `Referer` header of the
      // request being made.
      get referrer() {
        webidl.brandCheck(this, Request);
        if (this[kState].referrer === "no-referrer") {
          return "";
        }
        if (this[kState].referrer === "client") {
          return "about:client";
        }
        return this[kState].referrer.toString();
      }
      // Returns the referrer policy associated with request.
      // This is used during fetching to compute the value of the request’s
      // referrer.
      get referrerPolicy() {
        webidl.brandCheck(this, Request);
        return this[kState].referrerPolicy;
      }
      // Returns the mode associated with request, which is a string indicating
      // whether the request will use CORS, or will be restricted to same-origin
      // URLs.
      get mode() {
        webidl.brandCheck(this, Request);
        return this[kState].mode;
      }
      // Returns the credentials mode associated with request,
      // which is a string indicating whether credentials will be sent with the
      // request always, never, or only when sent to a same-origin URL.
      get credentials() {
        return this[kState].credentials;
      }
      // Returns the cache mode associated with request,
      // which is a string indicating how the request will
      // interact with the browser’s cache when fetching.
      get cache() {
        webidl.brandCheck(this, Request);
        return this[kState].cache;
      }
      // Returns the redirect mode associated with request,
      // which is a string indicating how redirects for the
      // request will be handled during fetching. A request
      // will follow redirects by default.
      get redirect() {
        webidl.brandCheck(this, Request);
        return this[kState].redirect;
      }
      // Returns request’s subresource integrity metadata, which is a
      // cryptographic hash of the resource being fetched. Its value
      // consists of multiple hashes separated by whitespace. [SRI]
      get integrity() {
        webidl.brandCheck(this, Request);
        return this[kState].integrity;
      }
      // Returns a boolean indicating whether or not request can outlive the
      // global in which it was created.
      get keepalive() {
        webidl.brandCheck(this, Request);
        return this[kState].keepalive;
      }
      // Returns a boolean indicating whether or not request is for a reload
      // navigation.
      get isReloadNavigation() {
        webidl.brandCheck(this, Request);
        return this[kState].reloadNavigation;
      }
      // Returns a boolean indicating whether or not request is for a history
      // navigation (a.k.a. back-foward navigation).
      get isHistoryNavigation() {
        webidl.brandCheck(this, Request);
        return this[kState].historyNavigation;
      }
      // Returns the signal associated with request, which is an AbortSignal
      // object indicating whether or not request has been aborted, and its
      // abort event handler.
      get signal() {
        webidl.brandCheck(this, Request);
        return this[kSignal];
      }
      get body() {
        webidl.brandCheck(this, Request);
        return this[kState].body ? this[kState].body.stream : null;
      }
      get bodyUsed() {
        webidl.brandCheck(this, Request);
        return !!this[kState].body && util.isDisturbed(this[kState].body.stream);
      }
      get duplex() {
        webidl.brandCheck(this, Request);
        return "half";
      }
      // Returns a clone of request.
      clone() {
        webidl.brandCheck(this, Request);
        if (this.bodyUsed || this.body?.locked) {
          throw new TypeError("unusable");
        }
        const clonedRequest = cloneRequest(this[kState]);
        const clonedRequestObject = new Request(kInit);
        clonedRequestObject[kState] = clonedRequest;
        clonedRequestObject[kRealm] = this[kRealm];
        clonedRequestObject[kHeaders] = new Headers();
        clonedRequestObject[kHeaders][kHeadersList] = clonedRequest.headersList;
        clonedRequestObject[kHeaders][kGuard] = this[kHeaders][kGuard];
        clonedRequestObject[kHeaders][kRealm] = this[kHeaders][kRealm];
        const ac = new AbortController();
        if (this.signal.aborted) {
          ac.abort(this.signal.reason);
        } else {
          util.addAbortListener(
            this.signal,
            () => {
              ac.abort(this.signal.reason);
            }
          );
        }
        clonedRequestObject[kSignal] = ac.signal;
        return clonedRequestObject;
      }
    };
    mixinBody(Request);
    function makeRequest(init) {
      const request = {
        method: "GET",
        localURLsOnly: false,
        unsafeRequest: false,
        body: null,
        client: null,
        reservedClient: null,
        replacesClientId: "",
        window: "client",
        keepalive: false,
        serviceWorkers: "all",
        initiator: "",
        destination: "",
        priority: null,
        origin: "client",
        policyContainer: "client",
        referrer: "client",
        referrerPolicy: "",
        mode: "no-cors",
        useCORSPreflightFlag: false,
        credentials: "same-origin",
        useCredentials: false,
        cache: "default",
        redirect: "follow",
        integrity: "",
        cryptoGraphicsNonceMetadata: "",
        parserMetadata: "",
        reloadNavigation: false,
        historyNavigation: false,
        userActivation: false,
        taintedOrigin: false,
        redirectCount: 0,
        responseTainting: "basic",
        preventNoCacheCacheControlHeaderModification: false,
        done: false,
        timingAllowFailed: false,
        ...init,
        headersList: init.headersList ? new HeadersList(init.headersList) : new HeadersList()
      };
      request.url = request.urlList[0];
      return request;
    }
    function cloneRequest(request) {
      const newRequest = makeRequest({ ...request, body: null });
      if (request.body != null) {
        newRequest.body = cloneBody(request.body);
      }
      return newRequest;
    }
    Object.defineProperties(Request.prototype, {
      method: kEnumerableProperty,
      url: kEnumerableProperty,
      headers: kEnumerableProperty,
      redirect: kEnumerableProperty,
      clone: kEnumerableProperty,
      signal: kEnumerableProperty,
      duplex: kEnumerableProperty,
      destination: kEnumerableProperty,
      body: kEnumerableProperty,
      bodyUsed: kEnumerableProperty,
      isHistoryNavigation: kEnumerableProperty,
      isReloadNavigation: kEnumerableProperty,
      keepalive: kEnumerableProperty,
      integrity: kEnumerableProperty,
      cache: kEnumerableProperty,
      credentials: kEnumerableProperty,
      attribute: kEnumerableProperty,
      referrerPolicy: kEnumerableProperty,
      referrer: kEnumerableProperty,
      mode: kEnumerableProperty,
      [Symbol.toStringTag]: {
        value: "Request",
        configurable: true
      }
    });
    webidl.converters.Request = webidl.interfaceConverter(
      Request
    );
    webidl.converters.RequestInfo = function(V) {
      if (typeof V === "string") {
        return webidl.converters.USVString(V);
      }
      if (V instanceof Request) {
        return webidl.converters.Request(V);
      }
      return webidl.converters.USVString(V);
    };
    webidl.converters.AbortSignal = webidl.interfaceConverter(
      AbortSignal
    );
    webidl.converters.RequestInit = webidl.dictionaryConverter([
      {
        key: "method",
        converter: webidl.converters.ByteString
      },
      {
        key: "headers",
        converter: webidl.converters.HeadersInit
      },
      {
        key: "body",
        converter: webidl.nullableConverter(
          webidl.converters.BodyInit
        )
      },
      {
        key: "referrer",
        converter: webidl.converters.USVString
      },
      {
        key: "referrerPolicy",
        converter: webidl.converters.DOMString,
        // https://w3c.github.io/webappsec-referrer-policy/#referrer-policy
        allowedValues: referrerPolicy
      },
      {
        key: "mode",
        converter: webidl.converters.DOMString,
        // https://fetch.spec.whatwg.org/#concept-request-mode
        allowedValues: requestMode
      },
      {
        key: "credentials",
        converter: webidl.converters.DOMString,
        // https://fetch.spec.whatwg.org/#requestcredentials
        allowedValues: requestCredentials
      },
      {
        key: "cache",
        converter: webidl.converters.DOMString,
        // https://fetch.spec.whatwg.org/#requestcache
        allowedValues: requestCache
      },
      {
        key: "redirect",
        converter: webidl.converters.DOMString,
        // https://fetch.spec.whatwg.org/#requestredirect
        allowedValues: requestRedirect
      },
      {
        key: "integrity",
        converter: webidl.converters.DOMString
      },
      {
        key: "keepalive",
        converter: webidl.converters.boolean
      },
      {
        key: "signal",
        converter: webidl.nullableConverter(
          (signal) => webidl.converters.AbortSignal(
            signal,
            { strict: false }
          )
        )
      },
      {
        key: "window",
        converter: webidl.converters.any
      },
      {
        key: "duplex",
        converter: webidl.converters.DOMString,
        allowedValues: requestDuplex
      }
    ]);
    module2.exports = { Request, makeRequest };
  }
});

// lib/dispatcher.js
var require_dispatcher = __commonJS({
  "lib/dispatcher.js"(exports2, module2) {
    "use strict";
    var EventEmitter = require("events");
    var Dispatcher = class extends EventEmitter {
      dispatch() {
        throw new Error("not implemented");
      }
      close() {
        throw new Error("not implemented");
      }
      destroy() {
        throw new Error("not implemented");
      }
    };
    module2.exports = Dispatcher;
  }
});

// lib/dispatcher-base.js
var require_dispatcher_base = __commonJS({
  "lib/dispatcher-base.js"(exports2, module2) {
    "use strict";
    var Dispatcher = require_dispatcher();
    var {
      ClientDestroyedError,
      ClientClosedError,
      InvalidArgumentError
    } = require_errors();
    var { kDestroy, kClose, kDispatch, kInterceptors } = require_symbols();
    var kDestroyed = Symbol("destroyed");
    var kClosed = Symbol("closed");
    var kOnDestroyed = Symbol("onDestroyed");
    var kOnClosed = Symbol("onClosed");
    var kInterceptedDispatch = Symbol("Intercepted Dispatch");
    var DispatcherBase = class extends Dispatcher {
      constructor() {
        super();
        this[kDestroyed] = false;
        this[kOnDestroyed] = null;
        this[kClosed] = false;
        this[kOnClosed] = [];
      }
      get destroyed() {
        return this[kDestroyed];
      }
      get closed() {
        return this[kClosed];
      }
      get interceptors() {
        return this[kInterceptors];
      }
      set interceptors(newInterceptors) {
        if (newInterceptors) {
          for (let i = newInterceptors.length - 1; i >= 0; i--) {
            const interceptor = this[kInterceptors][i];
            if (typeof interceptor !== "function") {
              throw new InvalidArgumentError("interceptor must be an function");
            }
          }
        }
        this[kInterceptors] = newInterceptors;
      }
      close(callback) {
        if (callback === void 0) {
          return new Promise((resolve, reject) => {
            this.close((err, data) => {
              return err ? reject(err) : resolve(data);
            });
          });
        }
        if (typeof callback !== "function") {
          throw new InvalidArgumentError("invalid callback");
        }
        if (this[kDestroyed]) {
          queueMicrotask(() => callback(new ClientDestroyedError(), null));
          return;
        }
        if (this[kClosed]) {
          if (this[kOnClosed]) {
            this[kOnClosed].push(callback);
          } else {
            queueMicrotask(() => callback(null, null));
          }
          return;
        }
        this[kClosed] = true;
        this[kOnClosed].push(callback);
        const onClosed = () => {
          const callbacks = this[kOnClosed];
          this[kOnClosed] = null;
          for (let i = 0; i < callbacks.length; i++) {
            callbacks[i](null, null);
          }
        };
        this[kClose]().then(() => this.destroy()).then(() => {
          queueMicrotask(onClosed);
        });
      }
      destroy(err, callback) {
        if (typeof err === "function") {
          callback = err;
          err = null;
        }
        if (callback === void 0) {
          return new Promise((resolve, reject) => {
            this.destroy(err, (err2, data) => {
              return err2 ? (
                /* istanbul ignore next: should never error */
                reject(err2)
              ) : resolve(data);
            });
          });
        }
        if (typeof callback !== "function") {
          throw new InvalidArgumentError("invalid callback");
        }
        if (this[kDestroyed]) {
          if (this[kOnDestroyed]) {
            this[kOnDestroyed].push(callback);
          } else {
            queueMicrotask(() => callback(null, null));
          }
          return;
        }
        if (!err) {
          err = new ClientDestroyedError();
        }
        this[kDestroyed] = true;
        this[kOnDestroyed] = this[kOnDestroyed] || [];
        this[kOnDestroyed].push(callback);
        const onDestroyed = () => {
          const callbacks = this[kOnDestroyed];
          this[kOnDestroyed] = null;
          for (let i = 0; i < callbacks.length; i++) {
            callbacks[i](null, null);
          }
        };
        this[kDestroy](err).then(() => {
          queueMicrotask(onDestroyed);
        });
      }
      [kInterceptedDispatch](opts, handler) {
        if (!this[kInterceptors] || this[kInterceptors].length === 0) {
          this[kInterceptedDispatch] = this[kDispatch];
          return this[kDispatch](opts, handler);
        }
        let dispatch = this[kDispatch].bind(this);
        for (let i = this[kInterceptors].length - 1; i >= 0; i--) {
          dispatch = this[kInterceptors][i](dispatch);
        }
        this[kInterceptedDispatch] = dispatch;
        return dispatch(opts, handler);
      }
      dispatch(opts, handler) {
        if (!handler || typeof handler !== "object") {
          throw new InvalidArgumentError("handler must be an object");
        }
        try {
          if (!opts || typeof opts !== "object") {
            throw new InvalidArgumentError("opts must be an object.");
          }
          if (this[kDestroyed] || this[kOnDestroyed]) {
            throw new ClientDestroyedError();
          }
          if (this[kClosed]) {
            throw new ClientClosedError();
          }
          return this[kInterceptedDispatch](opts, handler);
        } catch (err) {
          if (typeof handler.onError !== "function") {
            throw new InvalidArgumentError("invalid onError method");
          }
          handler.onError(err);
          return false;
        }
      }
    };
    module2.exports = DispatcherBase;
  }
});

// lib/node/fixed-queue.js
var require_fixed_queue = __commonJS({
  "lib/node/fixed-queue.js"(exports2, module2) {
    "use strict";
    var kSize = 2048;
    var kMask = kSize - 1;
    var FixedCircularBuffer = class {
      constructor() {
        this.bottom = 0;
        this.top = 0;
        this.list = new Array(kSize);
        this.next = null;
      }
      isEmpty() {
        return this.top === this.bottom;
      }
      isFull() {
        return (this.top + 1 & kMask) === this.bottom;
      }
      push(data) {
        this.list[this.top] = data;
        this.top = this.top + 1 & kMask;
      }
      shift() {
        const nextItem = this.list[this.bottom];
        if (nextItem === void 0)
          return null;
        this.list[this.bottom] = void 0;
        this.bottom = this.bottom + 1 & kMask;
        return nextItem;
      }
    };
    module2.exports = class FixedQueue {
      constructor() {
        this.head = this.tail = new FixedCircularBuffer();
      }
      isEmpty() {
        return this.head.isEmpty();
      }
      push(data) {
        if (this.head.isFull()) {
          this.head = this.head.next = new FixedCircularBuffer();
        }
        this.head.push(data);
      }
      shift() {
        const tail = this.tail;
        const next = tail.shift();
        if (tail.isEmpty() && tail.next !== null) {
          this.tail = tail.next;
        }
        return next;
      }
    };
  }
});

// lib/pool-stats.js
var require_pool_stats = __commonJS({
  "lib/pool-stats.js"(exports2, module2) {
    var { kFree, kConnected, kPending, kQueued, kRunning, kSize } = require_symbols();
    var kPool = Symbol("pool");
    var PoolStats = class {
      constructor(pool) {
        this[kPool] = pool;
      }
      get connected() {
        return this[kPool][kConnected];
      }
      get free() {
        return this[kPool][kFree];
      }
      get pending() {
        return this[kPool][kPending];
      }
      get queued() {
        return this[kPool][kQueued];
      }
      get running() {
        return this[kPool][kRunning];
      }
      get size() {
        return this[kPool][kSize];
      }
    };
    module2.exports = PoolStats;
  }
});

// lib/pool-base.js
var require_pool_base = __commonJS({
  "lib/pool-base.js"(exports2, module2) {
    "use strict";
    var DispatcherBase = require_dispatcher_base();
    var FixedQueue = require_fixed_queue();
    var { kConnected, kSize, kRunning, kPending, kQueued, kBusy, kFree, kUrl, kClose, kDestroy, kDispatch } = require_symbols();
    var PoolStats = require_pool_stats();
    var kClients = Symbol("clients");
    var kNeedDrain = Symbol("needDrain");
    var kQueue = Symbol("queue");
    var kClosedResolve = Symbol("closed resolve");
    var kOnDrain = Symbol("onDrain");
    var kOnConnect = Symbol("onConnect");
    var kOnDisconnect = Symbol("onDisconnect");
    var kOnConnectionError = Symbol("onConnectionError");
    var kGetDispatcher = Symbol("get dispatcher");
    var kAddClient = Symbol("add client");
    var kRemoveClient = Symbol("remove client");
    var kStats = Symbol("stats");
    var PoolBase = class extends DispatcherBase {
      constructor() {
        super();
        this[kQueue] = new FixedQueue();
        this[kClients] = [];
        this[kQueued] = 0;
        const pool = this;
        this[kOnDrain] = function onDrain(origin, targets) {
          const queue = pool[kQueue];
          let needDrain = false;
          while (!needDrain) {
            const item = queue.shift();
            if (!item) {
              break;
            }
            pool[kQueued]--;
            needDrain = !this.dispatch(item.opts, item.handler);
          }
          this[kNeedDrain] = needDrain;
          if (!this[kNeedDrain] && pool[kNeedDrain]) {
            pool[kNeedDrain] = false;
            pool.emit("drain", origin, [pool, ...targets]);
          }
          if (pool[kClosedResolve] && queue.isEmpty()) {
            Promise.all(pool[kClients].map((c) => c.close())).then(pool[kClosedResolve]);
          }
        };
        this[kOnConnect] = (origin, targets) => {
          pool.emit("connect", origin, [pool, ...targets]);
        };
        this[kOnDisconnect] = (origin, targets, err) => {
          pool.emit("disconnect", origin, [pool, ...targets], err);
        };
        this[kOnConnectionError] = (origin, targets, err) => {
          pool.emit("connectionError", origin, [pool, ...targets], err);
        };
        this[kStats] = new PoolStats(this);
      }
      get [kBusy]() {
        return this[kNeedDrain];
      }
      get [kConnected]() {
        return this[kClients].filter((client) => client[kConnected]).length;
      }
      get [kFree]() {
        return this[kClients].filter((client) => client[kConnected] && !client[kNeedDrain]).length;
      }
      get [kPending]() {
        let ret = this[kQueued];
        for (const { [kPending]: pending } of this[kClients]) {
          ret += pending;
        }
        return ret;
      }
      get [kRunning]() {
        let ret = 0;
        for (const { [kRunning]: running } of this[kClients]) {
          ret += running;
        }
        return ret;
      }
      get [kSize]() {
        let ret = this[kQueued];
        for (const { [kSize]: size } of this[kClients]) {
          ret += size;
        }
        return ret;
      }
      get stats() {
        return this[kStats];
      }
      async [kClose]() {
        if (this[kQueue].isEmpty()) {
          return Promise.all(this[kClients].map((c) => c.close()));
        } else {
          return new Promise((resolve) => {
            this[kClosedResolve] = resolve;
          });
        }
      }
      async [kDestroy](err) {
        while (true) {
          const item = this[kQueue].shift();
          if (!item) {
            break;
          }
          item.handler.onError(err);
        }
        return Promise.all(this[kClients].map((c) => c.destroy(err)));
      }
      [kDispatch](opts, handler) {
        const dispatcher = this[kGetDispatcher]();
        if (!dispatcher) {
          this[kNeedDrain] = true;
          this[kQueue].push({ opts, handler });
          this[kQueued]++;
        } else if (!dispatcher.dispatch(opts, handler)) {
          dispatcher[kNeedDrain] = true;
          this[kNeedDrain] = !this[kGetDispatcher]();
        }
        return !this[kNeedDrain];
      }
      [kAddClient](client) {
        client.on("drain", this[kOnDrain]).on("connect", this[kOnConnect]).on("disconnect", this[kOnDisconnect]).on("connectionError", this[kOnConnectionError]);
        this[kClients].push(client);
        if (this[kNeedDrain]) {
          process.nextTick(() => {
            if (this[kNeedDrain]) {
              this[kOnDrain](client[kUrl], [this, client]);
            }
          });
        }
        return this;
      }
      [kRemoveClient](client) {
        client.close(() => {
          const idx = this[kClients].indexOf(client);
          if (idx !== -1) {
            this[kClients].splice(idx, 1);
          }
        });
        this[kNeedDrain] = this[kClients].some((dispatcher) => !dispatcher[kNeedDrain] && dispatcher.closed !== true && dispatcher.destroyed !== true);
      }
    };
    module2.exports = {
      PoolBase,
      kClients,
      kNeedDrain,
      kAddClient,
      kRemoveClient,
      kGetDispatcher
    };
  }
});

// lib/timers.js
var require_timers = __commonJS({
  "lib/timers.js"(exports2, module2) {
    "use strict";
    var fastNow = Date.now();
    var fastNowTimeout;
    var fastTimers = [];
    function onTimeout() {
      fastNow = Date.now();
      let len = fastTimers.length;
      let idx = 0;
      while (idx < len) {
        const timer = fastTimers[idx];
        if (timer.state === 0) {
          timer.state = fastNow + timer.delay;
        } else if (timer.state > 0 && fastNow >= timer.state) {
          timer.state = -1;
          timer.callback(timer.opaque);
        }
        if (timer.state === -1) {
          timer.state = -2;
          if (idx !== len - 1) {
            fastTimers[idx] = fastTimers.pop();
          } else {
            fastTimers.pop();
          }
          len -= 1;
        } else {
          idx += 1;
        }
      }
      if (fastTimers.length > 0) {
        refreshTimeout();
      }
    }
    function refreshTimeout() {
      if (fastNowTimeout && fastNowTimeout.refresh) {
        fastNowTimeout.refresh();
      } else {
        clearTimeout(fastNowTimeout);
        fastNowTimeout = setTimeout(onTimeout, 1e3);
        if (fastNowTimeout.unref) {
          fastNowTimeout.unref();
        }
      }
    }
    var Timeout = class {
      constructor(callback, delay, opaque) {
        this.callback = callback;
        this.delay = delay;
        this.opaque = opaque;
        this.state = -2;
        this.refresh();
      }
      refresh() {
        if (this.state === -2) {
          fastTimers.push(this);
          if (!fastNowTimeout || fastTimers.length === 1) {
            refreshTimeout();
          }
        }
        this.state = 0;
      }
      clear() {
        this.state = -1;
      }
    };
    module2.exports = {
      setTimeout(callback, delay, opaque) {
        return delay < 1e3 ? setTimeout(callback, delay, opaque) : new Timeout(callback, delay, opaque);
      },
      clearTimeout(timeout) {
        if (timeout instanceof Timeout) {
          timeout.clear();
        } else {
          clearTimeout(timeout);
        }
      }
    };
  }
});

// lib/core/request.js
var require_request2 = __commonJS({
  "lib/core/request.js"(exports2, module2) {
    "use strict";
    var {
      InvalidArgumentError,
      NotSupportedError
    } = require_errors();
    var assert = require("assert");
    var { kHTTP2BuildRequest, kHTTP2CopyHeaders, kHTTP1BuildRequest } = require_symbols();
    var util = require_util();
    var tokenRegExp = /^[\^_`a-zA-Z\-0-9!#$%&'*+.|~]+$/;
    var headerCharRegex = /[^\t\x20-\x7e\x80-\xff]/;
    var invalidPathRegex = /[^\u0021-\u00ff]/;
    var kHandler = Symbol("handler");
    var channels = {};
    var extractBody;
    try {
      const diagnosticsChannel = require("diagnostics_channel");
      channels.create = diagnosticsChannel.channel("undici:request:create");
      channels.bodySent = diagnosticsChannel.channel("undici:request:bodySent");
      channels.headers = diagnosticsChannel.channel("undici:request:headers");
      channels.trailers = diagnosticsChannel.channel("undici:request:trailers");
      channels.error = diagnosticsChannel.channel("undici:request:error");
    } catch {
      channels.create = { hasSubscribers: false };
      channels.bodySent = { hasSubscribers: false };
      channels.headers = { hasSubscribers: false };
      channels.trailers = { hasSubscribers: false };
      channels.error = { hasSubscribers: false };
    }
    var Request = class {
      constructor(origin, {
        path,
        method,
        body,
        headers,
        query,
        idempotent,
        blocking,
        upgrade,
        headersTimeout,
        bodyTimeout,
        reset,
        throwOnError,
        expectContinue
      }, handler) {
        if (typeof path !== "string") {
          throw new InvalidArgumentError("path must be a string");
        } else if (path[0] !== "/" && !(path.startsWith("http://") || path.startsWith("https://")) && method !== "CONNECT") {
          throw new InvalidArgumentError("path must be an absolute URL or start with a slash");
        } else if (invalidPathRegex.exec(path) !== null) {
          throw new InvalidArgumentError("invalid request path");
        }
        if (typeof method !== "string") {
          throw new InvalidArgumentError("method must be a string");
        } else if (tokenRegExp.exec(method) === null) {
          throw new InvalidArgumentError("invalid request method");
        }
        if (upgrade && typeof upgrade !== "string") {
          throw new InvalidArgumentError("upgrade must be a string");
        }
        if (headersTimeout != null && (!Number.isFinite(headersTimeout) || headersTimeout < 0)) {
          throw new InvalidArgumentError("invalid headersTimeout");
        }
        if (bodyTimeout != null && (!Number.isFinite(bodyTimeout) || bodyTimeout < 0)) {
          throw new InvalidArgumentError("invalid bodyTimeout");
        }
        if (reset != null && typeof reset !== "boolean") {
          throw new InvalidArgumentError("invalid reset");
        }
        if (expectContinue != null && typeof expectContinue !== "boolean") {
          throw new InvalidArgumentError("invalid expectContinue");
        }
        this.headersTimeout = headersTimeout;
        this.bodyTimeout = bodyTimeout;
        this.throwOnError = throwOnError === true;
        this.method = method;
        if (body == null) {
          this.body = null;
        } else if (util.isStream(body)) {
          this.body = body;
        } else if (util.isBuffer(body)) {
          this.body = body.byteLength ? body : null;
        } else if (ArrayBuffer.isView(body)) {
          this.body = body.buffer.byteLength ? Buffer.from(body.buffer, body.byteOffset, body.byteLength) : null;
        } else if (body instanceof ArrayBuffer) {
          this.body = body.byteLength ? Buffer.from(body) : null;
        } else if (typeof body === "string") {
          this.body = body.length ? Buffer.from(body) : null;
        } else if (util.isFormDataLike(body) || util.isIterable(body) || util.isBlobLike(body)) {
          this.body = body;
        } else {
          throw new InvalidArgumentError("body must be a string, a Buffer, a Readable stream, an iterable, or an async iterable");
        }
        this.completed = false;
        this.aborted = false;
        this.upgrade = upgrade || null;
        this.path = query ? util.buildURL(path, query) : path;
        this.origin = origin;
        this.idempotent = idempotent == null ? method === "HEAD" || method === "GET" : idempotent;
        this.blocking = blocking == null ? false : blocking;
        this.reset = reset == null ? null : reset;
        this.host = null;
        this.contentLength = null;
        this.contentType = null;
        this.headers = "";
        this.expectContinue = expectContinue != null ? expectContinue : false;
        if (Array.isArray(headers)) {
          if (headers.length % 2 !== 0) {
            throw new InvalidArgumentError("headers array must be even");
          }
          for (let i = 0; i < headers.length; i += 2) {
            processHeader(this, headers[i], headers[i + 1]);
          }
        } else if (headers && typeof headers === "object") {
          const keys = Object.keys(headers);
          for (let i = 0; i < keys.length; i++) {
            const key = keys[i];
            processHeader(this, key, headers[key]);
          }
        } else if (headers != null) {
          throw new InvalidArgumentError("headers must be an object or an array");
        }
        if (util.isFormDataLike(this.body)) {
          if (util.nodeMajor < 16 || util.nodeMajor === 16 && util.nodeMinor < 8) {
            throw new InvalidArgumentError("Form-Data bodies are only supported in node v16.8 and newer.");
          }
          if (!extractBody) {
            extractBody = require_body().extractBody;
          }
          const [bodyStream, contentType] = extractBody(body);
          if (this.contentType == null) {
            this.contentType = contentType;
            this.headers += `content-type: ${contentType}\r
`;
          }
          this.body = bodyStream.stream;
          this.contentLength = bodyStream.length;
        } else if (util.isBlobLike(body) && this.contentType == null && body.type) {
          this.contentType = body.type;
          this.headers += `content-type: ${body.type}\r
`;
        }
        util.validateHandler(handler, method, upgrade);
        this.servername = util.getServerName(this.host);
        this[kHandler] = handler;
        if (channels.create.hasSubscribers) {
          channels.create.publish({ request: this });
        }
      }
      onBodySent(chunk) {
        if (this[kHandler].onBodySent) {
          try {
            this[kHandler].onBodySent(chunk);
          } catch (err) {
            this.onError(err);
          }
        }
      }
      onRequestSent() {
        if (channels.bodySent.hasSubscribers) {
          channels.bodySent.publish({ request: this });
        }
      }
      onConnect(abort) {
        assert(!this.aborted);
        assert(!this.completed);
        return this[kHandler].onConnect(abort);
      }
      onHeaders(statusCode, headers, resume, statusText) {
        assert(!this.aborted);
        assert(!this.completed);
        if (channels.headers.hasSubscribers) {
          channels.headers.publish({ request: this, response: { statusCode, headers, statusText } });
        }
        return this[kHandler].onHeaders(statusCode, headers, resume, statusText);
      }
      onData(chunk) {
        assert(!this.aborted);
        assert(!this.completed);
        return this[kHandler].onData(chunk);
      }
      onUpgrade(statusCode, headers, socket) {
        assert(!this.aborted);
        assert(!this.completed);
        return this[kHandler].onUpgrade(statusCode, headers, socket);
      }
      onComplete(trailers) {
        assert(!this.aborted);
        this.completed = true;
        if (channels.trailers.hasSubscribers) {
          channels.trailers.publish({ request: this, trailers });
        }
        return this[kHandler].onComplete(trailers);
      }
      onError(error) {
        if (channels.error.hasSubscribers) {
          channels.error.publish({ request: this, error });
        }
        if (this.aborted) {
          return;
        }
        this.aborted = true;
        return this[kHandler].onError(error);
      }
      // TODO: adjust to support H2
      addHeader(key, value) {
        processHeader(this, key, value);
        return this;
      }
      static [kHTTP1BuildRequest](origin, opts, handler) {
        return new Request(origin, opts, handler);
      }
      static [kHTTP2BuildRequest](origin, opts, handler) {
        const headers = opts.headers;
        opts = { ...opts, headers: null };
        const request = new Request(origin, opts, handler);
        request.headers = {};
        if (Array.isArray(headers)) {
          if (headers.length % 2 !== 0) {
            throw new InvalidArgumentError("headers array must be even");
          }
          for (let i = 0; i < headers.length; i += 2) {
            processHeader(request, headers[i], headers[i + 1], true);
          }
        } else if (headers && typeof headers === "object") {
          const keys = Object.keys(headers);
          for (let i = 0; i < keys.length; i++) {
            const key = keys[i];
            processHeader(request, key, headers[key], true);
          }
        } else if (headers != null) {
          throw new InvalidArgumentError("headers must be an object or an array");
        }
        return request;
      }
      static [kHTTP2CopyHeaders](raw) {
        const rawHeaders = raw.split("\r\n");
        const headers = {};
        for (const header of rawHeaders) {
          const [key, value] = header.split(": ");
          if (value == null || value.length === 0)
            continue;
          if (headers[key])
            headers[key] += `,${value}`;
          else
            headers[key] = value;
        }
        return headers;
      }
    };
    function processHeaderValue(key, val, skipAppend) {
      if (val && typeof val === "object") {
        throw new InvalidArgumentError(`invalid ${key} header`);
      }
      val = val != null ? `${val}` : "";
      if (headerCharRegex.exec(val) !== null) {
        throw new InvalidArgumentError(`invalid ${key} header`);
      }
      return skipAppend ? val : `${key}: ${val}\r
`;
    }
    function processHeader(request, key, val, skipAppend = false) {
      if (val && (typeof val === "object" && !Array.isArray(val))) {
        throw new InvalidArgumentError(`invalid ${key} header`);
      } else if (val === void 0) {
        return;
      }
      if (request.host === null && key.length === 4 && key.toLowerCase() === "host") {
        if (headerCharRegex.exec(val) !== null) {
          throw new InvalidArgumentError(`invalid ${key} header`);
        }
        request.host = val;
      } else if (request.contentLength === null && key.length === 14 && key.toLowerCase() === "content-length") {
        request.contentLength = parseInt(val, 10);
        if (!Number.isFinite(request.contentLength)) {
          throw new InvalidArgumentError("invalid content-length header");
        }
      } else if (request.contentType === null && key.length === 12 && key.toLowerCase() === "content-type") {
        request.contentType = val;
        if (skipAppend)
          request.headers[key] = processHeaderValue(key, val, skipAppend);
        else
          request.headers += processHeaderValue(key, val);
      } else if (key.length === 17 && key.toLowerCase() === "transfer-encoding") {
        throw new InvalidArgumentError("invalid transfer-encoding header");
      } else if (key.length === 10 && key.toLowerCase() === "connection") {
        const value = typeof val === "string" ? val.toLowerCase() : null;
        if (value !== "close" && value !== "keep-alive") {
          throw new InvalidArgumentError("invalid connection header");
        } else if (value === "close") {
          request.reset = true;
        }
      } else if (key.length === 10 && key.toLowerCase() === "keep-alive") {
        throw new InvalidArgumentError("invalid keep-alive header");
      } else if (key.length === 7 && key.toLowerCase() === "upgrade") {
        throw new InvalidArgumentError("invalid upgrade header");
      } else if (key.length === 6 && key.toLowerCase() === "expect") {
        throw new NotSupportedError("expect header not supported");
      } else if (tokenRegExp.exec(key) === null) {
        throw new InvalidArgumentError("invalid header key");
      } else {
        if (Array.isArray(val)) {
          for (let i = 0; i < val.length; i++) {
            if (skipAppend) {
              if (request.headers[key])
                request.headers[key] += `,${processHeaderValue(key, val[i], skipAppend)}`;
              else
                request.headers[key] = processHeaderValue(key, val[i], skipAppend);
            } else {
              request.headers += processHeaderValue(key, val[i]);
            }
          }
        } else {
          if (skipAppend)
            request.headers[key] = processHeaderValue(key, val, skipAppend);
          else
            request.headers += processHeaderValue(key, val);
        }
      }
    }
    module2.exports = Request;
  }
});

// lib/core/connect.js
var require_connect = __commonJS({
  "lib/core/connect.js"(exports2, module2) {
    "use strict";
    var net = require("net");
    var assert = require("assert");
    var util = require_util();
    var { InvalidArgumentError, ConnectTimeoutError } = require_errors();
    var tls;
    var SessionCache;
    if (global.FinalizationRegistry && !process.env.NODE_V8_COVERAGE) {
      SessionCache = class WeakSessionCache {
        constructor(maxCachedSessions) {
          this._maxCachedSessions = maxCachedSessions;
          this._sessionCache = /* @__PURE__ */ new Map();
          this._sessionRegistry = new global.FinalizationRegistry((key) => {
            if (this._sessionCache.size < this._maxCachedSessions) {
              return;
            }
            const ref = this._sessionCache.get(key);
            if (ref !== void 0 && ref.deref() === void 0) {
              this._sessionCache.delete(key);
            }
          });
        }
        get(sessionKey) {
          const ref = this._sessionCache.get(sessionKey);
          return ref ? ref.deref() : null;
        }
        set(sessionKey, session) {
          if (this._maxCachedSessions === 0) {
            return;
          }
          this._sessionCache.set(sessionKey, new WeakRef(session));
          this._sessionRegistry.register(session, sessionKey);
        }
      };
    } else {
      SessionCache = class SimpleSessionCache {
        constructor(maxCachedSessions) {
          this._maxCachedSessions = maxCachedSessions;
          this._sessionCache = /* @__PURE__ */ new Map();
        }
        get(sessionKey) {
          return this._sessionCache.get(sessionKey);
        }
        set(sessionKey, session) {
          if (this._maxCachedSessions === 0) {
            return;
          }
          if (this._sessionCache.size >= this._maxCachedSessions) {
            const { value: oldestKey } = this._sessionCache.keys().next();
            this._sessionCache.delete(oldestKey);
          }
          this._sessionCache.set(sessionKey, session);
        }
      };
    }
    function buildConnector({ allowH2, maxCachedSessions, socketPath, timeout, ...opts }) {
      if (maxCachedSessions != null && (!Number.isInteger(maxCachedSessions) || maxCachedSessions < 0)) {
        throw new InvalidArgumentError("maxCachedSessions must be a positive integer or zero");
      }
      const options = { path: socketPath, ...opts };
      const sessionCache = new SessionCache(maxCachedSessions == null ? 100 : maxCachedSessions);
      timeout = timeout == null ? 1e4 : timeout;
      allowH2 = allowH2 != null ? allowH2 : false;
      return function connect({ hostname, host, protocol, port, servername, localAddress, httpSocket }, callback) {
        let socket;
        if (protocol === "https:") {
          if (!tls) {
            tls = require("tls");
          }
          servername = servername || options.servername || util.getServerName(host) || null;
          const sessionKey = servername || hostname;
          const session = sessionCache.get(sessionKey) || null;
          assert(sessionKey);
          socket = tls.connect({
            highWaterMark: 16384,
            // TLS in node can't have bigger HWM anyway...
            ...options,
            servername,
            session,
            localAddress,
            // TODO(HTTP/2): Add support for h2c
            ALPNProtocols: allowH2 ? ["http/1.1", "h2"] : ["http/1.1"],
            socket: httpSocket,
            // upgrade socket connection
            port: port || 443,
            host: hostname
          });
          socket.on("session", function(session2) {
            sessionCache.set(sessionKey, session2);
          });
        } else {
          assert(!httpSocket, "httpSocket can only be sent on TLS update");
          socket = net.connect({
            highWaterMark: 64 * 1024,
            // Same as nodejs fs streams.
            ...options,
            localAddress,
            port: port || 80,
            host: hostname
          });
        }
        if (options.keepAlive == null || options.keepAlive) {
          const keepAliveInitialDelay = options.keepAliveInitialDelay === void 0 ? 6e4 : options.keepAliveInitialDelay;
          socket.setKeepAlive(true, keepAliveInitialDelay);
        }
        const cancelTimeout = setupTimeout(() => onConnectTimeout(socket), timeout);
        socket.setNoDelay(true).once(protocol === "https:" ? "secureConnect" : "connect", function() {
          cancelTimeout();
          if (callback) {
            const cb = callback;
            callback = null;
            cb(null, this);
          }
        }).on("error", function(err) {
          cancelTimeout();
          if (callback) {
            const cb = callback;
            callback = null;
            cb(err);
          }
        });
        return socket;
      };
    }
    function setupTimeout(onConnectTimeout2, timeout) {
      if (!timeout) {
        return () => {
        };
      }
      let s1 = null;
      let s2 = null;
      const timeoutId = setTimeout(() => {
        s1 = setImmediate(() => {
          if (process.platform === "win32") {
            s2 = setImmediate(() => onConnectTimeout2());
          } else {
            onConnectTimeout2();
          }
        });
      }, timeout);
      return () => {
        clearTimeout(timeoutId);
        clearImmediate(s1);
        clearImmediate(s2);
      };
    }
    function onConnectTimeout(socket) {
      util.destroy(socket, new ConnectTimeoutError());
    }
    module2.exports = buildConnector;
  }
});

// lib/llhttp/utils.js
var require_utils = __commonJS({
  "lib/llhttp/utils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.enumToMap = void 0;
    function enumToMap(obj) {
      const res = {};
      Object.keys(obj).forEach((key) => {
        const value = obj[key];
        if (typeof value === "number") {
          res[key] = value;
        }
      });
      return res;
    }
    exports2.enumToMap = enumToMap;
  }
});

// lib/llhttp/constants.js
var require_constants2 = __commonJS({
  "lib/llhttp/constants.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SPECIAL_HEADERS = exports2.HEADER_STATE = exports2.MINOR = exports2.MAJOR = exports2.CONNECTION_TOKEN_CHARS = exports2.HEADER_CHARS = exports2.TOKEN = exports2.STRICT_TOKEN = exports2.HEX = exports2.URL_CHAR = exports2.STRICT_URL_CHAR = exports2.USERINFO_CHARS = exports2.MARK = exports2.ALPHANUM = exports2.NUM = exports2.HEX_MAP = exports2.NUM_MAP = exports2.ALPHA = exports2.FINISH = exports2.H_METHOD_MAP = exports2.METHOD_MAP = exports2.METHODS_RTSP = exports2.METHODS_ICE = exports2.METHODS_HTTP = exports2.METHODS = exports2.LENIENT_FLAGS = exports2.FLAGS = exports2.TYPE = exports2.ERROR = void 0;
    var utils_1 = require_utils();
    var ERROR;
    (function(ERROR2) {
      ERROR2[ERROR2["OK"] = 0] = "OK";
      ERROR2[ERROR2["INTERNAL"] = 1] = "INTERNAL";
      ERROR2[ERROR2["STRICT"] = 2] = "STRICT";
      ERROR2[ERROR2["LF_EXPECTED"] = 3] = "LF_EXPECTED";
      ERROR2[ERROR2["UNEXPECTED_CONTENT_LENGTH"] = 4] = "UNEXPECTED_CONTENT_LENGTH";
      ERROR2[ERROR2["CLOSED_CONNECTION"] = 5] = "CLOSED_CONNECTION";
      ERROR2[ERROR2["INVALID_METHOD"] = 6] = "INVALID_METHOD";
      ERROR2[ERROR2["INVALID_URL"] = 7] = "INVALID_URL";
      ERROR2[ERROR2["INVALID_CONSTANT"] = 8] = "INVALID_CONSTANT";
      ERROR2[ERROR2["INVALID_VERSION"] = 9] = "INVALID_VERSION";
      ERROR2[ERROR2["INVALID_HEADER_TOKEN"] = 10] = "INVALID_HEADER_TOKEN";
      ERROR2[ERROR2["INVALID_CONTENT_LENGTH"] = 11] = "INVALID_CONTENT_LENGTH";
      ERROR2[ERROR2["INVALID_CHUNK_SIZE"] = 12] = "INVALID_CHUNK_SIZE";
      ERROR2[ERROR2["INVALID_STATUS"] = 13] = "INVALID_STATUS";
      ERROR2[ERROR2["INVALID_EOF_STATE"] = 14] = "INVALID_EOF_STATE";
      ERROR2[ERROR2["INVALID_TRANSFER_ENCODING"] = 15] = "INVALID_TRANSFER_ENCODING";
      ERROR2[ERROR2["CB_MESSAGE_BEGIN"] = 16] = "CB_MESSAGE_BEGIN";
      ERROR2[ERROR2["CB_HEADERS_COMPLETE"] = 17] = "CB_HEADERS_COMPLETE";
      ERROR2[ERROR2["CB_MESSAGE_COMPLETE"] = 18] = "CB_MESSAGE_COMPLETE";
      ERROR2[ERROR2["CB_CHUNK_HEADER"] = 19] = "CB_CHUNK_HEADER";
      ERROR2[ERROR2["CB_CHUNK_COMPLETE"] = 20] = "CB_CHUNK_COMPLETE";
      ERROR2[ERROR2["PAUSED"] = 21] = "PAUSED";
      ERROR2[ERROR2["PAUSED_UPGRADE"] = 22] = "PAUSED_UPGRADE";
      ERROR2[ERROR2["PAUSED_H2_UPGRADE"] = 23] = "PAUSED_H2_UPGRADE";
      ERROR2[ERROR2["USER"] = 24] = "USER";
    })(ERROR = exports2.ERROR || (exports2.ERROR = {}));
    var TYPE;
    (function(TYPE2) {
      TYPE2[TYPE2["BOTH"] = 0] = "BOTH";
      TYPE2[TYPE2["REQUEST"] = 1] = "REQUEST";
      TYPE2[TYPE2["RESPONSE"] = 2] = "RESPONSE";
    })(TYPE = exports2.TYPE || (exports2.TYPE = {}));
    var FLAGS;
    (function(FLAGS2) {
      FLAGS2[FLAGS2["CONNECTION_KEEP_ALIVE"] = 1] = "CONNECTION_KEEP_ALIVE";
      FLAGS2[FLAGS2["CONNECTION_CLOSE"] = 2] = "CONNECTION_CLOSE";
      FLAGS2[FLAGS2["CONNECTION_UPGRADE"] = 4] = "CONNECTION_UPGRADE";
      FLAGS2[FLAGS2["CHUNKED"] = 8] = "CHUNKED";
      FLAGS2[FLAGS2["UPGRADE"] = 16] = "UPGRADE";
      FLAGS2[FLAGS2["CONTENT_LENGTH"] = 32] = "CONTENT_LENGTH";
      FLAGS2[FLAGS2["SKIPBODY"] = 64] = "SKIPBODY";
      FLAGS2[FLAGS2["TRAILING"] = 128] = "TRAILING";
      FLAGS2[FLAGS2["TRANSFER_ENCODING"] = 512] = "TRANSFER_ENCODING";
    })(FLAGS = exports2.FLAGS || (exports2.FLAGS = {}));
    var LENIENT_FLAGS;
    (function(LENIENT_FLAGS2) {
      LENIENT_FLAGS2[LENIENT_FLAGS2["HEADERS"] = 1] = "HEADERS";
      LENIENT_FLAGS2[LENIENT_FLAGS2["CHUNKED_LENGTH"] = 2] = "CHUNKED_LENGTH";
      LENIENT_FLAGS2[LENIENT_FLAGS2["KEEP_ALIVE"] = 4] = "KEEP_ALIVE";
    })(LENIENT_FLAGS = exports2.LENIENT_FLAGS || (exports2.LENIENT_FLAGS = {}));
    var METHODS;
    (function(METHODS2) {
      METHODS2[METHODS2["DELETE"] = 0] = "DELETE";
      METHODS2[METHODS2["GET"] = 1] = "GET";
      METHODS2[METHODS2["HEAD"] = 2] = "HEAD";
      METHODS2[METHODS2["POST"] = 3] = "POST";
      METHODS2[METHODS2["PUT"] = 4] = "PUT";
      METHODS2[METHODS2["CONNECT"] = 5] = "CONNECT";
      METHODS2[METHODS2["OPTIONS"] = 6] = "OPTIONS";
      METHODS2[METHODS2["TRACE"] = 7] = "TRACE";
      METHODS2[METHODS2["COPY"] = 8] = "COPY";
      METHODS2[METHODS2["LOCK"] = 9] = "LOCK";
      METHODS2[METHODS2["MKCOL"] = 10] = "MKCOL";
      METHODS2[METHODS2["MOVE"] = 11] = "MOVE";
      METHODS2[METHODS2["PROPFIND"] = 12] = "PROPFIND";
      METHODS2[METHODS2["PROPPATCH"] = 13] = "PROPPATCH";
      METHODS2[METHODS2["SEARCH"] = 14] = "SEARCH";
      METHODS2[METHODS2["UNLOCK"] = 15] = "UNLOCK";
      METHODS2[METHODS2["BIND"] = 16] = "BIND";
      METHODS2[METHODS2["REBIND"] = 17] = "REBIND";
      METHODS2[METHODS2["UNBIND"] = 18] = "UNBIND";
      METHODS2[METHODS2["ACL"] = 19] = "ACL";
      METHODS2[METHODS2["REPORT"] = 20] = "REPORT";
      METHODS2[METHODS2["MKACTIVITY"] = 21] = "MKACTIVITY";
      METHODS2[METHODS2["CHECKOUT"] = 22] = "CHECKOUT";
      METHODS2[METHODS2["MERGE"] = 23] = "MERGE";
      METHODS2[METHODS2["M-SEARCH"] = 24] = "M-SEARCH";
      METHODS2[METHODS2["NOTIFY"] = 25] = "NOTIFY";
      METHODS2[METHODS2["SUBSCRIBE"] = 26] = "SUBSCRIBE";
      METHODS2[METHODS2["UNSUBSCRIBE"] = 27] = "UNSUBSCRIBE";
      METHODS2[METHODS2["PATCH"] = 28] = "PATCH";
      METHODS2[METHODS2["PURGE"] = 29] = "PURGE";
      METHODS2[METHODS2["MKCALENDAR"] = 30] = "MKCALENDAR";
      METHODS2[METHODS2["LINK"] = 31] = "LINK";
      METHODS2[METHODS2["UNLINK"] = 32] = "UNLINK";
      METHODS2[METHODS2["SOURCE"] = 33] = "SOURCE";
      METHODS2[METHODS2["PRI"] = 34] = "PRI";
      METHODS2[METHODS2["DESCRIBE"] = 35] = "DESCRIBE";
      METHODS2[METHODS2["ANNOUNCE"] = 36] = "ANNOUNCE";
      METHODS2[METHODS2["SETUP"] = 37] = "SETUP";
      METHODS2[METHODS2["PLAY"] = 38] = "PLAY";
      METHODS2[METHODS2["PAUSE"] = 39] = "PAUSE";
      METHODS2[METHODS2["TEARDOWN"] = 40] = "TEARDOWN";
      METHODS2[METHODS2["GET_PARAMETER"] = 41] = "GET_PARAMETER";
      METHODS2[METHODS2["SET_PARAMETER"] = 42] = "SET_PARAMETER";
      METHODS2[METHODS2["REDIRECT"] = 43] = "REDIRECT";
      METHODS2[METHODS2["RECORD"] = 44] = "RECORD";
      METHODS2[METHODS2["FLUSH"] = 45] = "FLUSH";
    })(METHODS = exports2.METHODS || (exports2.METHODS = {}));
    exports2.METHODS_HTTP = [
      METHODS.DELETE,
      METHODS.GET,
      METHODS.HEAD,
      METHODS.POST,
      METHODS.PUT,
      METHODS.CONNECT,
      METHODS.OPTIONS,
      METHODS.TRACE,
      METHODS.COPY,
      METHODS.LOCK,
      METHODS.MKCOL,
      METHODS.MOVE,
      METHODS.PROPFIND,
      METHODS.PROPPATCH,
      METHODS.SEARCH,
      METHODS.UNLOCK,
      METHODS.BIND,
      METHODS.REBIND,
      METHODS.UNBIND,
      METHODS.ACL,
      METHODS.REPORT,
      METHODS.MKACTIVITY,
      METHODS.CHECKOUT,
      METHODS.MERGE,
      METHODS["M-SEARCH"],
      METHODS.NOTIFY,
      METHODS.SUBSCRIBE,
      METHODS.UNSUBSCRIBE,
      METHODS.PATCH,
      METHODS.PURGE,
      METHODS.MKCALENDAR,
      METHODS.LINK,
      METHODS.UNLINK,
      METHODS.PRI,
      // TODO(indutny): should we allow it with HTTP?
      METHODS.SOURCE
    ];
    exports2.METHODS_ICE = [
      METHODS.SOURCE
    ];
    exports2.METHODS_RTSP = [
      METHODS.OPTIONS,
      METHODS.DESCRIBE,
      METHODS.ANNOUNCE,
      METHODS.SETUP,
      METHODS.PLAY,
      METHODS.PAUSE,
      METHODS.TEARDOWN,
      METHODS.GET_PARAMETER,
      METHODS.SET_PARAMETER,
      METHODS.REDIRECT,
      METHODS.RECORD,
      METHODS.FLUSH,
      // For AirPlay
      METHODS.GET,
      METHODS.POST
    ];
    exports2.METHOD_MAP = utils_1.enumToMap(METHODS);
    exports2.H_METHOD_MAP = {};
    Object.keys(exports2.METHOD_MAP).forEach((key) => {
      if (/^H/.test(key)) {
        exports2.H_METHOD_MAP[key] = exports2.METHOD_MAP[key];
      }
    });
    var FINISH;
    (function(FINISH2) {
      FINISH2[FINISH2["SAFE"] = 0] = "SAFE";
      FINISH2[FINISH2["SAFE_WITH_CB"] = 1] = "SAFE_WITH_CB";
      FINISH2[FINISH2["UNSAFE"] = 2] = "UNSAFE";
    })(FINISH = exports2.FINISH || (exports2.FINISH = {}));
    exports2.ALPHA = [];
    for (let i = "A".charCodeAt(0); i <= "Z".charCodeAt(0); i++) {
      exports2.ALPHA.push(String.fromCharCode(i));
      exports2.ALPHA.push(String.fromCharCode(i + 32));
    }
    exports2.NUM_MAP = {
      0: 0,
      1: 1,
      2: 2,
      3: 3,
      4: 4,
      5: 5,
      6: 6,
      7: 7,
      8: 8,
      9: 9
    };
    exports2.HEX_MAP = {
      0: 0,
      1: 1,
      2: 2,
      3: 3,
      4: 4,
      5: 5,
      6: 6,
      7: 7,
      8: 8,
      9: 9,
      A: 10,
      B: 11,
      C: 12,
      D: 13,
      E: 14,
      F: 15,
      a: 10,
      b: 11,
      c: 12,
      d: 13,
      e: 14,
      f: 15
    };
    exports2.NUM = [
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9"
    ];
    exports2.ALPHANUM = exports2.ALPHA.concat(exports2.NUM);
    exports2.MARK = ["-", "_", ".", "!", "~", "*", "'", "(", ")"];
    exports2.USERINFO_CHARS = exports2.ALPHANUM.concat(exports2.MARK).concat(["%", ";", ":", "&", "=", "+", "$", ","]);
    exports2.STRICT_URL_CHAR = [
      "!",
      '"',
      "$",
      "%",
      "&",
      "'",
      "(",
      ")",
      "*",
      "+",
      ",",
      "-",
      ".",
      "/",
      ":",
      ";",
      "<",
      "=",
      ">",
      "@",
      "[",
      "\\",
      "]",
      "^",
      "_",
      "`",
      "{",
      "|",
      "}",
      "~"
    ].concat(exports2.ALPHANUM);
    exports2.URL_CHAR = exports2.STRICT_URL_CHAR.concat(["	", "\f"]);
    for (let i = 128; i <= 255; i++) {
      exports2.URL_CHAR.push(i);
    }
    exports2.HEX = exports2.NUM.concat(["a", "b", "c", "d", "e", "f", "A", "B", "C", "D", "E", "F"]);
    exports2.STRICT_TOKEN = [
      "!",
      "#",
      "$",
      "%",
      "&",
      "'",
      "*",
      "+",
      "-",
      ".",
      "^",
      "_",
      "`",
      "|",
      "~"
    ].concat(exports2.ALPHANUM);
    exports2.TOKEN = exports2.STRICT_TOKEN.concat([" "]);
    exports2.HEADER_CHARS = ["	"];
    for (let i = 32; i <= 255; i++) {
      if (i !== 127) {
        exports2.HEADER_CHARS.push(i);
      }
    }
    exports2.CONNECTION_TOKEN_CHARS = exports2.HEADER_CHARS.filter((c) => c !== 44);
    exports2.MAJOR = exports2.NUM_MAP;
    exports2.MINOR = exports2.MAJOR;
    var HEADER_STATE;
    (function(HEADER_STATE2) {
      HEADER_STATE2[HEADER_STATE2["GENERAL"] = 0] = "GENERAL";
      HEADER_STATE2[HEADER_STATE2["CONNECTION"] = 1] = "CONNECTION";
      HEADER_STATE2[HEADER_STATE2["CONTENT_LENGTH"] = 2] = "CONTENT_LENGTH";
      HEADER_STATE2[HEADER_STATE2["TRANSFER_ENCODING"] = 3] = "TRANSFER_ENCODING";
      HEADER_STATE2[HEADER_STATE2["UPGRADE"] = 4] = "UPGRADE";
      HEADER_STATE2[HEADER_STATE2["CONNECTION_KEEP_ALIVE"] = 5] = "CONNECTION_KEEP_ALIVE";
      HEADER_STATE2[HEADER_STATE2["CONNECTION_CLOSE"] = 6] = "CONNECTION_CLOSE";
      HEADER_STATE2[HEADER_STATE2["CONNECTION_UPGRADE"] = 7] = "CONNECTION_UPGRADE";
      HEADER_STATE2[HEADER_STATE2["TRANSFER_ENCODING_CHUNKED"] = 8] = "TRANSFER_ENCODING_CHUNKED";
    })(HEADER_STATE = exports2.HEADER_STATE || (exports2.HEADER_STATE = {}));
    exports2.SPECIAL_HEADERS = {
      "connection": HEADER_STATE.CONNECTION,
      "content-length": HEADER_STATE.CONTENT_LENGTH,
      "proxy-connection": HEADER_STATE.CONNECTION,
      "transfer-encoding": HEADER_STATE.TRANSFER_ENCODING,
      "upgrade": HEADER_STATE.UPGRADE
    };
  }
});

// lib/handler/RedirectHandler.js
var require_RedirectHandler = __commonJS({
  "lib/handler/RedirectHandler.js"(exports2, module2) {
    "use strict";
    var util = require_util();
    var { kBodyUsed } = require_symbols();
    var assert = require("assert");
    var { InvalidArgumentError } = require_errors();
    var EE = require("events");
    var redirectableStatusCodes = [300, 301, 302, 303, 307, 308];
    var kBody = Symbol("body");
    var BodyAsyncIterable = class {
      constructor(body) {
        this[kBody] = body;
        this[kBodyUsed] = false;
      }
      async *[Symbol.asyncIterator]() {
        assert(!this[kBodyUsed], "disturbed");
        this[kBodyUsed] = true;
        yield* this[kBody];
      }
    };
    var RedirectHandler = class {
      constructor(dispatch, maxRedirections, opts, handler) {
        if (maxRedirections != null && (!Number.isInteger(maxRedirections) || maxRedirections < 0)) {
          throw new InvalidArgumentError("maxRedirections must be a positive number");
        }
        util.validateHandler(handler, opts.method, opts.upgrade);
        this.dispatch = dispatch;
        this.location = null;
        this.abort = null;
        this.opts = { ...opts, maxRedirections: 0 };
        this.maxRedirections = maxRedirections;
        this.handler = handler;
        this.history = [];
        if (util.isStream(this.opts.body)) {
          if (util.bodyLength(this.opts.body) === 0) {
            this.opts.body.on("data", function() {
              assert(false);
            });
          }
          if (typeof this.opts.body.readableDidRead !== "boolean") {
            this.opts.body[kBodyUsed] = false;
            EE.prototype.on.call(this.opts.body, "data", function() {
              this[kBodyUsed] = true;
            });
          }
        } else if (this.opts.body && typeof this.opts.body.pipeTo === "function") {
          this.opts.body = new BodyAsyncIterable(this.opts.body);
        } else if (this.opts.body && typeof this.opts.body !== "string" && !ArrayBuffer.isView(this.opts.body) && util.isIterable(this.opts.body)) {
          this.opts.body = new BodyAsyncIterable(this.opts.body);
        }
      }
      onConnect(abort) {
        this.abort = abort;
        this.handler.onConnect(abort, { history: this.history });
      }
      onUpgrade(statusCode, headers, socket) {
        this.handler.onUpgrade(statusCode, headers, socket);
      }
      onError(error) {
        this.handler.onError(error);
      }
      onHeaders(statusCode, headers, resume, statusText) {
        this.location = this.history.length >= this.maxRedirections || util.isDisturbed(this.opts.body) ? null : parseLocation(statusCode, headers);
        if (this.opts.origin) {
          this.history.push(new URL(this.opts.path, this.opts.origin));
        }
        if (!this.location) {
          return this.handler.onHeaders(statusCode, headers, resume, statusText);
        }
        const { origin, pathname, search } = util.parseURL(new URL(this.location, this.opts.origin && new URL(this.opts.path, this.opts.origin)));
        const path = search ? `${pathname}${search}` : pathname;
        this.opts.headers = cleanRequestHeaders(this.opts.headers, statusCode === 303, this.opts.origin !== origin);
        this.opts.path = path;
        this.opts.origin = origin;
        this.opts.maxRedirections = 0;
        this.opts.query = null;
        if (statusCode === 303 && this.opts.method !== "HEAD") {
          this.opts.method = "GET";
          this.opts.body = null;
        }
      }
      onData(chunk) {
        if (this.location) {
        } else {
          return this.handler.onData(chunk);
        }
      }
      onComplete(trailers) {
        if (this.location) {
          this.location = null;
          this.abort = null;
          this.dispatch(this.opts, this);
        } else {
          this.handler.onComplete(trailers);
        }
      }
      onBodySent(chunk) {
        if (this.handler.onBodySent) {
          this.handler.onBodySent(chunk);
        }
      }
    };
    function parseLocation(statusCode, headers) {
      if (redirectableStatusCodes.indexOf(statusCode) === -1) {
        return null;
      }
      for (let i = 0; i < headers.length; i += 2) {
        if (headers[i].toString().toLowerCase() === "location") {
          return headers[i + 1];
        }
      }
    }
    function shouldRemoveHeader(header, removeContent, unknownOrigin) {
      return header.length === 4 && header.toString().toLowerCase() === "host" || removeContent && header.toString().toLowerCase().indexOf("content-") === 0 || unknownOrigin && header.length === 13 && header.toString().toLowerCase() === "authorization" || unknownOrigin && header.length === 6 && header.toString().toLowerCase() === "cookie";
    }
    function cleanRequestHeaders(headers, removeContent, unknownOrigin) {
      const ret = [];
      if (Array.isArray(headers)) {
        for (let i = 0; i < headers.length; i += 2) {
          if (!shouldRemoveHeader(headers[i], removeContent, unknownOrigin)) {
            ret.push(headers[i], headers[i + 1]);
          }
        }
      } else if (headers && typeof headers === "object") {
        for (const key of Object.keys(headers)) {
          if (!shouldRemoveHeader(key, removeContent, unknownOrigin)) {
            ret.push(key, headers[key]);
          }
        }
      } else {
        assert(headers == null, "headers must be an object or an array");
      }
      return ret;
    }
    module2.exports = RedirectHandler;
  }
});

// lib/interceptor/redirectInterceptor.js
var require_redirectInterceptor = __commonJS({
  "lib/interceptor/redirectInterceptor.js"(exports2, module2) {
    "use strict";
    var RedirectHandler = require_RedirectHandler();
    function createRedirectInterceptor({ maxRedirections: defaultMaxRedirections }) {
      return (dispatch) => {
        return function Intercept(opts, handler) {
          const { maxRedirections = defaultMaxRedirections } = opts;
          if (!maxRedirections) {
            return dispatch(opts, handler);
          }
          const redirectHandler = new RedirectHandler(dispatch, maxRedirections, opts, handler);
          opts = { ...opts, maxRedirections: 0 };
          return dispatch(opts, redirectHandler);
        };
      };
    }
    module2.exports = createRedirectInterceptor;
  }
});

// lib/llhttp/llhttp-wasm.js
var require_llhttp_wasm = __commonJS({
  "lib/llhttp/llhttp-wasm.js"(exports2, module2) {
    module2.exports = "AGFzbQEAAAABMAhgAX8Bf2ADf39/AX9gBH9/f38Bf2AAAGABfwBgA39/fwBgAn9/AGAGf39/f39/ AALLAQgDZW52GHdhc21fb25faGVhZGVyc19jb21wbGV0ZQACA2VudhV3YXNtX29uX21lc3NhZ2Vf YmVnaW4AAANlbnYLd2FzbV9vbl91cmwAAQNlbnYOd2FzbV9vbl9zdGF0dXMAAQNlbnYUd2FzbV9v bl9oZWFkZXJfZmllbGQAAQNlbnYUd2FzbV9vbl9oZWFkZXJfdmFsdWUAAQNlbnYMd2FzbV9vbl9i b2R5AAEDZW52GHdhc21fb25fbWVzc2FnZV9jb21wbGV0ZQAAA0xLAwMDAAEAAAQEBQAABAAAAAAA AAQBBAAEBAQAAAYAAAAABgYGBgYGBgYGBgEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEAAQAAAQEH BAUBcAESEgUDAQACBggBfwFB8NcECwfFBygGbWVtb3J5AgALX2luaXRpYWxpemUACRlfX2luZGly ZWN0X2Z1bmN0aW9uX3RhYmxlAQAGbWFsbG9jAA0EZnJlZQAPC2xsaHR0cF9pbml0ABEYbGxodHRw X3Nob3VsZF9rZWVwX2FsaXZlAE4MbGxodHRwX2FsbG9jABMLbGxodHRwX2ZyZWUAFA9sbGh0dHBf Z2V0X3R5cGUAFRVsbGh0dHBfZ2V0X2h0dHBfbWFqb3IAFhVsbGh0dHBfZ2V0X2h0dHBfbWlub3IA FxFsbGh0dHBfZ2V0X21ldGhvZAAYFmxsaHR0cF9nZXRfc3RhdHVzX2NvZGUAGRJsbGh0dHBfZ2V0 X3VwZ3JhZGUAGgxsbGh0dHBfcmVzZXQAGw5sbGh0dHBfZXhlY3V0ZQAcFGxsaHR0cF9zZXR0aW5n c19pbml0AB0NbGxodHRwX2ZpbmlzaAAeDGxsaHR0cF9wYXVzZQAfDWxsaHR0cF9yZXN1bWUAIBts bGh0dHBfcmVzdW1lX2FmdGVyX3VwZ3JhZGUAIRBsbGh0dHBfZ2V0X2Vycm5vACIXbGxodHRwX2dl dF9lcnJvcl9yZWFzb24AIxdsbGh0dHBfc2V0X2Vycm9yX3JlYXNvbgAkFGxsaHR0cF9nZXRfZXJy b3JfcG9zACURbGxodHRwX2Vycm5vX25hbWUAJhJsbGh0dHBfbWV0aG9kX25hbWUAJxJsbGh0dHBf c3RhdHVzX25hbWUAKBpsbGh0dHBfc2V0X2xlbmllbnRfaGVhZGVycwApIWxsaHR0cF9zZXRfbGVu aWVudF9jaHVua2VkX2xlbmd0aAAqHWxsaHR0cF9zZXRfbGVuaWVudF9rZWVwX2FsaXZlACskbGxo dHRwX3NldF9sZW5pZW50X3RyYW5zZmVyX2VuY29kaW5nACwabGxodHRwX3NldF9sZW5pZW50X3Zl cnNpb24ALSNsbGh0dHBfc2V0X2xlbmllbnRfZGF0YV9hZnRlcl9jbG9zZQAuJ2xsaHR0cF9zZXRf bGVuaWVudF9vcHRpb25hbF9sZl9hZnRlcl9jcgAvLGxsaHR0cF9zZXRfbGVuaWVudF9vcHRpb25h bF9jcmxmX2FmdGVyX2NodW5rADAobGxodHRwX3NldF9sZW5pZW50X29wdGlvbmFsX2NyX2JlZm9y ZV9sZgAxKmxsaHR0cF9zZXRfbGVuaWVudF9zcGFjZXNfYWZ0ZXJfY2h1bmtfc2l6ZQAyGGxsaHR0 cF9tZXNzYWdlX25lZWRzX2VvZgBMCRcBAEEBCxEBAgMEBRIGB0JGRDg6NjQ8PgqI9gJLAgALCAAQ iICAgAALBAAAAAtOAAJAIAANAD8AQRB0DwsCQCAAQf//A3ENACAAQX9MDQACQCAAQRB2QAAiAEF/ Rw0AQQBBMDYC+NOAgABBfw8LIABBEHQPCxCKgICAAAALkQMCA38BfgJAIAJBIUkNACAAIAEgAvwL ACAADwsCQCACRQ0AIAAgAToAACACIABqIgNBf2ogAToAACACQQNJDQAgACABOgACIAAgAToAASAD QX1qIAE6AAAgA0F+aiABOgAAIAJBB0kNACAAIAE6AAMgA0F8aiABOgAAIAJBCUkNACAAQQAgAGtB A3EiBGoiBSABQf8BcUGBgoQIbCIDNgIAIAUgAiAEa0F8cSIBaiICQXxqIAM2AgAgAUEJSQ0AIAUg AzYCCCAFIAM2AgQgAkF4aiADNgIAIAJBdGogAzYCACABQRlJDQAgBSADNgIYIAUgAzYCFCAFIAM2 AhAgBSADNgIMIAJBcGogAzYCACACQWxqIAM2AgAgAkFoaiADNgIAIAJBZGogAzYCACABIAVBBHFB GHIiAmsiAUEgSQ0AIAOtQoGAgIAQfiEGIAUgAmohAgNAIAIgBjcDACACQRhqIAY3AwAgAkEQaiAG NwMAIAJBCGogBjcDACACQSBqIQIgAUFgaiIBQR9LDQALCyAACwoAIAAQjoCAgAALqDcBC38jgICA gABBEGsiASSAgICAAAJAQQAoApTUgIAAIgINAAJAAkBBACgC1NeAgAAiA0UNAEEAKALY14CAACEE DAELQQBCfzcC4NeAgABBAEKAgISAgIDAADcC2NeAgABBACABQQhqQXBxQdiq1aoFcyIDNgLU14CA AEEAQQA2AujXgIAAQQBBADYCuNeAgABBgIAEIQQLQQAhAkGAgIiAAEHw14SAACAEakF/akEAIARr cUGAgIiAABtB8NeEgABrIgVB2QBJDQBBACEEQQAgBTYCwNeAgABBAEHw14SAADYCvNeAgABBAEHw 14SAADYCjNSAgABBACADNgKg1ICAAEEAQX82ApzUgIAAA0AgBEG41ICAAGogBEGs1ICAAGoiAzYC ACADIARBpNSAgABqIgY2AgAgBEGw1ICAAGogBjYCACAEQcDUgIAAaiAEQbTUgIAAaiIGNgIAIAYg AzYCACAEQcjUgIAAaiAEQbzUgIAAaiIDNgIAIAMgBjYCACAEQcTUgIAAaiADNgIAIARBIGoiBEGA AkcNAAtB8NeEgABBeEHw14SAAGtBD3FBAEHw14SAAEEIakEPcRsiBGoiAkEEaiAFQUhqIgMgBGsi BEEBcjYCAEEAQQAoAuTXgIAANgKY1ICAAEEAIAQ2AojUgIAAQQAgAjYClNSAgABB8NeEgAAgA2pB ODYCBAsCQAJAAkACQAJAAkACQAJAAkACQAJAAkAgAEHsAUsNAAJAQQAoAvzTgIAAIgdBECAAQRNq QXBxIABBC0kbIgVBA3YiA3YiBEEDcUUNACAEQQFxIANyQQFzIgZBA3QiAEGs1ICAAGooAgAiA0EI aiEEAkACQCADKAIIIgUgAEGk1ICAAGoiAEcNAEEAIAdBfiAGd3E2AvzTgIAADAELIAAgBTYCCCAF IAA2AgwLIAMgBkEDdCIGQQNyNgIEIAMgBmoiAyADKAIEQQFyNgIEDAwLIAVBACgChNSAgAAiCE0N AQJAIARFDQACQAJAIAQgA3RBAiADdCIEQQAgBGtycSIEQQAgBGtxQX9qIgQgBEEMdkEQcSIEdiID QQV2QQhxIgYgBHIgAyAGdiIEQQJ2QQRxIgNyIAQgA3YiBEEBdkECcSIDciAEIAN2IgRBAXZBAXEi A3IgBCADdmoiBkEDdCIAQazUgIAAaigCACIDKAIIIgQgAEGk1ICAAGoiAEcNAEEAIAdBfiAGd3Ei BzYC/NOAgAAMAQsgACAENgIIIAQgADYCDAsgA0EIaiEEIAMgBUEDcjYCBCADIAZBA3QiBmogBiAF ayIGNgIAIAMgBWoiACAGQQFyNgIEAkAgCEUNACAIQQN2IglBA3RBpNSAgABqIQVBACgCkNSAgAAh AwJAAkAgB0EBIAl0IglxDQBBACAHIAlyNgL804CAACAFIQkMAQsgBSgCCCEJCyAJIAM2AgwgBSAD NgIIIAMgBTYCDCADIAk2AggLQQAgADYCkNSAgABBACAGNgKE1ICAAAwMC0EAKAKA1ICAACIKRQ0B IApBACAKa3FBf2oiBCAEQQx2QRBxIgR2IgNBBXZBCHEiBiAEciADIAZ2IgRBAnZBBHEiA3IgBCAD diIEQQF2QQJxIgNyIAQgA3YiBEEBdkEBcSIDciAEIAN2akECdEGs1oCAAGooAgAiACgCBEF4cSAF ayEDIAAhBgJAA0ACQCAGKAIQIgQNACAGQRRqKAIAIgRFDQILIAQoAgRBeHEgBWsiBiADIAYgA0ki BhshAyAEIAAgBhshACAEIQYMAAsLIAAoAhghCwJAIAAoAgwiCSAARg0AQQAoAozUgIAAIAAoAggi BEsaIAkgBDYCCCAEIAk2AgwMCwsCQCAAQRRqIgYoAgAiBA0AIAAoAhAiBEUNAyAAQRBqIQYLA0Ag BiECIAQiCUEUaiIGKAIAIgQNACAJQRBqIQYgCSgCECIEDQALIAJBADYCAAwKC0F/IQUgAEG/f0sN ACAAQRNqIgRBcHEhBUEAKAKA1ICAACIKRQ0AQQAhCAJAIAVBgAJJDQBBHyEIIAVB////B0sNACAE QQh2IgQgBEGA/j9qQRB2QQhxIgR0IgMgA0GA4B9qQRB2QQRxIgN0IgYgBkGAgA9qQRB2QQJxIgZ0 QQ92IAQgA3IgBnJrIgRBAXQgBSAEQRVqdkEBcXJBHGohCAtBACAFayEDAkACQAJAAkAgCEECdEGs 1oCAAGooAgAiBg0AQQAhBEEAIQkMAQtBACEEIAVBAEEZIAhBAXZrIAhBH0YbdCEAQQAhCQNAAkAg BigCBEF4cSAFayIHIANPDQAgByEDIAYhCSAHDQBBACEDIAYhCSAGIQQMAwsgBCAGQRRqKAIAIgcg ByAGIABBHXZBBHFqQRBqKAIAIgZGGyAEIAcbIQQgAEEBdCEAIAYNAAsLAkAgBCAJcg0AQQAhCUEC IAh0IgRBACAEa3IgCnEiBEUNAyAEQQAgBGtxQX9qIgQgBEEMdkEQcSIEdiIGQQV2QQhxIgAgBHIg BiAAdiIEQQJ2QQRxIgZyIAQgBnYiBEEBdkECcSIGciAEIAZ2IgRBAXZBAXEiBnIgBCAGdmpBAnRB rNaAgABqKAIAIQQLIARFDQELA0AgBCgCBEF4cSAFayIHIANJIQACQCAEKAIQIgYNACAEQRRqKAIA IQYLIAcgAyAAGyEDIAQgCSAAGyEJIAYhBCAGDQALCyAJRQ0AIANBACgChNSAgAAgBWtPDQAgCSgC GCECAkAgCSgCDCIAIAlGDQBBACgCjNSAgAAgCSgCCCIESxogACAENgIIIAQgADYCDAwJCwJAIAlB FGoiBigCACIEDQAgCSgCECIERQ0DIAlBEGohBgsDQCAGIQcgBCIAQRRqIgYoAgAiBA0AIABBEGoh BiAAKAIQIgQNAAsgB0EANgIADAgLAkBBACgChNSAgAAiBCAFSQ0AQQAoApDUgIAAIQMCQAJAIAQg BWsiBkEQSQ0AIAMgBWoiACAGQQFyNgIEQQAgBjYChNSAgABBACAANgKQ1ICAACADIARqIAY2AgAg AyAFQQNyNgIEDAELIAMgBEEDcjYCBCADIARqIgQgBCgCBEEBcjYCBEEAQQA2ApDUgIAAQQBBADYC hNSAgAALIANBCGohBAwKCwJAQQAoAojUgIAAIgYgBU0NACACIAVqIgQgBiAFayIDQQFyNgIEQQAg BDYClNSAgABBACADNgKI1ICAACACIAVBA3I2AgQgAkEIaiEEDAoLAkACQEEAKALU14CAAEUNAEEA KALc14CAACEDDAELQQBCfzcC4NeAgABBAEKAgISAgIDAADcC2NeAgABBACABQQxqQXBxQdiq1aoF czYC1NeAgABBAEEANgLo14CAAEEAQQA2ArjXgIAAQYCABCEDC0EAIQQCQCADIAVBxwBqIghqIgBB ACADayIHcSIJIAVLDQBBAEEwNgL404CAAAwKCwJAQQAoArTXgIAAIgRFDQACQEEAKAKs14CAACID IAlqIgogA00NACAKIARNDQELQQAhBEEAQTA2AvjTgIAADAoLQQAtALjXgIAAQQRxDQQCQAJAAkAg AkUNAEG814CAACEEA0ACQCAEKAIAIgMgAksNACADIAQoAgRqIAJLDQMLIAQoAggiBA0ACwtBABCL gICAACIAQX9GDQUgCSEHAkBBACgC2NeAgAAiBEF/aiIDIABxRQ0AIAkgAGsgAyAAakEAIARrcWoh BwsgByAFTQ0FIAdB/v///wdLDQUCQEEAKAK014CAACIERQ0AQQAoAqzXgIAAIgMgB2oiBiADTQ0G IAYgBEsNBgsgBxCLgICAACIEIABHDQEMBwsgACAGayAHcSIHQf7///8HSw0EIAcQi4CAgAAiACAE KAIAIAQoAgRqRg0DIAAhBAsCQCAEQX9GDQAgBUHIAGogB00NAAJAIAggB2tBACgC3NeAgAAiA2pB ACADa3EiA0H+////B00NACAEIQAMBwsCQCADEIuAgIAAQX9GDQAgAyAHaiEHIAQhAAwHC0EAIAdr EIuAgIAAGgwECyAEIQAgBEF/Rw0FDAMLQQAhCQwHC0EAIQAMBQsgAEF/Rw0CC0EAQQAoArjXgIAA QQRyNgK414CAAAsgCUH+////B0sNASAJEIuAgIAAIQBBABCLgICAACEEIABBf0YNASAEQX9GDQEg ACAETw0BIAQgAGsiByAFQThqTQ0BC0EAQQAoAqzXgIAAIAdqIgQ2AqzXgIAAAkAgBEEAKAKw14CA AE0NAEEAIAQ2ArDXgIAACwJAAkACQAJAQQAoApTUgIAAIgNFDQBBvNeAgAAhBANAIAAgBCgCACIG IAQoAgQiCWpGDQIgBCgCCCIEDQAMAwsLAkACQEEAKAKM1ICAACIERQ0AIAAgBE8NAQtBACAANgKM 1ICAAAtBACEEQQAgBzYCwNeAgABBACAANgK814CAAEEAQX82ApzUgIAAQQBBACgC1NeAgAA2AqDU gIAAQQBBADYCyNeAgAADQCAEQbjUgIAAaiAEQazUgIAAaiIDNgIAIAMgBEGk1ICAAGoiBjYCACAE QbDUgIAAaiAGNgIAIARBwNSAgABqIARBtNSAgABqIgY2AgAgBiADNgIAIARByNSAgABqIARBvNSA gABqIgM2AgAgAyAGNgIAIARBxNSAgABqIAM2AgAgBEEgaiIEQYACRw0ACyAAQXggAGtBD3FBACAA QQhqQQ9xGyIEaiIDIAdBSGoiBiAEayIEQQFyNgIEQQBBACgC5NeAgAA2ApjUgIAAQQAgBDYCiNSA gABBACADNgKU1ICAACAAIAZqQTg2AgQMAgsgBC0ADEEIcQ0AIAYgA0sNACAAIANNDQAgA0F4IANr QQ9xQQAgA0EIakEPcRsiBmoiAEEAKAKI1ICAACAHaiICIAZrIgZBAXI2AgQgBCAJIAdqNgIEQQBB ACgC5NeAgAA2ApjUgIAAQQAgBjYCiNSAgABBACAANgKU1ICAACADIAJqQTg2AgQMAQsCQCAAQQAo AozUgIAAIglPDQBBACAANgKM1ICAACAAIQkLIAAgB2ohBkG814CAACEEAkACQAJAAkACQAJAAkAD QCAEKAIAIAZGDQEgBCgCCCIEDQAMAgsLIAQtAAxBCHFFDQELQbzXgIAAIQQDQAJAIAQoAgAiBiAD Sw0AIAYgBCgCBGoiBiADSw0DCyAEKAIIIQQMAAsLIAQgADYCACAEIAQoAgQgB2o2AgQgAEF4IABr QQ9xQQAgAEEIakEPcRtqIgIgBUEDcjYCBCAGQXggBmtBD3FBACAGQQhqQQ9xG2oiByACIAVqIgVr IQYCQCADIAdHDQBBACAFNgKU1ICAAEEAQQAoAojUgIAAIAZqIgQ2AojUgIAAIAUgBEEBcjYCBAwD CwJAQQAoApDUgIAAIAdHDQBBACAFNgKQ1ICAAEEAQQAoAoTUgIAAIAZqIgQ2AoTUgIAAIAUgBEEB cjYCBCAFIARqIAQ2AgAMAwsCQCAHKAIEIgRBA3FBAUcNACAEQXhxIQgCQAJAIARB/wFLDQAgBygC CCIDIARBA3YiCUEDdEGk1ICAAGoiAEYaAkAgBygCDCIEIANHDQBBAEEAKAL804CAAEF+IAl3cTYC /NOAgAAMAgsgBCAARhogBCADNgIIIAMgBDYCDAwBCyAHKAIYIQoCQAJAIAcoAgwiACAHRg0AIAkg BygCCCIESxogACAENgIIIAQgADYCDAwBCwJAIAdBFGoiBCgCACIDDQAgB0EQaiIEKAIAIgMNAEEA IQAMAQsDQCAEIQkgAyIAQRRqIgQoAgAiAw0AIABBEGohBCAAKAIQIgMNAAsgCUEANgIACyAKRQ0A AkACQCAHKAIcIgNBAnRBrNaAgABqIgQoAgAgB0cNACAEIAA2AgAgAA0BQQBBACgCgNSAgABBfiAD d3E2AoDUgIAADAILIApBEEEUIAooAhAgB0YbaiAANgIAIABFDQELIAAgCjYCGAJAIAcoAhAiBEUN ACAAIAQ2AhAgBCAANgIYCyAHKAIUIgRFDQAgAEEUaiAENgIAIAQgADYCGAsgCCAGaiEGIAcgCGoh BwsgByAHKAIEQX5xNgIEIAUgBmogBjYCACAFIAZBAXI2AgQCQCAGQf8BSw0AIAZBA3YiA0EDdEGk 1ICAAGohBAJAAkBBACgC/NOAgAAiBkEBIAN0IgNxDQBBACAGIANyNgL804CAACAEIQMMAQsgBCgC CCEDCyADIAU2AgwgBCAFNgIIIAUgBDYCDCAFIAM2AggMAwtBHyEEAkAgBkH///8HSw0AIAZBCHYi BCAEQYD+P2pBEHZBCHEiBHQiAyADQYDgH2pBEHZBBHEiA3QiACAAQYCAD2pBEHZBAnEiAHRBD3Yg BCADciAAcmsiBEEBdCAGIARBFWp2QQFxckEcaiEECyAFIAQ2AhwgBUIANwIQIARBAnRBrNaAgABq IQMCQEEAKAKA1ICAACIAQQEgBHQiCXENACADIAU2AgBBACAAIAlyNgKA1ICAACAFIAM2AhggBSAF NgIIIAUgBTYCDAwDCyAGQQBBGSAEQQF2ayAEQR9GG3QhBCADKAIAIQADQCAAIgMoAgRBeHEgBkYN AiAEQR12IQAgBEEBdCEEIAMgAEEEcWpBEGoiCSgCACIADQALIAkgBTYCACAFIAM2AhggBSAFNgIM IAUgBTYCCAwCCyAAQXggAGtBD3FBACAAQQhqQQ9xGyIEaiICIAdBSGoiCSAEayIEQQFyNgIEIAAg CWpBODYCBCADIAZBNyAGa0EPcUEAIAZBSWpBD3EbakFBaiIJIAkgA0EQakkbIglBIzYCBEEAQQAo AuTXgIAANgKY1ICAAEEAIAQ2AojUgIAAQQAgAjYClNSAgAAgCUEQakEAKQLE14CAADcCACAJQQAp ArzXgIAANwIIQQAgCUEIajYCxNeAgABBACAHNgLA14CAAEEAIAA2ArzXgIAAQQBBADYCyNeAgAAg CUEkaiEEA0AgBEEHNgIAIAYgBEEEaiIESw0ACyAJIANGDQMgCSAJKAIEQX5xNgIEIAkgCSADayIH NgIAIAMgB0EBcjYCBAJAIAdB/wFLDQAgB0EDdiIGQQN0QaTUgIAAaiEEAkACQEEAKAL804CAACIA QQEgBnQiBnENAEEAIAAgBnI2AvzTgIAAIAQhBgwBCyAEKAIIIQYLIAYgAzYCDCAEIAM2AgggAyAE NgIMIAMgBjYCCAwEC0EfIQQCQCAHQf///wdLDQAgB0EIdiIEIARBgP4/akEQdkEIcSIEdCIGIAZB gOAfakEQdkEEcSIGdCIAIABBgIAPakEQdkECcSIAdEEPdiAEIAZyIAByayIEQQF0IAcgBEEVanZB AXFyQRxqIQQLIANCADcCECADQRxqIAQ2AgAgBEECdEGs1oCAAGohBgJAQQAoAoDUgIAAIgBBASAE dCIJcQ0AIAYgAzYCAEEAIAAgCXI2AoDUgIAAIANBGGogBjYCACADIAM2AgggAyADNgIMDAQLIAdB AEEZIARBAXZrIARBH0YbdCEEIAYoAgAhAANAIAAiBigCBEF4cSAHRg0DIARBHXYhACAEQQF0IQQg BiAAQQRxakEQaiIJKAIAIgANAAsgCSADNgIAIANBGGogBjYCACADIAM2AgwgAyADNgIIDAMLIAMo AggiBCAFNgIMIAMgBTYCCCAFQQA2AhggBSADNgIMIAUgBDYCCAsgAkEIaiEEDAULIAYoAggiBCAD NgIMIAYgAzYCCCADQRhqQQA2AgAgAyAGNgIMIAMgBDYCCAtBACgCiNSAgAAiBCAFTQ0AQQAoApTU gIAAIgMgBWoiBiAEIAVrIgRBAXI2AgRBACAENgKI1ICAAEEAIAY2ApTUgIAAIAMgBUEDcjYCBCAD QQhqIQQMAwtBACEEQQBBMDYC+NOAgAAMAgsCQCACRQ0AAkACQCAJIAkoAhwiBkECdEGs1oCAAGoi BCgCAEcNACAEIAA2AgAgAA0BQQAgCkF+IAZ3cSIKNgKA1ICAAAwCCyACQRBBFCACKAIQIAlGG2og ADYCACAARQ0BCyAAIAI2AhgCQCAJKAIQIgRFDQAgACAENgIQIAQgADYCGAsgCUEUaigCACIERQ0A IABBFGogBDYCACAEIAA2AhgLAkACQCADQQ9LDQAgCSADIAVqIgRBA3I2AgQgCSAEaiIEIAQoAgRB AXI2AgQMAQsgCSAFaiIAIANBAXI2AgQgCSAFQQNyNgIEIAAgA2ogAzYCAAJAIANB/wFLDQAgA0ED diIDQQN0QaTUgIAAaiEEAkACQEEAKAL804CAACIGQQEgA3QiA3ENAEEAIAYgA3I2AvzTgIAAIAQh AwwBCyAEKAIIIQMLIAMgADYCDCAEIAA2AgggACAENgIMIAAgAzYCCAwBC0EfIQQCQCADQf///wdL DQAgA0EIdiIEIARBgP4/akEQdkEIcSIEdCIGIAZBgOAfakEQdkEEcSIGdCIFIAVBgIAPakEQdkEC cSIFdEEPdiAEIAZyIAVyayIEQQF0IAMgBEEVanZBAXFyQRxqIQQLIAAgBDYCHCAAQgA3AhAgBEEC dEGs1oCAAGohBgJAIApBASAEdCIFcQ0AIAYgADYCAEEAIAogBXI2AoDUgIAAIAAgBjYCGCAAIAA2 AgggACAANgIMDAELIANBAEEZIARBAXZrIARBH0YbdCEEIAYoAgAhBQJAA0AgBSIGKAIEQXhxIANG DQEgBEEddiEFIARBAXQhBCAGIAVBBHFqQRBqIgcoAgAiBQ0ACyAHIAA2AgAgACAGNgIYIAAgADYC DCAAIAA2AggMAQsgBigCCCIEIAA2AgwgBiAANgIIIABBADYCGCAAIAY2AgwgACAENgIICyAJQQhq IQQMAQsCQCALRQ0AAkACQCAAIAAoAhwiBkECdEGs1oCAAGoiBCgCAEcNACAEIAk2AgAgCQ0BQQAg CkF+IAZ3cTYCgNSAgAAMAgsgC0EQQRQgCygCECAARhtqIAk2AgAgCUUNAQsgCSALNgIYAkAgACgC ECIERQ0AIAkgBDYCECAEIAk2AhgLIABBFGooAgAiBEUNACAJQRRqIAQ2AgAgBCAJNgIYCwJAAkAg A0EPSw0AIAAgAyAFaiIEQQNyNgIEIAAgBGoiBCAEKAIEQQFyNgIEDAELIAAgBWoiBiADQQFyNgIE IAAgBUEDcjYCBCAGIANqIAM2AgACQCAIRQ0AIAhBA3YiCUEDdEGk1ICAAGohBUEAKAKQ1ICAACEE AkACQEEBIAl0IgkgB3ENAEEAIAkgB3I2AvzTgIAAIAUhCQwBCyAFKAIIIQkLIAkgBDYCDCAFIAQ2 AgggBCAFNgIMIAQgCTYCCAtBACAGNgKQ1ICAAEEAIAM2AoTUgIAACyAAQQhqIQQLIAFBEGokgICA gAAgBAsKACAAEJCAgIAAC/ANAQd/AkAgAEUNACAAQXhqIgEgAEF8aigCACICQXhxIgBqIQMCQCAC QQFxDQAgAkEDcUUNASABIAEoAgAiAmsiAUEAKAKM1ICAACIESQ0BIAIgAGohAAJAQQAoApDUgIAA IAFGDQACQCACQf8BSw0AIAEoAggiBCACQQN2IgVBA3RBpNSAgABqIgZGGgJAIAEoAgwiAiAERw0A QQBBACgC/NOAgABBfiAFd3E2AvzTgIAADAMLIAIgBkYaIAIgBDYCCCAEIAI2AgwMAgsgASgCGCEH AkACQCABKAIMIgYgAUYNACAEIAEoAggiAksaIAYgAjYCCCACIAY2AgwMAQsCQCABQRRqIgIoAgAi BA0AIAFBEGoiAigCACIEDQBBACEGDAELA0AgAiEFIAQiBkEUaiICKAIAIgQNACAGQRBqIQIgBigC ECIEDQALIAVBADYCAAsgB0UNAQJAAkAgASgCHCIEQQJ0QazWgIAAaiICKAIAIAFHDQAgAiAGNgIA IAYNAUEAQQAoAoDUgIAAQX4gBHdxNgKA1ICAAAwDCyAHQRBBFCAHKAIQIAFGG2ogBjYCACAGRQ0C CyAGIAc2AhgCQCABKAIQIgJFDQAgBiACNgIQIAIgBjYCGAsgASgCFCICRQ0BIAZBFGogAjYCACAC IAY2AhgMAQsgAygCBCICQQNxQQNHDQAgAyACQX5xNgIEQQAgADYChNSAgAAgASAAaiAANgIAIAEg AEEBcjYCBA8LIAMgAU0NACADKAIEIgJBAXFFDQACQAJAIAJBAnENAAJAQQAoApTUgIAAIANHDQBB ACABNgKU1ICAAEEAQQAoAojUgIAAIABqIgA2AojUgIAAIAEgAEEBcjYCBCABQQAoApDUgIAARw0D QQBBADYChNSAgABBAEEANgKQ1ICAAA8LAkBBACgCkNSAgAAgA0cNAEEAIAE2ApDUgIAAQQBBACgC hNSAgAAgAGoiADYChNSAgAAgASAAQQFyNgIEIAEgAGogADYCAA8LIAJBeHEgAGohAAJAAkAgAkH/ AUsNACADKAIIIgQgAkEDdiIFQQN0QaTUgIAAaiIGRhoCQCADKAIMIgIgBEcNAEEAQQAoAvzTgIAA QX4gBXdxNgL804CAAAwCCyACIAZGGiACIAQ2AgggBCACNgIMDAELIAMoAhghBwJAAkAgAygCDCIG IANGDQBBACgCjNSAgAAgAygCCCICSxogBiACNgIIIAIgBjYCDAwBCwJAIANBFGoiAigCACIEDQAg A0EQaiICKAIAIgQNAEEAIQYMAQsDQCACIQUgBCIGQRRqIgIoAgAiBA0AIAZBEGohAiAGKAIQIgQN AAsgBUEANgIACyAHRQ0AAkACQCADKAIcIgRBAnRBrNaAgABqIgIoAgAgA0cNACACIAY2AgAgBg0B QQBBACgCgNSAgABBfiAEd3E2AoDUgIAADAILIAdBEEEUIAcoAhAgA0YbaiAGNgIAIAZFDQELIAYg BzYCGAJAIAMoAhAiAkUNACAGIAI2AhAgAiAGNgIYCyADKAIUIgJFDQAgBkEUaiACNgIAIAIgBjYC GAsgASAAaiAANgIAIAEgAEEBcjYCBCABQQAoApDUgIAARw0BQQAgADYChNSAgAAPCyADIAJBfnE2 AgQgASAAaiAANgIAIAEgAEEBcjYCBAsCQCAAQf8BSw0AIABBA3YiAkEDdEGk1ICAAGohAAJAAkBB ACgC/NOAgAAiBEEBIAJ0IgJxDQBBACAEIAJyNgL804CAACAAIQIMAQsgACgCCCECCyACIAE2Agwg ACABNgIIIAEgADYCDCABIAI2AggPC0EfIQICQCAAQf///wdLDQAgAEEIdiICIAJBgP4/akEQdkEI cSICdCIEIARBgOAfakEQdkEEcSIEdCIGIAZBgIAPakEQdkECcSIGdEEPdiACIARyIAZyayICQQF0 IAAgAkEVanZBAXFyQRxqIQILIAFCADcCECABQRxqIAI2AgAgAkECdEGs1oCAAGohBAJAAkBBACgC gNSAgAAiBkEBIAJ0IgNxDQAgBCABNgIAQQAgBiADcjYCgNSAgAAgAUEYaiAENgIAIAEgATYCCCAB IAE2AgwMAQsgAEEAQRkgAkEBdmsgAkEfRht0IQIgBCgCACEGAkADQCAGIgQoAgRBeHEgAEYNASAC QR12IQYgAkEBdCECIAQgBkEEcWpBEGoiAygCACIGDQALIAMgATYCACABQRhqIAQ2AgAgASABNgIM IAEgATYCCAwBCyAEKAIIIgAgATYCDCAEIAE2AgggAUEYakEANgIAIAEgBDYCDCABIAA2AggLQQBB ACgCnNSAgABBf2oiAUF/IAEbNgKc1ICAAAsLGQAgABDPgICAABogACACNgI4IAAgAToAKAscACAA IAAvATQgAC0AMCAAEM6AgIAAEICAgIAACyoBAX9BwAAQjYCAgAAiARDPgICAABogAUGAiICAADYC OCABIAA6ACggAQsKACAAEI+AgIAACwcAIAAtACgLBwAgAC0AKgsHACAALQArCwcAIAAtACkLBwAg AC8BNAsHACAALQAwC0UBBH8gACgCGCEBIAAvAS4hAiAALQAoIQMgACgCOCEEIAAQz4CAgAAaIAAg BDYCOCAAIAM6ACggACACOwEuIAAgATYCGAsRACAAIAEgASACahDQgICAAAsQACAAQQBB3AAQjICA gAAaC2cBAX9BACEBAkAgACgCDA0AAkACQAJAAkAgAC0AMQ4DAQADAgsgACgCOCIBRQ0AIAEoAiwi AUUNACAAIAERgICAgAAAIgENAwtBAA8LEIqAgIAAAAsgAEHQmICAADYCEEEOIQELIAELHgACQCAA KAIMDQAgAEHJnoCAADYCECAAQRU2AgwLCxYAAkAgACgCDEEVRw0AIABBADYCDAsLFgACQCAAKAIM QRZHDQAgAEEANgIMCwsHACAAKAIMCwcAIAAoAhALCQAgACABNgIQCwcAIAAoAhQLIgACQCAAQSRJ DQAQioCAgAAACyAAQQJ0QZC3gIAAaigCAAsiAAJAIABBLkkNABCKgICAAAALIABBAnRBoLiAgABq KAIAC+4LAQF/QdmsgIAAIQECQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJA AkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkAC QAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJA AkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQCAAQZx/ag70A2Ni AAFhYWFhYWECAwQFYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFh YWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYQYHCAkKCwwNDg9hYWFhYRBh YWFhYWFhYWFhYRFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFh YWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWESExQVFhcYGRobYWFhYWFhYWFhYWFhYWFhYWFhYWFh YWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFh YWFhYWFhYWFhYWFhYRwdHh8gISIjJCUmJygpKissLS4vMDEyMzQ1NmE3ODk6YWFhYWFhYWE7YWFh PGFhYWE9Pj9hYWFhYWFhYUBhYUFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFCQ0RFRkdI SUpLTE1OT1BRUlNhYWFhYWFhYVRVVldYWVpbYVxdYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFh YWFhXmFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYV9gYQtBz6uAgAAPC0H9pICA AA8LQbmwgIAADwtB7LWAgAAPC0GuqICAAA8LQZmogIAADwtB+6uAgAAPC0HQqoCAAA8LQe6zgIAA DwtBp7OAgAAPC0HFqICAAA8LQcijgIAADwtBuqOAgAAPC0HTo4CAAA8LQcukgIAADwtBlrOAgAAP C0GctoCAAA8LQfazgIAADwtB2quAgAAPC0HbpYCAAA8LQeeggIAADwtBvrKAgAAPC0Gjp4CAAA8L QbO2gIAADwtBuKCAgAAPC0GroICAAA8LQZ2kgIAADwtBsKSAgAAPC0H7ooCAAA8LQduygIAADwtB mbSAgAAPC0HCqYCAAA8LQbqygIAADwtB6LKAgAAPC0Hqr4CAAA8LQcC0gIAADwtByqGAgAAPC0GU pICAAA8LQeWvgIAADwtB/rSAgAAPC0HFtYCAAA8LQZCxgIAADwtBwquAgAAPC0HOr4CAAA8LQY2w gIAADwtB2bWAgAAPC0Guo4CAAA8LQbi1gIAADwtBzKmAgAAPC0GtooCAAA8LQc2ggIAADwtBlbaA gAAPC0GKoYCAAA8LQfmggIAADwtBp7WAgAAPC0GqtICAAA8LQeukgIAADwtBoaqAgAAPC0HXsICA AA8LQYWigIAADwtBwq+AgAAPC0HlqoCAAA8LQe6pgIAADwtBiaWAgAAPC0HXooCAAA8LQeamgIAA DwtB97CAgAAPC0HQpoCAAA8LQY61gIAADwtBh6OAgAAPC0G0qYCAAA8LQcGigIAADwtB7KWAgAAP C0Gws4CAAA8LQZyhgIAADwtB+a+AgAAPC0G6oYCAAA8LQfuygIAADwtBw6WAgAAPC0GisYCAAA8L QcCzgIAADwtBzbaAgAAPC0HAtoCAAA8LQd60gIAADwtBgqaAgAAPC0Hnp4CAAA8LQfKhgIAADwtB o7CAgAAPC0GJtICAAA8LQYC2gIAADwtBpK+AgAAPC0GbpoCAAA8LQea2gIAADwtBjKmAgAAPC0Gp poCAAA8LQZOigIAADwtB2qGAgAAPCxCKgICAAAALQa+lgIAAIQELIAELFwAgACAALwEuQf7/A3Eg AUEAR3I7AS4LGgAgACAALwEuQf3/A3EgAUEAR0EBdHI7AS4LGgAgACAALwEuQfv/A3EgAUEAR0EC dHI7AS4LGgAgACAALwEuQff/A3EgAUEAR0EDdHI7AS4LGgAgACAALwEuQe//A3EgAUEAR0EEdHI7 AS4LGgAgACAALwEuQd//A3EgAUEAR0EFdHI7AS4LGgAgACAALwEuQb//A3EgAUEAR0EGdHI7AS4L GgAgACAALwEuQf/+A3EgAUEAR0EHdHI7AS4LGgAgACAALwEuQf/9A3EgAUEAR0EIdHI7AS4LGgAg ACAALwEuQf/7A3EgAUEAR0EJdHI7AS4LLgECf0EAIQMCQCAAKAI4IgRFDQAgBCgCACIERQ0AIAAg BBGAgICAAAAhAwsgAwtJAQJ/QQAhAwJAIAAoAjgiBEUNACAEKAIEIgRFDQAgACABIAIgAWsgBBGB gICAAAAiA0F/Rw0AIABBzpGAgAA2AhBBGCEDCyADCy4BAn9BACEDAkAgACgCOCIERQ0AIAQoAjAi BEUNACAAIAQRgICAgAAAIQMLIAMLSQECf0EAIQMCQCAAKAI4IgRFDQAgBCgCCCIERQ0AIAAgASAC IAFrIAQRgYCAgAAAIgNBf0cNACAAQeSKgIAANgIQQRghAwsgAwsuAQJ/QQAhAwJAIAAoAjgiBEUN ACAEKAI0IgRFDQAgACAEEYCAgIAAACEDCyADC0kBAn9BACEDAkAgACgCOCIERQ0AIAQoAgwiBEUN ACAAIAEgAiABayAEEYGAgIAAACIDQX9HDQAgAEHlnYCAADYCEEEYIQMLIAMLLgECf0EAIQMCQCAA KAI4IgRFDQAgBCgCOCIERQ0AIAAgBBGAgICAAAAhAwsgAwtJAQJ/QQAhAwJAIAAoAjgiBEUNACAE KAIQIgRFDQAgACABIAIgAWsgBBGBgICAAAAiA0F/Rw0AIABBnZCAgAA2AhBBGCEDCyADCy4BAn9B ACEDAkAgACgCOCIERQ0AIAQoAjwiBEUNACAAIAQRgICAgAAAIQMLIAMLSQECf0EAIQMCQCAAKAI4 IgRFDQAgBCgCFCIERQ0AIAAgASACIAFrIAQRgYCAgAAAIgNBf0cNACAAQaKegIAANgIQQRghAwsg AwsuAQJ/QQAhAwJAIAAoAjgiBEUNACAEKAJAIgRFDQAgACAEEYCAgIAAACEDCyADC0kBAn9BACED AkAgACgCOCIERQ0AIAQoAhgiBEUNACAAIAEgAiABayAEEYGAgIAAACIDQX9HDQAgAEHulICAADYC EEEYIQMLIAMLLgECf0EAIQMCQCAAKAI4IgRFDQAgBCgCRCIERQ0AIAAgBBGAgICAAAAhAwsgAwsu AQJ/QQAhAwJAIAAoAjgiBEUNACAEKAIkIgRFDQAgACAEEYCAgIAAACEDCyADCy4BAn9BACEDAkAg ACgCOCIERQ0AIAQoAiwiBEUNACAAIAQRgICAgAAAIQMLIAMLSQECf0EAIQMCQCAAKAI4IgRFDQAg BCgCKCIERQ0AIAAgASACIAFrIAQRgYCAgAAAIgNBf0cNACAAQfaIgIAANgIQQRghAwsgAwsuAQJ/ QQAhAwJAIAAoAjgiBEUNACAEKAJQIgRFDQAgACAEEYCAgIAAACEDCyADC0kBAn9BACEDAkAgACgC OCIERQ0AIAQoAhwiBEUNACAAIAEgAiABayAEEYGAgIAAACIDQX9HDQAgAEH3m4CAADYCEEEYIQML IAMLLgECf0EAIQMCQCAAKAI4IgRFDQAgBCgCSCIERQ0AIAAgBBGAgICAAAAhAwsgAwtJAQJ/QQAh AwJAIAAoAjgiBEUNACAEKAIgIgRFDQAgACABIAIgAWsgBBGBgICAAAAiA0F/Rw0AIABBlZWAgAA2 AhBBGCEDCyADCy4BAn9BACEDAkAgACgCOCIERQ0AIAQoAkwiBEUNACAAIAQRgICAgAAAIQMLIAML LgECf0EAIQMCQCAAKAI4IgRFDQAgBCgCVCIERQ0AIAAgBBGAgICAAAAhAwsgAwsuAQJ/QQAhAwJA IAAoAjgiBEUNACAEKAJYIgRFDQAgACAEEYCAgIAAACEDCyADC0UBAX8CQAJAIAAvATJBFHFBFEcN AEEBIQMgAC0AKEEBRg0BIAAvATRB5QBGIQMMAQsgAC0AKUEFRiEDCyAAIAM6ADBBAAuJAgEEf0EB IQMCQCAALwEyIgRBCHENACAAKQMgQgBSIQMLAkACQCAALQAwRQ0AQQEhBSAALQApQQVGDQFBASEF IARBwABxRSADcUEBRw0BCwJAAkAgAC0AKCIDQQJHDQBBASEFIAAvATQiBkHlAEYNAkEAIQUgBkHk AEYNAiAEQcAAcQ0CIAZBmn9qQQJJDQIgBkHMAUYNAiAGQbACRg0CDAELQQAhBSAEQcAAcQ0BC0EC IQUgBEEIcQ0AAkAgBEGABHFFDQACQCADQQFHDQAgAC0ALkEKcQ0AQQUPC0EEDwsCQCAEQSBxDQAg ABDMgICAAEEAR0ECdA8LQQBBAyAAKQMgUBshBQsgBQtiAQJ/QQAhAQJAIAAtAChBAUYNACAALwE0 Qf//A3EiAkGcf2pB5ABJDQAgAkHMAUYNACACQbACRg0AIAAvATIiAEHAAHENAEEBIQEgAEGIBHFB gARGDQAgAEEocUUhAQsgAQunAQEDfwJAAkACQCAALQAqRQ0AIAAtACtFDQBBACEDIAAvATIiBEEC cUUNAQwCC0EAIQMgAC8BMiIEQQFxRQ0BC0EBIQMgAC0AKEEBRg0AIAAvATRB//8DcSIFQZx/akHk AEkNACAFQcwBRg0AIAVBsAJGDQAgBEHAAHENAEEAIQMgBEGIBHFBgARGDQAgBEEocUEARyEDCyAA QQA7ATIgAEEAOgAxIAMLmQEBAn8CQAJAAkAgAC0AKkUNACAALQArRQ0AQQAhASAALwEyIgJBAnFF DQEMAgtBACEBIAAvATIiAkEBcUUNAQtBASEBIAAtAChBAUYNACAALwE0Qf//A3EiAEGcf2pB5ABJ DQAgAEHMAUYNACAAQbACRg0AIAJBwABxDQBBACEBIAJBiARxQYAERg0AIAJBKHFBAEchAQsgAQtZ ACAAQRhqQgA3AwAgAEIANwMAIABBOGpCADcDACAAQTBqQgA3AwAgAEEoakIANwMAIABBIGpCADcD ACAAQRBqQgA3AwAgAEEIakIANwMAIABB6wE2AhxBAAt7AQF/AkAgACgCDCIDDQACQCAAKAIERQ0A IAAgATYCBAsCQCAAIAEgAhDRgICAACIDDQAgACgCDA8LIAAgAzYCHEEAIQMgACgCBCIBRQ0AIAAg ASACIAAoAggRgYCAgAAAIgFFDQAgACACNgIUIAAgATYCDCABIQMLIAMLlocCAxR/A34EfyOAgICA AEEQayIDJICAgIAAIAEhBCABIQUgASEGIAEhByABIQggASEJIAEhCiABIQsgASEMIAEhDSABIQ4g ASEPIAEhECABIREgASESIAEhEyABIRQgASEVAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJA AkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkAC QAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJA AkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkAC QAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJA AkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkAC QAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJA AkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkAC QAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQCAAKAIcIhZB f2oO6wHtAQHnAQIDBAUGBwgJCgsMDQ4PEBES5gET5QEUFeQBFhfjARgZGhscHR4fIO4B7AEh4gEi IyQlJicoKSor4QEsLS4vMDEy4AHfATM03gHdATU2Nzg5Ojs8PT4/QEFCQ0RFRkdISUpLTE1OT+gB UFFSU9wB2wFU2gFV2QFWV1hZWltcXV5fYGFiY2RlZmdoaWprbG1ub3BxcnN0dXZ3eHl6e3x9fn+A AYEBggGDAYQBhQGGAYcBiAGJAYoBiwGMAY0BjgGPAZABkQGSAZMBlAGVAZYBlwGYAZkBmgGbAZwB nQGeAZ8BoAGhAaIBowGkAaUBpgGnAagBqQGqAasBrAGtAa4BrwGwAbEBsgGzAbQBtQG2AbcBuAG5 AboBuwG8Ab0BvgG/AcABwQHCAcMBxAHYAdcBxQHWAcYB1QHHAcgByQHKAcsBzAHNAc4BzwHQAdEB 0gHTAQDpAQtBACEWDNMBC0EOIRYM0gELQQ0hFgzRAQtBDyEWDNABC0EQIRYMzwELQRMhFgzOAQtB FCEWDM0BC0EVIRYMzAELQRYhFgzLAQtBFyEWDMoBC0EYIRYMyQELQRkhFgzIAQtBGiEWDMcBC0Eb IRYMxgELQRwhFgzFAQtBHSEWDMQBC0EeIRYMwwELQR8hFgzCAQtBICEWDMEBC0EhIRYMwAELQQgh Fgy/AQtBIiEWDL4BC0EkIRYMvQELQSMhFgy8AQtBByEWDLsBC0ElIRYMugELQSYhFgy5AQtBJyEW DLgBC0EoIRYMtwELQRIhFgy2AQtBESEWDLUBC0EpIRYMtAELQSohFgyzAQtBKyEWDLIBC0EsIRYM sQELQc4BIRYMsAELQS4hFgyvAQtBMCEWDK4BC0ExIRYMrQELQTIhFgysAQtBMyEWDKsBC0E0IRYM qgELQTUhFgypAQtBzwEhFgyoAQtBNiEWDKcBC0E6IRYMpgELQQwhFgylAQtBNyEWDKQBC0E4IRYM owELQTkhFgyiAQtBPyEWDKEBC0E7IRYMoAELQdABIRYMnwELQQshFgyeAQtBwAAhFgydAQtBPCEW DJwBC0EKIRYMmwELQT0hFgyaAQtBPiEWDJkBC0HRASEWDJgBC0HCACEWDJcBC0HBACEWDJYBC0HD ACEWDJUBC0EJIRYMlAELQS0hFgyTAQtBxAAhFgySAQtBxQAhFgyRAQtBxgAhFgyQAQtBxwAhFgyP AQtByAAhFgyOAQtByQAhFgyNAQtBygAhFgyMAQtBywAhFgyLAQtBzAAhFgyKAQtBLyEWDIkBC0HN ACEWDIgBC0HOACEWDIcBC0HPACEWDIYBC0HQACEWDIUBC0HRACEWDIQBC0HSACEWDIMBC0HTACEW DIIBC0HVACEWDIEBC0HUACEWDIABC0HWACEWDH8LQdcAIRYMfgtB2AAhFgx9C0HZACEWDHwLQdoA IRYMewtB2wAhFgx6C0HcACEWDHkLQdIBIRYMeAtB3QAhFgx3C0HeACEWDHYLQQYhFgx1C0HfACEW DHQLQQUhFgxzC0HgACEWDHILQQQhFgxxC0HhACEWDHALQeIAIRYMbwtB4wAhFgxuC0HkACEWDG0L QQMhFgxsC0HlACEWDGsLQeYAIRYMagtB5wAhFgxpC0HpACEWDGgLQegAIRYMZwtB6gAhFgxmC0Hr ACEWDGULQewAIRYMZAtB7QAhFgxjC0ECIRYMYgtB7gAhFgxhC0HvACEWDGALQfAAIRYMXwtB8QAh FgxeC0HyACEWDF0LQfMAIRYMXAtB9AAhFgxbC0H1ACEWDFoLQfYAIRYMWQtB9wAhFgxYC0H4ACEW DFcLQfkAIRYMVgtB+gAhFgxVC0H7ACEWDFQLQfwAIRYMUwtB/QAhFgxSC0H+ACEWDFELQf8AIRYM UAtBgAEhFgxPC0GBASEWDE4LQYIBIRYMTQtBgwEhFgxMC0GEASEWDEsLQYUBIRYMSgtBhgEhFgxJ C0GHASEWDEgLQYgBIRYMRwtBiQEhFgxGC0GKASEWDEULQYsBIRYMRAtBjAEhFgxDC0GNASEWDEIL QY4BIRYMQQtBjwEhFgxAC0GQASEWDD8LQZEBIRYMPgtBkgEhFgw9C0GTASEWDDwLQZQBIRYMOwtB lQEhFgw6C0GWASEWDDkLQZcBIRYMOAtBmAEhFgw3C0GZASEWDDYLQZoBIRYMNQtBmwEhFgw0C0Gc ASEWDDMLQZ0BIRYMMgtBngEhFgwxC0GfASEWDDALQaABIRYMLwtBoQEhFgwuC0GiASEWDC0LQaMB IRYMLAtBpAEhFgwrC0GlASEWDCoLQaYBIRYMKQtBpwEhFgwoC0GoASEWDCcLQakBIRYMJgtBqgEh FgwlC0GrASEWDCQLQawBIRYMIwtBrQEhFgwiC0GuASEWDCELQa8BIRYMIAtBsAEhFgwfC0GxASEW DB4LQbIBIRYMHQtBswEhFgwcC0G0ASEWDBsLQbUBIRYMGgtBtgEhFgwZC0G3ASEWDBgLQbgBIRYM FwtBASEWDBYLQbkBIRYMFQtBugEhFgwUC0G7ASEWDBMLQbwBIRYMEgtBvQEhFgwRC0G+ASEWDBAL Qb8BIRYMDwtBwAEhFgwOC0HBASEWDA0LQcIBIRYMDAtBwwEhFgwLC0HEASEWDAoLQcUBIRYMCQtB xgEhFgwIC0HTASEWDAcLQccBIRYMBgtByAEhFgwFC0HJASEWDAQLQcoBIRYMAwtBywEhFgwCC0HN ASEWDAELQcwBIRYLA0ACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkAC QAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJA AkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkAC QAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJA AkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkAC QAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJA AkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkAC QAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJA AkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkAC QAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJA AkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkAC QAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJA AkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkAC QAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJA AkACQAJAAkACQAJAAkAgFg7UAQABAgMEBQYHCAkKCwwNDg8QERITFBUWFxgZGhscHR4fICEjJCUn KCmFA4IDgQP4AvAC7QLqAukC5gLkAuEC3gLdAtsC2QLUAtMC0gLRAtACyALHAsUCxALDAsICwQLA ArsCugK4ArcCtgK1ArQCswKyArECrAKqAqgCpwKmAqUCpAKjAqICoQKgAp8CmwKaApkCmAKXApAC iAKEAoMCggL5AfYB9QH0AfMB8gHxAfAB7wHtAesB6AHjAeEB4AHfAd4B3QHcAdsB2gHZAdgB1wHW AdUB1AHSAdEB0AHPAc4BzQHMAcsBygHJAcgBxwHGAcUBxAHDAcIBwQHAAb8BvgG9AbwBuwG6AbkB uAG3AbYBtQG0AbMBsgGxAbABrwGuAa0BrAGrAaoBqQGoAacBpgGlAaQBowGiAaEBoAGfAZ4BnQGc AZsBmAGXAZIBkQGQAY8BjgGNAYwBiwGKAYkBhgGFAYQBgAF/fn18eXh3UVJTVFVWVgsgASIEIAJH DXVB6wEhFgyoAwsgASIWIAJHDZEBQdABIRYMpwMLIAEiASACRw3pAUGEASEWDKYDCyABIhUgAkcN 9AFB+gAhFgylAwsgASIVIAJHDYICQfUAIRYMpAMLIAEiFSACRw2JAkHzACEWDKMDCyABIhUgAkcN jAJB8QAhFgyiAwsgASIBIAJHDR5BHiEWDKEDCyABIgEgAkcNGUEYIRYMoAMLIAEiASACRw21AkHN ACEWDJ8DCyABIgEgAkcNwQJBxgAhFgyeAwsgASIBIAJHDcICQcMAIRYMnQMLIAEiASACRw3IAkE4 IRYMnAMLIAAtADBBAUYNlAMM8AILIAAgASIBIAIQzYCAgABBAUcNYyAAQgA3AyAMZAsgACABIgEg AhDBgICAACIWDWEgASEBDEgLAkAgASIBIAJHDQBBBiEWDJkDCyABLQAAQQpHDRkgAUEBaiEBDBoL IABCADcDIEESIRYM/QILIAEiFiACRw3xAkEjIRYMlgMLAkAgASIBIAJHDQBBByEWDJYDCwJAAkAg AS0AAEF2ag4EARgYABgLIAFBAWohAUEQIRYM/AILIAFBAWohASAAQS9qLQAAQQFxDRcgAEEANgIc IAAgATYCFCAAQYSfgIAANgIQIABBGTYCDEEAIRYMlQMLIABCACAAKQMgIhcgAiABIhZrrSIYfSIZ IBkgF1YbNwMgIBcgGFYiGkUNGEEIIRYMlAMLAkAgASIBIAJGDQAgAEGJgICAADYCCCAAIAE2AgQg ASEBQRQhFgz6AgtBCSEWDJMDCyABIQEgACkDIFANFyABIQEMQwsCQCABIgEgAkcNAEELIRYMkgML IAEtAABBCkcNFyABQQFqIQEMGAsgASEBIABBL2otAABBAXFFDRogASEBDCcLIAAgASIBIAIQxYCA gAAiFg0aIAEhAQxCCyAAIAEiASACEMWAgIAAIhYNGyABIQEMJQsgACABIgEgAhDFgICAACIWDRwg ASEBDDMLIAEhASAAQS9qLQAAQQFxRQ0dIAEhAQwjCyAAIAEiASACEMeAgIAAIhYNHSABIQEMQgsg ACABIgEgAhDHgICAACIWDR4gASEBDCELAkAgASIBIAJHDQBBEyEWDIoDCwJAIAEtAAAiFkF2ag4E ICQkACMLIAFBAWohAQwgCyAAIAEiASACEMeAgIAAIhYNIyABIQEMQgsCQCABIgEgAkcNAEEWIRYM iAMLIAEtAABB8L+AgABqLQAAQQFHDSQgAUEBaiEBDOwCCwJAA0ACQCABLQAAQeC5gIAAai0AACIW QQFGDQACQCAWQX5qDgIDACgLIAFBAWohAUEhIRYM7wILIAFBAWoiASACRw0AC0EYIRYMhwMLIAAo AgQhFiAAQQA2AgQgACAWIAFBAWoiARDGgICAACIWDSIgASEBDEELIAAgASIBIAIQx4CAgAAiFg0k IAEhAQwrCwJAIAEiASACRw0AQRwhFgyFAwsgAEGKgICAADYCCCAAIAE2AgQgACABIAIQxYCAgAAi Fg0mIAEhAUEkIRYM6gILAkAgASIBIAJGDQADQAJAIAEtAABB4LuAgABqLQAAIhZBA0YNAAJAIBZB f2oOBRocKAAnKAsgAUEBaiEBDOsCCyABQQFqIgEgAkcNAAtBGyEWDIQDC0EbIRYMgwMLA0ACQCAB LQAAQeC9gIAAai0AACIWQQNGDQAgFkF/ag4FEBIoFCcoCyABQQFqIgEgAkcNAAtBHiEWDIIDCwJA IAEiASACRg0AIABBi4CAgAA2AgggACABNgIEIAEhAUEHIRYM6AILQR8hFgyBAwsCQCABIhogAkcN AEEgIRYMgQMLIBohAQJAIBotAABBc2oOFC8/Pz8/Pz8/Pz8/Pz8/Pz8/Pz8APwtBACEWIABBADYC HCAAQbeLgIAANgIQIABBAjYCDCAAIBpBAWo2AhQMgAMLIAEhASAAQS9qIRYDQAJAIAEgAkcNAEEh IRYMgQMLAkACQAJAIAEtAAAiGkF3ag4YAgAqKgEqKioqKioqKioqKioqKioqKioCKAsgAUEBaiEB IABBL2otAABBAXFFDQsgASEBDBkLIAFBAWohAQwYCyABQQFqIQEgFi0AAEECcQ0ACyAAQQA2Ahwg ACABNgIUIABBzpSAgAA2AhAgAEEMNgIMQQAhFgz/AgsgAC0ALkGAAXFFDQELAkAgACABIAIQyICA gAAiFg0AIAEhAQzOAgsCQCAWQRVHDQAgAEEkNgIcIAAgATYCFCAAQYaagIAANgIQIABBFTYCDEEA IRYM/gILIABBADYCHCAAIAE2AhQgAEHijYCAADYCECAAQRQ2AgxBACEWDP0CCyAAQQA2AhwgACAB NgIUIABBqZ+AgAA2AhAgAEECNgIMQQAhFgz8AgsgACgCBCEbIABBADYCBCAWIBenaiIcIQEgACAb IBYgHCAaGyIWEMKAgIAAIhpFDSsgAEEHNgIcIAAgFjYCFCAAIBo2AgxBACEWDPsCCyAAIAAvATJB gAFyOwEyIAEhAQy8AgsgAC0ALkHAAHFFDQELAkAgACABIAIQw4CAgAAiFg0AIAEhAQwrCwJAIBZB FUcNACAAQQo2AhwgACABNgIUIABB8ZiAgAA2AhAgAEEVNgIMQQAhFgz5AgsgAEEANgIcIAAgATYC FCAAQYuMgIAANgIQIABBEzYCDEEAIRYM+AILIABBADYCHCAAIAE2AhQgAEGxlICAADYCECAAQQI2 AgxBACEWDPcCCyAAQQA2AhwgACABNgIUIABBjJSAgAA2AhAgAEEZNgIMQQAhFgz2AgsgAEEANgIc IAAgATYCFCAAQdGcgIAANgIQIABBGTYCDEEAIRYM9QILIBZBFUYNOyAAQQA2AhwgACABNgIUIABB oo+AgAA2AhAgAEEiNgIMQQAhFgz0AgsgACgCBCEWIABBADYCBAJAIAAgFiABEMSAgIAAIhYNACAB IQEMKAsgAEENNgIcIAAgATYCFCAAIBY2AgxBACEWDPMCCyAWQRVGDTggAEEANgIcIAAgATYCFCAA QaKPgIAANgIQIABBIjYCDEEAIRYM8gILIAAoAgQhFiAAQQA2AgQCQCAAIBYgARDEgICAACIWDQAg AUEBaiEBDCcLIABBDjYCHCAAIBY2AgwgACABQQFqNgIUQQAhFgzxAgsgFkEVRg01IABBADYCHCAA IAE2AhQgAEGij4CAADYCECAAQSI2AgxBACEWDPACCyAAKAIEIRYgAEEANgIEAkAgACAWIAEQxICA gAAiFg0AIAFBAWohAQwmCyAAQQ82AhwgACAWNgIMIAAgAUEBajYCFEEAIRYM7wILIABBADYCHCAA IAE2AhQgAEHoloCAADYCECAAQRk2AgxBACEWDO4CCyAWQRVGDTEgAEEANgIcIAAgATYCFCAAQc6M gIAANgIQIABBIzYCDEEAIRYM7QILIAAoAgQhFiAAQQA2AgQCQCAAIBYgARDGgICAACIWDQAgASEB DCULIABBETYCHCAAIAE2AhQgACAWNgIMQQAhFgzsAgsgFkEVRg0uIABBADYCHCAAIAE2AhQgAEHO jICAADYCECAAQSM2AgxBACEWDOsCCyAAKAIEIRYgAEEANgIEAkAgACAWIAEQxoCAgAAiFg0AIAFB AWohAQwkCyAAQRI2AhwgACAWNgIMIAAgAUEBajYCFEEAIRYM6gILIABBL2otAABBAXFFDQEgASEB C0EXIRYMzgILIABBADYCHCAAIAE2AhQgAEHoloCAADYCECAAQRk2AgxBACEWDOcCCyAWQTtHDQAg AUEBaiEBDAwLQQAhFiAAQQA2AhwgACABNgIUIABBmJeAgAA2AhAgAEECNgIMDOUCCyAWQRVGDSYg AEEANgIcIAAgATYCFCAAQc6MgIAANgIQIABBIzYCDEEAIRYM5AILIABBFDYCHCAAIAE2AhQgACAW NgIMQQAhFgzjAgsgACgCBCEEIABBADYCBAJAIAAgBCABEMaAgIAAIgQNACABQQFqIQEM2wILIABB FTYCHCAAIAQ2AgwgACABQQFqNgIUQQAhFgziAgsgACgCBCEEIABBADYCBAJAIAAgBCABEMaAgIAA IgQNACABQQFqIQEM2QILIABBFzYCHCAAIAQ2AgwgACABQQFqNgIUQQAhFgzhAgsgFkEVRg0hIABB ADYCHCAAIAE2AhQgAEHOjICAADYCECAAQSM2AgxBACEWDOACCyAAKAIEIRYgAEEANgIEAkAgACAW IAEQxoCAgAAiFg0AIAFBAWohAQwcCyAAQRk2AhwgACAWNgIMIAAgAUEBajYCFEEAIRYM3wILIAAo AgQhBCAAQQA2AgQCQCAAIAQgARDGgICAACIEDQAgAUEBaiEBDNUCCyAAQRo2AhwgACAENgIMIAAg AUEBajYCFEEAIRYM3gILIBZBFUYNHSAAQQA2AhwgACABNgIUIABBoo+AgAA2AhAgAEEiNgIMQQAh FgzdAgsgACgCBCEWIABBADYCBAJAIAAgFiABEMSAgIAAIhYNACABQQFqIQEMGgsgAEEcNgIcIAAg FjYCDCAAIAFBAWo2AhRBACEWDNwCCyAAKAIEIQQgAEEANgIEAkAgACAEIAEQxICAgAAiBA0AIAFB AWohAQzRAgsgAEEdNgIcIAAgBDYCDCAAIAFBAWo2AhRBACEWDNsCCyAaQTtHDQEgAUEBaiEBC0Em IRYMvwILQQAhFiAAQQA2AhwgACABNgIUIABBzpSAgAA2AhAgAEEMNgIMDNgCCwJAIBEgAkYNAANA AkAgES0AAEEgRg0AIBEhAQzvAQsgEUEBaiIRIAJHDQALQSwhFgzYAgtBLCEWDNcCCwJAIBIgAkcN AEE0IRYM1wILAkACQANAAkAgEi0AAEF2ag4EAgAAAwALIBJBAWoiEiACRw0AC0E0IRYM2AILIAAo AgQhASAAQQA2AgQCQCAAIAEgEhC+gICAACIBDQAgEiEBDIsCCyAAQTI2AhwgACASNgIUIAAgATYC DEEAIRYM1wILIAAoAgQhASAAQQA2AgQCQCAAIAEgEhC+gICAACIBDQAgEkEBaiEBDIoCCyAAQTI2 AhwgACABNgIMIAAgEkEBajYCFEEAIRYM1gILAkAgEyACRg0AAkADQAJAIBMtAABBUGoiAUH/AXFB CkkNACATIQFBOyEWDL8CCyAAKQMgIhdCmbPmzJmz5swZVg0BIAAgF0IKfiIXNwMgIBcgAa1C/wGD IhhCf4VWDQEgACAXIBh8NwMgIBNBAWoiEyACRw0AC0HAACEWDNcCCyAAKAIEIQEgAEEANgIEIAAg ASATQQFqIgQQvoCAgAAiAQ0VIAQhAQzIAgtBwAAhFgzVAgsCQCAUIAJHDQBByQAhFgzVAgsCQANA AkAgFC0AAEF3ag4YAAL0AfQBkQL0AfQB9AH0AfQB9AH0AfQB9AH0AfQB9AH0AfQB9AH0AfQB9AEA 9AELIBRBAWoiFCACRw0AC0HJACEWDNUCCyAUQQFqIQECQCAAQS9qLQAAQQFxRQ0AIAEhAQyOAgsg AEEANgIcIAAgATYCFCAAQemPgIAANgIQIABBCjYCDEEAIRYM1AILAkAgFSACRg0AA0ACQCAVLQAA IgFBIEYNAAJAAkACQCABQbh/ag4LAAHNAc0BzQHNAc0BzQHNAc0BAs0BCyAVQQFqIQFB2gAhFgy+ AgsgFUEBaiEBQdsAIRYMvQILIBVBAWohAUHcACEWDLwCCyAVQQFqIhUgAkcNAAtB7gAhFgzUAgtB 7gAhFgzTAgsgAEECOgAoDDELQQAhFiAAQQA2AhwgAEG3i4CAADYCECAAQQI2AgwgACAaQQFqNgIU DNECC0ENIRYMtgILQRMhFgy1AgtBFSEWDLQCC0EWIRYMswILQRghFgyyAgtBGSEWDLECC0EaIRYM sAILQRshFgyvAgtBHCEWDK4CC0EdIRYMrQILQR4hFgysAgtBHyEWDKsCC0EgIRYMqgILQSIhFgyp AgtBIyEWDKgCC0ElIRYMpwILIABBPTYCHCAAIAQ2AhQgACABNgIMQQAhFgzAAgsgAEEbNgIcIAAg ATYCFCAAQY+bgIAANgIQIABBFTYCDEEAIRYMvwILIABBIDYCHCAAIAE2AhQgAEGemYCAADYCECAA QRU2AgxBACEWDL4CCyAAQRM2AhwgACABNgIUIABBnpmAgAA2AhAgAEEVNgIMQQAhFgy9AgsgAEEL NgIcIAAgATYCFCAAQZ6ZgIAANgIQIABBFTYCDEEAIRYMvAILIABBEDYCHCAAIAE2AhQgAEGemYCA ADYCECAAQRU2AgxBACEWDLsCCyAAQSA2AhwgACABNgIUIABBj5uAgAA2AhAgAEEVNgIMQQAhFgy6 AgsgAEELNgIcIAAgATYCFCAAQY+bgIAANgIQIABBFTYCDEEAIRYMuQILIABBDDYCHCAAIAE2AhQg AEGPm4CAADYCECAAQRU2AgxBACEWDLgCCwJAIBZBFUYNACAAQQA2AhwgACABNgIUIABBr46AgAA2 AhAgAEESNgIMQQAhFgy4AgsgAEEENgIcIAAgATYCFCAAQb2agIAANgIQIABBFTYCDEEAIRYMtwIL IABBADoAMSAALQAuQQRxRQ0BCyAAQQA6ADEgAEEBOgA2IAEhAQwBCyABIQEMswILQQAhFgyZAgsC QANAAkAgBC0AAEF2ag4EAAICAAILIARBAWoiBCACRw0AC0HrASEWDLMCCwJAAkAgAC0ANkEBRw0A IAAgBCACEMmAgIAAIhZFDQAgFkEVRw0BIABB6gE2AhwgACAENgIUIABB4piAgAA2AhAgAEEVNgIM QQAhFgy0AgtBzAEhFgyZAgsgAEEANgIcIAAgBDYCFCAAQfGLgIAANgIQIABBHzYCDEEAIRYMsgIL AkACQCAALQAoQX9qDgIEAQALQcsBIRYMmAILQcQBIRYMlwILIABBAjoAMQJAIAAgBCACELOAgIAA IhYNAEHNASEWDJcCCwJAIBZBFUYNACAAQQA2AhwgACAENgIUIABBrIyAgAA2AhAgAEEQNgIMQQAh FgyxAgsgAEHpATYCHCAAIAQ2AhQgAEGHmYCAADYCECAAQRU2AgxBACEWDLACCwJAIAQgAkcNAEHo ASEWDLACCyAELQAAQcgARg0BIABBAToAKAtBtgEhFgyUAgtBygEhFgyTAgsCQCAEIAJGDQAgAEGM gICAADYCCCAAIAQ2AgRByQEhFgyTAgtB5wEhFgysAgsCQCAEIAJHDQBB5gEhFgysAgsgBC0AAEHI AEcNBCAEQQFqIQRByAEhFgyRAgsCQCAEIAJHDQBB5QEhFgyrAgsCQAJAIAQtAABBu39qDhAABQUF BQUFBQUFBQUFBQUBBQsgBEEBaiEEQcYBIRYMkQILIARBAWohBEHHASEWDJACCwJAIAQgAkcNAEHk ASEWDKoCCyACIARrIAAoAgAiFmohGiAEIBZrQQJqIQ8CQANAIAQtAAAgFkHz04CAAGotAABHDQMg FkECRg0BIBZBAWohFiAEQQFqIgQgAkcNAAsgACAaNgIAQeQBIRYMqgILIAAoAgQhFiAAQgA3AwAC QCAAIBYgD0EBaiIPELiAgIAAIhYNAEHTASEWDJACCyAAQeMBNgIcIAAgDzYCFCAAIBY2AgxBACEW DKkCCwJAIAQgAkcNAEHiASEWDKkCCyACIARrIAAoAgAiFmohGiAEIBZrQQFqIRACQANAIAQtAAAg FkHx04CAAGotAABHDQIgFkEBRg0BIBZBAWohFiAEQQFqIgQgAkcNAAsgACAaNgIAQeIBIRYMqQIL IABBgQQ7ASggACgCBCEWIABCADcDACAAIBYgEEEBaiIQELiAgIAAIhZFDQIgAEHhATYCHCAAIBA2 AhQgACAWNgIMQQAhFgyoAgsgAEEANgIAC0EAIRYgAEEANgIcIAAgBDYCFCAAQdCegIAANgIQIABB CDYCDAymAgtBxQEhFgyLAgsCQCAAIBAgAhC5gICAACIBDQAgECEBDGULAkAgAUEVRg0AIABBADYC HCAAIBA2AhQgAEHUjoCAADYCECAAQSA2AgxBACEWDKUCCyAAQYUBNgIcIAAgEDYCFCAAQdeagIAA NgIQIABBFTYCDEEAIRYMpAILAkAgBCACRw0AQeABIRYMpAILIAIgBGsgACgCACIWaiEaIAQgFmtB BGohDwJAA0AgBC0AACAWQezTgIAAai0AAEcNASAWQQRGDQMgFkEBaiEWIARBAWoiBCACRw0ACyAA IBo2AgBB4AEhFgykAgsgAEEANgIcIAAgBDYCFCAAQf62gIAANgIQIABBCDYCDCAAQQA2AgBBACEW DKMCCwJAIA8gAkYNACAAQY2AgIAANgIIIAAgDzYCBEHCASEWDIkCC0HfASEWDKICCyAAQQA2AgAg D0EBaiEPC0HDASEWDIYCCwJAIA8gAkcNAEHeASEWDKACCwJAIA8tAABBUGoiFkH/AXFBCk8NACAA IBY6ACogD0EBaiEOQcEBIRYMhgILIAAoAgQhBCAAQQA2AgQgACAEIA8QuoCAgAAiBEUNhgIgAEHd ATYCHCAAIA82AhQgACAENgIMQQAhFgyfAgsCQCAOIAJHDQBB3AEhFgyfAgsCQAJAIA4tAABBLkcN ACAOQQFqIQ0MAQsgACgCBCEEIABBADYCBCAAIAQgDhC6gICAACIERQ2HAiAAQdsBNgIcIAAgDjYC FCAAIAQ2AgxBACEWDJ8CC0HAASEWDIQCCwJAIA0gAkcNAEHaASEWDJ4CC0EAIRpBASEbQQEhHEEA IRYCQAJAAkACQAJAAkACQAJAAkACQAJAAkACQCANLQAAQVBqDgoK CQABAgMEBQYICwtBAiEWDAYLQQMhFgwFC0EEIRYMBAtBBSEWDAMLQQYhFgwCC0EHIRYMAQtBCCEW C0EAIRtBACEcQQAhGgwCC0EJIRZBASEaQQAhG0EAIRwMAQtBASEcQQAhG0EAIRpBASEWCyAAIBY6 ACsgDUEBaiEMAkACQCAALQAuQRBxDQACQAJAAkAgAC0AKg4DAQACBAsgHEUNAwwCCyAaDQEMAgsg G0UNAQsgACgCBCEWIABBADYCBCAAIBYgDBC6gICAACIWRQ0CIABB1wE2AhwgACAMNgIUIAAgFjYC DEEAIRYMoAILIAAoAgQhBCAAQQA2AgQgACAEIAwQuoCAgAAiBEUNiQIgAEHYATYCHCAAIAw2AhQg ACAENgIMQQAhFgyfAgsgACgCBCEEIABBADYCBCAAIAQgDRC6gICAACIERQ2HAiAAQdkBNgIcIAAg DTYCFCAAIAQ2AgxBACEWDJ4CC0G/ASEWDIMCCwJAIAAgDCACELuAgIAAIhZFDQACQCAWQRVHDQAg AEHWATYCHCAAIAw2AhQgAEHWmYCAADYCECAAQRU2AgxBACEWDJ4CCyAAQQA2AhwgACAMNgIUIABB nI2AgAA2AhAgAEEhNgIMQQAhFgydAgtBvgEhFgyCAgsCQCAMIAJHDQBB1gEhFgycAgsCQAJAIAwt AABBIEcNACAAQQA7ATQgDEEBaiELDAELIABBADYCHCAAIAw2AhQgAEHrkICAADYCECAAQQk2AgxB ACEWDJwCC0G9ASEWDIECCwJAIAsgAkcNAEHVASEWDJsCCwJAAkAgCy0AAEFQaiIaQf8BcUEKTw0A IAtBAWohCgJAIAAvATQiFkGZM0sNACAAIBZBCmwiFjsBNCAaQf8BcSIaQf//A3MgFkH+/wNxSQ0A IAAgFiAaajsBNAwCC0EAIRYgAEEANgIcIAAgCjYCFCAAQYCdgIAANgIQIABBDTYCDAycAgsgAEEA NgIcIAAgCzYCFCAAQYCdgIAANgIQIABBDTYCDEEAIRYMmwILQbwBIRYMgAILAkAgCiACRw0AQdQB IRYMmgILAkACQCAKLQAAQVBqIhpB/wFxQQpPDQAgCkEBaiEJAkAgAC8BNCIWQZkzSw0AIAAgFkEK bCIWOwE0IBpB/wFxIhpB//8DcyAWQf7/A3FJDQAgACAWIBpqOwE0DAILQQAhFiAAQQA2AhwgACAJ NgIUIABBgJ2AgAA2AhAgAEENNgIMDJsCCyAAQQA2AhwgACAKNgIUIABBgJ2AgAA2AhAgAEENNgIM QQAhFgyaAgtBuwEhFgz/AQsCQCAJIAJHDQBB0wEhFgyZAgsCQAJAIAktAABBUGoiGkH/AXFBCk8N ACAJQQFqIQgCQCAALwE0IhZBmTNLDQAgACAWQQpsIhY7ATQgGkH/AXEiGkH//wNzIBZB/v8DcUkN ACAAIBYgGmo7ATQMAgtBACEWIABBADYCHCAAIAg2AhQgAEGAnYCAADYCECAAQQ02AgwMmgILIABB ADYCHCAAIAk2AhQgAEGAnYCAADYCECAAQQ02AgxBACEWDJkCC0G6ASEWDP4BCwJAIAggAkcNAEHS ASEWDJgCCwJAAkACQAJAIAgtAABBdmoOFwIDAwADAwMDAwMDAwMDAwMDAwMDAwMBAwsgCEEBaiEG DAULIAhBAWohB0G5ASEWDP8BCyAIQQFqIQYgAEEvai0AAEEBcQ0IIABBADYCHCAAIAY2AhQgAEGF i4CAADYCECAAQQ02AgxBACEWDJgCCyAAQQA2AhwgACAINgIUIABBhYuAgAA2AhAgAEENNgIMQQAh FgyXAgsCQCAHIAJGDQAgAEGOgICAADYCCCAAIAc2AgQgByEBQQEhFgz9AQtB0QEhFgyWAgsCQAJA A0ACQCAWLQAAQXZqDgQCAAADAAsgFkEBaiIWIAJHDQALQdABIRYMlwILIAAoAgQhBiAAQQA2AgQC QCAAIAYgFhC2gICAACIGDQAgFkEBaiEGDAQLIABBzwE2AhwgACAGNgIMIAAgFkEBajYCFEEAIRYM lgILIAAoAgQhBiAAQQA2AgQgACAGIBYQtoCAgAAiBg0BIBZBAWohBgtBtwEhFgz6AQsgAEHOATYC HCAAIAY2AgwgACAWQQFqNgIUQQAhFgyTAgtBuAEhFgz4AQsgAEEvai0AAEEBcQ0BIABBADYCHCAA IAY2AhQgAEHPm4CAADYCECAAQRk2AgxBACEWDJECCwJAIAYgAkcNAEHOASEWDJECCwJAAkACQCAG LQAAQXZqDgQBAgIAAgsgBkEBaiEGDAILIAZBAWohBgwBCyAALQAuQcAAcUUNAQsCQCAAIAYgAhC3 gICAACIBDQAgBiEBDJYBCwJAIAFBFUcNACAAQdkANgIcIAAgBjYCFCAAQb2ZgIAANgIQIABBFTYC DEEAIRYMkAILIABBADYCHCAAIAY2AhQgAEH4jICAADYCECAAQRs2AgxBACEWDI8CCyAAQQA2Ahwg ACAGNgIUIABBwaeAgAA2AhAgAEECNgIMQQAhFgyOAgsCQCAEIAJGDQAgAEGMgICAADYCCCAAIAQ2 AgRBtQEhFgz0AQtBzQEhFgyNAgsCQCAEIAJHDQBBzAEhFgyNAgsCQAJAAkACQAJAAkACQAJAAkAC QAJAAkACQAJAAkACQCAELQAAQb9/ag4VAAECA1gEBQZYWFgHCAkKC1gMDQ4PWAsgBEEBaiEBQfIA IRYMgQILIARBAWohAUHzACEWDIACCyAEQQFqIQFB+AAhFgz/AQsgBEEBaiEBQfwAIRYM/gELIARB AWohAUH9ACEWDP0BCyAEQQFqIQRBgAEhFgz8AQsgBEEBaiEEQYEBIRYM+wELIARBAWohBEGEASEW DPoBCyAEQQFqIQRBjQEhFgz5AQsgBEEBaiEEQY4BIRYM+AELIARBAWohBEGPASEWDPcBCyAEQQFq IQRBnAEhFgz2AQsgBEEBaiEEQaIBIRYM9QELIARBAWohBEGqASEWDPQBCyAEQQFqIQRBrQEhFgzz AQsgBEEBaiEEQbQBIRYM8gELAkAgBCACRw0AQcsBIRYMjAILIAQtAABBzgBHDUcgBEEBaiEEQbMB IRYM8QELAkAgBCACRw0AQcoBIRYMiwILAkACQAJAIAQtAABBvn9qDhIASUlJSUlJSUlJAUlJSUlJ SQJJCyAEQQFqIQRBrgEhFgzyAQsgBEEBaiEEQbEBIRYM8QELIARBAWohBEGyASEWDPABCwJAIAQg AkcNAEHJASEWDIoCCyACIARrIAAoAgAiAWohBSAEIAFrQQdqIRYCQANAIAQtAAAgAUHk04CAAGot AABHDUQgAUEHRg0BIAFBAWohASAEQQFqIgQgAkcNAAsgACAFNgIAQckBIRYMigILIABBADYCACAW QQFqIQVBGyEWDEQLAkAgBCACRw0AQcgBIRYMiQILAkACQCAELQAAQbd/ag4HAEZGRkZGAUYLIARB AWohBEGvASEWDO8BCyAEQQFqIQRBsAEhFgzuAQsCQCAEIAJHDQBBxwEhFgyIAgsgAiAEayAAKAIA IgFqIQUgBCABa0EBaiEWAkADQCAELQAAIAFB4tOAgABqLQAARw1CIAFBAUYNASABQQFqIQEgBEEB aiIEIAJHDQALIAAgBTYCAEHHASEWDIgCCyAAQQA2AgAgFkEBaiEFQQ8hFgxCCwJAIAQgAkcNAEHG ASEWDIcCCyACIARrIAAoAgAiAWohBSAEIAFrQQFqIRYCQANAIAQtAAAgAUHg04CAAGotAABHDUEg AUEBRg0BIAFBAWohASAEQQFqIgQgAkcNAAsgACAFNgIAQcYBIRYMhwILIABBADYCACAWQQFqIQVB ICEWDEELAkAgBCACRw0AQcUBIRYMhgILIAIgBGsgACgCACIBaiEFIAQgAWtBAmohFgJAA0AgBC0A ACABQd3TgIAAai0AAEcNQCABQQJGDQEgAUEBaiEBIARBAWoiBCACRw0ACyAAIAU2AgBBxQEhFgyG AgsgAEEANgIAIBZBAWohBUESIRYMQAsCQCAEIAJHDQBBxAEhFgyFAgsCQAJAIAQtAABBu39qDg4A QkJCQkJCQkJCQkJCAUILIARBAWohBEGrASEWDOsBCyAEQQFqIQRBrAEhFgzqAQsCQCAEIAJHDQBB wwEhFgyEAgsgAiAEayAAKAIAIgFqIQUgBCABa0ECaiEWAkADQCAELQAAIAFB2tOAgABqLQAARw0+ IAFBAkYNASABQQFqIQEgBEEBaiIEIAJHDQALIAAgBTYCAEHDASEWDIQCCyAAQQA2AgAgFkEBaiEF QQchFgw+CwJAIAQgAkcNAEHCASEWDIMCCyACIARrIAAoAgAiAWohBSAEIAFrQQVqIRYCQANAIAQt AAAgAUHU04CAAGotAABHDT0gAUEFRg0BIAFBAWohASAEQQFqIgQgAkcNAAsgACAFNgIAQcIBIRYM gwILIABBADYCACAWQQFqIQVBKCEWDD0LAkAgBCACRw0AQcEBIRYMggILAkACQAJAIAQtAABBu39q DhEAQEBAQEBAQEBAAUBAQEBAAkALIARBAWohBEGnASEWDOkBCyAEQQFqIQRBqAEhFgzoAQsgBEEB aiEEQakBIRYM5wELAkAgBCACRw0AQcABIRYMgQILIAIgBGsgACgCACIBaiEFIAQgAWtBBmohFgJA A0AgBC0AACABQc3TgIAAai0AAEcNOyABQQZGDQEgAUEBaiEBIARBAWoiBCACRw0ACyAAIAU2AgBB wAEhFgyBAgsgAEEANgIAIBZBAWohBUEaIRYMOwsCQCAEIAJHDQBBvwEhFgyAAgsgAiAEayAAKAIA IgFqIQUgBCABa0EDaiEWAkADQCAELQAAIAFBydOAgABqLQAARw06IAFBA0YNASABQQFqIQEgBEEB aiIEIAJHDQALIAAgBTYCAEG/ASEWDIACCyAAQQA2AgAgFkEBaiEFQSEhFgw6CwJAIAQgAkcNAEG+ ASEWDP8BCwJAAkAgBC0AAEG/f2oOFAA8PDw8PDw8PDw8PDw8PDw8PDwBPAsgBEEBaiEEQaMBIRYM 5QELIARBAWohBEGmASEWDOQBCwJAIAQgAkcNAEG9ASEWDP4BCwJAAkAgBC0AAEGrf2oOCwA7Ozs7 Ozs7OzsBOwsgBEEBaiEEQaQBIRYM5AELIARBAWohBEGlASEWDOMBCwJAIAQgAkcNAEG8ASEWDP0B CyACIARrIAAoAgAiAWohBSAEIAFrQQhqIRYCQANAIAQtAAAgAUHA04CAAGotAABHDTcgAUEIRg0B IAFBAWohASAEQQFqIgQgAkcNAAsgACAFNgIAQbwBIRYM/QELIABBADYCACAWQQFqIQVBKiEWDDcL AkAgBCACRw0AQbsBIRYM/AELIAQtAABB0ABHDTcgBEEBaiEFQSUhFgw2CwJAIAQgAkcNAEG6ASEW DPsBCyACIARrIAAoAgAiAWohBSAEIAFrQQJqIRYCQANAIAQtAAAgAUG904CAAGotAABHDTUgAUEC Rg0BIAFBAWohASAEQQFqIgQgAkcNAAsgACAFNgIAQboBIRYM+wELIABBADYCACAWQQFqIQVBDiEW DDULAkAgBCACRw0AQbkBIRYM+gELIAQtAABBxQBHDTUgBEEBaiEEQaEBIRYM3wELAkAgBCACRw0A QbgBIRYM+QELAkACQAJAAkAgBC0AAEG+f2oODwABAjg4ODg4ODg4ODg4AzgLIARBAWohBEGdASEW DOEBCyAEQQFqIQRBngEhFgzgAQsgBEEBaiEEQZ8BIRYM3wELIARBAWohBEGgASEWDN4BCwJAIAQg AkcNAEG3ASEWDPgBCyACIARrIAAoAgAiAWohBSAEIAFrQQJqIRYCQANAIAQtAAAgAUG604CAAGot AABHDTIgAUECRg0BIAFBAWohASAEQQFqIgQgAkcNAAsgACAFNgIAQbcBIRYM+AELIABBADYCACAW QQFqIQVBFCEWDDILAkAgBCACRw0AQbYBIRYM9wELIAIgBGsgACgCACIBaiEFIAQgAWtBBGohFgJA A0AgBC0AACABQbXTgIAAai0AAEcNMSABQQRGDQEgAUEBaiEBIARBAWoiBCACRw0ACyAAIAU2AgBB tgEhFgz3AQsgAEEANgIAIBZBAWohBUErIRYMMQsCQCAEIAJHDQBBtQEhFgz2AQsgAiAEayAAKAIA IgFqIQUgBCABa0ECaiEWAkADQCAELQAAIAFBstOAgABqLQAARw0wIAFBAkYNASABQQFqIQEgBEEB aiIEIAJHDQALIAAgBTYCAEG1ASEWDPYBCyAAQQA2AgAgFkEBaiEFQSwhFgwwCwJAIAQgAkcNAEG0 ASEWDPUBCyACIARrIAAoAgAiAWohBSAEIAFrQQJqIRYCQANAIAQtAAAgAUHd04CAAGotAABHDS8g AUECRg0BIAFBAWohASAEQQFqIgQgAkcNAAsgACAFNgIAQbQBIRYM9QELIABBADYCACAWQQFqIQVB ESEWDC8LAkAgBCACRw0AQbMBIRYM9AELAkACQAJAAkACQCAELQAAQb9/ag4VADQ0NDQ0NDQ0NDQB NDQCNDQDNDQENAsgBEEBaiEEQZIBIRYM3QELIARBAWohBEGTASEWDNwBCyAEQQFqIQRBlAEhFgzb AQsgBEEBaiEEQZkBIRYM2gELIARBAWohBEGbASEWDNkBCwJAIAQgAkcNAEGyASEWDPMBCwJAAkAg BC0AAEGuf2oOAwAwATALIARBAWohBEGaASEWDNkBCyAEQQFqIQVBBCEWDC0LAkAgBCACRw0AQbEB IRYM8gELIAIgBGsgACgCACIBaiEFIAQgAWtBAWohFgJAA0AgBC0AACABQbDTgIAAai0AAEcNLCAB QQFGDQEgAUEBaiEBIARBAWoiBCACRw0ACyAAIAU2AgBBsQEhFgzyAQsgAEEANgIAIBZBAWohBUEd IRYMLAsCQCAEIAJHDQBBsAEhFgzxAQsCQAJAIAQtAABBt39qDgcBLi4uLi4ALgsgBEEBaiEEQZgB IRYM1wELIARBAWohBUEiIRYMKwsCQCAEIAJHDQBBrwEhFgzwAQsgBC0AAEHQAEcNKyAEQQFqIQRB lwEhFgzVAQsCQCAEIAJHDQBBrgEhFgzvAQsCQAJAIAQtAABBun9qDgsALCwsLCwsLCwsASwLIARB AWohBEGVASEWDNUBCyAEQQFqIQRBlgEhFgzUAQsCQCAEIAJHDQBBrQEhFgzuAQsgAiAEayAAKAIA IgFqIQUgBCABa0EDaiEWAkADQCAELQAAIAFBrNOAgABqLQAARw0oIAFBA0YNASABQQFqIQEgBEEB aiIEIAJHDQALIAAgBTYCAEGtASEWDO4BCyAAQQA2AgAgFkEBaiEFQQ0hFgwoCwJAIAQgAkcNAEGs ASEWDO0BCyACIARrIAAoAgAiAWohBSAEIAFrQQJqIRYCQANAIAQtAAAgAUHd04CAAGotAABHDScg AUECRg0BIAFBAWohASAEQQFqIgQgAkcNAAsgACAFNgIAQawBIRYM7QELIABBADYCACAWQQFqIQVB DCEWDCcLAkAgBCACRw0AQasBIRYM7AELIAIgBGsgACgCACIBaiEFIAQgAWtBAWohFgJAA0AgBC0A ACABQarTgIAAai0AAEcNJiABQQFGDQEgAUEBaiEBIARBAWoiBCACRw0ACyAAIAU2AgBBqwEhFgzs AQsgAEEANgIAIBZBAWohBUEDIRYMJgsCQCAEIAJHDQBBqgEhFgzrAQsgAiAEayAAKAIAIgFqIQUg BCABa0EBaiEWAkADQCAELQAAIAFBqNOAgABqLQAARw0lIAFBAUYNASABQQFqIQEgBEEBaiIEIAJH DQALIAAgBTYCAEGqASEWDOsBCyAAQQA2AgAgFkEBaiEFQSYhFgwlCwJAIAQgAkcNAEGpASEWDOoB CwJAAkAgBC0AAEGsf2oOAgABJwsgBEEBaiEEQZABIRYM0AELIARBAWohBEGRASEWDM8BCwJAIAQg AkcNAEGoASEWDOkBCyACIARrIAAoAgAiAWohBSAEIAFrQQFqIRYCQANAIAQtAAAgAUGm04CAAGot AABHDSMgAUEBRg0BIAFBAWohASAEQQFqIgQgAkcNAAsgACAFNgIAQagBIRYM6QELIABBADYCACAW QQFqIQVBJyEWDCMLAkAgBCACRw0AQacBIRYM6AELIAIgBGsgACgCACIBaiEFIAQgAWtBAWohFgJA A0AgBC0AACABQaTTgIAAai0AAEcNIiABQQFGDQEgAUEBaiEBIARBAWoiBCACRw0ACyAAIAU2AgBB pwEhFgzoAQsgAEEANgIAIBZBAWohBUEcIRYMIgsCQCAEIAJHDQBBpgEhFgznAQsgAiAEayAAKAIA IgFqIQUgBCABa0EFaiEWAkADQCAELQAAIAFBntOAgABqLQAARw0hIAFBBUYNASABQQFqIQEgBEEB aiIEIAJHDQALIAAgBTYCAEGmASEWDOcBCyAAQQA2AgAgFkEBaiEFQQYhFgwhCwJAIAQgAkcNAEGl ASEWDOYBCyACIARrIAAoAgAiAWohBSAEIAFrQQRqIRYCQANAIAQtAAAgAUGZ04CAAGotAABHDSAg AUEERg0BIAFBAWohASAEQQFqIgQgAkcNAAsgACAFNgIAQaUBIRYM5gELIABBADYCACAWQQFqIQVB GSEWDCALAkAgBCACRw0AQaQBIRYM5QELAkACQAJAAkAgBC0AAEFTag4jACQkJCQkJCQkJCQkJCQk JCQkJCQkJCQkASQkJCQkAiQkJAMkCyAEQQFqIQRBhQEhFgzNAQsgBEEBaiEEQYYBIRYMzAELIARB AWohBEGLASEWDMsBCyAEQQFqIQRBjAEhFgzKAQsCQCAEIAJHDQBBowEhFgzkAQsgAiAEayAAKAIA IgFqIQUgBCABa0EBaiEWAkADQCAELQAAIAFBl9OAgABqLQAARw0eIAFBAUYNASABQQFqIQEgBEEB aiIEIAJHDQALIAAgBTYCAEGjASEWDOQBCyAAQQA2AgAgFkEBaiEFQQshFgweCwJAIAQgAkcNAEGi ASEWDOMBCwJAAkAgBC0AAEG/f2oOAwAgASALIARBAWohBEGHASEWDMkBCyAEQQFqIQRBigEhFgzI AQsCQCAEIAJHDQBBoQEhFgziAQsCQAJAIAQtAABBv39qDg8AHx8fHx8fHx8fHx8fHwEfCyAEQQFq IQRBiAEhFgzIAQsgBEEBaiEEQYkBIRYMxwELAkAgBCACRw0AQaABIRYM4QELIAQtAABBzABHDRwg BEEBaiEFQQohFgwbCwJAIAQgAkcNAEGfASEWDOABCyACIARrIAAoAgAiAWohBSAEIAFrQQVqIRYC QANAIAQtAAAgAUGR04CAAGotAABHDRogAUEFRg0BIAFBAWohASAEQQFqIgQgAkcNAAsgACAFNgIA QZ8BIRYM4AELIABBADYCACAWQQFqIQVBHiEWDBoLAkAgBCACRw0AQZ4BIRYM3wELIAIgBGsgACgC ACIBaiEFIAQgAWtBBmohFgJAA0AgBC0AACABQYrTgIAAai0AAEcNGSABQQZGDQEgAUEBaiEBIARB AWoiBCACRw0ACyAAIAU2AgBBngEhFgzfAQsgAEEANgIAIBZBAWohBUEVIRYMGQsCQCAEIAJHDQBB nQEhFgzeAQsgAiAEayAAKAIAIgFqIQUgBCABa0ECaiEWAkADQCAELQAAIAFBh9OAgABqLQAARw0Y IAFBAkYNASABQQFqIQEgBEEBaiIEIAJHDQALIAAgBTYCAEGdASEWDN4BCyAAQQA2AgAgFkEBaiEF QRchFgwYCwJAIAQgAkcNAEGcASEWDN0BCyACIARrIAAoAgAiAWohBSAEIAFrQQVqIRYCQANAIAQt AAAgAUGB04CAAGotAABHDRcgAUEFRg0BIAFBAWohASAEQQFqIgQgAkcNAAsgACAFNgIAQZwBIRYM 3QELIABBADYCACAWQQFqIQVBGCEWDBcLAkAgBCACRw0AQZsBIRYM3AELAkACQCAELQAAQbd/ag4H ABkZGRkZARkLIARBAWohBEGCASEWDMIBCyAEQQFqIQRBgwEhFgzBAQsCQCAEIAJHDQBBmgEhFgzb AQsgAiAEayAAKAIAIgFqIQUgBCABa0EBaiEWAkADQCAELQAAIAFB4tOAgABqLQAARw0VIAFBAUYN ASABQQFqIQEgBEEBaiIEIAJHDQALIAAgBTYCAEGaASEWDNsBCyAAQQA2AgAgFkEBaiEFQQkhFgwV CwJAIAQgAkcNAEGZASEWDNoBCyACIARrIAAoAgAiAWohBSAEIAFrQQFqIRYCQANAIAQtAAAgAUHg 04CAAGotAABHDRQgAUEBRg0BIAFBAWohASAEQQFqIgQgAkcNAAsgACAFNgIAQZkBIRYM2gELIABB ADYCACAWQQFqIQVBHyEWDBQLAkAgBCACRw0AQZgBIRYM2QELIAIgBGsgACgCACIBaiEFIAQgAWtB AmohFgJAA0AgBC0AACABQf7SgIAAai0AAEcNEyABQQJGDQEgAUEBaiEBIARBAWoiBCACRw0ACyAA IAU2AgBBmAEhFgzZAQsgAEEANgIAIBZBAWohBUECIRYMEwsCQCAEIAJHDQBBlwEhFgzYAQsgAiAE ayAAKAIAIhZqIRogBCAWa0EBaiEFA0AgBC0AACAWQfzSgIAAai0AAEcNESAWQQFGDQIgFkEBaiEW IARBAWoiBCACRw0ACyAAIBo2AgBBlwEhFgzXAQsCQCAFIAJHDQBBlgEhFgzXAQtBASEWIAUtAABB 3wBHDREgBUEBaiEEQf4AIRYMvAELIABBADYCACAFQQFqIQVB/wAhFgy7AQsCQCAEIAJHDQBBlQEh FgzVAQsgAiAEayAAKAIAIgFqIQUgBCABa0EIaiEWAkADQCAELQAAIAFBwNOAgABqLQAARw0PIAFB CEYNASABQQFqIQEgBEEBaiIEIAJHDQALIAAgBTYCAEGVASEWDNUBCyAAQQA2AgAgFkEBaiEFQSkh FgwPCwJAIAEiBCACRw0AQZQBIRYM1AELIAIgBGsgACgCACIBaiEFIAQgAWtBA2ohFgJAA0AgBC0A ACABQfjSgIAAai0AAEcNDiABQQNGDQEgAUEBaiEBIARBAWoiBCACRw0ACyAAIAU2AgBBlAEhFgzU AQsgAEEANgIAIBZBAWohBUEtIRYMDgsCQCABIgQgAkcNAEGTASEWDNMBCyAELQAAQcUARw0OIARB AWohAUH7ACEWDLgBCwJAIAEiBCACRw0AQZIBIRYM0gELAkACQCAELQAAQbR/ag4IAA8PDw8PDwEP CyAEQQFqIQFB+QAhFgy4AQsgBEEBaiEBQfoAIRYMtwELAkAgASIEIAJHDQBBkQEhFgzRAQsgAiAE ayAAKAIAIgFqIQUgBCABa0EEaiEWAkADQCAELQAAIAFB89KAgABqLQAARw0LIAFBBEYNASABQQFq IQEgBEEBaiIEIAJHDQALIAAgBTYCAEGRASEWDNEBCyAAQQA2AgAgFkEBaiEFQSMhFgwLCwJAIAEi BCACRw0AQZABIRYM0AELIAIgBGsgACgCACIBaiEWIAQgAWtBAmohBQJAA0AgBC0AACABQfDSgIAA ai0AAEcNCiABQQJGDQEgAUEBaiEBIARBAWoiBCACRw0ACyAAIBY2AgBBkAEhFgzQAQtBACEWIABB ADYCACAFQQFqIQUMCgsCQCABIgQgAkcNAEGPASEWDM8BCwJAAkAgBC0AAEG4f2oOCAAMDAwMDAwB DAsgBEEBaiEBQfQAIRYMtQELIARBAWohAUH3ACEWDLQBCwJAIAEiBCACRw0AQY4BIRYMzgELAkAC QCAELQAAQbJ/ag4DAAsBCwsgBEEBaiEBQfUAIRYMtAELIARBAWohAUH2ACEWDLMBCwJAIAEiBCAC Rw0AQY0BIRYMzQELIAQtAABB2QBHDQggBEEBaiEFQQghFgwHCwJAIAEiBCACRw0AQYwBIRYMzAEL IAIgBGsgACgCACIBaiEFIAQgAWtBA2ohFgJAA0AgBC0AACABQezSgIAAai0AAEcNBiABQQNGDQEg AUEBaiEBIARBAWoiBCACRw0ACyAAIAU2AgBBjAEhFgzMAQsgAEEANgIAIBZBAWohBUEFIRYMBgsC QCABIgQgAkcNAEGLASEWDMsBCyACIARrIAAoAgAiAWohBSAEIAFrQQVqIRYCQANAIAQtAAAgAUHm 0oCAAGotAABHDQUgAUEFRg0BIAFBAWohASAEQQFqIgQgAkcNAAsgACAFNgIAQYsBIRYMywELIABB ADYCACAWQQFqIQVBFiEWDAULAkAgASIEIAJHDQBBigEhFgzKAQsgAiAEayAAKAIAIgFqIQUgBCAB a0ECaiEWAkADQCAELQAAIAFB3dOAgABqLQAARw0EIAFBAkYNASABQQFqIQEgBEEBaiIEIAJHDQAL IAAgBTYCAEGKASEWDMoBCyAAQQA2AgAgFkEBaiEFQRAhFgwECwJAIAEiBCACRw0AQYkBIRYMyQEL AkACQCAELQAAQb1/ag4MAAYGBgYGBgYGBgYBBgsgBEEBaiEBQfAAIRYMrwELIARBAWohAUHxACEW DK4BCwJAIAEiBCACRw0AQYgBIRYMyAELIAIgBGsgACgCACIBaiEFIAQgAWtBBWohFgJAA0AgBC0A ACABQeDSgIAAai0AAEcNAiABQQVGDQEgAUEBaiEBIARBAWoiBCACRw0ACyAAIAU2AgBBiAEhFgzI AQsgAEEANgIAIBZBAWohBUEkIRYMAgsgAEEANgIADAILAkAgASIEIAJHDQBBhwEhFgzGAQsgBC0A AEHMAEcNASAEQQFqIQVBEyEWCyAAIBY6ACkgACgCBCEBIABBADYCBCAAIAEgBRC4gICAACIBDQIg BSEBDAELQQAhFiAAQQA2AhwgACAENgIUIABB6Z6AgAA2AhAgAEEGNgIMDMMBC0HvACEWDKgBCyAA QYYBNgIcIAAgBTYCFCAAIAE2AgxBACEWDMEBCwJAIAAgASIBIAIQuYCAgAAiFg0AIAEhAQwBCyAW QRVGDQEgAEEANgIcIAAgATYCFCAAQdSOgIAANgIQIABBIDYCDEEAIRYMwAELQe4AIRYMpQELIABB hQE2AhwgACABNgIUIABB15qAgAA2AhAgAEEVNgIMQQAhFgy+AQsCQCABIgEgAkcNAEGFASEWDL4B CwJAAkAgAS0AAEEgRw0AIAFBAWohAQwBCyAAQQA2AhwgACABNgIUIABBhp6AgAA2AhAgAEEGNgIM QQAhFgy+AQtBAiEWDKMBCwNAIAEtAABBIEcNAiABQQFqIgEgAkcNAAtBhAEhFgy8AQsCQCABIhUg AkcNAEGDASEWDLwBCyAVIQECQCAVLQAAQXdqDgRAAABAAAtB7AAhFgyhAQsgASEBAkAgAC0AKUEF Rw0AQe0AIRYMoQELQesAIRYMoAELAkAgASIBIAJHDQBBggEhFgy6AQsgAEGPgICAADYCCCAAIAE2 AgQgASEBDAoLAkAgASIVIAJHDQBBgQEhFgy5AQsgFSEBAkAgFS0AAEF3ag4EPQAAPQALQeoAIRYM ngELAkAgASIBIAJGDQAgAEGPgICAADYCCCAAIAE2AgQgASEBQegAIRYMngELQYABIRYMtwELAkAC QCABIhUgAkYNAANAAkAgFS0AAEHgzoCAAGotAAAiAUEDRg0AAkAgAUF/ag4CPwAECyAVIQFB5wAh FgygAQsgFUEBaiIVIAJHDQALQf4AIRYMuAELQf4AIRYMtwELIABBADYCHCAAIBU2AhQgAEHGn4CA ADYCECAAQQc2AgxBACEWDLYBCwJAIAEiFSACRw0AQf8AIRYMtgELIBUhAQJAAkACQCAVLQAAQeDQ gIAAai0AAEF/ag4DPAIAAQtB6QAhFgydAQsgAEEANgIcIAAgFTYCFCAAQYaSgIAANgIQIABBBzYC DEEAIRYMtgELQeEAIRYMmwELAkAgASIBIAJGDQAgAUEBaiEBQeYAIRYMmwELQf0AIRYMtAELAkAg ASIVIAJHDQBB/AAhFgy0AQsCQCAVLQAAIgFBL0cNACAVQQFqIQFB5QAhFgyaAQsgAUF3aiIEQRdL DQFBASAEdEGbgIAEcUUNAQw3CwJAIAEiFSACRw0AQfsAIRYMswELIBUtAABBL0cNACAVQQFqIQEM AwtBACEWIABBADYCHCAAIBU2AhQgAEHGn4CAADYCECAAQQc2AgwMsQELAkACQAJAAkACQANAAkAg FS0AAEHgzICAAGotAAAiAUEFRg0AAkACQCABQX9qDgg9BQYHCAAEAQgLIBUhAUHiACEWDJ4BCyAV QQFqIQFB5AAhFgydAQsgFUEBaiIVIAJHDQALQfoAIRYMtQELIBVBAWohAQwUCyAAKAIEIQEgAEEA NgIEAkAgACABIBUQtICAgAAiAQ0AIBUhAQwfCyAAQdsANgIcIAAgFTYCFCAAIAE2AgxBACEWDLMB CyAAKAIEIQEgAEEANgIEAkAgACABIBUQtICAgAAiAQ0AIBUhAQwfCyAAQd0ANgIcIAAgFTYCFCAA IAE2AgxBACEWDLIBCyAAKAIEIQEgAEEANgIEAkAgACABIBUQtICAgAAiAQ0AIBUhAQwfCyAAQfAA NgIcIAAgFTYCFCAAIAE2AgxBACEWDLEBCyAAQQA2AhwgACAVNgIUIABBy4+AgAA2AhAgAEEHNgIM QQAhFgywAQsCQCABIhUgAkcNAEH5ACEWDLABCyAVIQECQCAVLQAAQeDMgIAAai0AAEF/ag4INAQF BgAIAgMHCyAVQQFqIQELQQMhFgyUAQsgFUEBaiEBDA0LIABBADYCHCAAQaOSgIAANgIQIABBBzYC DCAAIBVBAWo2AhRBACEWDKwBCyAAKAIEIQEgAEEANgIEAkAgACABIBUQtICAgAAiAQ0AIBUhAQwX CyAAQdsANgIcIAAgFTYCFCAAIAE2AgxBACEWDKsBCyAAKAIEIQEgAEEANgIEAkAgACABIBUQtICA gAAiAQ0AIBUhAQwXCyAAQd0ANgIcIAAgFTYCFCAAIAE2AgxBACEWDKoBCyAAKAIEIQEgAEEANgIE AkAgACABIBUQtICAgAAiAQ0AIBUhAQwXCyAAQfAANgIcIAAgFTYCFCAAIAE2AgxBACEWDKkBCyAA QQA2AhwgACAVNgIUIABBy4+AgAA2AhAgAEEHNgIMQQAhFgyoAQtB4wAhFgyNAQsCQCABIgEgAkcN AEH4ACEWDKcBCyABQQFqIQEMAgsCQCABIgEgAkcNAEH3ACEWDKYBCyABQQFqIQEMAQsgASIBIAJG DQEgAUEBaiEBC0EEIRYMiQELQfYAIRYMogELA0ACQCAVLQAAQeDKgIAAai0AACIBQQJGDQAgAUEB Rg0nIBUhAUHgACEWDIkBCyAVQQFqIhUgAkcNAAtB9QAhFgyhAQsCQCABIhUgAkcNAEH0ACEWDKEB CwJAIBUtAABBd2oONyUDBiUEBgYGBgYGBgYGBgYGBgYGBgYGBQYGAgYGBgYGBgYGBgYGBgYGBgYG BgYGBgYGBgYGBgAGCyAVQQFqIQELQQUhFgyFAQsgFUEBaiEBDAYLIAAoAgQhASAAQQA2AgQCQCAA IAEgFRC0gICAACIBDQAgFSEBDAkLIABB2wA2AhwgACAVNgIUIAAgATYCDEEAIRYMnQELIAAoAgQh ASAAQQA2AgQCQCAAIAEgFRC0gICAACIBDQAgFSEBDAkLIABB3QA2AhwgACAVNgIUIAAgATYCDEEA IRYMnAELIAAoAgQhASAAQQA2AgQCQCAAIAEgFRC0gICAACIBDQAgFSEBDAkLIABB8AA2AhwgACAV NgIUIAAgATYCDEEAIRYMmwELIABBADYCHCAAIBU2AhQgAEG8k4CAADYCECAAQQc2AgxBACEWDJoB CwJAAkACQAJAA0ACQCAVLQAAQeDIgIAAai0AACIBQQVGDQACQCABQX9qDgYkAwQFBgAGCyAVIQFB 3wAhFgyFAQsgFUEBaiIVIAJHDQALQfMAIRYMnQELIAAoAgQhASAAQQA2AgQCQCAAIAEgFRC0gICA ACIBDQAgFSEBDAgLIABB2wA2AhwgACAVNgIUIAAgATYCDEEAIRYMnAELIAAoAgQhASAAQQA2AgQC QCAAIAEgFRC0gICAACIBDQAgFSEBDAgLIABB3QA2AhwgACAVNgIUIAAgATYCDEEAIRYMmwELIAAo AgQhASAAQQA2AgQCQCAAIAEgFRC0gICAACIBDQAgFSEBDAgLIABB8AA2AhwgACAVNgIUIAAgATYC DEEAIRYMmgELIABBADYCHCAAIBU2AhQgAEHciICAADYCECAAQQc2AgxBACEWDJkBCyABIgEgAkYN ASABQQFqIQELQQYhFgx9C0HyACEWDJYBCwJAAkACQAJAA0ACQCAVLQAAQeDGgIAAai0AACIBQQVG DQAgAUF/ag4EHwIDBAULIBVBAWoiFSACRw0AC0HxACEWDJkBCyAAKAIEIQEgAEEANgIEAkAgACAB IBUQtICAgAAiAQ0AIBUhAQwECyAAQdsANgIcIAAgFTYCFCAAIAE2AgxBACEWDJgBCyAAKAIEIQEg AEEANgIEAkAgACABIBUQtICAgAAiAQ0AIBUhAQwECyAAQd0ANgIcIAAgFTYCFCAAIAE2AgxBACEW DJcBCyAAKAIEIQEgAEEANgIEAkAgACABIBUQtICAgAAiAQ0AIBUhAQwECyAAQfAANgIcIAAgFTYC FCAAIAE2AgxBACEWDJYBCyAAQQA2AhwgACAVNgIUIABBtIqAgAA2AhAgAEEHNgIMQQAhFgyVAQtB zwAhFgx6C0HRACEWDHkLQd4AIRYMeAsCQCABIhUgAkcNAEHwACEWDJIBCwJAIBUtAABBd2oOBBYA ABYACyAVQQFqIQFB3QAhFgx3CwJAIAEiFSACRw0AQe8AIRYMkQELAkAgFS0AAEF3ag4EFQAAFQAL AkAgACAVIAIQtYCAgAAiFkUNAAJAIBZBFUcNACAAQe4ANgIcIAAgFTYCFCAAQfCZgIAANgIQIABB FTYCDEEAIRYMkgELIABBADYCHCAAIBU2AhQgAEHBjYCAADYCECAAQRo2AgxBACEWDJEBC0HSASEW DHYLQe0AIRYgASIVIAJGDY8BIAIgFWsgACgCACIBaiEbIBUgAWtBA2ohGgJAA0AgFS0AACABQdfG gIAAai0AAEcNBCABQQNGDQEgAUEBaiEBIBVBAWoiFSACRw0ACyAAIBs2AgAMkAELIABBADYCACAa QQFqIQECQCAALQApIhZBXWpBC08NACABIQEMBQsCQCAWQQZLDQBBASAWdEHKAHFFDQAgASEBDAUL QQAhFiAAQQA2AhwgACABNgIUIABB5YmAgAA2AhAgAEEINgIMDI8BC0HsACEWIAEiFSACRg2OASAC IBVrIAAoAgAiAWohGyAVIAFrQQJqIRoCQANAIBUtAAAgAUHUxoCAAGotAABHDQMgAUECRg0BIAFB AWohASAVQQFqIhUgAkcNAAsgACAbNgIADI8BCyAAQQA2AgAgGkEBaiEBAkAgAC0AKUEhRw0AIAEh AQwECyAAQQA2AhwgACABNgIUIABBiYqAgAA2AhAgAEEINgIMQQAhFgyOAQtB6wAhFiABIhUgAkYN jQEgAiAVayAAKAIAIgFqIRsgFSABa0EDaiEaAkADQCAVLQAAIAFB0MaAgABqLQAARw0CIAFBA0YN ASABQQFqIQEgFUEBaiIVIAJHDQALIAAgGzYCAAyOAQsgAEEANgIAIBpBAWohAQJAIAAtAClBI08N ACABIQEMAwsgAEEANgIcIAAgATYCFCAAQcGJgIAANgIQIABBCDYCDEEAIRYMjQELIABBADYCAAtB ACEWIABBADYCHCAAIBU2AhQgAEH+toCAADYCECAAQQg2AgwMiwELQdkAIRYMcAsCQCABIgEgAkYN ACAAQY2AgIAANgIIIAAgATYCBCABIQFB2AAhFgxwC0HqACEWDIkBCwJAIAEiASACRw0AQekAIRYM iQELAkAgAS0AAEFQaiIWQf8BcUEKTw0AIAAgFjoAKiABQQFqIQFB1wAhFgxvCyAAKAIEIQQgAEEA NgIEAkAgACAEIAEQuoCAgAAiBA0AIAEhAQx0CyAAQegANgIcIAAgATYCFCAAIAQ2AgxBACEWDIgB CwJAIAEiASACRw0AQecAIRYMiAELAkACQCABLQAAQS5HDQAgAUEBaiEBDAELIAAoAgQhBCAAQQA2 AgQCQCAAIAQgARC6gICAACIEDQAgASEBDHULIABB5gA2AhwgACABNgIUIAAgBDYCDEEAIRYMiAEL QdYAIRYMbQsCQCABIgEgAkcNAEHlACEWDIcBC0EAIRpBASEbQQEhHEEAIRYCQAJAAkACQAJAAkAC QAJAAkACQAJAAkACQCABLQAAQVBqDgoK CQABAgMEBQYICwtBAiEWDAYLQQMhFgwFC0EEIRYMBAtBBSEWDAMLQQYhFgwCC0EHIRYMAQtBCCEW C0EAIRtBACEaQQAhHAwCC0EJIRZBASEaQQAhG0EAIRwMAQtBASEcQQAhG0EAIRpBASEWCyAAIBY6 ACsgAUEBaiEBAkACQCAALQAuQRBxDQACQAJAAkAgAC0AKg4DAQACBAsgHEUNAwwCCyAaDQEMAgsg G0UNAQsgACgCBCEWIABBADYCBAJAIAAgFiABELqAgIAAIhYNACABIQEMAwsgAEHiADYCHCAAIAE2 AhQgACAWNgIMQQAhFgyJAQsgACgCBCEEIABBADYCBAJAIAAgBCABELqAgIAAIgQNACABIQEMdwsg AEHjADYCHCAAIAE2AhQgACAENgIMQQAhFgyIAQsgACgCBCEEIABBADYCBAJAIAAgBCABELqAgIAA IgQNACABIQEMdQsgAEHkADYCHCAAIAE2AhQgACAENgIMQQAhFgyHAQtB1AAhFgxsCyAALQApQSJG DX9B0wAhFgxrCwJAIAAgASIBIAIQu4CAgAAiFg0AIAEhAUHVACEWDGsLAkAgFkEVRg0AIABBADYC HCAAIAE2AhQgAEGcjYCAADYCECAAQSE2AgxBACEWDIUBCyAAQeEANgIcIAAgATYCFCAAQdaZgIAA NgIQIABBFTYCDEEAIRYMhAELAkAgASIBIAJHDQBB4AAhFgyEAQsCQAJAAkACQAJAIAEtAABBdmoO BAEEBAAECyABQQFqIQEMAQsgAUEBaiEBIABBL2otAABBAXFFDQEgASEBC0HSACEWDGsLIABBADYC HCAAIAE2AhQgAEGIkYCAADYCECAAQQk2AgxBACEWDIQBCyAAQQA2AhwgACABNgIUIABBiJGAgAA2 AhAgAEEJNgIMQQAhFgyDAQsCQCABIgEgAkcNAEHfACEWDIMBCwJAIAEtAABBCkcNACABQQFqIQEM CQsCQCAALQAuQcAAcUUNACABIQEMCQsgAEEANgIcIAAgATYCFCAAQYiRgIAANgIQIABBAjYCDEEA IRYMggELAkAgASIVIAJHDQBB3QAhFgyCAQsCQCAVLQAAIgFBDUcNACAVQQFqIQFB0AAhFgxoCyAB QXdqDgQFAQEFAQsCQCABIhUgAkcNAEHcACEWDIEBCyAVLQAAQQpHDQAgFUEBaiEBDAILQQAhFiAA QQA2AhwgACAVNgIUIABBr6yAgAA2AhAgAEEHNgIMDH8LAkAgASIVIAJHDQBB2wAhFgx/CwJAIBUt AABBd2oOBAMAAAMACyAVQQFqIQELQc4AIRYMYwsCQCABIhUgAkcNAEHaACEWDH0LIBUtAABBd2oO BAABAQABC0EAIRYgAEEANgIcIABB7JGAgAA2AhAgAEEHNgIMIAAgFUEBajYCFAx7CyAAQYASOwEq AkAgACAVIAIQtYCAgAAiAQ0AIBUhAQwBCyABQRVHDQEgAEHZADYCHCAAIBU2AhQgAEHwmYCAADYC ECAAQRU2AgxBACEWDHoLQc0AIRYMXwsgAEEANgIcIAAgFTYCFCAAQcGNgIAANgIQIABBGjYCDEEA IRYMeAsCQCABIgEgAkcNAEHZACEWDHgLAkAgAS0AAEEgRg0AIAEhAQw6CyABQQFqIQECQCAALQAu QQFxRQ0AIAEhAQw6CyAAQQA2AhwgACABNgIUIABBrZuAgAA2AhAgAEEeNgIMQQAhFgx3CwJAIAEi ASACRg0AIABBkICAgAA2AgggACABNgIEIAEhAUHLACEWDF0LQdcAIRYMdgsCQCABIhEgAkcNAEHW ACEWDHYLAkACQAJAAkAgES0AACIBQSByIAEgAUG/f2pB/wFxQRpJG0H/AXFBnX9qDhMAXV1dXV1d XV1dXV1dAV1dXQIDXQsgEUEBaiEBQccAIRYMXgsgEUEBaiEBQcgAIRYMXQsgEUEBaiEBQckAIRYM XAsgEUEBaiEBQcoAIRYMWwtB1QAhFiABIhEgAkYNdCACIBFrIAAoAgAiAWohHCARIAFrQQVqIRsD QCARLQAAIhpBIHIgGiAaQb9/akH/AXFBGkkbQf8BcSABQcDGgIAAai0AAEcNWAJAIAFBBUcNAEEE IQEMCgsgAUEBaiEBIBFBAWoiESACRw0ACyAAIBw2AgAMdAtB1AAhFiABIhEgAkYNcyACIBFrIAAo AgAiAWohHCARIAFrQQ9qIRsDQCARLQAAIhpBIHIgGiAaQb9/akH/AXFBGkkbQf8BcSABQbDGgIAA ai0AAEcNVwJAIAFBD0cNAEEDIQEMCQsgAUEBaiEBIBFBAWoiESACRw0ACyAAIBw2AgAMcwtB0wAh FiABIhEgAkYNciACIBFrIAAoAgAiAWohHCARIAFrQQ5qIRsDQCARLQAAIhpBIHIgGiAaQb9/akH/ AXFBGkkbQf8BcSABQZLGgIAAai0AAEcNViABQQ5GDQYgAUEBaiEBIBFBAWoiESACRw0ACyAAIBw2 AgAMcgtB0gAhFiABIhEgAkYNcSACIBFrIAAoAgAiAWohHCARIAFrQQFqIRsDQCARLQAAIhpBIHIg GiAaQb9/akH/AXFBGkkbQf8BcSABQZDGgIAAai0AAEcNVSABQQFGDQIgAUEBaiEBIBFBAWoiESAC Rw0ACyAAIBw2AgAMcQsCQCABIhEgAkcNAEHRACEWDHELAkACQCARLQAAIgFBIHIgASABQb9/akH/ AXFBGkkbQf8BcUGSf2oOBwBWVlZWVgFWCyARQQFqIQFBxAAhFgxXCyARQQFqIQFBxQAhFgxWCyAA QQA2AgAgG0EBaiEBQcYAIRYMVQtB0AAhFiABIhEgAkYNbiACIBFrIAAoAgAiAWohHCARIAFrQQlq IRsDQCARLQAAIhpBIHIgGiAaQb9/akH/AXFBGkkbQf8BcSABQYbGgIAAai0AAEcNUgJAIAFBCUcN AEECIQEMBAsgAUEBaiEBIBFBAWoiESACRw0ACyAAIBw2AgAMbgtBzwAhFiABIhEgAkYNbSACIBFr IAAoAgAiAWohHCARIAFrQQVqIRsDQCARLQAAIhpBIHIgGiAaQb9/akH/AXFBGkkbQf8BcSABQYDG gIAAai0AAEcNUSABQQVGDQEgAUEBaiEBIBFBAWoiESACRw0ACyAAIBw2AgAMbQtBASEBCyAAIAE6 ACwgAEEANgIAIBtBAWohAQtBLSEWDFALAkADQAJAIAEtAABBgMSAgABqLQAAQQFGDQAgASEBDAIL IAFBAWoiASACRw0AC0HNACEWDGoLQcMAIRYMTwsCQCABIgEgAkcNAEHMACEWDGkLAkAgAS0AAEE6 Rw0AIAAoAgQhFiAAQQA2AgQCQCAAIBYgARC8gICAACIWDQAgAUEBaiEBDC8LIABBywA2AhwgACAW NgIMIAAgAUEBajYCFEEAIRYMaQsgAEEANgIcIAAgATYCFCAAQbmRgIAANgIQIABBCjYCDEEAIRYM aAsgASEUAkACQCAALQAsQX5qDgIAASULIABBM2otAABBAnFFDSQgAC0ALkECcQ0kIABBADYCHCAA IBQ2AhQgAEHVk4CAADYCECAAQQs2AgxBACEWDGgLIAAtADJBIHFFDSMgAC0ALkECcQ0jIABBADYC HCAAIBQ2AhQgAEHskoCAADYCECAAQQ82AgxBACEWDGcLAkAgACABIgEgAhC9gICAACIWDQAgASEB QcIAIRYMTQsCQCAWQRVGDQAgAEEANgIcIAAgATYCFCAAQfiOgIAANgIQIABBHDYCDEEAIRYMZwsg AEHKADYCHCAAIAE2AhQgAEHwmoCAADYCECAAQRU2AgxBACEWDGYLAkAgASIBIAJGDQADQAJAIAEt AABB8L+AgABqLQAAQQFGDQAgASEBDBkLIAFBAWoiASACRw0AC0HEACEWDGYLQcQAIRYMZQsCQCAB IgEgAkYNAANAAkAgAS0AACIWQSByIBYgFkG/f2pB/wFxQRpJG0H/AXEiFkEJRg0AIBZBIEYNAAJA AkACQAJAIBZBnX9qDhMAAwMDAwMDAwEDAwMDAwMDAwMCAwsgAUEBaiEBQTchFgxQCyABQQFqIQFB OCEWDE8LIAFBAWohAUE5IRYMTgsgASEBDBYLIAFBAWoiASACRw0AC0E8IRYMZQtBPCEWDGQLAkAg ASITIAJHDQBByAAhFgxkCyAAQZGAgIAANgIIIAAgEzYCBCATIQECQAJAAkACQAJAIAAtACxBf2oO BBUAAQIKCyAALQAyQSBxDQNB0AEhFgxNCwJAIAAvATIiAUEIcUUNACAALQAoQQFHDQAgAC0ALkEI cUUNAgsgACABQff7A3FBgARyOwEyIBMhAQwMCyAAIAAvATJBEHI7ATIMBQsgAEEANgIEAkAgACAT IBMQvoCAgAAiBEUNACAAQcEANgIcIAAgBDYCDCAAIBNBAWo2AhRBACEWDGULIBNBAWohAQxUCyAA QQA2AhwgACATNgIUIABBo5OAgAA2AhAgAEEENgIMQQAhFgxjCyAUIQEMGAtBxwAhFiABIhogAkYN YSACIBprIAAoAgAiAWohHCAaIAFrQQZqIRsCQANAIBotAABBIHIgAUHww4CAAGotAABHDQEgAUEG Rg1FIAFBAWohASAaQQFqIhogAkcNAAsgACAcNgIADGILIABBADYCACAaIQEMBQsCQCABIhMgAkYN AANAAkAgEy0AAEHwwYCAAGotAAAiAUEBRg0AIAFBAkcNAyATQQFqIQEMBAsgE0EBaiITIAJHDQAL QcUAIRYMYQtBxQAhFgxgCyAAQQA6ACwgEyEBDAELQQshFgxEC0HAACEWDEMLAkACQANAAkAgAS0A ACIWQSBGDQACQAJAIBZBdmoOBAQBAQQACyAWQSxGDQQLIAEhAQwECyABQQFqIgEgAkcNAAtBxgAh FgxeCyAAQQg6ACwgASEBDA4LAkAgAC0AKEEBRg0AIAEhAQwDCwJAIAAtAC5BCHFFDQAgASEBDAML IAAoAgQhBCAAQQA2AgQCQCAAIAQgARC+gICAACIERQ0AIABBwgA2AhwgACAENgIMIAAgAUEBajYC FEEAIRYMXQsgAUEBaiEBDEsLQTwhFgxBCwJAA0ACQCABLQAAIhZBIEYNACAWQQlHDQILIAFBAWoi ASACRw0AC0HDACEWDFsLIAEhAQtBPSEWDD8LAkACQAJAIAEiASACRg0AA0ACQCABLQAAIhZBIEYN ACAWQXZqDgQDBAQDBAsgAUEBaiIBIAJHDQALQT8hFgxbC0E/IRYMWgsgACAALwEyQSByOwEyIAEh AQwKCyAAKAIEIQQgAEEANgIEAkAgACAEIAEQvoCAgAAiBA0AIAEhAQxKCyAAQT42AhwgACABNgIU IAAgBDYCDEEAIRYMWAsCQAJAIAEiASACRg0AA0ACQCABLQAAQfDBgIAAai0AACIWQQFGDQAgFkEC Rg0DIAEhAQwMCyABQQFqIgEgAkcNAAtBNyEWDFkLQTchFgxYCyABQQFqIQEMBAtBOyEWIAEiGiAC Rg1WIAIgGmsgACgCACIBaiEdIBogAWtBBWohHAJAA0AgGi0AACIbQSByIBsgG0G/f2pB/wFxQRpJ G0H/AXEgAUHAxoCAAGotAABHDQECQCABQQVHDQBBByEBDDoLIAFBAWohASAaQQFqIhogAkcNAAsg ACAdNgIADFcLIABBADYCACAaIQEMBQtBOiEWIAEiGiACRg1VIAIgGmsgACgCACIBaiEdIBogAWtB CGohHAJAA0AgGi0AACIbQSByIBsgG0G/f2pB/wFxQRpJG0H/AXEgAUHkv4CAAGotAABHDQECQCAB QQhHDQBBBSEBDDkLIAFBAWohASAaQQFqIhogAkcNAAsgACAdNgIADFYLIABBADYCACAaIQEMBAtB OSEWIAEiGiACRg1UIAIgGmsgACgCACIBaiEdIBogAWtBA2ohHAJAA0AgGi0AACIbQSByIBsgG0G/ f2pB/wFxQRpJG0H/AXEgAUHgv4CAAGotAABHDQECQCABQQNHDQBBBiEBDDgLIAFBAWohASAaQQFq IhogAkcNAAsgACAdNgIADFULIABBADYCACAaIQEMAwsCQANAAkAgAS0AACIWQSBGDQACQCAWQXZq DgQABQUAAwsgASEBDAcLIAFBAWoiASACRw0AC0E4IRYMVAsgFkEsRw0BIAFBAWohFkEBIQECQAJA AkACQAJAIAAtACxBe2oOBAMBAgQACyAWIQEMBAtBAiEBDAELQQQhAQsgAEEBOgAsIAAgAC8BMiAB cjsBMiAWIQEMAQsgACAALwEyQQhyOwEyIBYhAQtBPyEWDDgLIABBADoALCABIQELQTohFgw2CwJA IAEiEiACRw0AQTYhFgxQCwJAAkACQAJAAkAgEi0AAEF2ag4EAAICAQILIAAoAgQhASAAQQA2AgQC QCAAIAEgEhC+gICAACIBDQAgEiEBDAMLIABBMzYCHCAAIBI2AhQgACABNgIMQQAhFgxTCyAAKAIE IQEgAEEANgIEAkAgACABIBIQvoCAgAAiAQ0AIBJBAWohAQwGCyAAQTI2AhwgACABNgIMIAAgEkEB ajYCFEEAIRYMUgsCQCAALQAuQQFxRQ0AQc8BIRYMOAsgACgCBCEEIABBADYCBCAAIAQgEhC+gICA ACIEDQEgEiEBDEQLQTUhFgw2CyAAQTU2AhwgACASNgIUIAAgBDYCDEEAIRYMTwtBNiEWDDQLIAEh AQJAIABBL2otAABBAXFFDQAgASEBDAELIABBADYCHCAAIAE2AhQgAEHxlYCAADYCECAAQRk2AgxB ACEWDE0LQTQhFgwyCwJAIAEiASACRw0AQTIhFgxMCwJAAkAgAS0AAEEKRw0AIAFBAWohAQwBCyAA QQA2AhwgACABNgIUIABBmJaAgAA2AhAgAEEDNgIMQQAhFgxMC0EzIRYMMQsCQCABIhYgAkcNAEEx IRYMSwsCQCAWLQAAIgFBCUYNACABQSBHDQILAkAgAC0ALEEIRg0AIBYhAQwBCyAAQQA6ACwgFiEB C0E+IRYMLwsgFiEBQQEhGgJAAkACQAJAAkAgAC0ALEF7ag4EAwECAAsLIAAgAC8BMkEIcjsBMgwD C0ECIRoMAQtBBCEaCyAAQQE6ACwgACAALwEyIBpyOwEyCyAWIQEMBgsCQCABIgEgAkcNAEEwIRYM SAsCQCABLQAAQQpHDQAgAUEBaiEBDAELAkAgAC0ALkEBcUUNACABIQEMAQsgAEEANgIcIAAgATYC FCAAQcGngIAANgIQIABBAjYCDEEAIRYMRwtBMSEWDCwLIBRBAWohAUEyIRYMKwsCQCABIhYgAkcN AEEvIRYMRQsCQAJAIBYtAAAiGkEJRg0AIBpBIEcNAQsgFkEBaiEUIAAtAC5BAXENASAAQQA2Ahwg ACAUNgIUIABB6Y+AgAA2AhAgAEEKNgIMQQAhFgxFCyAWIQFBASEaAkACQAJAAkACQAJAAkAgAC0A LEF+ag4HBgUFAwECAAULIAAgAC8BMkEIcjsBMgwDC0ECIRoMAQtBBCEaCyAAQQE6ACwgACAALwEy IBpyOwEyCyAWIQELQTAhFgwrCyAAQQA2AhwgACAWNgIUIABBs5KAgAA2AhAgAEELNgIMQQAhFgxE C0HRASEWDCkLAkAgASIBIAJHDQBBLiEWDEMLIABBADYCBCAAQZGAgIAANgIIIAAgASABEL6AgIAA IhYNASABIQELQS4hFgwnCyAAQS02AhwgACABNgIUIAAgFjYCDEEAIRYMQAsCQCABIhYgAkcNAEHY ACEWDEALIBYhAQJAAkACQAJAAkACQCAWLQAAQXZqDgQBAgIAAgsgFkEBaiEBQSwhFgwqCyAWQQFq IRYCQCAAQS9qLQAAQQFxDQAgFiEBDDgLAkAgAC0AMkGAAXFFDQACQCAAIBYgAhDIgICAACIBDQAg FiEBDB8LIAFBFUcNBCAAQQU2AhwgACAWNgIUIABBhpqAgAA2AhAgAEEVNgIMQQAhFgxECyAAQTJq IRogACAWIAIQyoCAgAAaIBYhASAAIBYgAhDAgICAAA4WDQwLAQEBAQEBAQEBAQEBAQEBAQEBAgEL QcwAIRYMKAsgAEEANgIcIAAgFjYCFCAAQd2LgIAANgIQIABBETYCDEEAIRYMQQsgAEEpNgIcIAAg FjYCFCAAQbKYgIAANgIQIABBFTYCDEEAIRYMQAsgAEEANgIcIAAgFjYCFCAAQeKNgIAANgIQIABB FDYCDEEAIRYMPwsgACABIgEgAhC/gICAACIWDQEgASEBC0EvIRYMIwsCQCAWQRVGDQAgAEEANgIc IAAgATYCFCAAQYWOgIAANgIQIABBHTYCDEEAIRYMPQsgAEHYADYCHCAAIAE2AhQgAEGemoCAADYC ECAAQRU2AgxBACEWDDwLAkAgASIRIAJHDQBBzgAhFgw8CwJAAkAgES0AACIWQSBGDQAgFkE6Rw0h IAAoAgQhASAAQQA2AgQgACABIBEQvICAgAAiAQ0BIBFBAWohAQwCCwJAIAAtAC5BAXFFDQBBzgEh FgwjCyAAKAIEIQQgAEEANgIEIAAgBCARELyAgIAAIgRFDQIgAEEqNgIcIAAgBDYCDCAAIBFBAWo2 AhRBACEWDDwLIABBywA2AhwgACABNgIMIAAgEUEBajYCFEEAIRYMOwtBwQAhFgwgCyARQQFqIQEM LQsCQCABIhYgAkcNAEErIRYMOQsCQAJAIBYtAABBCkcNACAWQQFqIRYMAQsgAC0ALkHAAHFFDQYL AkAgAC0AMkGAAXFFDQACQCAAIBYgAhDIgICAACIBDQAgFiEBDBQLIAFBFUcNByAAQQU2AhwgACAW NgIUIABBhpqAgAA2AhAgAEEVNgIMQQAhFgw5CyAAQTJqIRogACAWIAIQyoCAgAAaIBYhASAAIBYg AhDAgICAAA4WAgEABAQEBAQEBAQEBAQEBAQEBAQEAwQLIABBAToAMAsgGiAaLwEAQcAAcjsBACAW IQELQSshFgwbCyAAQSk2AhwgACAWNgIUIABBspiAgAA2AhAgAEEVNgIMQQAhFgw0CyAAQQA2Ahwg ACAWNgIUIABB3YuAgAA2AhAgAEERNgIMQQAhFgwzCyAAQQA2AhwgACAWNgIUIABBnYuAgAA2AhAg AEECNgIMQQAhFgwyCyAAQQA2AhwgACAWNgIUIABB4o2AgAA2AhAgAEEUNgIMQQAhFgwxCyAAIAEi FiACEMuAgIAAQX9qDgUCAAcBAwQLQREhFgwVCyAAQQE6ADEgFiEBDCwLAkAgACAWIAIQwYCAgAAi BA0AIBYhAQwnCwJAIARBFUcNACAAQQM2AhwgACAWNgIUIABBvZqAgAA2AhAgAEEVNgIMQQAhFgwu CyAAQQA2AhwgACAWNgIUIABBr46AgAA2AhAgAEESNgIMQQAhFgwtCyAAQQA2AhwgACAWNgIUIABB 5J+AgAA2AhAgAEEPNgIMQQAhFgwsCyAAIBYgAhDBgICAACIBDQEgFiEBC0EOIRYMEAsCQCABQRVH DQAgAEECNgIcIAAgFjYCFCAAQb2agIAANgIQIABBFTYCDEEAIRYMKgsgAEEANgIcIAAgFjYCFCAA Qa+OgIAANgIQIABBEjYCDEEAIRYMKQtBKiEWDA4LAkAgASIBIAJGDQAgAEGJgICAADYCCCAAIAE2 AgQgASEBQSkhFgwOC0EmIRYMJwsgAEIAIAApAyAiFyACIAEiFmutIhh9IhkgGSAXVhs3AyACQCAX IBhWIhpFDQBBJSEWDCcLIAAoAgQhGyAAQQA2AgQgFiAXp2oiHCEBIAAgGyAWIBwgGhsiFhDCgICA ACIaRQ0AIABBBTYCHCAAIBY2AhQgACAaNgIMQQAhFgwmC0EPIRYMCwtCACEXAkACQAJAAkACQAJA AkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAIBYtAABBUGoONxcWAAECAwQFBgcUFBQUFBQU CAkKCwwNFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQODxAREhMUC0ICIRcMFgtCAyEXDBULQgQh FwwUC0IFIRcMEwtCBiEXDBILQgchFwwRC0IIIRcMEAtCCSEXDA8LQgohFwwOC0ILIRcMDQtCDCEX DAwLQg0hFwwLC0IOIRcMCgtCDyEXDAkLQgohFwwIC0ILIRcMBwtCDCEXDAYLQg0hFwwFC0IOIRcM BAtCDyEXDAMLIABBADYCHCAAIBY2AhQgAEHOlICAADYCECAAQQw2AgxBACEWDCQLAkAgASIWIAJH DQBBIiEWDCQLQgAhFyAWIQECQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJAAkACQAJA IBYtAABBUGoONxUUAAECAwQFBgcWFhYWFhYWCAkKCwwNFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYW FhYODxAREhMWC0ICIRcMFAtCAyEXDBMLQgQhFwwSC0IFIRcMEQtCBiEXDBALQgchFwwPC0IIIRcM DgtCCSEXDA0LQgohFwwMC0ILIRcMCwtCDCEXDAoLQg0hFwwJC0IOIRcMCAtCDyEXDAcLQgohFwwG C0ILIRcMBQtCDCEXDAQLQg0hFwwDC0IOIRcMAgtCDyEXDAELQgEhFwsgFkEBaiEBAkAgACkDICIY Qv//////////D1YNACAAIBhCBIYgF4Q3AyAgASEBDAILIABBADYCHCAAIAE2AhQgAEGtiYCAADYC ECAAQQw2AgxBACEWDCELQSchFgwGC0EoIRYMBQsgACABOgAsIABBADYCACAcQQFqIQFBDCEWDAQL IABBADYCACAbQQFqIQFBCiEWDAMLIABBADYCAAsgAEEAOgAsIBEhAUEJIRYMAQtBCCEWDAALC0EA IRYgAEEANgIcIAAgDzYCFCAAQdWQgIAANgIQIABBCTYCDAwYC0EAIRYgAEEANgIcIAAgDjYCFCAA QdeKgIAANgIQIABBCTYCDAwXC0EAIRYgAEEANgIcIAAgDTYCFCAAQb+QgIAANgIQIABBCTYCDAwW C0EAIRYgAEEANgIcIAAgDDYCFCAAQaSRgIAANgIQIABBCTYCDAwVC0EAIRYgAEEANgIcIAAgATYC FCAAQdWQgIAANgIQIABBCTYCDAwUC0EAIRYgAEEANgIcIAAgATYCFCAAQdeKgIAANgIQIABBCTYC DAwTC0EAIRYgAEEANgIcIAAgATYCFCAAQb+QgIAANgIQIABBCTYCDAwSC0EAIRYgAEEANgIcIAAg ATYCFCAAQaSRgIAANgIQIABBCTYCDAwRC0EAIRYgAEEANgIcIAAgATYCFCAAQb+WgIAANgIQIABB DzYCDAwQC0EAIRYgAEEANgIcIAAgATYCFCAAQb+WgIAANgIQIABBDzYCDAwPC0EAIRYgAEEANgIc IAAgATYCFCAAQciSgIAANgIQIABBCzYCDAwOC0EAIRYgAEEANgIcIAAgATYCFCAAQZWJgIAANgIQ IABBCzYCDAwNC0EAIRYgAEEANgIcIAAgATYCFCAAQemPgIAANgIQIABBCjYCDAwMC0EAIRYgAEEA NgIcIAAgATYCFCAAQYOQgIAANgIQIABBCjYCDAwLC0EAIRYgAEEANgIcIAAgATYCFCAAQaacgIAA NgIQIABBAjYCDAwKC0EAIRYgAEEANgIcIAAgATYCFCAAQcWVgIAANgIQIABBAjYCDAwJC0EAIRYg AEEANgIcIAAgATYCFCAAQf+XgIAANgIQIABBAjYCDAwIC0EAIRYgAEEANgIcIAAgATYCFCAAQcqX gIAANgIQIABBAjYCDAwHCyAAQQI2AhwgACABNgIUIABBlJ2AgAA2AhAgAEEWNgIMQQAhFgwGC0He ACEWIAEiBCACRg0FIANBCGogACAEIAJBxsaAgABBChDSgICAACADKAIMIQQgAygCCA4DAQUCAAsQ ioCAgAAACyAAQQA2AhwgAEGtnYCAADYCECAAQRc2AgwgACAEQQFqNgIUQQAhFgwDCyAAQQA2Ahwg ACAENgIUIABBwp2AgAA2AhAgAEEJNgIMQQAhFgwCCwJAIAEiBCACRw0AQSghFgwCCyAAQYmAgIAA NgIIIAAgBDYCBEEnIRYMAQsCQCABIgQgAkcNAEEBIRYMAQsDQAJAAkACQCAELQAAQXZqDgQAAQEA AQsgBEEBaiEEDAELIARBAWohBCAALQAuQSBxDQAgAEEANgIcIAAgBDYCFCAAQYyggIAANgIQIABB BTYCDEEAIRYMAgtBASEWIAQgAkcNAAsLIANBEGokgICAgAAgFguvAQECfyABKAIAIQYCQAJAIAIg A0YNACAEIAZqIQQgBiADaiACayEHIAIgBkF/cyAFaiIGaiEFA0ACQCACLQAAIAQtAABGDQBBAiEE DAMLAkAgBg0AQQAhBCAFIQIMAwsgBkF/aiEGIARBAWohBCACQQFqIgIgA0cNAAsgByEGIAMhAgsg AEEBNgIAIAEgBjYCACAAIAI2AgQPCyABQQA2AgAgACAENgIAIAAgAjYCBAsL/ksBAEGACAv2SwEA AAACAAAAAwAAAAAAAAAAAAAABAAAAAUAAAAAAAAAAAAAAAYAAAAHAAAACAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAASW52YWxpZCBjaGFyIGluIHVybCBxdWVy eQBTcGFuIGNhbGxiYWNrIGVycm9yIGluIG9uX2JvZHkAQ29udGVudC1MZW5ndGggb3ZlcmZsb3cA Q2h1bmsgc2l6ZSBvdmVyZmxvdwBJbnZhbGlkIG1ldGhvZCBmb3IgSFRUUC94LnggcmVxdWVzdABJ bnZhbGlkIG1ldGhvZCBmb3IgUlRTUC94LnggcmVxdWVzdABFeHBlY3RlZCBTT1VSQ0UgbWV0aG9k IGZvciBJQ0UveC54IHJlcXVlc3QASW52YWxpZCBjaGFyIGluIHVybCBmcmFnbWVudCBzdGFydABF eHBlY3RlZCBkb3QAU3BhbiBjYWxsYmFjayBlcnJvciBpbiBvbl9zdGF0dXMASW52YWxpZCByZXNw b25zZSBzdGF0dXMARXhwZWN0ZWQgTEYgYWZ0ZXIgaGVhZGVycwBJbnZhbGlkIGNoYXJhY3RlciBp biBjaHVuayBleHRlbnNpb25zAFVzZXIgY2FsbGJhY2sgZXJyb3IAYG9uX3Jlc2V0YCBjYWxsYmFj ayBlcnJvcgBgb25fY2h1bmtfaGVhZGVyYCBjYWxsYmFjayBlcnJvcgBgb25fbWVzc2FnZV9iZWdp bmAgY2FsbGJhY2sgZXJyb3IAYG9uX2NodW5rX2V4dGVuc2lvbl92YWx1ZWAgY2FsbGJhY2sgZXJy b3IAYG9uX3N0YXR1c19jb21wbGV0ZWAgY2FsbGJhY2sgZXJyb3IAYG9uX3ZlcnNpb25fY29tcGxl dGVgIGNhbGxiYWNrIGVycm9yAGBvbl91cmxfY29tcGxldGVgIGNhbGxiYWNrIGVycm9yAGBvbl9j aHVua19jb21wbGV0ZWAgY2FsbGJhY2sgZXJyb3IAYG9uX2hlYWRlcl92YWx1ZV9jb21wbGV0ZWAg Y2FsbGJhY2sgZXJyb3IAYG9uX21lc3NhZ2VfY29tcGxldGVgIGNhbGxiYWNrIGVycm9yAGBvbl9t ZXRob2RfY29tcGxldGVgIGNhbGxiYWNrIGVycm9yAGBvbl9oZWFkZXJfZmllbGRfY29tcGxldGVg IGNhbGxiYWNrIGVycm9yAGBvbl9jaHVua19leHRlbnNpb25fbmFtZWAgY2FsbGJhY2sgZXJyb3IA VW5leHBlY3RlZCBjaGFyIGluIHVybCBzZXJ2ZXIASW52YWxpZCBoZWFkZXIgdmFsdWUgY2hhcgBJ bnZhbGlkIGhlYWRlciBmaWVsZCBjaGFyAFNwYW4gY2FsbGJhY2sgZXJyb3IgaW4gb25fdmVyc2lv bgBJbnZhbGlkIG1pbm9yIHZlcnNpb24ASW52YWxpZCBtYWpvciB2ZXJzaW9uAEV4cGVjdGVkIHNw YWNlIGFmdGVyIHZlcnNpb24ARXhwZWN0ZWQgQ1JMRiBhZnRlciB2ZXJzaW9uAEludmFsaWQgSFRU UCB2ZXJzaW9uAEludmFsaWQgaGVhZGVyIHRva2VuAFNwYW4gY2FsbGJhY2sgZXJyb3IgaW4gb25f dXJsAEludmFsaWQgY2hhcmFjdGVycyBpbiB1cmwAVW5leHBlY3RlZCBzdGFydCBjaGFyIGluIHVy bABEb3VibGUgQCBpbiB1cmwARW1wdHkgQ29udGVudC1MZW5ndGgASW52YWxpZCBjaGFyYWN0ZXIg aW4gQ29udGVudC1MZW5ndGgAVHJhbnNmZXItRW5jb2RpbmcgY2FuJ3QgYmUgcHJlc2VudCB3aXRo IENvbnRlbnQtTGVuZ3RoAER1cGxpY2F0ZSBDb250ZW50LUxlbmd0aABJbnZhbGlkIGNoYXIgaW4g dXJsIHBhdGgAQ29udGVudC1MZW5ndGggY2FuJ3QgYmUgcHJlc2VudCB3aXRoIFRyYW5zZmVyLUVu Y29kaW5nAE1pc3NpbmcgZXhwZWN0ZWQgQ1IgYWZ0ZXIgY2h1bmsgc2l6ZQBFeHBlY3RlZCBMRiBh ZnRlciBjaHVuayBzaXplAEludmFsaWQgY2hhcmFjdGVyIGluIGNodW5rIHNpemUAU3BhbiBjYWxs YmFjayBlcnJvciBpbiBvbl9oZWFkZXJfdmFsdWUAU3BhbiBjYWxsYmFjayBlcnJvciBpbiBvbl9j aHVua19leHRlbnNpb25fdmFsdWUASW52YWxpZCBjaGFyYWN0ZXIgaW4gY2h1bmsgZXh0ZW5zaW9u cyB2YWx1ZQBNaXNzaW5nIGV4cGVjdGVkIENSIGFmdGVyIGhlYWRlciB2YWx1ZQBNaXNzaW5nIGV4 cGVjdGVkIExGIGFmdGVyIGhlYWRlciB2YWx1ZQBJbnZhbGlkIGBUcmFuc2Zlci1FbmNvZGluZ2Ag aGVhZGVyIHZhbHVlAE1pc3NpbmcgZXhwZWN0ZWQgQ1IgYWZ0ZXIgY2h1bmsgZXh0ZW5zaW9uIHZh bHVlAEludmFsaWQgY2hhcmFjdGVyIGluIGNodW5rIGV4dGVuc2lvbnMgcXVvdGUgdmFsdWUASW52 YWxpZCBxdW90ZWQtcGFpciBpbiBjaHVuayBleHRlbnNpb25zIHF1b3RlZCB2YWx1ZQBJbnZhbGlk IGNoYXJhY3RlciBpbiBjaHVuayBleHRlbnNpb25zIHF1b3RlZCB2YWx1ZQBQYXVzZWQgYnkgb25f aGVhZGVyc19jb21wbGV0ZQBJbnZhbGlkIEVPRiBzdGF0ZQBvbl9yZXNldCBwYXVzZQBvbl9jaHVu a19oZWFkZXIgcGF1c2UAb25fbWVzc2FnZV9iZWdpbiBwYXVzZQBvbl9jaHVua19leHRlbnNpb25f dmFsdWUgcGF1c2UAb25fc3RhdHVzX2NvbXBsZXRlIHBhdXNlAG9uX3ZlcnNpb25fY29tcGxldGUg cGF1c2UAb25fdXJsX2NvbXBsZXRlIHBhdXNlAG9uX2NodW5rX2NvbXBsZXRlIHBhdXNlAG9uX2hl YWRlcl92YWx1ZV9jb21wbGV0ZSBwYXVzZQBvbl9tZXNzYWdlX2NvbXBsZXRlIHBhdXNlAG9uX21l dGhvZF9jb21wbGV0ZSBwYXVzZQBvbl9oZWFkZXJfZmllbGRfY29tcGxldGUgcGF1c2UAb25fY2h1 bmtfZXh0ZW5zaW9uX25hbWUgcGF1c2UAVW5leHBlY3RlZCBzcGFjZSBhZnRlciBzdGFydCBsaW5l AE1pc3NpbmcgZXhwZWN0ZWQgQ1IgYWZ0ZXIgcmVzcG9uc2UgbGluZQBTcGFuIGNhbGxiYWNrIGVy cm9yIGluIG9uX2NodW5rX2V4dGVuc2lvbl9uYW1lAEludmFsaWQgY2hhcmFjdGVyIGluIGNodW5r IGV4dGVuc2lvbnMgbmFtZQBNaXNzaW5nIGV4cGVjdGVkIENSIGFmdGVyIGNodW5rIGV4dGVuc2lv biBuYW1lAEludmFsaWQgc3RhdHVzIGNvZGUAUGF1c2Ugb24gQ09OTkVDVC9VcGdyYWRlAFBhdXNl IG9uIFBSSS9VcGdyYWRlAEV4cGVjdGVkIEhUVFAvMiBDb25uZWN0aW9uIFByZWZhY2UAU3BhbiBj YWxsYmFjayBlcnJvciBpbiBvbl9tZXRob2QARXhwZWN0ZWQgc3BhY2UgYWZ0ZXIgbWV0aG9kAFNw YW4gY2FsbGJhY2sgZXJyb3IgaW4gb25faGVhZGVyX2ZpZWxkAFBhdXNlZABJbnZhbGlkIHdvcmQg ZW5jb3VudGVyZWQASW52YWxpZCBtZXRob2QgZW5jb3VudGVyZWQATWlzc2luZyBleHBlY3RlZCBD UiBhZnRlciBjaHVuayBkYXRhAEV4cGVjdGVkIExGIGFmdGVyIGNodW5rIGRhdGEAVW5leHBlY3Rl ZCBjaGFyIGluIHVybCBzY2hlbWEAUmVxdWVzdCBoYXMgaW52YWxpZCBgVHJhbnNmZXItRW5jb2Rp bmdgAERhdGEgYWZ0ZXIgYENvbm5lY3Rpb246IGNsb3NlYABTV0lUQ0hfUFJPWFkAVVNFX1BST1hZ AE1LQUNUSVZJVFkAVU5QUk9DRVNTQUJMRV9FTlRJVFkAQ09QWQBNT1ZFRF9QRVJNQU5FTlRMWQBU T09fRUFSTFkATk9USUZZAEZBSUxFRF9ERVBFTkRFTkNZAEJBRF9HQVRFV0FZAFBMQVkAUFVUAENI RUNLT1VUAEdBVEVXQVlfVElNRU9VVABSRVFVRVNUX1RJTUVPVVQATkVUV09SS19DT05ORUNUX1RJ TUVPVVQAQ09OTkVDVElPTl9USU1FT1VUAExPR0lOX1RJTUVPVVQATkVUV09SS19SRUFEX1RJTUVP VVQAUE9TVABNSVNESVJFQ1RFRF9SRVFVRVNUAENMSUVOVF9DTE9TRURfUkVRVUVTVABDTElFTlRf Q0xPU0VEX0xPQURfQkFMQU5DRURfUkVRVUVTVABCQURfUkVRVUVTVABIVFRQX1JFUVVFU1RfU0VO VF9UT19IVFRQU19QT1JUAFJFUE9SVABJTV9BX1RFQVBPVABSRVNFVF9DT05URU5UAE5PX0NPTlRF TlQAUEFSVElBTF9DT05URU5UAEhQRV9JTlZBTElEX0NPTlNUQU5UAEhQRV9DQl9SRVNFVABHRVQA SFBFX1NUUklDVABDT05GTElDVABURU1QT1JBUllfUkVESVJFQ1QAUEVSTUFORU5UX1JFRElSRUNU AENPTk5FQ1QATVVMVElfU1RBVFVTAEhQRV9JTlZBTElEX1NUQVRVUwBUT09fTUFOWV9SRVFVRVNU UwBFQVJMWV9ISU5UUwBVTkFWQUlMQUJMRV9GT1JfTEVHQUxfUkVBU09OUwBPUFRJT05TAFNXSVRD SElOR19QUk9UT0NPTFMAVkFSSUFOVF9BTFNPX05FR09USUFURVMATVVMVElQTEVfQ0hPSUNFUwBJ TlRFUk5BTF9TRVJWRVJfRVJST1IAV0VCX1NFUlZFUl9VTktOT1dOX0VSUk9SAFJBSUxHVU5fRVJS T1IASURFTlRJVFlfUFJPVklERVJfQVVUSEVOVElDQVRJT05fRVJST1IAU1NMX0NFUlRJRklDQVRF X0VSUk9SAElOVkFMSURfWF9GT1JXQVJERURfRk9SAFNFVF9QQVJBTUVURVIAR0VUX1BBUkFNRVRF UgBIUEVfVVNFUgBTRUVfT1RIRVIASFBFX0NCX0NIVU5LX0hFQURFUgBFeHBlY3RlZCBMRiBhZnRl ciBDUgBNS0NBTEVOREFSAFNFVFVQAFdFQl9TRVJWRVJfSVNfRE9XTgBURUFSRE9XTgBIUEVfQ0xP U0VEX0NPTk5FQ1RJT04ASEVVUklTVElDX0VYUElSQVRJT04ARElTQ09OTkVDVEVEX09QRVJBVElP TgBOT05fQVVUSE9SSVRBVElWRV9JTkZPUk1BVElPTgBIUEVfSU5WQUxJRF9WRVJTSU9OAEhQRV9D Ql9NRVNTQUdFX0JFR0lOAFNJVEVfSVNfRlJPWkVOAEhQRV9JTlZBTElEX0hFQURFUl9UT0tFTgBJ TlZBTElEX1RPS0VOAEZPUkJJRERFTgBFTkhBTkNFX1lPVVJfQ0FMTQBIUEVfSU5WQUxJRF9VUkwA QkxPQ0tFRF9CWV9QQVJFTlRBTF9DT05UUk9MAE1LQ09MAEFDTABIUEVfSU5URVJOQUwAUkVRVUVT VF9IRUFERVJfRklFTERTX1RPT19MQVJHRV9VTk9GRklDSUFMAEhQRV9PSwBVTkxJTksAVU5MT0NL AFBSSQBSRVRSWV9XSVRIAEhQRV9JTlZBTElEX0NPTlRFTlRfTEVOR1RIAEhQRV9VTkVYUEVDVEVE X0NPTlRFTlRfTEVOR1RIAEZMVVNIAFBST1BQQVRDSABNLVNFQVJDSABVUklfVE9PX0xPTkcAUFJP Q0VTU0lORwBNSVNDRUxMQU5FT1VTX1BFUlNJU1RFTlRfV0FSTklORwBNSVNDRUxMQU5FT1VTX1dB Uk5JTkcASFBFX0lOVkFMSURfVFJBTlNGRVJfRU5DT0RJTkcARXhwZWN0ZWQgQ1JMRgBIUEVfSU5W QUxJRF9DSFVOS19TSVpFAE1PVkUAQ09OVElOVUUASFBFX0NCX1NUQVRVU19DT01QTEVURQBIUEVf Q0JfSEVBREVSU19DT01QTEVURQBIUEVfQ0JfVkVSU0lPTl9DT01QTEVURQBIUEVfQ0JfVVJMX0NP TVBMRVRFAEhQRV9DQl9DSFVOS19DT01QTEVURQBIUEVfQ0JfSEVBREVSX1ZBTFVFX0NPTVBMRVRF AEhQRV9DQl9DSFVOS19FWFRFTlNJT05fVkFMVUVfQ09NUExFVEUASFBFX0NCX0NIVU5LX0VYVEVO U0lPTl9OQU1FX0NPTVBMRVRFAEhQRV9DQl9NRVNTQUdFX0NPTVBMRVRFAEhQRV9DQl9NRVRIT0Rf Q09NUExFVEUASFBFX0NCX0hFQURFUl9GSUVMRF9DT01QTEVURQBERUxFVEUASFBFX0lOVkFMSURf RU9GX1NUQVRFAElOVkFMSURfU1NMX0NFUlRJRklDQVRFAFBBVVNFAE5PX1JFU1BPTlNFAFVOU1VQ UE9SVEVEX01FRElBX1RZUEUAR09ORQBOT1RfQUNDRVBUQUJMRQBTRVJWSUNFX1VOQVZBSUxBQkxF AFJBTkdFX05PVF9TQVRJU0ZJQUJMRQBPUklHSU5fSVNfVU5SRUFDSEFCTEUAUkVTUE9OU0VfSVNf U1RBTEUAUFVSR0UATUVSR0UAUkVRVUVTVF9IRUFERVJfRklFTERTX1RPT19MQVJHRQBSRVFVRVNU X0hFQURFUl9UT09fTEFSR0UAUEFZTE9BRF9UT09fTEFSR0UASU5TVUZGSUNJRU5UX1NUT1JBR0UA SFBFX1BBVVNFRF9VUEdSQURFAEhQRV9QQVVTRURfSDJfVVBHUkFERQBTT1VSQ0UAQU5OT1VOQ0UA VFJBQ0UASFBFX1VORVhQRUNURURfU1BBQ0UAREVTQ1JJQkUAVU5TVUJTQ1JJQkUAUkVDT1JEAEhQ RV9JTlZBTElEX01FVEhPRABOT1RfRk9VTkQAUFJPUEZJTkQAVU5CSU5EAFJFQklORABVTkFVVEhP UklaRUQATUVUSE9EX05PVF9BTExPV0VEAEhUVFBfVkVSU0lPTl9OT1RfU1VQUE9SVEVEAEFMUkVB RFlfUkVQT1JURUQAQUNDRVBURUQATk9UX0lNUExFTUVOVEVEAExPT1BfREVURUNURUQASFBFX0NS X0VYUEVDVEVEAEhQRV9MRl9FWFBFQ1RFRABDUkVBVEVEAElNX1VTRUQASFBFX1BBVVNFRABUSU1F T1VUX09DQ1VSRUQAUEFZTUVOVF9SRVFVSVJFRABQUkVDT05ESVRJT05fUkVRVUlSRUQAUFJPWFlf QVVUSEVOVElDQVRJT05fUkVRVUlSRUQATkVUV09SS19BVVRIRU5USUNBVElPTl9SRVFVSVJFRABM RU5HVEhfUkVRVUlSRUQAU1NMX0NFUlRJRklDQVRFX1JFUVVJUkVEAFVQR1JBREVfUkVRVUlSRUQA UEFHRV9FWFBJUkVEAFBSRUNPTkRJVElPTl9GQUlMRUQARVhQRUNUQVRJT05fRkFJTEVEAFJFVkFM SURBVElPTl9GQUlMRUQAU1NMX0hBTkRTSEFLRV9GQUlMRUQATE9DS0VEAFRSQU5TRk9STUFUSU9O X0FQUExJRUQATk9UX01PRElGSUVEAE5PVF9FWFRFTkRFRABCQU5EV0lEVEhfTElNSVRfRVhDRUVE RUQAU0lURV9JU19PVkVSTE9BREVEAEhFQUQARXhwZWN0ZWQgSFRUUC8AAAAATBUAABQVAAAJEgAA 3hkAAIsVAAADFAAAJxkAAN4UAADjEQAAYxQAAJsUAABwFQAAPRYAAFgSAACOFwAAERYAAHcUAAB5 FgAAOxcAAK0TAAC9FgAA/hkAALcYAADKGAAAmhMAAM4ZAACpFgAAYhYAAGoXAADTFgAA9hgAAPgR AABTFwAAkRYAABYXAADwFgAAhxcAAAUSAAB5GwAAKBEAAK0QAABDEgAApxIAAPAYAABiEAAAXBUA AAoVAABUFgAARBkAAK8VAAC7FQAAWhUAAFYZAABUGQAATRkAABAVAACnEQAAQhAAALEQAABRGAAA uRUAAIMQAAAWGQAAFBkAALMVAABLGAAA1hMAAFUVAABTFQAA4BgAAGEVAAALGQAA5xgAAOETAACo EAAAvBcAAPoTAACMEwAAfhMAADoSAAAgGQAAqRUAAAAAAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAA AAAAAAAAAAAAAAAAAAABAQIBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEB AQEBAQEBAQEBAQEBAQEBAQEDAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEB AQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEB AQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEB AQEBAQEBAQEBAQAAAAAAAAAAAAABAAACAAAAAAAAAAAAAAAAAAAAAAAAAAMEAwMDAwMAAAMDAAMD AAMDAwMDAwMDAwMABQAAAAAAAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMAAAADAwMDAwMDAwMD AwMDAwMDAwMDAwMDAwMDAwMDAwADAAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQAAAgAAAAAA AAAAAAAAAAAAAAAAAAADAAMDAwMDAAADAwADAwADAwMDAwMDAwMDAAQABQAAAAMDAwMDAwMDAwMD AwMDAwMDAwMDAwMDAwMDAAAAAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMAAwADAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAbG9zZWVlcC1hbGl2ZQAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEB AQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEAAQEBAQEBAQEBAQEBAQEBAQEB AQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEB AQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEAAAAA AAAAAAABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEBAQEBAQEBAQEBAQIBAQEBAQEBAQEBAQEBAQEB AQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEB AQEBAQEBAQEBAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEB AQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEB AQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBY2h1bmtlZAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAEAAQEBAQEAAAEBAAEBAAEBAQEBAQEBAQEAAAAAAAAAAQEBAQEBAQEB AQEBAQEBAQEBAQEBAQEBAQEAAAABAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQABAAEAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAABlY3Rpb25lbnQtbGVuZ3Rob25yb3h5LWNvbm5lY3Rpb24AAAAAAAAAAAAAAAAA AAByYW5zZmVyLWVuY29kaW5ncGdyYWRlDQoNClNNDQoNClRUUC9DRS9UU1AvAAAAAAAAAAAAAAAA AAABAgABAwAAAAAAAAAAAAAAAAAAAAAAAAQFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUF BQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUF BQUFBQUFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQIAAQMAAAAAAAAAAAAAAAAAAAAAAAAEBQUG BQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUF BQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAEAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAICAAICAgICAgICAgICAgICAgICAgICAgICAgICAgAC AgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIC AgICAgIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAgABAwAAAAAAAAAAAAAAAAAAAAAAAAQFAAAF BQUFBQUFBQUFBQYFBQUFBQUFBQUFBQUABQAHCAUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQAF AAUABQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUAAAAFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AQEAAQEAAAAAAAAAAAAAAAAAAAAAAAABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAAAAAAAD AwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwAAAAAAAAMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMD AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEBAAEBAAAAAAAAAAAAAAAAAAAAAAAAAQAAAAAA AAAAAAIAAAAAAgAAAAAAAAAAAAAAAAAAAAAAAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMAAAAA AAADAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABOT1VOQ0VFQ0tP VVRORUNURVRFQ1JJQkVMVVNIRVRFQURTRUFSQ0hSR0VDVElWSVRZTEVOREFSVkVPVElGWVBUSU9O U0NIU0VBWVNUQVRDSEdFT1JESVJFQ1RPUlRSQ0hQQVJBTUVURVJVUkNFQlNDUklCRUFSRE9XTkFD RUlORE5LQ0tVQlNDUklCRUhUVFAvQURUUC8=";
  }
});

// lib/client.js
var require_client = __commonJS({
  "lib/client.js"(exports2, module2) {
    "use strict";
    var assert = require("assert");
    var net = require("net");
    var http = require("http");
    var { pipeline } = require("stream");
    var util = require_util();
    var timers = require_timers();
    var Request = require_request2();
    var DispatcherBase = require_dispatcher_base();
    var {
      RequestContentLengthMismatchError,
      ResponseContentLengthMismatchError,
      InvalidArgumentError,
      RequestAbortedError,
      HeadersTimeoutError,
      HeadersOverflowError,
      SocketError,
      InformationalError,
      BodyTimeoutError,
      HTTPParserError,
      ResponseExceededMaxSizeError,
      ClientDestroyedError
    } = require_errors();
    var buildConnector = require_connect();
    var {
      kUrl,
      kReset,
      kServerName,
      kClient,
      kBusy,
      kParser,
      kConnect,
      kBlocking,
      kResuming,
      kRunning,
      kPending,
      kSize,
      kWriting,
      kQueue,
      kConnected,
      kConnecting,
      kNeedDrain,
      kNoRef,
      kKeepAliveDefaultTimeout,
      kHostHeader,
      kPendingIdx,
      kRunningIdx,
      kError,
      kPipelining,
      kSocket,
      kKeepAliveTimeoutValue,
      kMaxHeadersSize,
      kKeepAliveMaxTimeout,
      kKeepAliveTimeoutThreshold,
      kHeadersTimeout,
      kBodyTimeout,
      kStrictContentLength,
      kConnector,
      kMaxRedirections,
      kMaxRequests,
      kCounter,
      kClose,
      kDestroy,
      kDispatch,
      kInterceptors,
      kLocalAddress,
      kMaxResponseSize,
      kHTTPConnVersion,
      // HTTP2
      kHost,
      kHTTP2Session,
      kHTTP2SessionState,
      kHTTP2BuildRequest,
      kHTTP2CopyHeaders,
      kHTTP1BuildRequest
    } = require_symbols();
    var http2;
    try {
      http2 = require("http2");
    } catch {
      http2 = { constants: {} };
    }
    var {
      constants: {
        HTTP2_HEADER_AUTHORITY,
        HTTP2_HEADER_METHOD,
        HTTP2_HEADER_PATH,
        HTTP2_HEADER_SCHEME,
        HTTP2_HEADER_CONTENT_LENGTH,
        HTTP2_HEADER_EXPECT,
        HTTP2_HEADER_STATUS
      }
    } = http2;
    var h2ExperimentalWarned = false;
    var FastBuffer = Buffer[Symbol.species];
    var kClosedResolve = Symbol("kClosedResolve");
    var channels = {};
    try {
      const diagnosticsChannel = require("diagnostics_channel");
      channels.sendHeaders = diagnosticsChannel.channel("undici:client:sendHeaders");
      channels.beforeConnect = diagnosticsChannel.channel("undici:client:beforeConnect");
      channels.connectError = diagnosticsChannel.channel("undici:client:connectError");
      channels.connected = diagnosticsChannel.channel("undici:client:connected");
    } catch {
      channels.sendHeaders = { hasSubscribers: false };
      channels.beforeConnect = { hasSubscribers: false };
      channels.connectError = { hasSubscribers: false };
      channels.connected = { hasSubscribers: false };
    }
    var Client = class extends DispatcherBase {
      /**
       *
       * @param {string|URL} url
       * @param {import('../types/client').Client.Options} options
       */
      constructor(url, {
        interceptors,
        maxHeaderSize,
        headersTimeout,
        socketTimeout,
        requestTimeout,
        connectTimeout,
        bodyTimeout,
        idleTimeout,
        keepAlive,
        keepAliveTimeout,
        maxKeepAliveTimeout,
        keepAliveMaxTimeout,
        keepAliveTimeoutThreshold,
        socketPath,
        pipelining,
        tls,
        strictContentLength,
        maxCachedSessions,
        maxRedirections,
        connect: connect2,
        maxRequestsPerClient,
        localAddress,
        maxResponseSize,
        autoSelectFamily,
        autoSelectFamilyAttemptTimeout,
        // h2
        allowH2,
        maxConcurrentStreams
      } = {}) {
        super();
        if (keepAlive !== void 0) {
          throw new InvalidArgumentError("unsupported keepAlive, use pipelining=0 instead");
        }
        if (socketTimeout !== void 0) {
          throw new InvalidArgumentError("unsupported socketTimeout, use headersTimeout & bodyTimeout instead");
        }
        if (requestTimeout !== void 0) {
          throw new InvalidArgumentError("unsupported requestTimeout, use headersTimeout & bodyTimeout instead");
        }
        if (idleTimeout !== void 0) {
          throw new InvalidArgumentError("unsupported idleTimeout, use keepAliveTimeout instead");
        }
        if (maxKeepAliveTimeout !== void 0) {
          throw new InvalidArgumentError("unsupported maxKeepAliveTimeout, use keepAliveMaxTimeout instead");
        }
        if (maxHeaderSize != null && !Number.isFinite(maxHeaderSize)) {
          throw new InvalidArgumentError("invalid maxHeaderSize");
        }
        if (socketPath != null && typeof socketPath !== "string") {
          throw new InvalidArgumentError("invalid socketPath");
        }
        if (connectTimeout != null && (!Number.isFinite(connectTimeout) || connectTimeout < 0)) {
          throw new InvalidArgumentError("invalid connectTimeout");
        }
        if (keepAliveTimeout != null && (!Number.isFinite(keepAliveTimeout) || keepAliveTimeout <= 0)) {
          throw new InvalidArgumentError("invalid keepAliveTimeout");
        }
        if (keepAliveMaxTimeout != null && (!Number.isFinite(keepAliveMaxTimeout) || keepAliveMaxTimeout <= 0)) {
          throw new InvalidArgumentError("invalid keepAliveMaxTimeout");
        }
        if (keepAliveTimeoutThreshold != null && !Number.isFinite(keepAliveTimeoutThreshold)) {
          throw new InvalidArgumentError("invalid keepAliveTimeoutThreshold");
        }
        if (headersTimeout != null && (!Number.isInteger(headersTimeout) || headersTimeout < 0)) {
          throw new InvalidArgumentError("headersTimeout must be a positive integer or zero");
        }
        if (bodyTimeout != null && (!Number.isInteger(bodyTimeout) || bodyTimeout < 0)) {
          throw new InvalidArgumentError("bodyTimeout must be a positive integer or zero");
        }
        if (connect2 != null && typeof connect2 !== "function" && typeof connect2 !== "object") {
          throw new InvalidArgumentError("connect must be a function or an object");
        }
        if (maxRedirections != null && (!Number.isInteger(maxRedirections) || maxRedirections < 0)) {
          throw new InvalidArgumentError("maxRedirections must be a positive number");
        }
        if (maxRequestsPerClient != null && (!Number.isInteger(maxRequestsPerClient) || maxRequestsPerClient < 0)) {
          throw new InvalidArgumentError("maxRequestsPerClient must be a positive number");
        }
        if (localAddress != null && (typeof localAddress !== "string" || net.isIP(localAddress) === 0)) {
          throw new InvalidArgumentError("localAddress must be valid string IP address");
        }
        if (maxResponseSize != null && (!Number.isInteger(maxResponseSize) || maxResponseSize < -1)) {
          throw new InvalidArgumentError("maxResponseSize must be a positive number");
        }
        if (autoSelectFamilyAttemptTimeout != null && (!Number.isInteger(autoSelectFamilyAttemptTimeout) || autoSelectFamilyAttemptTimeout < -1)) {
          throw new InvalidArgumentError("autoSelectFamilyAttemptTimeout must be a positive number");
        }
        if (allowH2 != null && typeof allowH2 !== "boolean") {
          throw new InvalidArgumentError("allowH2 must be a valid boolean value");
        }
        if (maxConcurrentStreams != null && (typeof maxConcurrentStreams !== "number" || maxConcurrentStreams < 1)) {
          throw new InvalidArgumentError("maxConcurrentStreams must be a possitive integer, greater than 0");
        }
        if (typeof connect2 !== "function") {
          connect2 = buildConnector({
            ...tls,
            maxCachedSessions,
            allowH2,
            socketPath,
            timeout: connectTimeout,
            ...util.nodeHasAutoSelectFamily && autoSelectFamily ? { autoSelectFamily, autoSelectFamilyAttemptTimeout } : void 0,
            ...connect2
          });
        }
        this[kInterceptors] = interceptors && interceptors.Client && Array.isArray(interceptors.Client) ? interceptors.Client : [createRedirectInterceptor({ maxRedirections })];
        this[kUrl] = util.parseOrigin(url);
        this[kConnector] = connect2;
        this[kSocket] = null;
        this[kPipelining] = pipelining != null ? pipelining : 1;
        this[kMaxHeadersSize] = maxHeaderSize || http.maxHeaderSize;
        this[kKeepAliveDefaultTimeout] = keepAliveTimeout == null ? 4e3 : keepAliveTimeout;
        this[kKeepAliveMaxTimeout] = keepAliveMaxTimeout == null ? 6e5 : keepAliveMaxTimeout;
        this[kKeepAliveTimeoutThreshold] = keepAliveTimeoutThreshold == null ? 1e3 : keepAliveTimeoutThreshold;
        this[kKeepAliveTimeoutValue] = this[kKeepAliveDefaultTimeout];
        this[kServerName] = null;
        this[kLocalAddress] = localAddress != null ? localAddress : null;
        this[kResuming] = 0;
        this[kNeedDrain] = 0;
        this[kHostHeader] = `host: ${this[kUrl].hostname}${this[kUrl].port ? `:${this[kUrl].port}` : ""}\r
`;
        this[kBodyTimeout] = bodyTimeout != null ? bodyTimeout : 3e5;
        this[kHeadersTimeout] = headersTimeout != null ? headersTimeout : 3e5;
        this[kStrictContentLength] = strictContentLength == null ? true : strictContentLength;
        this[kMaxRedirections] = maxRedirections;
        this[kMaxRequests] = maxRequestsPerClient;
        this[kClosedResolve] = null;
        this[kMaxResponseSize] = maxResponseSize > -1 ? maxResponseSize : -1;
        this[kHTTPConnVersion] = "h1";
        this[kHTTP2Session] = null;
        this[kHTTP2SessionState] = !allowH2 ? null : {
          // streams: null, // Fixed queue of streams - For future support of `push`
          openStreams: 0,
          // Keep track of them to decide wether or not unref the session
          maxConcurrentStreams: maxConcurrentStreams != null ? maxConcurrentStreams : 100
          // Max peerConcurrentStreams for a Node h2 server
        };
        this[kHost] = `${this[kUrl].hostname}${this[kUrl].port ? `:${this[kUrl].port}` : ""}`;
        this[kQueue] = [];
        this[kRunningIdx] = 0;
        this[kPendingIdx] = 0;
      }
      get pipelining() {
        return this[kPipelining];
      }
      set pipelining(value) {
        this[kPipelining] = value;
        resume(this, true);
      }
      get [kPending]() {
        return this[kQueue].length - this[kPendingIdx];
      }
      get [kRunning]() {
        return this[kPendingIdx] - this[kRunningIdx];
      }
      get [kSize]() {
        return this[kQueue].length - this[kRunningIdx];
      }
      get [kConnected]() {
        return !!this[kSocket] && !this[kConnecting] && !this[kSocket].destroyed;
      }
      get [kBusy]() {
        const socket = this[kSocket];
        return socket && (socket[kReset] || socket[kWriting] || socket[kBlocking]) || this[kSize] >= (this[kPipelining] || 1) || this[kPending] > 0;
      }
      /* istanbul ignore: only used for test */
      [kConnect](cb) {
        connect(this);
        this.once("connect", cb);
      }
      [kDispatch](opts, handler) {
        const origin = opts.origin || this[kUrl].origin;
        const request = this[kHTTPConnVersion] === "h2" ? Request[kHTTP2BuildRequest](origin, opts, handler) : Request[kHTTP1BuildRequest](origin, opts, handler);
        this[kQueue].push(request);
        if (this[kResuming]) {
        } else if (util.bodyLength(request.body) == null && util.isIterable(request.body)) {
          this[kResuming] = 1;
          process.nextTick(resume, this);
        } else {
          resume(this, true);
        }
        if (this[kResuming] && this[kNeedDrain] !== 2 && this[kBusy]) {
          this[kNeedDrain] = 2;
        }
        return this[kNeedDrain] < 2;
      }
      async [kClose]() {
        return new Promise((resolve) => {
          if (!this[kSize]) {
            resolve(null);
          } else {
            this[kClosedResolve] = resolve;
          }
        });
      }
      async [kDestroy](err) {
        return new Promise((resolve) => {
          const requests = this[kQueue].splice(this[kPendingIdx]);
          for (let i = 0; i < requests.length; i++) {
            const request = requests[i];
            errorRequest(this, request, err);
          }
          const callback = () => {
            if (this[kClosedResolve]) {
              this[kClosedResolve]();
              this[kClosedResolve] = null;
            }
            resolve();
          };
          if (this[kHTTP2Session] != null) {
            util.destroy(this[kHTTP2Session], err);
            this[kHTTP2Session] = null;
            this[kHTTP2SessionState] = null;
          }
          if (!this[kSocket]) {
            queueMicrotask(callback);
          } else {
            util.destroy(this[kSocket].on("close", callback), err);
          }
          resume(this);
        });
      }
    };
    function onHttp2SessionError(err) {
      assert(err.code !== "ERR_TLS_CERT_ALTNAME_INVALID");
      this[kSocket][kError] = err;
      onError(this[kClient], err);
    }
    function onHttp2FrameError(type, code, id) {
      const err = new InformationalError(`HTTP/2: "frameError" received - type ${type}, code ${code}`);
      if (id === 0) {
        this[kSocket][kError] = err;
        onError(this[kClient], err);
      }
    }
    function onHttp2SessionEnd() {
      util.destroy(this, new SocketError("other side closed"));
      util.destroy(this[kSocket], new SocketError("other side closed"));
    }
    function onHTTP2GoAway(code) {
      const client = this[kClient];
      const err = new InformationalError(`HTTP/2: "GOAWAY" frame received with code ${code}`);
      client[kSocket] = null;
      client[kHTTP2Session] = null;
      if (client.destroyed) {
        assert(this[kPending] === 0);
        const requests = client[kQueue].splice(client[kRunningIdx]);
        for (let i = 0; i < requests.length; i++) {
          const request = requests[i];
          errorRequest(this, request, err);
        }
      } else if (client[kRunning] > 0) {
        const request = client[kQueue][client[kRunningIdx]];
        client[kQueue][client[kRunningIdx]++] = null;
        errorRequest(client, request, err);
      }
      client[kPendingIdx] = client[kRunningIdx];
      assert(client[kRunning] === 0);
      client.emit(
        "disconnect",
        client[kUrl],
        [client],
        err
      );
      resume(client);
    }
    var constants = require_constants2();
    var createRedirectInterceptor = require_redirectInterceptor();
    var EMPTY_BUF = Buffer.alloc(0);
    async function lazyllhttp() {
      const llhttpWasmData = process.env.JEST_WORKER_ID ? require_llhttp_wasm() : void 0;
      const mod = await WebAssembly.compile(Buffer.from(llhttpWasmData || require_llhttp_wasm(), "base64"));
      return await WebAssembly.instantiate(mod, {
        env: {
          /* eslint-disable camelcase */
          wasm_on_url: (p, at, len) => {
            return 0;
          },
          wasm_on_status: (p, at, len) => {
            assert.strictEqual(currentParser.ptr, p);
            const start = at - currentBufferPtr + currentBufferRef.byteOffset;
            return currentParser.onStatus(new FastBuffer(currentBufferRef.buffer, start, len)) || 0;
          },
          wasm_on_message_begin: (p) => {
            assert.strictEqual(currentParser.ptr, p);
            return currentParser.onMessageBegin() || 0;
          },
          wasm_on_header_field: (p, at, len) => {
            assert.strictEqual(currentParser.ptr, p);
            const start = at - currentBufferPtr + currentBufferRef.byteOffset;
            return currentParser.onHeaderField(new FastBuffer(currentBufferRef.buffer, start, len)) || 0;
          },
          wasm_on_header_value: (p, at, len) => {
            assert.strictEqual(currentParser.ptr, p);
            const start = at - currentBufferPtr + currentBufferRef.byteOffset;
            return currentParser.onHeaderValue(new FastBuffer(currentBufferRef.buffer, start, len)) || 0;
          },
          wasm_on_headers_complete: (p, statusCode, upgrade, shouldKeepAlive) => {
            assert.strictEqual(currentParser.ptr, p);
            return currentParser.onHeadersComplete(statusCode, Boolean(upgrade), Boolean(shouldKeepAlive)) || 0;
          },
          wasm_on_body: (p, at, len) => {
            assert.strictEqual(currentParser.ptr, p);
            const start = at - currentBufferPtr + currentBufferRef.byteOffset;
            return currentParser.onBody(new FastBuffer(currentBufferRef.buffer, start, len)) || 0;
          },
          wasm_on_message_complete: (p) => {
            assert.strictEqual(currentParser.ptr, p);
            return currentParser.onMessageComplete() || 0;
          }
          /* eslint-enable camelcase */
        }
      });
    }
    var llhttpInstance = null;
    var llhttpPromise = lazyllhttp();
    llhttpPromise.catch();
    var currentParser = null;
    var currentBufferRef = null;
    var currentBufferSize = 0;
    var currentBufferPtr = null;
    var TIMEOUT_HEADERS = 1;
    var TIMEOUT_BODY = 2;
    var TIMEOUT_IDLE = 3;
    var Parser = class {
      constructor(client, socket, { exports: exports3 }) {
        assert(Number.isFinite(client[kMaxHeadersSize]) && client[kMaxHeadersSize] > 0);
        this.llhttp = exports3;
        this.ptr = this.llhttp.llhttp_alloc(constants.TYPE.RESPONSE);
        this.client = client;
        this.socket = socket;
        this.timeout = null;
        this.timeoutValue = null;
        this.timeoutType = null;
        this.statusCode = null;
        this.statusText = "";
        this.upgrade = false;
        this.headers = [];
        this.headersSize = 0;
        this.headersMaxSize = client[kMaxHeadersSize];
        this.shouldKeepAlive = false;
        this.paused = false;
        this.resume = this.resume.bind(this);
        this.bytesRead = 0;
        this.keepAlive = "";
        this.contentLength = "";
        this.connection = "";
        this.maxResponseSize = client[kMaxResponseSize];
      }
      setTimeout(value, type) {
        this.timeoutType = type;
        if (value !== this.timeoutValue) {
          timers.clearTimeout(this.timeout);
          if (value) {
            this.timeout = timers.setTimeout(onParserTimeout, value, this);
            if (this.timeout.unref) {
              this.timeout.unref();
            }
          } else {
            this.timeout = null;
          }
          this.timeoutValue = value;
        } else if (this.timeout) {
          if (this.timeout.refresh) {
            this.timeout.refresh();
          }
        }
      }
      resume() {
        if (this.socket.destroyed || !this.paused) {
          return;
        }
        assert(this.ptr != null);
        assert(currentParser == null);
        this.llhttp.llhttp_resume(this.ptr);
        assert(this.timeoutType === TIMEOUT_BODY);
        if (this.timeout) {
          if (this.timeout.refresh) {
            this.timeout.refresh();
          }
        }
        this.paused = false;
        this.execute(this.socket.read() || EMPTY_BUF);
        this.readMore();
      }
      readMore() {
        while (!this.paused && this.ptr) {
          const chunk = this.socket.read();
          if (chunk === null) {
            break;
          }
          this.execute(chunk);
        }
      }
      execute(data) {
        assert(this.ptr != null);
        assert(currentParser == null);
        assert(!this.paused);
        const { socket, llhttp } = this;
        if (data.length > currentBufferSize) {
          if (currentBufferPtr) {
            llhttp.free(currentBufferPtr);
          }
          currentBufferSize = Math.ceil(data.length / 4096) * 4096;
          currentBufferPtr = llhttp.malloc(currentBufferSize);
        }
        new Uint8Array(llhttp.memory.buffer, currentBufferPtr, currentBufferSize).set(data);
        try {
          let ret;
          try {
            currentBufferRef = data;
            currentParser = this;
            ret = llhttp.llhttp_execute(this.ptr, currentBufferPtr, data.length);
          } catch (err) {
            throw err;
          } finally {
            currentParser = null;
            currentBufferRef = null;
          }
          const offset = llhttp.llhttp_get_error_pos(this.ptr) - currentBufferPtr;
          if (ret === constants.ERROR.PAUSED_UPGRADE) {
            this.onUpgrade(data.slice(offset));
          } else if (ret === constants.ERROR.PAUSED) {
            this.paused = true;
            socket.unshift(data.slice(offset));
          } else if (ret !== constants.ERROR.OK) {
            const ptr = llhttp.llhttp_get_error_reason(this.ptr);
            let message = "";
            if (ptr) {
              const len = new Uint8Array(llhttp.memory.buffer, ptr).indexOf(0);
              message = "Response does not match the HTTP/1.1 protocol (" + Buffer.from(llhttp.memory.buffer, ptr, len).toString() + ")";
            }
            throw new HTTPParserError(message, constants.ERROR[ret], data.slice(offset));
          }
        } catch (err) {
          util.destroy(socket, err);
        }
      }
      destroy() {
        assert(this.ptr != null);
        assert(currentParser == null);
        this.llhttp.llhttp_free(this.ptr);
        this.ptr = null;
        timers.clearTimeout(this.timeout);
        this.timeout = null;
        this.timeoutValue = null;
        this.timeoutType = null;
        this.paused = false;
      }
      onStatus(buf) {
        this.statusText = buf.toString();
      }
      onMessageBegin() {
        const { socket, client } = this;
        if (socket.destroyed) {
          return -1;
        }
        const request = client[kQueue][client[kRunningIdx]];
        if (!request) {
          return -1;
        }
      }
      onHeaderField(buf) {
        const len = this.headers.length;
        if ((len & 1) === 0) {
          this.headers.push(buf);
        } else {
          this.headers[len - 1] = Buffer.concat([this.headers[len - 1], buf]);
        }
        this.trackHeader(buf.length);
      }
      onHeaderValue(buf) {
        let len = this.headers.length;
        if ((len & 1) === 1) {
          this.headers.push(buf);
          len += 1;
        } else {
          this.headers[len - 1] = Buffer.concat([this.headers[len - 1], buf]);
        }
        const key = this.headers[len - 2];
        if (key.length === 10 && key.toString().toLowerCase() === "keep-alive") {
          this.keepAlive += buf.toString();
        } else if (key.length === 10 && key.toString().toLowerCase() === "connection") {
          this.connection += buf.toString();
        } else if (key.length === 14 && key.toString().toLowerCase() === "content-length") {
          this.contentLength += buf.toString();
        }
        this.trackHeader(buf.length);
      }
      trackHeader(len) {
        this.headersSize += len;
        if (this.headersSize >= this.headersMaxSize) {
          util.destroy(this.socket, new HeadersOverflowError());
        }
      }
      onUpgrade(head) {
        const { upgrade, client, socket, headers, statusCode } = this;
        assert(upgrade);
        const request = client[kQueue][client[kRunningIdx]];
        assert(request);
        assert(!socket.destroyed);
        assert(socket === client[kSocket]);
        assert(!this.paused);
        assert(request.upgrade || request.method === "CONNECT");
        this.statusCode = null;
        this.statusText = "";
        this.shouldKeepAlive = null;
        assert(this.headers.length % 2 === 0);
        this.headers = [];
        this.headersSize = 0;
        socket.unshift(head);
        socket[kParser].destroy();
        socket[kParser] = null;
        socket[kClient] = null;
        socket[kError] = null;
        socket.removeListener("error", onSocketError).removeListener("readable", onSocketReadable).removeListener("end", onSocketEnd).removeListener("close", onSocketClose);
        client[kSocket] = null;
        client[kQueue][client[kRunningIdx]++] = null;
        client.emit("disconnect", client[kUrl], [client], new InformationalError("upgrade"));
        try {
          request.onUpgrade(statusCode, headers, socket);
        } catch (err) {
          util.destroy(socket, err);
        }
        resume(client);
      }
      onHeadersComplete(statusCode, upgrade, shouldKeepAlive) {
        const { client, socket, headers, statusText } = this;
        if (socket.destroyed) {
          return -1;
        }
        const request = client[kQueue][client[kRunningIdx]];
        if (!request) {
          return -1;
        }
        assert(!this.upgrade);
        assert(this.statusCode < 200);
        if (statusCode === 100) {
          util.destroy(socket, new SocketError("bad response", util.getSocketInfo(socket)));
          return -1;
        }
        if (upgrade && !request.upgrade) {
          util.destroy(socket, new SocketError("bad upgrade", util.getSocketInfo(socket)));
          return -1;
        }
        assert.strictEqual(this.timeoutType, TIMEOUT_HEADERS);
        this.statusCode = statusCode;
        this.shouldKeepAlive = shouldKeepAlive || // Override llhttp value which does not allow keepAlive for HEAD.
        request.method === "HEAD" && !socket[kReset] && this.connection.toLowerCase() === "keep-alive";
        if (this.statusCode >= 200) {
          const bodyTimeout = request.bodyTimeout != null ? request.bodyTimeout : client[kBodyTimeout];
          this.setTimeout(bodyTimeout, TIMEOUT_BODY);
        } else if (this.timeout) {
          if (this.timeout.refresh) {
            this.timeout.refresh();
          }
        }
        if (request.method === "CONNECT") {
          assert(client[kRunning] === 1);
          this.upgrade = true;
          return 2;
        }
        if (upgrade) {
          assert(client[kRunning] === 1);
          this.upgrade = true;
          return 2;
        }
        assert(this.headers.length % 2 === 0);
        this.headers = [];
        this.headersSize = 0;
        if (this.shouldKeepAlive && client[kPipelining]) {
          const keepAliveTimeout = this.keepAlive ? util.parseKeepAliveTimeout(this.keepAlive) : null;
          if (keepAliveTimeout != null) {
            const timeout = Math.min(
              keepAliveTimeout - client[kKeepAliveTimeoutThreshold],
              client[kKeepAliveMaxTimeout]
            );
            if (timeout <= 0) {
              socket[kReset] = true;
            } else {
              client[kKeepAliveTimeoutValue] = timeout;
            }
          } else {
            client[kKeepAliveTimeoutValue] = client[kKeepAliveDefaultTimeout];
          }
        } else {
          socket[kReset] = true;
        }
        let pause;
        try {
          pause = request.onHeaders(statusCode, headers, this.resume, statusText) === false;
        } catch (err) {
          util.destroy(socket, err);
          return -1;
        }
        if (request.method === "HEAD") {
          return 1;
        }
        if (statusCode < 200) {
          return 1;
        }
        if (socket[kBlocking]) {
          socket[kBlocking] = false;
          resume(client);
        }
        return pause ? constants.ERROR.PAUSED : 0;
      }
      onBody(buf) {
        const { client, socket, statusCode, maxResponseSize } = this;
        if (socket.destroyed) {
          return -1;
        }
        const request = client[kQueue][client[kRunningIdx]];
        assert(request);
        assert.strictEqual(this.timeoutType, TIMEOUT_BODY);
        if (this.timeout) {
          if (this.timeout.refresh) {
            this.timeout.refresh();
          }
        }
        assert(statusCode >= 200);
        if (maxResponseSize > -1 && this.bytesRead + buf.length > maxResponseSize) {
          util.destroy(socket, new ResponseExceededMaxSizeError());
          return -1;
        }
        this.bytesRead += buf.length;
        try {
          if (request.onData(buf) === false) {
            return constants.ERROR.PAUSED;
          }
        } catch (err) {
          util.destroy(socket, err);
          return -1;
        }
      }
      onMessageComplete() {
        const { client, socket, statusCode, upgrade, headers, contentLength, bytesRead, shouldKeepAlive } = this;
        if (socket.destroyed && (!statusCode || shouldKeepAlive)) {
          return -1;
        }
        if (upgrade) {
          return;
        }
        const request = client[kQueue][client[kRunningIdx]];
        assert(request);
        assert(statusCode >= 100);
        this.statusCode = null;
        this.statusText = "";
        this.bytesRead = 0;
        this.contentLength = "";
        this.keepAlive = "";
        this.connection = "";
        assert(this.headers.length % 2 === 0);
        this.headers = [];
        this.headersSize = 0;
        if (statusCode < 200) {
          return;
        }
        if (request.method !== "HEAD" && contentLength && bytesRead !== parseInt(contentLength, 10)) {
          util.destroy(socket, new ResponseContentLengthMismatchError());
          return -1;
        }
        try {
          request.onComplete(headers);
        } catch (err) {
          errorRequest(client, request, err);
        }
        client[kQueue][client[kRunningIdx]++] = null;
        if (socket[kWriting]) {
          assert.strictEqual(client[kRunning], 0);
          util.destroy(socket, new InformationalError("reset"));
          return constants.ERROR.PAUSED;
        } else if (!shouldKeepAlive) {
          util.destroy(socket, new InformationalError("reset"));
          return constants.ERROR.PAUSED;
        } else if (socket[kReset] && client[kRunning] === 0) {
          util.destroy(socket, new InformationalError("reset"));
          return constants.ERROR.PAUSED;
        } else if (client[kPipelining] === 1) {
          setImmediate(resume, client);
        } else {
          resume(client);
        }
      }
    };
    function onParserTimeout(parser) {
      const { socket, timeoutType, client } = parser;
      if (timeoutType === TIMEOUT_HEADERS) {
        if (!socket[kWriting] || socket.writableNeedDrain || client[kRunning] > 1) {
          assert(!parser.paused, "cannot be paused while waiting for headers");
          util.destroy(socket, new HeadersTimeoutError());
        }
      } else if (timeoutType === TIMEOUT_BODY) {
        if (!parser.paused) {
          util.destroy(socket, new BodyTimeoutError());
        }
      } else if (timeoutType === TIMEOUT_IDLE) {
        assert(client[kRunning] === 0 && client[kKeepAliveTimeoutValue]);
        util.destroy(socket, new InformationalError("socket idle timeout"));
      }
    }
    function onSocketReadable() {
      const { [kParser]: parser } = this;
      parser.readMore();
    }
    function onSocketError(err) {
      const { [kClient]: client, [kParser]: parser } = this;
      assert(err.code !== "ERR_TLS_CERT_ALTNAME_INVALID");
      if (client[kHTTPConnVersion] !== "h2") {
        if (err.code === "ECONNRESET" && parser.statusCode && !parser.shouldKeepAlive) {
          parser.onMessageComplete();
          return;
        }
      }
      this[kError] = err;
      onError(this[kClient], err);
    }
    function onError(client, err) {
      if (client[kRunning] === 0 && err.code !== "UND_ERR_INFO" && err.code !== "UND_ERR_SOCKET") {
        assert(client[kPendingIdx] === client[kRunningIdx]);
        const requests = client[kQueue].splice(client[kRunningIdx]);
        for (let i = 0; i < requests.length; i++) {
          const request = requests[i];
          errorRequest(client, request, err);
        }
        assert(client[kSize] === 0);
      }
    }
    function onSocketEnd() {
      const { [kParser]: parser, [kClient]: client } = this;
      if (client[kHTTPConnVersion] !== "h2") {
        if (parser.statusCode && !parser.shouldKeepAlive) {
          parser.onMessageComplete();
          return;
        }
      }
      util.destroy(this, new SocketError("other side closed", util.getSocketInfo(this)));
    }
    function onSocketClose() {
      const { [kClient]: client, [kParser]: parser } = this;
      if (client[kHTTPConnVersion] === "h1" && parser) {
        if (!this[kError] && parser.statusCode && !parser.shouldKeepAlive) {
          parser.onMessageComplete();
        }
        this[kParser].destroy();
        this[kParser] = null;
      }
      const err = this[kError] || new SocketError("closed", util.getSocketInfo(this));
      client[kSocket] = null;
      if (client.destroyed) {
        assert(client[kPending] === 0);
        const requests = client[kQueue].splice(client[kRunningIdx]);
        for (let i = 0; i < requests.length; i++) {
          const request = requests[i];
          errorRequest(client, request, err);
        }
      } else if (client[kRunning] > 0 && err.code !== "UND_ERR_INFO") {
        const request = client[kQueue][client[kRunningIdx]];
        client[kQueue][client[kRunningIdx]++] = null;
        errorRequest(client, request, err);
      }
      client[kPendingIdx] = client[kRunningIdx];
      assert(client[kRunning] === 0);
      client.emit("disconnect", client[kUrl], [client], err);
      resume(client);
    }
    async function connect(client) {
      assert(!client[kConnecting]);
      assert(!client[kSocket]);
      let { host, hostname, protocol, port } = client[kUrl];
      if (hostname[0] === "[") {
        const idx = hostname.indexOf("]");
        assert(idx !== -1);
        const ip = hostname.substr(1, idx - 1);
        assert(net.isIP(ip));
        hostname = ip;
      }
      client[kConnecting] = true;
      if (channels.beforeConnect.hasSubscribers) {
        channels.beforeConnect.publish({
          connectParams: {
            host,
            hostname,
            protocol,
            port,
            servername: client[kServerName],
            localAddress: client[kLocalAddress]
          },
          connector: client[kConnector]
        });
      }
      try {
        const socket = await new Promise((resolve, reject) => {
          client[kConnector]({
            host,
            hostname,
            protocol,
            port,
            servername: client[kServerName],
            localAddress: client[kLocalAddress]
          }, (err, socket2) => {
            if (err) {
              reject(err);
            } else {
              resolve(socket2);
            }
          });
        });
        if (client.destroyed) {
          util.destroy(socket.on("error", () => {
          }), new ClientDestroyedError());
          return;
        }
        client[kConnecting] = false;
        assert(socket);
        const isH2 = socket.alpnProtocol === "h2";
        if (isH2) {
          if (!h2ExperimentalWarned) {
            h2ExperimentalWarned = true;
            process.emitWarning("H2 support is experimental, expect them to change at any time.", {
              code: "UNDICI-H2"
            });
          }
          const session = http2.connect(client[kUrl], {
            createConnection: () => socket,
            peerMaxConcurrentStreams: client[kHTTP2SessionState].maxConcurrentStreams
          });
          client[kHTTPConnVersion] = "h2";
          session[kClient] = client;
          session[kSocket] = socket;
          session.on("error", onHttp2SessionError);
          session.on("frameError", onHttp2FrameError);
          session.on("end", onHttp2SessionEnd);
          session.on("goaway", onHTTP2GoAway);
          session.on("close", onSocketClose);
          session.unref();
          client[kHTTP2Session] = session;
          socket[kHTTP2Session] = session;
        } else {
          if (!llhttpInstance) {
            llhttpInstance = await llhttpPromise;
            llhttpPromise = null;
          }
          socket[kNoRef] = false;
          socket[kWriting] = false;
          socket[kReset] = false;
          socket[kBlocking] = false;
          socket[kParser] = new Parser(client, socket, llhttpInstance);
        }
        socket[kCounter] = 0;
        socket[kMaxRequests] = client[kMaxRequests];
        socket[kClient] = client;
        socket[kError] = null;
        socket.on("error", onSocketError).on("readable", onSocketReadable).on("end", onSocketEnd).on("close", onSocketClose);
        client[kSocket] = socket;
        if (channels.connected.hasSubscribers) {
          channels.connected.publish({
            connectParams: {
              host,
              hostname,
              protocol,
              port,
              servername: client[kServerName],
              localAddress: client[kLocalAddress]
            },
            connector: client[kConnector],
            socket
          });
        }
        client.emit("connect", client[kUrl], [client]);
      } catch (err) {
        if (client.destroyed) {
          return;
        }
        client[kConnecting] = false;
        if (channels.connectError.hasSubscribers) {
          channels.connectError.publish({
            connectParams: {
              host,
              hostname,
              protocol,
              port,
              servername: client[kServerName],
              localAddress: client[kLocalAddress]
            },
            connector: client[kConnector],
            error: err
          });
        }
        if (err.code === "ERR_TLS_CERT_ALTNAME_INVALID") {
          assert(client[kRunning] === 0);
          while (client[kPending] > 0 && client[kQueue][client[kPendingIdx]].servername === client[kServerName]) {
            const request = client[kQueue][client[kPendingIdx]++];
            errorRequest(client, request, err);
          }
        } else {
          onError(client, err);
        }
        client.emit("connectionError", client[kUrl], [client], err);
      }
      resume(client);
    }
    function emitDrain(client) {
      client[kNeedDrain] = 0;
      client.emit("drain", client[kUrl], [client]);
    }
    function resume(client, sync) {
      if (client[kResuming] === 2) {
        return;
      }
      client[kResuming] = 2;
      _resume(client, sync);
      client[kResuming] = 0;
      if (client[kRunningIdx] > 256) {
        client[kQueue].splice(0, client[kRunningIdx]);
        client[kPendingIdx] -= client[kRunningIdx];
        client[kRunningIdx] = 0;
      }
    }
    function _resume(client, sync) {
      while (true) {
        if (client.destroyed) {
          assert(client[kPending] === 0);
          return;
        }
        if (client[kClosedResolve] && !client[kSize]) {
          client[kClosedResolve]();
          client[kClosedResolve] = null;
          return;
        }
        const socket = client[kSocket];
        if (socket && !socket.destroyed && socket.alpnProtocol !== "h2") {
          if (client[kSize] === 0) {
            if (!socket[kNoRef] && socket.unref) {
              socket.unref();
              socket[kNoRef] = true;
            }
          } else if (socket[kNoRef] && socket.ref) {
            socket.ref();
            socket[kNoRef] = false;
          }
          if (client[kSize] === 0) {
            if (socket[kParser].timeoutType !== TIMEOUT_IDLE) {
              socket[kParser].setTimeout(client[kKeepAliveTimeoutValue], TIMEOUT_IDLE);
            }
          } else if (client[kRunning] > 0 && socket[kParser].statusCode < 200) {
            if (socket[kParser].timeoutType !== TIMEOUT_HEADERS) {
              const request2 = client[kQueue][client[kRunningIdx]];
              const headersTimeout = request2.headersTimeout != null ? request2.headersTimeout : client[kHeadersTimeout];
              socket[kParser].setTimeout(headersTimeout, TIMEOUT_HEADERS);
            }
          }
        }
        if (client[kBusy]) {
          client[kNeedDrain] = 2;
        } else if (client[kNeedDrain] === 2) {
          if (sync) {
            client[kNeedDrain] = 1;
            process.nextTick(emitDrain, client);
          } else {
            emitDrain(client);
          }
          continue;
        }
        if (client[kPending] === 0) {
          return;
        }
        if (client[kRunning] >= (client[kPipelining] || 1)) {
          return;
        }
        const request = client[kQueue][client[kPendingIdx]];
        if (client[kUrl].protocol === "https:" && client[kServerName] !== request.servername) {
          if (client[kRunning] > 0) {
            return;
          }
          client[kServerName] = request.servername;
          if (socket && socket.servername !== request.servername) {
            util.destroy(socket, new InformationalError("servername changed"));
            return;
          }
        }
        if (client[kConnecting]) {
          return;
        }
        if (!socket && !client[kHTTP2Session]) {
          connect(client);
          return;
        }
        if (socket.destroyed || socket[kWriting] || socket[kReset] || socket[kBlocking]) {
          return;
        }
        if (client[kRunning] > 0 && !request.idempotent) {
          return;
        }
        if (client[kRunning] > 0 && (request.upgrade || request.method === "CONNECT")) {
          return;
        }
        if (util.isStream(request.body) && util.bodyLength(request.body) === 0) {
          request.body.on(
            "data",
            /* istanbul ignore next */
            function() {
              assert(false);
            }
          ).on("error", function(err) {
            errorRequest(client, request, err);
          }).on("end", function() {
            util.destroy(this);
          });
          request.body = null;
        }
        if (client[kRunning] > 0 && (util.isStream(request.body) || util.isAsyncIterable(request.body))) {
          return;
        }
        if (!request.aborted && write(client, request)) {
          client[kPendingIdx]++;
        } else {
          client[kQueue].splice(client[kPendingIdx], 1);
        }
      }
    }
    function write(client, request) {
      if (client[kHTTPConnVersion] === "h2") {
        writeH2(client, client[kHTTP2Session], request);
        return;
      }
      const { body, method, path, host, upgrade, headers, blocking, reset } = request;
      const expectsPayload = method === "PUT" || method === "POST" || method === "PATCH";
      if (body && typeof body.read === "function") {
        body.read(0);
      }
      let contentLength = util.bodyLength(body);
      if (contentLength === null) {
        contentLength = request.contentLength;
      }
      if (contentLength === 0 && !expectsPayload) {
        contentLength = null;
      }
      if (request.contentLength !== null && request.contentLength !== contentLength) {
        if (client[kStrictContentLength]) {
          errorRequest(client, request, new RequestContentLengthMismatchError());
          return false;
        }
        process.emitWarning(new RequestContentLengthMismatchError());
      }
      const socket = client[kSocket];
      try {
        request.onConnect((err) => {
          if (request.aborted || request.completed) {
            return;
          }
          errorRequest(client, request, err || new RequestAbortedError());
          util.destroy(socket, new InformationalError("aborted"));
        });
      } catch (err) {
        errorRequest(client, request, err);
      }
      if (request.aborted) {
        return false;
      }
      if (method === "HEAD") {
        socket[kReset] = true;
      }
      if (upgrade || method === "CONNECT") {
        socket[kReset] = true;
      }
      if (reset != null) {
        socket[kReset] = reset;
      }
      if (client[kMaxRequests] && socket[kCounter]++ >= client[kMaxRequests]) {
        socket[kReset] = true;
      }
      if (blocking) {
        socket[kBlocking] = true;
      }
      let header = `${method} ${path} HTTP/1.1\r
`;
      if (typeof host === "string") {
        header += `host: ${host}\r
`;
      } else {
        header += client[kHostHeader];
      }
      if (upgrade) {
        header += `connection: upgrade\r
upgrade: ${upgrade}\r
`;
      } else if (client[kPipelining] && !socket[kReset]) {
        header += "connection: keep-alive\r\n";
      } else {
        header += "connection: close\r\n";
      }
      if (headers) {
        header += headers;
      }
      if (channels.sendHeaders.hasSubscribers) {
        channels.sendHeaders.publish({ request, headers: header, socket });
      }
      if (!body) {
        if (contentLength === 0) {
          socket.write(`${header}content-length: 0\r
\r
`, "latin1");
        } else {
          assert(contentLength === null, "no body must not have content length");
          socket.write(`${header}\r
`, "latin1");
        }
        request.onRequestSent();
      } else if (util.isBuffer(body)) {
        assert(contentLength === body.byteLength, "buffer body must have content length");
        socket.cork();
        socket.write(`${header}content-length: ${contentLength}\r
\r
`, "latin1");
        socket.write(body);
        socket.uncork();
        request.onBodySent(body);
        request.onRequestSent();
        if (!expectsPayload) {
          socket[kReset] = true;
        }
      } else if (util.isBlobLike(body)) {
        if (typeof body.stream === "function") {
          writeIterable({ body: body.stream(), client, request, socket, contentLength, header, expectsPayload });
        } else {
          writeBlob({ body, client, request, socket, contentLength, header, expectsPayload });
        }
      } else if (util.isStream(body)) {
        writeStream({ body, client, request, socket, contentLength, header, expectsPayload });
      } else if (util.isIterable(body)) {
        writeIterable({ body, client, request, socket, contentLength, header, expectsPayload });
      } else {
        assert(false);
      }
      return true;
    }
    function writeH2(client, session, request) {
      const { body, method, path, host, upgrade, expectContinue, signal, headers: reqHeaders } = request;
      let headers;
      if (typeof reqHeaders === "string")
        headers = Request[kHTTP2CopyHeaders](reqHeaders.trim());
      else
        headers = reqHeaders;
      if (upgrade) {
        errorRequest(client, request, new Error("Upgrade not supported for H2"));
        return false;
      }
      try {
        request.onConnect((err) => {
          if (request.aborted || request.completed) {
            return;
          }
          errorRequest(client, request, err || new RequestAbortedError());
        });
      } catch (err) {
        errorRequest(client, request, err);
      }
      if (request.aborted) {
        return false;
      }
      let stream;
      const h2State = client[kHTTP2SessionState];
      headers[HTTP2_HEADER_AUTHORITY] = host || client[kHost];
      headers[HTTP2_HEADER_METHOD] = method;
      if (method === "CONNECT") {
        session.ref();
        stream = session.request(headers, { endStream: false, signal });
        if (stream.id && !stream.pending) {
          request.onUpgrade(null, null, stream);
          ++h2State.openStreams;
        } else {
          stream.once("ready", () => {
            request.onUpgrade(null, null, stream);
            ++h2State.openStreams;
          });
        }
        stream.once("close", () => {
          h2State.openStreams -= 1;
          if (h2State.openStreams === 0)
            session.unref();
        });
        return true;
      }
      headers[HTTP2_HEADER_PATH] = path;
      headers[HTTP2_HEADER_SCHEME] = "https";
      const expectsPayload = method === "PUT" || method === "POST" || method === "PATCH";
      if (body && typeof body.read === "function") {
        body.read(0);
      }
      let contentLength = util.bodyLength(body);
      if (contentLength == null) {
        contentLength = request.contentLength;
      }
      if (contentLength === 0 || !expectsPayload) {
        contentLength = null;
      }
      if (request.contentLength != null && request.contentLength !== contentLength) {
        if (client[kStrictContentLength]) {
          errorRequest(client, request, new RequestContentLengthMismatchError());
          return false;
        }
        process.emitWarning(new RequestContentLengthMismatchError());
      }
      if (contentLength != null) {
        assert(body, "no body must not have content length");
        headers[HTTP2_HEADER_CONTENT_LENGTH] = `${contentLength}`;
      }
      session.ref();
      const shouldEndStream = method === "GET" || method === "HEAD";
      if (expectContinue) {
        headers[HTTP2_HEADER_EXPECT] = "100-continue";
        stream = session.request(headers, { endStream: shouldEndStream, signal });
        stream.once("continue", writeBodyH2);
      } else {
        stream = session.request(headers, {
          endStream: shouldEndStream,
          signal
        });
        writeBodyH2();
      }
      ++h2State.openStreams;
      stream.once("response", (headers2) => {
        if (request.onHeaders(Number(headers2[HTTP2_HEADER_STATUS]), headers2, stream.resume.bind(stream), "") === false) {
          stream.pause();
        }
      });
      stream.once("end", () => {
        request.onComplete([]);
      });
      stream.on("data", (chunk) => {
        if (request.onData(chunk) === false)
          stream.pause();
      });
      stream.once("close", () => {
        h2State.openStreams -= 1;
        if (h2State.openStreams === 0)
          session.unref();
      });
      stream.once("error", function(err) {
        if (client[kHTTP2Session] && !client[kHTTP2Session].destroyed && !this.closed && !this.destroyed) {
          h2State.streams -= 1;
          util.destroy(stream, err);
        }
      });
      stream.once("frameError", (type, code) => {
        const err = new InformationalError(`HTTP/2: "frameError" received - type ${type}, code ${code}`);
        errorRequest(client, request, err);
        if (client[kHTTP2Session] && !client[kHTTP2Session].destroyed && !this.closed && !this.destroyed) {
          h2State.streams -= 1;
          util.destroy(stream, err);
        }
      });
      return true;
      function writeBodyH2() {
        if (!body) {
          request.onRequestSent();
        } else if (util.isBuffer(body)) {
          assert(contentLength === body.byteLength, "buffer body must have content length");
          stream.cork();
          stream.write(body);
          stream.uncork();
          stream.end();
          request.onBodySent(body);
          request.onRequestSent();
        } else if (util.isBlobLike(body)) {
          if (typeof body.stream === "function") {
            writeIterable({
              client,
              request,
              contentLength,
              h2stream: stream,
              expectsPayload,
              body: body.stream(),
              socket: client[kSocket],
              header: ""
            });
          } else {
            writeBlob({
              body,
              client,
              request,
              contentLength,
              expectsPayload,
              h2stream: stream,
              header: "",
              socket: client[kSocket]
            });
          }
        } else if (util.isStream(body)) {
          writeStream({
            body,
            client,
            request,
            contentLength,
            expectsPayload,
            socket: client[kSocket],
            h2stream: stream,
            header: ""
          });
        } else if (util.isIterable(body)) {
          writeIterable({
            body,
            client,
            request,
            contentLength,
            expectsPayload,
            header: "",
            h2stream: stream,
            socket: client[kSocket]
          });
        } else {
          assert(false);
        }
      }
    }
    function writeStream({ h2stream, body, client, request, socket, contentLength, header, expectsPayload }) {
      assert(contentLength !== 0 || client[kRunning] === 0, "stream body cannot be pipelined");
      if (client[kHTTPConnVersion] === "h2") {
        let onPipeData = function(chunk) {
          request.onBodySent(chunk);
        };
        const pipe = pipeline(
          body,
          h2stream,
          (err) => {
            if (err) {
              util.destroy(body, err);
              util.destroy(h2stream, err);
            } else {
              request.onRequestSent();
            }
          }
        );
        pipe.on("data", onPipeData);
        pipe.once("end", () => {
          pipe.removeListener("data", onPipeData);
          util.destroy(pipe);
        });
        return;
      }
      let finished = false;
      const writer = new AsyncWriter({ socket, request, contentLength, client, expectsPayload, header });
      const onData = function(chunk) {
        if (finished) {
          return;
        }
        try {
          if (!writer.write(chunk) && this.pause) {
            this.pause();
          }
        } catch (err) {
          util.destroy(this, err);
        }
      };
      const onDrain = function() {
        if (finished) {
          return;
        }
        if (body.resume) {
          body.resume();
        }
      };
      const onAbort = function() {
        onFinished(new RequestAbortedError());
      };
      const onFinished = function(err) {
        if (finished) {
          return;
        }
        finished = true;
        assert(socket.destroyed || socket[kWriting] && client[kRunning] <= 1);
        socket.off("drain", onDrain).off("error", onFinished);
        body.removeListener("data", onData).removeListener("end", onFinished).removeListener("error", onFinished).removeListener("close", onAbort);
        if (!err) {
          try {
            writer.end();
          } catch (er) {
            err = er;
          }
        }
        writer.destroy(err);
        if (err && (err.code !== "UND_ERR_INFO" || err.message !== "reset")) {
          util.destroy(body, err);
        } else {
          util.destroy(body);
        }
      };
      body.on("data", onData).on("end", onFinished).on("error", onFinished).on("close", onAbort);
      if (body.resume) {
        body.resume();
      }
      socket.on("drain", onDrain).on("error", onFinished);
    }
    async function writeBlob({ h2stream, body, client, request, socket, contentLength, header, expectsPayload }) {
      assert(contentLength === body.size, "blob body must have content length");
      const isH2 = client[kHTTPConnVersion] === "h2";
      try {
        if (contentLength != null && contentLength !== body.size) {
          throw new RequestContentLengthMismatchError();
        }
        const buffer = Buffer.from(await body.arrayBuffer());
        if (isH2) {
          h2stream.cork();
          h2stream.write(buffer);
          h2stream.uncork();
        } else {
          socket.cork();
          socket.write(`${header}content-length: ${contentLength}\r
\r
`, "latin1");
          socket.write(buffer);
          socket.uncork();
        }
        request.onBodySent(buffer);
        request.onRequestSent();
        if (!expectsPayload) {
          socket[kReset] = true;
        }
        resume(client);
      } catch (err) {
        util.destroy(isH2 ? h2stream : socket, err);
      }
    }
    async function writeIterable({ h2stream, body, client, request, socket, contentLength, header, expectsPayload }) {
      assert(contentLength !== 0 || client[kRunning] === 0, "iterator body cannot be pipelined");
      let callback = null;
      function onDrain() {
        if (callback) {
          const cb = callback;
          callback = null;
          cb();
        }
      }
      const waitForDrain = () => new Promise((resolve, reject) => {
        assert(callback === null);
        if (socket[kError]) {
          reject(socket[kError]);
        } else {
          callback = resolve;
        }
      });
      if (client[kHTTPConnVersion] === "h2") {
        h2stream.on("close", onDrain).on("drain", onDrain);
        try {
          for await (const chunk of body) {
            if (socket[kError]) {
              throw socket[kError];
            }
            const res = h2stream.write(chunk);
            request.onBodySent(chunk);
            if (!res) {
              await waitForDrain();
            }
          }
        } catch (err) {
          h2stream.destroy(err);
        } finally {
          request.onRequestSent();
          h2stream.end();
          h2stream.off("close", onDrain).off("drain", onDrain);
        }
        return;
      }
      socket.on("close", onDrain).on("drain", onDrain);
      const writer = new AsyncWriter({ socket, request, contentLength, client, expectsPayload, header });
      try {
        for await (const chunk of body) {
          if (socket[kError]) {
            throw socket[kError];
          }
          if (!writer.write(chunk)) {
            await waitForDrain();
          }
        }
        writer.end();
      } catch (err) {
        writer.destroy(err);
      } finally {
        socket.off("close", onDrain).off("drain", onDrain);
      }
    }
    var AsyncWriter = class {
      constructor({ socket, request, contentLength, client, expectsPayload, header }) {
        this.socket = socket;
        this.request = request;
        this.contentLength = contentLength;
        this.client = client;
        this.bytesWritten = 0;
        this.expectsPayload = expectsPayload;
        this.header = header;
        socket[kWriting] = true;
      }
      write(chunk) {
        const { socket, request, contentLength, client, bytesWritten, expectsPayload, header } = this;
        if (socket[kError]) {
          throw socket[kError];
        }
        if (socket.destroyed) {
          return false;
        }
        const len = Buffer.byteLength(chunk);
        if (!len) {
          return true;
        }
        if (contentLength !== null && bytesWritten + len > contentLength) {
          if (client[kStrictContentLength]) {
            throw new RequestContentLengthMismatchError();
          }
          process.emitWarning(new RequestContentLengthMismatchError());
        }
        socket.cork();
        if (bytesWritten === 0) {
          if (!expectsPayload) {
            socket[kReset] = true;
          }
          if (contentLength === null) {
            socket.write(`${header}transfer-encoding: chunked\r
`, "latin1");
          } else {
            socket.write(`${header}content-length: ${contentLength}\r
\r
`, "latin1");
          }
        }
        if (contentLength === null) {
          socket.write(`\r
${len.toString(16)}\r
`, "latin1");
        }
        this.bytesWritten += len;
        const ret = socket.write(chunk);
        socket.uncork();
        request.onBodySent(chunk);
        if (!ret) {
          if (socket[kParser].timeout && socket[kParser].timeoutType === TIMEOUT_HEADERS) {
            if (socket[kParser].timeout.refresh) {
              socket[kParser].timeout.refresh();
            }
          }
        }
        return ret;
      }
      end() {
        const { socket, contentLength, client, bytesWritten, expectsPayload, header, request } = this;
        request.onRequestSent();
        socket[kWriting] = false;
        if (socket[kError]) {
          throw socket[kError];
        }
        if (socket.destroyed) {
          return;
        }
        if (bytesWritten === 0) {
          if (expectsPayload) {
            socket.write(`${header}content-length: 0\r
\r
`, "latin1");
          } else {
            socket.write(`${header}\r
`, "latin1");
          }
        } else if (contentLength === null) {
          socket.write("\r\n0\r\n\r\n", "latin1");
        }
        if (contentLength !== null && bytesWritten !== contentLength) {
          if (client[kStrictContentLength]) {
            throw new RequestContentLengthMismatchError();
          } else {
            process.emitWarning(new RequestContentLengthMismatchError());
          }
        }
        if (socket[kParser].timeout && socket[kParser].timeoutType === TIMEOUT_HEADERS) {
          if (socket[kParser].timeout.refresh) {
            socket[kParser].timeout.refresh();
          }
        }
        resume(client);
      }
      destroy(err) {
        const { socket, client } = this;
        socket[kWriting] = false;
        if (err) {
          assert(client[kRunning] <= 1, "pipeline should only contain this request");
          util.destroy(socket, err);
        }
      }
    };
    function errorRequest(client, request, err) {
      try {
        request.onError(err);
        assert(request.aborted);
      } catch (err2) {
        client.emit("error", err2);
      }
    }
    module2.exports = Client;
  }
});

// lib/pool.js
var require_pool = __commonJS({
  "lib/pool.js"(exports2, module2) {
    "use strict";
    var {
      PoolBase,
      kClients,
      kNeedDrain,
      kAddClient,
      kGetDispatcher
    } = require_pool_base();
    var Client = require_client();
    var {
      InvalidArgumentError
    } = require_errors();
    var util = require_util();
    var { kUrl, kInterceptors } = require_symbols();
    var buildConnector = require_connect();
    var kOptions = Symbol("options");
    var kConnections = Symbol("connections");
    var kFactory = Symbol("factory");
    function defaultFactory(origin, opts) {
      return new Client(origin, opts);
    }
    var Pool = class extends PoolBase {
      constructor(origin, {
        connections,
        factory = defaultFactory,
        connect,
        connectTimeout,
        tls,
        maxCachedSessions,
        socketPath,
        autoSelectFamily,
        autoSelectFamilyAttemptTimeout,
        allowH2,
        ...options
      } = {}) {
        super();
        if (connections != null && (!Number.isFinite(connections) || connections < 0)) {
          throw new InvalidArgumentError("invalid connections");
        }
        if (typeof factory !== "function") {
          throw new InvalidArgumentError("factory must be a function.");
        }
        if (connect != null && typeof connect !== "function" && typeof connect !== "object") {
          throw new InvalidArgumentError("connect must be a function or an object");
        }
        if (typeof connect !== "function") {
          connect = buildConnector({
            ...tls,
            maxCachedSessions,
            allowH2,
            socketPath,
            timeout: connectTimeout == null ? 1e4 : connectTimeout,
            ...util.nodeHasAutoSelectFamily && autoSelectFamily ? { autoSelectFamily, autoSelectFamilyAttemptTimeout } : void 0,
            ...connect
          });
        }
        this[kInterceptors] = options.interceptors && options.interceptors.Pool && Array.isArray(options.interceptors.Pool) ? options.interceptors.Pool : [];
        this[kConnections] = connections || null;
        this[kUrl] = util.parseOrigin(origin);
        this[kOptions] = { ...util.deepClone(options), connect, allowH2 };
        this[kOptions].interceptors = options.interceptors ? { ...options.interceptors } : void 0;
        this[kFactory] = factory;
      }
      [kGetDispatcher]() {
        let dispatcher = this[kClients].find((dispatcher2) => !dispatcher2[kNeedDrain]);
        if (dispatcher) {
          return dispatcher;
        }
        if (!this[kConnections] || this[kClients].length < this[kConnections]) {
          dispatcher = this[kFactory](this[kUrl], this[kOptions]);
          this[kAddClient](dispatcher);
        }
        return dispatcher;
      }
    };
    module2.exports = Pool;
  }
});

// lib/agent.js
var require_agent = __commonJS({
  "lib/agent.js"(exports2, module2) {
    "use strict";
    var { InvalidArgumentError } = require_errors();
    var { kClients, kRunning, kClose, kDestroy, kDispatch, kInterceptors } = require_symbols();
    var DispatcherBase = require_dispatcher_base();
    var Pool = require_pool();
    var Client = require_client();
    var util = require_util();
    var createRedirectInterceptor = require_redirectInterceptor();
    var { WeakRef: WeakRef2, FinalizationRegistry } = require_dispatcher_weakref()();
    var kOnConnect = Symbol("onConnect");
    var kOnDisconnect = Symbol("onDisconnect");
    var kOnConnectionError = Symbol("onConnectionError");
    var kMaxRedirections = Symbol("maxRedirections");
    var kOnDrain = Symbol("onDrain");
    var kFactory = Symbol("factory");
    var kFinalizer = Symbol("finalizer");
    var kOptions = Symbol("options");
    function defaultFactory(origin, opts) {
      return opts && opts.connections === 1 ? new Client(origin, opts) : new Pool(origin, opts);
    }
    var Agent = class extends DispatcherBase {
      constructor({ factory = defaultFactory, maxRedirections = 0, connect, ...options } = {}) {
        super();
        if (typeof factory !== "function") {
          throw new InvalidArgumentError("factory must be a function.");
        }
        if (connect != null && typeof connect !== "function" && typeof connect !== "object") {
          throw new InvalidArgumentError("connect must be a function or an object");
        }
        if (!Number.isInteger(maxRedirections) || maxRedirections < 0) {
          throw new InvalidArgumentError("maxRedirections must be a positive number");
        }
        if (connect && typeof connect !== "function") {
          connect = { ...connect };
        }
        this[kInterceptors] = options.interceptors && options.interceptors.Agent && Array.isArray(options.interceptors.Agent) ? options.interceptors.Agent : [createRedirectInterceptor({ maxRedirections })];
        this[kOptions] = { ...util.deepClone(options), connect };
        this[kOptions].interceptors = options.interceptors ? { ...options.interceptors } : void 0;
        this[kMaxRedirections] = maxRedirections;
        this[kFactory] = factory;
        this[kClients] = /* @__PURE__ */ new Map();
        this[kFinalizer] = new FinalizationRegistry(
          /* istanbul ignore next: gc is undeterministic */
          (key) => {
            const ref = this[kClients].get(key);
            if (ref !== void 0 && ref.deref() === void 0) {
              this[kClients].delete(key);
            }
          }
        );
        const agent = this;
        this[kOnDrain] = (origin, targets) => {
          agent.emit("drain", origin, [agent, ...targets]);
        };
        this[kOnConnect] = (origin, targets) => {
          agent.emit("connect", origin, [agent, ...targets]);
        };
        this[kOnDisconnect] = (origin, targets, err) => {
          agent.emit("disconnect", origin, [agent, ...targets], err);
        };
        this[kOnConnectionError] = (origin, targets, err) => {
          agent.emit("connectionError", origin, [agent, ...targets], err);
        };
      }
      get [kRunning]() {
        let ret = 0;
        for (const ref of this[kClients].values()) {
          const client = ref.deref();
          if (client) {
            ret += client[kRunning];
          }
        }
        return ret;
      }
      [kDispatch](opts, handler) {
        let key;
        if (opts.origin && (typeof opts.origin === "string" || opts.origin instanceof URL)) {
          key = String(opts.origin);
        } else {
          throw new InvalidArgumentError("opts.origin must be a non-empty string or URL.");
        }
        const ref = this[kClients].get(key);
        let dispatcher = ref ? ref.deref() : null;
        if (!dispatcher) {
          dispatcher = this[kFactory](opts.origin, this[kOptions]).on("drain", this[kOnDrain]).on("connect", this[kOnConnect]).on("disconnect", this[kOnDisconnect]).on("connectionError", this[kOnConnectionError]);
          this[kClients].set(key, new WeakRef2(dispatcher));
          this[kFinalizer].register(dispatcher, key);
        }
        return dispatcher.dispatch(opts, handler);
      }
      async [kClose]() {
        const closePromises = [];
        for (const ref of this[kClients].values()) {
          const client = ref.deref();
          if (client) {
            closePromises.push(client.close());
          }
        }
        await Promise.all(closePromises);
      }
      async [kDestroy](err) {
        const destroyPromises = [];
        for (const ref of this[kClients].values()) {
          const client = ref.deref();
          if (client) {
            destroyPromises.push(client.destroy(err));
          }
        }
        await Promise.all(destroyPromises);
      }
    };
    module2.exports = Agent;
  }
});

// lib/global.js
var require_global2 = __commonJS({
  "lib/global.js"(exports2, module2) {
    "use strict";
    var globalDispatcher = Symbol.for("undici.globalDispatcher.1");
    var { InvalidArgumentError } = require_errors();
    var Agent = require_agent();
    if (getGlobalDispatcher() === void 0) {
      setGlobalDispatcher(new Agent());
    }
    function setGlobalDispatcher(agent) {
      if (!agent || typeof agent.dispatch !== "function") {
        throw new InvalidArgumentError("Argument agent must implement Agent");
      }
      Object.defineProperty(globalThis, globalDispatcher, {
        value: agent,
        writable: true,
        enumerable: false,
        configurable: false
      });
    }
    function getGlobalDispatcher() {
      return globalThis[globalDispatcher];
    }
    module2.exports = {
      setGlobalDispatcher,
      getGlobalDispatcher
    };
  }
});

// lib/fetch/index.js
var require_fetch = __commonJS({
  "lib/fetch/index.js"(exports2, module2) {
    "use strict";
    var {
      Response,
      makeNetworkError,
      makeAppropriateNetworkError,
      filterResponse,
      makeResponse
    } = require_response();
    var { Headers } = require_headers();
    var { Request, makeRequest } = require_request();
    var zlib = require("zlib");
    var {
      bytesMatch,
      makePolicyContainer,
      clonePolicyContainer,
      requestBadPort,
      TAOCheck,
      appendRequestOriginHeader,
      responseLocationURL,
      requestCurrentURL,
      setRequestReferrerPolicyOnRedirect,
      tryUpgradeRequestToAPotentiallyTrustworthyURL,
      createOpaqueTimingInfo,
      appendFetchMetadata,
      corsCheck,
      crossOriginResourcePolicyCheck,
      determineRequestsReferrer,
      coarsenedSharedCurrentTime,
      createDeferredPromise,
      isBlobLike,
      sameOrigin,
      isCancelled,
      isAborted,
      isErrorLike,
      fullyReadBody,
      readableStreamClose,
      isomorphicEncode,
      urlIsLocal,
      urlIsHttpHttpsScheme,
      urlHasHttpsScheme
    } = require_util2();
    var { kState, kHeaders, kGuard, kRealm } = require_symbols2();
    var assert = require("assert");
    var { safelyExtractBody } = require_body();
    var {
      redirectStatus,
      nullBodyStatus,
      safeMethods,
      requestBodyHeader,
      subresource,
      DOMException
    } = require_constants();
    var { kHeadersList } = require_symbols();
    var EE = require("events");
    var { Readable, pipeline } = require("stream");
    var { addAbortListener, isErrored, isReadable, nodeMajor, nodeMinor } = require_util();
    var { dataURLProcessor, serializeAMimeType } = require_dataURL();
    var { TransformStream } = require("stream/web");
    var { getGlobalDispatcher } = require_global2();
    var { webidl } = require_webidl();
    var { STATUS_CODES } = require("http");
    var resolveObjectURL;
    var ReadableStream = globalThis.ReadableStream;
    var Fetch = class extends EE {
      constructor(dispatcher) {
        super();
        this.dispatcher = dispatcher;
        this.connection = null;
        this.dump = false;
        this.state = "ongoing";
        this.setMaxListeners(21);
      }
      terminate(reason) {
        if (this.state !== "ongoing") {
          return;
        }
        this.state = "terminated";
        this.connection?.destroy(reason);
        this.emit("terminated", reason);
      }
      // https://fetch.spec.whatwg.org/#fetch-controller-abort
      abort(error) {
        if (this.state !== "ongoing") {
          return;
        }
        this.state = "aborted";
        if (!error) {
          error = new DOMException("The operation was aborted.", "AbortError");
        }
        this.serializedAbortReason = error;
        this.connection?.destroy(error);
        this.emit("terminated", error);
      }
    };
    async function fetch2(input, init = {}) {
      webidl.argumentLengthCheck(arguments, 1, { header: "globalThis.fetch" });
      const p = createDeferredPromise();
      let requestObject;
      try {
        requestObject = new Request(input, init);
      } catch (e) {
        p.reject(e);
        return p.promise;
      }
      const request = requestObject[kState];
      if (requestObject.signal.aborted) {
        abortFetch(p, request, null, requestObject.signal.reason);
        return p.promise;
      }
      const globalObject = request.client.globalObject;
      if (globalObject?.constructor?.name === "ServiceWorkerGlobalScope") {
        request.serviceWorkers = "none";
      }
      let responseObject = null;
      const relevantRealm = null;
      let locallyAborted = false;
      let controller = null;
      addAbortListener(
        requestObject.signal,
        () => {
          locallyAborted = true;
          assert(controller != null);
          controller.abort(requestObject.signal.reason);
          abortFetch(p, request, responseObject, requestObject.signal.reason);
        }
      );
      const handleFetchDone = (response) => finalizeAndReportTiming(response, "fetch");
      const processResponse = (response) => {
        if (locallyAborted) {
          return;
        }
        if (response.aborted) {
          abortFetch(p, request, responseObject, controller.serializedAbortReason);
          return;
        }
        if (response.type === "error") {
          p.reject(
            Object.assign(new TypeError("fetch failed"), { cause: response.error })
          );
          return;
        }
        responseObject = new Response();
        responseObject[kState] = response;
        responseObject[kRealm] = relevantRealm;
        responseObject[kHeaders][kHeadersList] = response.headersList;
        responseObject[kHeaders][kGuard] = "immutable";
        responseObject[kHeaders][kRealm] = relevantRealm;
        p.resolve(responseObject);
      };
      controller = fetching({
        request,
        processResponseEndOfBody: handleFetchDone,
        processResponse,
        dispatcher: init.dispatcher ?? getGlobalDispatcher()
        // undici
      });
      return p.promise;
    }
    function finalizeAndReportTiming(response, initiatorType = "other") {
      if (response.type === "error" && response.aborted) {
        return;
      }
      if (!response.urlList?.length) {
        return;
      }
      const originalURL = response.urlList[0];
      let timingInfo = response.timingInfo;
      let cacheState = response.cacheState;
      if (!urlIsHttpHttpsScheme(originalURL)) {
        return;
      }
      if (timingInfo === null) {
        return;
      }
      if (!timingInfo.timingAllowPassed) {
        timingInfo = createOpaqueTimingInfo({
          startTime: timingInfo.startTime
        });
        cacheState = "";
      }
      timingInfo.endTime = coarsenedSharedCurrentTime();
      response.timingInfo = timingInfo;
      markResourceTiming(
        timingInfo,
        originalURL,
        initiatorType,
        globalThis,
        cacheState
      );
    }
    function markResourceTiming(timingInfo, originalURL, initiatorType, globalThis2, cacheState) {
      if (nodeMajor > 18 || nodeMajor === 18 && nodeMinor >= 2) {
        performance.markResourceTiming(timingInfo, originalURL.href, initiatorType, globalThis2, cacheState);
      }
    }
    function abortFetch(p, request, responseObject, error) {
      if (!error) {
        error = new DOMException("The operation was aborted.", "AbortError");
      }
      p.reject(error);
      if (request.body != null && isReadable(request.body?.stream)) {
        request.body.stream.cancel(error).catch((err) => {
          if (err.code === "ERR_INVALID_STATE") {
            return;
          }
          throw err;
        });
      }
      if (responseObject == null) {
        return;
      }
      const response = responseObject[kState];
      if (response.body != null && isReadable(response.body?.stream)) {
        response.body.stream.cancel(error).catch((err) => {
          if (err.code === "ERR_INVALID_STATE") {
            return;
          }
          throw err;
        });
      }
    }
    function fetching({
      request,
      processRequestBodyChunkLength,
      processRequestEndOfBody,
      processResponse,
      processResponseEndOfBody,
      processResponseConsumeBody,
      useParallelQueue = false,
      dispatcher
      // undici
    }) {
      let taskDestination = null;
      let crossOriginIsolatedCapability = false;
      if (request.client != null) {
        taskDestination = request.client.globalObject;
        crossOriginIsolatedCapability = request.client.crossOriginIsolatedCapability;
      }
      const currenTime = coarsenedSharedCurrentTime(crossOriginIsolatedCapability);
      const timingInfo = createOpaqueTimingInfo({
        startTime: currenTime
      });
      const fetchParams = {
        controller: new Fetch(dispatcher),
        request,
        timingInfo,
        processRequestBodyChunkLength,
        processRequestEndOfBody,
        processResponse,
        processResponseConsumeBody,
        processResponseEndOfBody,
        taskDestination,
        crossOriginIsolatedCapability
      };
      assert(!request.body || request.body.stream);
      if (request.window === "client") {
        request.window = request.client?.globalObject?.constructor?.name === "Window" ? request.client : "no-window";
      }
      if (request.origin === "client") {
        request.origin = request.client?.origin;
      }
      if (request.policyContainer === "client") {
        if (request.client != null) {
          request.policyContainer = clonePolicyContainer(
            request.client.policyContainer
          );
        } else {
          request.policyContainer = makePolicyContainer();
        }
      }
      if (!request.headersList.contains("accept")) {
        const value = "*/*";
        request.headersList.append("accept", value);
      }
      if (!request.headersList.contains("accept-language")) {
        request.headersList.append("accept-language", "*");
      }
      if (request.priority === null) {
      }
      if (subresource.includes(request.destination)) {
      }
      mainFetch(fetchParams).catch((err) => {
        fetchParams.controller.terminate(err);
      });
      return fetchParams.controller;
    }
    async function mainFetch(fetchParams, recursive = false) {
      const request = fetchParams.request;
      let response = null;
      if (request.localURLsOnly && !urlIsLocal(requestCurrentURL(request))) {
        response = makeNetworkError("local URLs only");
      }
      tryUpgradeRequestToAPotentiallyTrustworthyURL(request);
      if (requestBadPort(request) === "blocked") {
        response = makeNetworkError("bad port");
      }
      if (request.referrerPolicy === "") {
        request.referrerPolicy = request.policyContainer.referrerPolicy;
      }
      if (request.referrer !== "no-referrer") {
        request.referrer = determineRequestsReferrer(request);
      }
      if (response === null) {
        response = await (async () => {
          const currentURL = requestCurrentURL(request);
          if (
            // - request’s current URL’s origin is same origin with request’s origin,
            //   and request’s response tainting is "basic"
            sameOrigin(currentURL, request.url) && request.responseTainting === "basic" || // request’s current URL’s scheme is "data"
            currentURL.protocol === "data:" || // - request’s mode is "navigate" or "websocket"
            (request.mode === "navigate" || request.mode === "websocket")
          ) {
            request.responseTainting = "basic";
            return await schemeFetch(fetchParams);
          }
          if (request.mode === "same-origin") {
            return makeNetworkError('request mode cannot be "same-origin"');
          }
          if (request.mode === "no-cors") {
            if (request.redirect !== "follow") {
              return makeNetworkError(
                'redirect mode cannot be "follow" for "no-cors" request'
              );
            }
            request.responseTainting = "opaque";
            return await schemeFetch(fetchParams);
          }
          if (!urlIsHttpHttpsScheme(requestCurrentURL(request))) {
            return makeNetworkError("URL scheme must be a HTTP(S) scheme");
          }
          request.responseTainting = "cors";
          return await httpFetch(fetchParams);
        })();
      }
      if (recursive) {
        return response;
      }
      if (response.status !== 0 && !response.internalResponse) {
        if (request.responseTainting === "cors") {
        }
        if (request.responseTainting === "basic") {
          response = filterResponse(response, "basic");
        } else if (request.responseTainting === "cors") {
          response = filterResponse(response, "cors");
        } else if (request.responseTainting === "opaque") {
          response = filterResponse(response, "opaque");
        } else {
          assert(false);
        }
      }
      let internalResponse = response.status === 0 ? response : response.internalResponse;
      if (internalResponse.urlList.length === 0) {
        internalResponse.urlList.push(...request.urlList);
      }
      if (!request.timingAllowFailed) {
        response.timingAllowPassed = true;
      }
      if (response.type === "opaque" && internalResponse.status === 206 && internalResponse.rangeRequested && !request.headers.contains("range")) {
        response = internalResponse = makeNetworkError();
      }
      if (response.status !== 0 && (request.method === "HEAD" || request.method === "CONNECT" || nullBodyStatus.includes(internalResponse.status))) {
        internalResponse.body = null;
        fetchParams.controller.dump = true;
      }
      if (request.integrity) {
        const processBodyError = (reason) => fetchFinale(fetchParams, makeNetworkError(reason));
        if (request.responseTainting === "opaque" || response.body == null) {
          processBodyError(response.error);
          return;
        }
        const processBody = (bytes) => {
          if (!bytesMatch(bytes, request.integrity)) {
            processBodyError("integrity mismatch");
            return;
          }
          response.body = safelyExtractBody(bytes)[0];
          fetchFinale(fetchParams, response);
        };
        await fullyReadBody(response.body, processBody, processBodyError);
      } else {
        fetchFinale(fetchParams, response);
      }
    }
    async function schemeFetch(fetchParams) {
      if (isCancelled(fetchParams) && fetchParams.request.redirectCount === 0) {
        return makeAppropriateNetworkError(fetchParams);
      }
      const { request } = fetchParams;
      const { protocol: scheme } = requestCurrentURL(request);
      switch (scheme) {
        case "about:": {
          return makeNetworkError("about scheme is not supported");
        }
        case "blob:": {
          if (!resolveObjectURL) {
            resolveObjectURL = require("buffer").resolveObjectURL;
          }
          const blobURLEntry = requestCurrentURL(request);
          if (blobURLEntry.search.length !== 0) {
            return makeNetworkError("NetworkError when attempting to fetch resource.");
          }
          const blobURLEntryObject = resolveObjectURL(blobURLEntry.toString());
          if (request.method !== "GET" || !isBlobLike(blobURLEntryObject)) {
            return makeNetworkError("invalid method");
          }
          const bodyWithType = safelyExtractBody(blobURLEntryObject);
          const body = bodyWithType[0];
          const length = isomorphicEncode(`${body.length}`);
          const type = bodyWithType[1] ?? "";
          const response = makeResponse({
            statusText: "OK",
            headersList: [
              ["content-length", { name: "Content-Length", value: length }],
              ["content-type", { name: "Content-Type", value: type }]
            ]
          });
          response.body = body;
          return response;
        }
        case "data:": {
          const currentURL = requestCurrentURL(request);
          const dataURLStruct = dataURLProcessor(currentURL);
          if (dataURLStruct === "failure") {
            return makeNetworkError("failed to fetch the data URL");
          }
          const mimeType = serializeAMimeType(dataURLStruct.mimeType);
          return makeResponse({
            statusText: "OK",
            headersList: [
              ["content-type", { name: "Content-Type", value: mimeType }]
            ],
            body: safelyExtractBody(dataURLStruct.body)[0]
          });
        }
        case "file:": {
          return makeNetworkError("not implemented... yet...");
        }
        case "http:":
        case "https:": {
          return await httpFetch(fetchParams).catch((err) => makeNetworkError(err));
        }
        default: {
          return makeNetworkError("unknown scheme");
        }
      }
    }
    function finalizeResponse(fetchParams, response) {
      fetchParams.request.done = true;
      if (fetchParams.processResponseDone != null) {
        queueMicrotask(() => fetchParams.processResponseDone(response));
      }
    }
    async function fetchFinale(fetchParams, response) {
      if (response.type === "error") {
        response.urlList = [fetchParams.request.urlList[0]];
        response.timingInfo = createOpaqueTimingInfo({
          startTime: fetchParams.timingInfo.startTime
        });
      }
      const processResponseEndOfBody = () => {
        fetchParams.request.done = true;
        if (fetchParams.processResponseEndOfBody != null) {
          queueMicrotask(() => fetchParams.processResponseEndOfBody(response));
        }
      };
      if (fetchParams.processResponse != null) {
        queueMicrotask(() => fetchParams.processResponse(response));
      }
      if (response.body == null) {
        processResponseEndOfBody();
      } else {
        const identityTransformAlgorithm = (chunk, controller) => {
          controller.enqueue(chunk);
        };
        const transformStream = new TransformStream({
          start() {
          },
          transform: identityTransformAlgorithm,
          flush: processResponseEndOfBody
        }, {
          size() {
            return 1;
          }
        }, {
          size() {
            return 1;
          }
        });
        response.body = { stream: response.body.stream.pipeThrough(transformStream) };
      }
      if (fetchParams.processResponseConsumeBody != null) {
        const processBody = (nullOrBytes) => fetchParams.processResponseConsumeBody(response, nullOrBytes);
        const processBodyError = (failure) => fetchParams.processResponseConsumeBody(response, failure);
        if (response.body == null) {
          queueMicrotask(() => processBody(null));
        } else {
          await fullyReadBody(response.body, processBody, processBodyError);
        }
      }
    }
    async function httpFetch(fetchParams) {
      const request = fetchParams.request;
      let response = null;
      let actualResponse = null;
      const timingInfo = fetchParams.timingInfo;
      if (request.serviceWorkers === "all") {
      }
      if (response === null) {
        if (request.redirect === "follow") {
          request.serviceWorkers = "none";
        }
        actualResponse = response = await httpNetworkOrCacheFetch(fetchParams);
        if (request.responseTainting === "cors" && corsCheck(request, response) === "failure") {
          return makeNetworkError("cors failure");
        }
        if (TAOCheck(request, response) === "failure") {
          request.timingAllowFailed = true;
        }
      }
      if ((request.responseTainting === "opaque" || response.type === "opaque") && crossOriginResourcePolicyCheck(
        request.origin,
        request.client,
        request.destination,
        actualResponse
      ) === "blocked") {
        return makeNetworkError("blocked");
      }
      if (redirectStatus.includes(actualResponse.status)) {
        if (request.redirect !== "manual") {
          fetchParams.controller.connection.destroy();
        }
        if (request.redirect === "error") {
          response = makeNetworkError("unexpected redirect");
        } else if (request.redirect === "manual") {
          response = actualResponse;
        } else if (request.redirect === "follow") {
          response = await httpRedirectFetch(fetchParams, response);
        } else {
          assert(false);
        }
      }
      response.timingInfo = timingInfo;
      return response;
    }
    async function httpRedirectFetch(fetchParams, response) {
      const request = fetchParams.request;
      const actualResponse = response.internalResponse ? response.internalResponse : response;
      let locationURL;
      try {
        locationURL = responseLocationURL(
          actualResponse,
          requestCurrentURL(request).hash
        );
        if (locationURL == null) {
          return response;
        }
      } catch (err) {
        return makeNetworkError(err);
      }
      if (!urlIsHttpHttpsScheme(locationURL)) {
        return makeNetworkError("URL scheme must be a HTTP(S) scheme");
      }
      if (request.redirectCount === 20) {
        return makeNetworkError("redirect count exceeded");
      }
      request.redirectCount += 1;
      if (request.mode === "cors" && (locationURL.username || locationURL.password) && !sameOrigin(request, locationURL)) {
        return makeNetworkError('cross origin not allowed for request mode "cors"');
      }
      if (request.responseTainting === "cors" && (locationURL.username || locationURL.password)) {
        return makeNetworkError(
          'URL cannot contain credentials for request mode "cors"'
        );
      }
      if (actualResponse.status !== 303 && request.body != null && request.body.source == null) {
        return makeNetworkError();
      }
      if ([301, 302].includes(actualResponse.status) && request.method === "POST" || actualResponse.status === 303 && !["GET", "HEAD"].includes(request.method)) {
        request.method = "GET";
        request.body = null;
        for (const headerName of requestBodyHeader) {
          request.headersList.delete(headerName);
        }
      }
      if (!sameOrigin(requestCurrentURL(request), locationURL)) {
        request.headersList.delete("authorization");
        request.headersList.delete("cookie");
        request.headersList.delete("host");
      }
      if (request.body != null) {
        assert(request.body.source != null);
        request.body = safelyExtractBody(request.body.source)[0];
      }
      const timingInfo = fetchParams.timingInfo;
      timingInfo.redirectEndTime = timingInfo.postRedirectStartTime = coarsenedSharedCurrentTime(fetchParams.crossOriginIsolatedCapability);
      if (timingInfo.redirectStartTime === 0) {
        timingInfo.redirectStartTime = timingInfo.startTime;
      }
      request.urlList.push(locationURL);
      setRequestReferrerPolicyOnRedirect(request, actualResponse);
      return mainFetch(fetchParams, true);
    }
    async function httpNetworkOrCacheFetch(fetchParams, isAuthenticationFetch = false, isNewConnectionFetch = false) {
      const request = fetchParams.request;
      let httpFetchParams = null;
      let httpRequest = null;
      let response = null;
      const httpCache = null;
      const revalidatingFlag = false;
      if (request.window === "no-window" && request.redirect === "error") {
        httpFetchParams = fetchParams;
        httpRequest = request;
      } else {
        httpRequest = makeRequest(request);
        httpFetchParams = { ...fetchParams };
        httpFetchParams.request = httpRequest;
      }
      const includeCredentials = request.credentials === "include" || request.credentials === "same-origin" && request.responseTainting === "basic";
      const contentLength = httpRequest.body ? httpRequest.body.length : null;
      let contentLengthHeaderValue = null;
      if (httpRequest.body == null && ["POST", "PUT"].includes(httpRequest.method)) {
        contentLengthHeaderValue = "0";
      }
      if (contentLength != null) {
        contentLengthHeaderValue = isomorphicEncode(`${contentLength}`);
      }
      if (contentLengthHeaderValue != null) {
        httpRequest.headersList.append("content-length", contentLengthHeaderValue);
      }
      if (contentLength != null && httpRequest.keepalive) {
      }
      if (httpRequest.referrer instanceof URL) {
        httpRequest.headersList.append("referer", isomorphicEncode(httpRequest.referrer.href));
      }
      appendRequestOriginHeader(httpRequest);
      appendFetchMetadata(httpRequest);
      if (!httpRequest.headersList.contains("user-agent")) {
        httpRequest.headersList.append("user-agent", typeof esbuildDetection === "undefined" ? "undici" : "node");
      }
      if (httpRequest.cache === "default" && (httpRequest.headersList.contains("if-modified-since") || httpRequest.headersList.contains("if-none-match") || httpRequest.headersList.contains("if-unmodified-since") || httpRequest.headersList.contains("if-match") || httpRequest.headersList.contains("if-range"))) {
        httpRequest.cache = "no-store";
      }
      if (httpRequest.cache === "no-cache" && !httpRequest.preventNoCacheCacheControlHeaderModification && !httpRequest.headersList.contains("cache-control")) {
        httpRequest.headersList.append("cache-control", "max-age=0");
      }
      if (httpRequest.cache === "no-store" || httpRequest.cache === "reload") {
        if (!httpRequest.headersList.contains("pragma")) {
          httpRequest.headersList.append("pragma", "no-cache");
        }
        if (!httpRequest.headersList.contains("cache-control")) {
          httpRequest.headersList.append("cache-control", "no-cache");
        }
      }
      if (httpRequest.headersList.contains("range")) {
        httpRequest.headersList.append("accept-encoding", "identity");
      }
      if (!httpRequest.headersList.contains("accept-encoding")) {
        if (urlHasHttpsScheme(requestCurrentURL(httpRequest))) {
          httpRequest.headersList.append("accept-encoding", "br, gzip, deflate");
        } else {
          httpRequest.headersList.append("accept-encoding", "gzip, deflate");
        }
      }
      httpRequest.headersList.delete("host");
      if (includeCredentials) {
      }
      if (httpCache == null) {
        httpRequest.cache = "no-store";
      }
      if (httpRequest.mode !== "no-store" && httpRequest.mode !== "reload") {
      }
      if (response == null) {
        if (httpRequest.mode === "only-if-cached") {
          return makeNetworkError("only if cached");
        }
        const forwardResponse = await httpNetworkFetch(
          httpFetchParams,
          includeCredentials,
          isNewConnectionFetch
        );
        if (!safeMethods.includes(httpRequest.method) && forwardResponse.status >= 200 && forwardResponse.status <= 399) {
        }
        if (revalidatingFlag && forwardResponse.status === 304) {
        }
        if (response == null) {
          response = forwardResponse;
        }
      }
      response.urlList = [...httpRequest.urlList];
      if (httpRequest.headersList.contains("range")) {
        response.rangeRequested = true;
      }
      response.requestIncludesCredentials = includeCredentials;
      if (response.status === 407) {
        if (request.window === "no-window") {
          return makeNetworkError();
        }
        if (isCancelled(fetchParams)) {
          return makeAppropriateNetworkError(fetchParams);
        }
        return makeNetworkError("proxy authentication required");
      }
      if (
        // response’s status is 421
        response.status === 421 && // isNewConnectionFetch is false
        !isNewConnectionFetch && // request’s body is null, or request’s body is non-null and request’s body’s source is non-null
        (request.body == null || request.body.source != null)
      ) {
        if (isCancelled(fetchParams)) {
          return makeAppropriateNetworkError(fetchParams);
        }
        fetchParams.controller.connection.destroy();
        response = await httpNetworkOrCacheFetch(
          fetchParams,
          isAuthenticationFetch,
          true
        );
      }
      if (isAuthenticationFetch) {
      }
      return response;
    }
    async function httpNetworkFetch(fetchParams, includeCredentials = false, forceNewConnection = false) {
      assert(!fetchParams.controller.connection || fetchParams.controller.connection.destroyed);
      fetchParams.controller.connection = {
        abort: null,
        destroyed: false,
        destroy(err) {
          if (!this.destroyed) {
            this.destroyed = true;
            this.abort?.(err ?? new DOMException("The operation was aborted.", "AbortError"));
          }
        }
      };
      const request = fetchParams.request;
      let response = null;
      const timingInfo = fetchParams.timingInfo;
      const httpCache = null;
      if (httpCache == null) {
        request.cache = "no-store";
      }
      const newConnection = forceNewConnection ? "yes" : "no";
      if (request.mode === "websocket") {
      } else {
      }
      let requestBody = null;
      if (request.body == null && fetchParams.processRequestEndOfBody) {
        queueMicrotask(() => fetchParams.processRequestEndOfBody());
      } else if (request.body != null) {
        const processBodyChunk = async function* (bytes) {
          if (isCancelled(fetchParams)) {
            return;
          }
          yield bytes;
          fetchParams.processRequestBodyChunkLength?.(bytes.byteLength);
        };
        const processEndOfBody = () => {
          if (isCancelled(fetchParams)) {
            return;
          }
          if (fetchParams.processRequestEndOfBody) {
            fetchParams.processRequestEndOfBody();
          }
        };
        const processBodyError = (e) => {
          if (isCancelled(fetchParams)) {
            return;
          }
          if (e.name === "AbortError") {
            fetchParams.controller.abort();
          } else {
            fetchParams.controller.terminate(e);
          }
        };
        requestBody = async function* () {
          try {
            for await (const bytes of request.body.stream) {
              yield* processBodyChunk(bytes);
            }
            processEndOfBody();
          } catch (err) {
            processBodyError(err);
          }
        }();
      }
      try {
        const { body, status, statusText, headersList, socket } = await dispatch({ body: requestBody });
        if (socket) {
          response = makeResponse({ status, statusText, headersList, socket });
        } else {
          const iterator = body[Symbol.asyncIterator]();
          fetchParams.controller.next = () => iterator.next();
          response = makeResponse({ status, statusText, headersList });
        }
      } catch (err) {
        if (err.name === "AbortError") {
          fetchParams.controller.connection.destroy();
          return makeAppropriateNetworkError(fetchParams, err);
        }
        return makeNetworkError(err);
      }
      const pullAlgorithm = () => {
        fetchParams.controller.resume();
      };
      const cancelAlgorithm = (reason) => {
        fetchParams.controller.abort(reason);
      };
      if (!ReadableStream) {
        ReadableStream = require("stream/web").ReadableStream;
      }
      const stream = new ReadableStream(
        {
          async start(controller) {
            fetchParams.controller.controller = controller;
          },
          async pull(controller) {
            await pullAlgorithm(controller);
          },
          async cancel(reason) {
            await cancelAlgorithm(reason);
          }
        },
        {
          highWaterMark: 0,
          size() {
            return 1;
          }
        }
      );
      response.body = { stream };
      fetchParams.controller.on("terminated", onAborted);
      fetchParams.controller.resume = async () => {
        while (true) {
          let bytes;
          let isFailure;
          try {
            const { done, value } = await fetchParams.controller.next();
            if (isAborted(fetchParams)) {
              break;
            }
            bytes = done ? void 0 : value;
          } catch (err) {
            if (fetchParams.controller.ended && !timingInfo.encodedBodySize) {
              bytes = void 0;
            } else {
              bytes = err;
              isFailure = true;
            }
          }
          if (bytes === void 0) {
            readableStreamClose(fetchParams.controller.controller);
            finalizeResponse(fetchParams, response);
            return;
          }
          timingInfo.decodedBodySize += bytes?.byteLength ?? 0;
          if (isFailure) {
            fetchParams.controller.terminate(bytes);
            return;
          }
          fetchParams.controller.controller.enqueue(new Uint8Array(bytes));
          if (isErrored(stream)) {
            fetchParams.controller.terminate();
            return;
          }
          if (!fetchParams.controller.controller.desiredSize) {
            return;
          }
        }
      };
      function onAborted(reason) {
        if (isAborted(fetchParams)) {
          response.aborted = true;
          if (isReadable(stream)) {
            fetchParams.controller.controller.error(
              fetchParams.controller.serializedAbortReason
            );
          }
        } else {
          if (isReadable(stream)) {
            fetchParams.controller.controller.error(new TypeError("terminated", {
              cause: isErrorLike(reason) ? reason : void 0
            }));
          }
        }
        fetchParams.controller.connection.destroy();
      }
      return response;
      async function dispatch({ body }) {
        const url = requestCurrentURL(request);
        const agent = fetchParams.controller.dispatcher;
        return new Promise((resolve, reject) => agent.dispatch(
          {
            path: url.pathname + url.search,
            origin: url.origin,
            method: request.method,
            body: fetchParams.controller.dispatcher.isMockActive ? request.body && request.body.source : body,
            headers: request.headersList.entries,
            maxRedirections: 0,
            upgrade: request.mode === "websocket" ? "websocket" : void 0
          },
          {
            body: null,
            abort: null,
            onConnect(abort) {
              const { connection } = fetchParams.controller;
              if (connection.destroyed) {
                abort(new DOMException("The operation was aborted.", "AbortError"));
              } else {
                fetchParams.controller.on("terminated", abort);
                this.abort = connection.abort = abort;
              }
            },
            onHeaders(status, headersList, resume, statusText) {
              if (status < 200) {
                return;
              }
              let codings = [];
              let location = "";
              const headers = new Headers();
              if (Array.isArray(headersList)) {
                for (let n = 0; n < headersList.length; n += 2) {
                  const key = headersList[n + 0].toString("latin1");
                  const val = headersList[n + 1].toString("latin1");
                  if (key.toLowerCase() === "content-encoding") {
                    codings = val.toLowerCase().split(",").map((x) => x.trim());
                  } else if (key.toLowerCase() === "location") {
                    location = val;
                  }
                  headers.append(key, val);
                }
              } else {
                const keys = Object.keys(headersList);
                for (const key of keys) {
                  const val = headersList[key];
                  if (key.toLowerCase() === "content-encoding") {
                    codings = val.toLowerCase().split(",").map((x) => x.trim()).reverse();
                  } else if (key.toLowerCase() === "location") {
                    location = val;
                  }
                  headers.append(key, val);
                }
              }
              this.body = new Readable({ read: resume });
              const decoders = [];
              const willFollow = request.redirect === "follow" && location && redirectStatus.includes(status);
              if (request.method !== "HEAD" && request.method !== "CONNECT" && !nullBodyStatus.includes(status) && !willFollow) {
                for (const coding of codings) {
                  if (coding === "x-gzip" || coding === "gzip") {
                    decoders.push(zlib.createGunzip({
                      // Be less strict when decoding compressed responses, since sometimes
                      // servers send slightly invalid responses that are still accepted
                      // by common browsers.
                      // Always using Z_SYNC_FLUSH is what cURL does.
                      flush: zlib.constants.Z_SYNC_FLUSH,
                      finishFlush: zlib.constants.Z_SYNC_FLUSH
                    }));
                  } else if (coding === "deflate") {
                    decoders.push(zlib.createInflate());
                  } else if (coding === "br") {
                    decoders.push(zlib.createBrotliDecompress());
                  } else {
                    decoders.length = 0;
                    break;
                  }
                }
              }
              resolve({
                status,
                statusText,
                headersList: headers[kHeadersList],
                body: decoders.length ? pipeline(this.body, ...decoders, () => {
                }) : this.body.on("error", () => {
                })
              });
              return true;
            },
            onData(chunk) {
              if (fetchParams.controller.dump) {
                return;
              }
              const bytes = chunk;
              timingInfo.encodedBodySize += bytes.byteLength;
              return this.body.push(bytes);
            },
            onComplete() {
              if (this.abort) {
                fetchParams.controller.off("terminated", this.abort);
              }
              fetchParams.controller.ended = true;
              this.body.push(null);
            },
            onError(error) {
              if (this.abort) {
                fetchParams.controller.off("terminated", this.abort);
              }
              this.body?.destroy(error);
              fetchParams.controller.terminate(error);
              reject(error);
            },
            onUpgrade(status, headersList, socket) {
              if (status !== 101) {
                return;
              }
              const headers = new Headers();
              for (let n = 0; n < headersList.length; n += 2) {
                const key = headersList[n + 0].toString("latin1");
                const val = headersList[n + 1].toString("latin1");
                headers.append(key, val);
              }
              resolve({
                status,
                statusText: STATUS_CODES[status],
                headersList: headers[kHeadersList],
                socket
              });
              return true;
            }
          }
        ));
      }
    }
    module2.exports = {
      fetch: fetch2,
      Fetch,
      fetching,
      finalizeAndReportTiming
    };
  }
});

// lib/websocket/constants.js
var require_constants3 = __commonJS({
  "lib/websocket/constants.js"(exports2, module2) {
    "use strict";
    var uid = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    var staticPropertyDescriptors = {
      enumerable: true,
      writable: false,
      configurable: false
    };
    var states = {
      CONNECTING: 0,
      OPEN: 1,
      CLOSING: 2,
      CLOSED: 3
    };
    var opcodes = {
      CONTINUATION: 0,
      TEXT: 1,
      BINARY: 2,
      CLOSE: 8,
      PING: 9,
      PONG: 10
    };
    var maxUnsigned16Bit = 2 ** 16 - 1;
    var parserStates = {
      INFO: 0,
      PAYLOADLENGTH_16: 2,
      PAYLOADLENGTH_64: 3,
      READ_DATA: 4
    };
    var emptyBuffer = Buffer.allocUnsafe(0);
    module2.exports = {
      uid,
      staticPropertyDescriptors,
      states,
      opcodes,
      maxUnsigned16Bit,
      parserStates,
      emptyBuffer
    };
  }
});

// lib/websocket/symbols.js
var require_symbols3 = __commonJS({
  "lib/websocket/symbols.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      kWebSocketURL: Symbol("url"),
      kReadyState: Symbol("ready state"),
      kController: Symbol("controller"),
      kResponse: Symbol("response"),
      kBinaryType: Symbol("binary type"),
      kSentClose: Symbol("sent close"),
      kReceivedClose: Symbol("received close"),
      kByteParser: Symbol("byte parser")
    };
  }
});

// lib/websocket/events.js
var require_events = __commonJS({
  "lib/websocket/events.js"(exports2, module2) {
    "use strict";
    var { webidl } = require_webidl();
    var { kEnumerableProperty } = require_util();
    var { MessagePort } = require("worker_threads");
    var MessageEvent = class extends Event {
      #eventInit;
      constructor(type, eventInitDict = {}) {
        webidl.argumentLengthCheck(arguments, 1, { header: "MessageEvent constructor" });
        type = webidl.converters.DOMString(type);
        eventInitDict = webidl.converters.MessageEventInit(eventInitDict);
        super(type, eventInitDict);
        this.#eventInit = eventInitDict;
      }
      get data() {
        webidl.brandCheck(this, MessageEvent);
        return this.#eventInit.data;
      }
      get origin() {
        webidl.brandCheck(this, MessageEvent);
        return this.#eventInit.origin;
      }
      get lastEventId() {
        webidl.brandCheck(this, MessageEvent);
        return this.#eventInit.lastEventId;
      }
      get source() {
        webidl.brandCheck(this, MessageEvent);
        return this.#eventInit.source;
      }
      get ports() {
        webidl.brandCheck(this, MessageEvent);
        if (!Object.isFrozen(this.#eventInit.ports)) {
          Object.freeze(this.#eventInit.ports);
        }
        return this.#eventInit.ports;
      }
      initMessageEvent(type, bubbles = false, cancelable = false, data = null, origin = "", lastEventId = "", source = null, ports = []) {
        webidl.brandCheck(this, MessageEvent);
        webidl.argumentLengthCheck(arguments, 1, { header: "MessageEvent.initMessageEvent" });
        return new MessageEvent(type, {
          bubbles,
          cancelable,
          data,
          origin,
          lastEventId,
          source,
          ports
        });
      }
    };
    var CloseEvent = class extends Event {
      #eventInit;
      constructor(type, eventInitDict = {}) {
        webidl.argumentLengthCheck(arguments, 1, { header: "CloseEvent constructor" });
        type = webidl.converters.DOMString(type);
        eventInitDict = webidl.converters.CloseEventInit(eventInitDict);
        super(type, eventInitDict);
        this.#eventInit = eventInitDict;
      }
      get wasClean() {
        webidl.brandCheck(this, CloseEvent);
        return this.#eventInit.wasClean;
      }
      get code() {
        webidl.brandCheck(this, CloseEvent);
        return this.#eventInit.code;
      }
      get reason() {
        webidl.brandCheck(this, CloseEvent);
        return this.#eventInit.reason;
      }
    };
    var ErrorEvent = class extends Event {
      #eventInit;
      constructor(type, eventInitDict) {
        webidl.argumentLengthCheck(arguments, 1, { header: "ErrorEvent constructor" });
        super(type, eventInitDict);
        type = webidl.converters.DOMString(type);
        eventInitDict = webidl.converters.ErrorEventInit(eventInitDict ?? {});
        this.#eventInit = eventInitDict;
      }
      get message() {
        webidl.brandCheck(this, ErrorEvent);
        return this.#eventInit.message;
      }
      get filename() {
        webidl.brandCheck(this, ErrorEvent);
        return this.#eventInit.filename;
      }
      get lineno() {
        webidl.brandCheck(this, ErrorEvent);
        return this.#eventInit.lineno;
      }
      get colno() {
        webidl.brandCheck(this, ErrorEvent);
        return this.#eventInit.colno;
      }
      get error() {
        webidl.brandCheck(this, ErrorEvent);
        return this.#eventInit.error;
      }
    };
    Object.defineProperties(MessageEvent.prototype, {
      [Symbol.toStringTag]: {
        value: "MessageEvent",
        configurable: true
      },
      data: kEnumerableProperty,
      origin: kEnumerableProperty,
      lastEventId: kEnumerableProperty,
      source: kEnumerableProperty,
      ports: kEnumerableProperty,
      initMessageEvent: kEnumerableProperty
    });
    Object.defineProperties(CloseEvent.prototype, {
      [Symbol.toStringTag]: {
        value: "CloseEvent",
        configurable: true
      },
      reason: kEnumerableProperty,
      code: kEnumerableProperty,
      wasClean: kEnumerableProperty
    });
    Object.defineProperties(ErrorEvent.prototype, {
      [Symbol.toStringTag]: {
        value: "ErrorEvent",
        configurable: true
      },
      message: kEnumerableProperty,
      filename: kEnumerableProperty,
      lineno: kEnumerableProperty,
      colno: kEnumerableProperty,
      error: kEnumerableProperty
    });
    webidl.converters.MessagePort = webidl.interfaceConverter(MessagePort);
    webidl.converters["sequence<MessagePort>"] = webidl.sequenceConverter(
      webidl.converters.MessagePort
    );
    var eventInit = [
      {
        key: "bubbles",
        converter: webidl.converters.boolean,
        defaultValue: false
      },
      {
        key: "cancelable",
        converter: webidl.converters.boolean,
        defaultValue: false
      },
      {
        key: "composed",
        converter: webidl.converters.boolean,
        defaultValue: false
      }
    ];
    webidl.converters.MessageEventInit = webidl.dictionaryConverter([
      ...eventInit,
      {
        key: "data",
        converter: webidl.converters.any,
        defaultValue: null
      },
      {
        key: "origin",
        converter: webidl.converters.USVString,
        defaultValue: ""
      },
      {
        key: "lastEventId",
        converter: webidl.converters.DOMString,
        defaultValue: ""
      },
      {
        key: "source",
        // Node doesn't implement WindowProxy or ServiceWorker, so the only
        // valid value for source is a MessagePort.
        converter: webidl.nullableConverter(webidl.converters.MessagePort),
        defaultValue: null
      },
      {
        key: "ports",
        converter: webidl.converters["sequence<MessagePort>"],
        get defaultValue() {
          return [];
        }
      }
    ]);
    webidl.converters.CloseEventInit = webidl.dictionaryConverter([
      ...eventInit,
      {
        key: "wasClean",
        converter: webidl.converters.boolean,
        defaultValue: false
      },
      {
        key: "code",
        converter: webidl.converters["unsigned short"],
        defaultValue: 0
      },
      {
        key: "reason",
        converter: webidl.converters.USVString,
        defaultValue: ""
      }
    ]);
    webidl.converters.ErrorEventInit = webidl.dictionaryConverter([
      ...eventInit,
      {
        key: "message",
        converter: webidl.converters.DOMString,
        defaultValue: ""
      },
      {
        key: "filename",
        converter: webidl.converters.USVString,
        defaultValue: ""
      },
      {
        key: "lineno",
        converter: webidl.converters["unsigned long"],
        defaultValue: 0
      },
      {
        key: "colno",
        converter: webidl.converters["unsigned long"],
        defaultValue: 0
      },
      {
        key: "error",
        converter: webidl.converters.any
      }
    ]);
    module2.exports = {
      MessageEvent,
      CloseEvent,
      ErrorEvent
    };
  }
});

// lib/websocket/util.js
var require_util3 = __commonJS({
  "lib/websocket/util.js"(exports2, module2) {
    "use strict";
    var { kReadyState, kController, kResponse, kBinaryType, kWebSocketURL } = require_symbols3();
    var { states, opcodes } = require_constants3();
    var { MessageEvent, ErrorEvent } = require_events();
    function isEstablished(ws) {
      return ws[kReadyState] === states.OPEN;
    }
    function isClosing(ws) {
      return ws[kReadyState] === states.CLOSING;
    }
    function isClosed(ws) {
      return ws[kReadyState] === states.CLOSED;
    }
    function fireEvent(e, target, eventConstructor = Event, eventInitDict) {
      const event = new eventConstructor(e, eventInitDict);
      target.dispatchEvent(event);
    }
    function websocketMessageReceived(ws, type, data) {
      if (ws[kReadyState] !== states.OPEN) {
        return;
      }
      let dataForEvent;
      if (type === opcodes.TEXT) {
        try {
          dataForEvent = new TextDecoder("utf-8", { fatal: true }).decode(data);
        } catch {
          failWebsocketConnection(ws, "Received invalid UTF-8 in text frame.");
          return;
        }
      } else if (type === opcodes.BINARY) {
        if (ws[kBinaryType] === "blob") {
          dataForEvent = new Blob([data]);
        } else {
          dataForEvent = new Uint8Array(data).buffer;
        }
      }
      fireEvent("message", ws, MessageEvent, {
        origin: ws[kWebSocketURL].origin,
        data: dataForEvent
      });
    }
    function isValidSubprotocol(protocol) {
      if (protocol.length === 0) {
        return false;
      }
      for (const char of protocol) {
        const code = char.charCodeAt(0);
        if (code < 33 || code > 126 || char === "(" || char === ")" || char === "<" || char === ">" || char === "@" || char === "," || char === ";" || char === ":" || char === "\\" || char === '"' || char === "/" || char === "[" || char === "]" || char === "?" || char === "=" || char === "{" || char === "}" || code === 32 || // SP
        code === 9) {
          return false;
        }
      }
      return true;
    }
    function isValidStatusCode(code) {
      if (code >= 1e3 && code < 1015) {
        return code !== 1004 && // reserved
        code !== 1005 && // "MUST NOT be set as a status code"
        code !== 1006;
      }
      return code >= 3e3 && code <= 4999;
    }
    function failWebsocketConnection(ws, reason) {
      const { [kController]: controller, [kResponse]: response } = ws;
      controller.abort();
      if (response?.socket && !response.socket.destroyed) {
        response.socket.destroy();
      }
      if (reason) {
        fireEvent("error", ws, ErrorEvent, {
          error: new Error(reason)
        });
      }
    }
    module2.exports = {
      isEstablished,
      isClosing,
      isClosed,
      fireEvent,
      isValidSubprotocol,
      isValidStatusCode,
      failWebsocketConnection,
      websocketMessageReceived
    };
  }
});

// lib/websocket/connection.js
var require_connection = __commonJS({
  "lib/websocket/connection.js"(exports2, module2) {
    "use strict";
    var diagnosticsChannel = require("diagnostics_channel");
    var { uid, states } = require_constants3();
    var {
      kReadyState,
      kSentClose,
      kByteParser,
      kReceivedClose
    } = require_symbols3();
    var { fireEvent, failWebsocketConnection } = require_util3();
    var { CloseEvent } = require_events();
    var { makeRequest } = require_request();
    var { fetching } = require_fetch();
    var { Headers } = require_headers();
    var { getGlobalDispatcher } = require_global2();
    var { kHeadersList } = require_symbols();
    var channels = {};
    channels.open = diagnosticsChannel.channel("undici:websocket:open");
    channels.close = diagnosticsChannel.channel("undici:websocket:close");
    channels.socketError = diagnosticsChannel.channel("undici:websocket:socket_error");
    var crypto;
    try {
      crypto = require("crypto");
    } catch {
    }
    function establishWebSocketConnection(url, protocols, ws, onEstablish, options) {
      const requestURL = url;
      requestURL.protocol = url.protocol === "ws:" ? "http:" : "https:";
      const request = makeRequest({
        urlList: [requestURL],
        serviceWorkers: "none",
        referrer: "no-referrer",
        mode: "websocket",
        credentials: "include",
        cache: "no-store",
        redirect: "error"
      });
      if (options.headers) {
        const headersList = new Headers(options.headers)[kHeadersList];
        request.headersList = headersList;
      }
      const keyValue = crypto.randomBytes(16).toString("base64");
      request.headersList.append("sec-websocket-key", keyValue);
      request.headersList.append("sec-websocket-version", "13");
      for (const protocol of protocols) {
        request.headersList.append("sec-websocket-protocol", protocol);
      }
      const permessageDeflate = "";
      const controller = fetching({
        request,
        useParallelQueue: true,
        dispatcher: options.dispatcher ?? getGlobalDispatcher(),
        processResponse(response) {
          if (response.type === "error" || response.status !== 101) {
            failWebsocketConnection(ws, "Received network error or non-101 status code.");
            return;
          }
          if (protocols.length !== 0 && !response.headersList.get("Sec-WebSocket-Protocol")) {
            failWebsocketConnection(ws, "Server did not respond with sent protocols.");
            return;
          }
          if (response.headersList.get("Upgrade")?.toLowerCase() !== "websocket") {
            failWebsocketConnection(ws, 'Server did not set Upgrade header to "websocket".');
            return;
          }
          if (response.headersList.get("Connection")?.toLowerCase() !== "upgrade") {
            failWebsocketConnection(ws, 'Server did not set Connection header to "upgrade".');
            return;
          }
          const secWSAccept = response.headersList.get("Sec-WebSocket-Accept");
          const digest = crypto.createHash("sha1").update(keyValue + uid).digest("base64");
          if (secWSAccept !== digest) {
            failWebsocketConnection(ws, "Incorrect hash received in Sec-WebSocket-Accept header.");
            return;
          }
          const secExtension = response.headersList.get("Sec-WebSocket-Extensions");
          if (secExtension !== null && secExtension !== permessageDeflate) {
            failWebsocketConnection(ws, "Received different permessage-deflate than the one set.");
            return;
          }
          const secProtocol = response.headersList.get("Sec-WebSocket-Protocol");
          if (secProtocol !== null && secProtocol !== request.headersList.get("Sec-WebSocket-Protocol")) {
            failWebsocketConnection(ws, "Protocol was not set in the opening handshake.");
            return;
          }
          response.socket.on("data", onSocketData);
          response.socket.on("close", onSocketClose);
          response.socket.on("error", onSocketError);
          if (channels.open.hasSubscribers) {
            channels.open.publish({
              address: response.socket.address(),
              protocol: secProtocol,
              extensions: secExtension
            });
          }
          onEstablish(response);
        }
      });
      return controller;
    }
    function onSocketData(chunk) {
      if (!this.ws[kByteParser].write(chunk)) {
        this.pause();
      }
    }
    function onSocketClose() {
      const { ws } = this;
      const wasClean = ws[kSentClose] && ws[kReceivedClose];
      let code = 1005;
      let reason = "";
      const result = ws[kByteParser].closingInfo;
      if (result) {
        code = result.code ?? 1005;
        reason = result.reason;
      } else if (!ws[kSentClose]) {
        code = 1006;
      }
      ws[kReadyState] = states.CLOSED;
      fireEvent("close", ws, CloseEvent, {
        wasClean,
        code,
        reason
      });
      if (channels.close.hasSubscribers) {
        channels.close.publish({
          websocket: ws,
          code,
          reason
        });
      }
    }
    function onSocketError(error) {
      const { ws } = this;
      ws[kReadyState] = states.CLOSING;
      if (channels.socketError.hasSubscribers) {
        channels.socketError.publish(error);
      }
      this.destroy();
    }
    module2.exports = {
      establishWebSocketConnection
    };
  }
});

// lib/websocket/frame.js
var require_frame = __commonJS({
  "lib/websocket/frame.js"(exports2, module2) {
    "use strict";
    var { maxUnsigned16Bit } = require_constants3();
    var crypto;
    try {
      crypto = require("crypto");
    } catch {
    }
    var WebsocketFrameSend = class {
      /**
       * @param {Buffer|undefined} data
       */
      constructor(data) {
        this.frameData = data;
        this.maskKey = crypto.randomBytes(4);
      }
      createFrame(opcode) {
        const bodyLength = this.frameData?.byteLength ?? 0;
        let payloadLength = bodyLength;
        let offset = 6;
        if (bodyLength > maxUnsigned16Bit) {
          offset += 8;
          payloadLength = 127;
        } else if (bodyLength > 125) {
          offset += 2;
          payloadLength = 126;
        }
        const buffer = Buffer.allocUnsafe(bodyLength + offset);
        buffer[0] = buffer[1] = 0;
        buffer[0] |= 128;
        buffer[0] = (buffer[0] & 240) + opcode;
        buffer[offset - 4] = this.maskKey[0];
        buffer[offset - 3] = this.maskKey[1];
        buffer[offset - 2] = this.maskKey[2];
        buffer[offset - 1] = this.maskKey[3];
        buffer[1] = payloadLength;
        if (payloadLength === 126) {
          buffer.writeUInt16BE(bodyLength, 2);
        } else if (payloadLength === 127) {
          buffer[2] = buffer[3] = 0;
          buffer.writeUIntBE(bodyLength, 4, 6);
        }
        buffer[1] |= 128;
        for (let i = 0; i < bodyLength; i++) {
          buffer[offset + i] = this.frameData[i] ^ this.maskKey[i % 4];
        }
        return buffer;
      }
    };
    module2.exports = {
      WebsocketFrameSend
    };
  }
});

// lib/websocket/receiver.js
var require_receiver = __commonJS({
  "lib/websocket/receiver.js"(exports2, module2) {
    "use strict";
    var { Writable } = require("stream");
    var diagnosticsChannel = require("diagnostics_channel");
    var { parserStates, opcodes, states, emptyBuffer } = require_constants3();
    var { kReadyState, kSentClose, kResponse, kReceivedClose } = require_symbols3();
    var { isValidStatusCode, failWebsocketConnection, websocketMessageReceived } = require_util3();
    var { WebsocketFrameSend } = require_frame();
    var channels = {};
    channels.ping = diagnosticsChannel.channel("undici:websocket:ping");
    channels.pong = diagnosticsChannel.channel("undici:websocket:pong");
    var ByteParser = class extends Writable {
      #buffers = [];
      #byteOffset = 0;
      #state = parserStates.INFO;
      #info = {};
      #fragments = [];
      constructor(ws) {
        super();
        this.ws = ws;
      }
      /**
       * @param {Buffer} chunk
       * @param {() => void} callback
       */
      _write(chunk, _, callback) {
        this.#buffers.push(chunk);
        this.#byteOffset += chunk.length;
        this.run(callback);
      }
      /**
       * Runs whenever a new chunk is received.
       * Callback is called whenever there are no more chunks buffering,
       * or not enough bytes are buffered to parse.
       */
      run(callback) {
        while (true) {
          if (this.#state === parserStates.INFO) {
            if (this.#byteOffset < 2) {
              return callback();
            }
            const buffer = this.consume(2);
            this.#info.fin = (buffer[0] & 128) !== 0;
            this.#info.opcode = buffer[0] & 15;
            this.#info.originalOpcode ??= this.#info.opcode;
            this.#info.fragmented = !this.#info.fin && this.#info.opcode !== opcodes.CONTINUATION;
            if (this.#info.fragmented && this.#info.opcode !== opcodes.BINARY && this.#info.opcode !== opcodes.TEXT) {
              failWebsocketConnection(this.ws, "Invalid frame type was fragmented.");
              return;
            }
            const payloadLength = buffer[1] & 127;
            if (payloadLength <= 125) {
              this.#info.payloadLength = payloadLength;
              this.#state = parserStates.READ_DATA;
            } else if (payloadLength === 126) {
              this.#state = parserStates.PAYLOADLENGTH_16;
            } else if (payloadLength === 127) {
              this.#state = parserStates.PAYLOADLENGTH_64;
            }
            if (this.#info.fragmented && payloadLength > 125) {
              failWebsocketConnection(this.ws, "Fragmented frame exceeded 125 bytes.");
              return;
            } else if ((this.#info.opcode === opcodes.PING || this.#info.opcode === opcodes.PONG || this.#info.opcode === opcodes.CLOSE) && payloadLength > 125) {
              failWebsocketConnection(this.ws, "Payload length for control frame exceeded 125 bytes.");
              return;
            } else if (this.#info.opcode === opcodes.CLOSE) {
              if (payloadLength === 1) {
                failWebsocketConnection(this.ws, "Received close frame with a 1-byte body.");
                return;
              }
              const body = this.consume(payloadLength);
              this.#info.closeInfo = this.parseCloseBody(false, body);
              if (!this.ws[kSentClose]) {
                const body2 = Buffer.allocUnsafe(2);
                body2.writeUInt16BE(this.#info.closeInfo.code, 0);
                const closeFrame = new WebsocketFrameSend(body2);
                this.ws[kResponse].socket.write(
                  closeFrame.createFrame(opcodes.CLOSE),
                  (err) => {
                    if (!err) {
                      this.ws[kSentClose] = true;
                    }
                  }
                );
              }
              this.ws[kReadyState] = states.CLOSING;
              this.ws[kReceivedClose] = true;
              this.end();
              return;
            } else if (this.#info.opcode === opcodes.PING) {
              const body = this.consume(payloadLength);
              if (!this.ws[kReceivedClose]) {
                const frame = new WebsocketFrameSend(body);
                this.ws[kResponse].socket.write(frame.createFrame(opcodes.PONG));
                if (channels.ping.hasSubscribers) {
                  channels.ping.publish({
                    payload: body
                  });
                }
              }
              this.#state = parserStates.INFO;
              if (this.#byteOffset > 0) {
                continue;
              } else {
                callback();
                return;
              }
            } else if (this.#info.opcode === opcodes.PONG) {
              const body = this.consume(payloadLength);
              if (channels.pong.hasSubscribers) {
                channels.pong.publish({
                  payload: body
                });
              }
              if (this.#byteOffset > 0) {
                continue;
              } else {
                callback();
                return;
              }
            }
          } else if (this.#state === parserStates.PAYLOADLENGTH_16) {
            if (this.#byteOffset < 2) {
              return callback();
            }
            const buffer = this.consume(2);
            this.#info.payloadLength = buffer.readUInt16BE(0);
            this.#state = parserStates.READ_DATA;
          } else if (this.#state === parserStates.PAYLOADLENGTH_64) {
            if (this.#byteOffset < 8) {
              return callback();
            }
            const buffer = this.consume(8);
            const upper = buffer.readUInt32BE(0);
            if (upper > 2 ** 31 - 1) {
              failWebsocketConnection(this.ws, "Received payload length > 2^31 bytes.");
              return;
            }
            const lower = buffer.readUInt32BE(4);
            this.#info.payloadLength = (upper << 8) + lower;
            this.#state = parserStates.READ_DATA;
          } else if (this.#state === parserStates.READ_DATA) {
            if (this.#byteOffset < this.#info.payloadLength) {
              return callback();
            } else if (this.#byteOffset >= this.#info.payloadLength) {
              const body = this.consume(this.#info.payloadLength);
              this.#fragments.push(body);
              if (!this.#info.fragmented || this.#info.fin && this.#info.opcode === opcodes.CONTINUATION) {
                const fullMessage = Buffer.concat(this.#fragments);
                websocketMessageReceived(this.ws, this.#info.originalOpcode, fullMessage);
                this.#info = {};
                this.#fragments.length = 0;
              }
              this.#state = parserStates.INFO;
            }
          }
          if (this.#byteOffset > 0) {
            continue;
          } else {
            callback();
            break;
          }
        }
      }
      /**
       * Take n bytes from the buffered Buffers
       * @param {number} n
       * @returns {Buffer|null}
       */
      consume(n) {
        if (n > this.#byteOffset) {
          return null;
        } else if (n === 0) {
          return emptyBuffer;
        }
        if (this.#buffers[0].length === n) {
          this.#byteOffset -= this.#buffers[0].length;
          return this.#buffers.shift();
        }
        const buffer = Buffer.allocUnsafe(n);
        let offset = 0;
        while (offset !== n) {
          const next = this.#buffers[0];
          const { length } = next;
          if (length + offset === n) {
            buffer.set(this.#buffers.shift(), offset);
            break;
          } else if (length + offset > n) {
            buffer.set(next.subarray(0, n - offset), offset);
            this.#buffers[0] = next.subarray(n - offset);
            break;
          } else {
            buffer.set(this.#buffers.shift(), offset);
            offset += next.length;
          }
        }
        this.#byteOffset -= n;
        return buffer;
      }
      parseCloseBody(onlyCode, data) {
        let code;
        if (data.length >= 2) {
          code = data.readUInt16BE(0);
        }
        if (onlyCode) {
          if (!isValidStatusCode(code)) {
            return null;
          }
          return { code };
        }
        let reason = data.subarray(2);
        if (reason[0] === 239 && reason[1] === 187 && reason[2] === 191) {
          reason = reason.subarray(3);
        }
        if (code !== void 0 && !isValidStatusCode(code)) {
          return null;
        }
        try {
          reason = new TextDecoder("utf-8", { fatal: true }).decode(reason);
        } catch {
          return null;
        }
        return { code, reason };
      }
      get closingInfo() {
        return this.#info.closeInfo;
      }
    };
    module2.exports = {
      ByteParser
    };
  }
});

// lib/websocket/websocket.js
var require_websocket = __commonJS({
  "lib/websocket/websocket.js"(exports2, module2) {
    "use strict";
    var { webidl } = require_webidl();
    var { DOMException } = require_constants();
    var { URLSerializer } = require_dataURL();
    var { getGlobalOrigin } = require_global();
    var { staticPropertyDescriptors, states, opcodes, emptyBuffer } = require_constants3();
    var {
      kWebSocketURL,
      kReadyState,
      kController,
      kBinaryType,
      kResponse,
      kSentClose,
      kByteParser
    } = require_symbols3();
    var { isEstablished, isClosing, isValidSubprotocol, failWebsocketConnection, fireEvent } = require_util3();
    var { establishWebSocketConnection } = require_connection();
    var { WebsocketFrameSend } = require_frame();
    var { ByteParser } = require_receiver();
    var { kEnumerableProperty, isBlobLike } = require_util();
    var { getGlobalDispatcher } = require_global2();
    var { types } = require("util");
    var experimentalWarned = false;
    var WebSocket = class extends EventTarget {
      #events = {
        open: null,
        error: null,
        close: null,
        message: null
      };
      #bufferedAmount = 0;
      #protocol = "";
      #extensions = "";
      /**
       * @param {string} url
       * @param {string|string[]} protocols
       */
      constructor(url, protocols = []) {
        super();
        webidl.argumentLengthCheck(arguments, 1, { header: "WebSocket constructor" });
        if (!experimentalWarned) {
          experimentalWarned = true;
          process.emitWarning("WebSockets are experimental, expect them to change at any time.", {
            code: "UNDICI-WS"
          });
        }
        const options = webidl.converters["DOMString or sequence<DOMString> or WebSocketInit"](protocols);
        url = webidl.converters.USVString(url);
        protocols = options.protocols;
        const baseURL = getGlobalOrigin();
        let urlRecord;
        try {
          urlRecord = new URL(url, baseURL);
        } catch (e) {
          throw new DOMException(e, "SyntaxError");
        }
        if (urlRecord.protocol === "http:") {
          urlRecord.protocol = "ws:";
        } else if (urlRecord.protocol === "https:") {
          urlRecord.protocol = "wss:";
        }
        if (urlRecord.protocol !== "ws:" && urlRecord.protocol !== "wss:") {
          throw new DOMException(
            `Expected a ws: or wss: protocol, got ${urlRecord.protocol}`,
            "SyntaxError"
          );
        }
        if (urlRecord.hash || urlRecord.href.endsWith("#")) {
          throw new DOMException("Got fragment", "SyntaxError");
        }
        if (typeof protocols === "string") {
          protocols = [protocols];
        }
        if (protocols.length !== new Set(protocols.map((p) => p.toLowerCase())).size) {
          throw new DOMException("Invalid Sec-WebSocket-Protocol value", "SyntaxError");
        }
        if (protocols.length > 0 && !protocols.every((p) => isValidSubprotocol(p))) {
          throw new DOMException("Invalid Sec-WebSocket-Protocol value", "SyntaxError");
        }
        this[kWebSocketURL] = new URL(urlRecord.href);
        this[kController] = establishWebSocketConnection(
          urlRecord,
          protocols,
          this,
          (response) => this.#onConnectionEstablished(response),
          options
        );
        this[kReadyState] = WebSocket.CONNECTING;
        this[kBinaryType] = "blob";
      }
      /**
       * @see https://websockets.spec.whatwg.org/#dom-websocket-close
       * @param {number|undefined} code
       * @param {string|undefined} reason
       */
      close(code = void 0, reason = void 0) {
        webidl.brandCheck(this, WebSocket);
        if (code !== void 0) {
          code = webidl.converters["unsigned short"](code, { clamp: true });
        }
        if (reason !== void 0) {
          reason = webidl.converters.USVString(reason);
        }
        if (code !== void 0) {
          if (code !== 1e3 && (code < 3e3 || code > 4999)) {
            throw new DOMException("invalid code", "InvalidAccessError");
          }
        }
        let reasonByteLength = 0;
        if (reason !== void 0) {
          reasonByteLength = Buffer.byteLength(reason);
          if (reasonByteLength > 123) {
            throw new DOMException(
              `Reason must be less than 123 bytes; received ${reasonByteLength}`,
              "SyntaxError"
            );
          }
        }
        if (this[kReadyState] === WebSocket.CLOSING || this[kReadyState] === WebSocket.CLOSED) {
        } else if (!isEstablished(this)) {
          failWebsocketConnection(this, "Connection was closed before it was established.");
          this[kReadyState] = WebSocket.CLOSING;
        } else if (!isClosing(this)) {
          const frame = new WebsocketFrameSend();
          if (code !== void 0 && reason === void 0) {
            frame.frameData = Buffer.allocUnsafe(2);
            frame.frameData.writeUInt16BE(code, 0);
          } else if (code !== void 0 && reason !== void 0) {
            frame.frameData = Buffer.allocUnsafe(2 + reasonByteLength);
            frame.frameData.writeUInt16BE(code, 0);
            frame.frameData.write(reason, 2, "utf-8");
          } else {
            frame.frameData = emptyBuffer;
          }
          const socket = this[kResponse].socket;
          socket.write(frame.createFrame(opcodes.CLOSE), (err) => {
            if (!err) {
              this[kSentClose] = true;
            }
          });
          this[kReadyState] = states.CLOSING;
        } else {
          this[kReadyState] = WebSocket.CLOSING;
        }
      }
      /**
       * @see https://websockets.spec.whatwg.org/#dom-websocket-send
       * @param {NodeJS.TypedArray|ArrayBuffer|Blob|string} data
       */
      send(data) {
        webidl.brandCheck(this, WebSocket);
        webidl.argumentLengthCheck(arguments, 1, { header: "WebSocket.send" });
        data = webidl.converters.WebSocketSendData(data);
        if (this[kReadyState] === WebSocket.CONNECTING) {
          throw new DOMException("Sent before connected.", "InvalidStateError");
        }
        if (!isEstablished(this) || isClosing(this)) {
          return;
        }
        const socket = this[kResponse].socket;
        if (typeof data === "string") {
          const value = Buffer.from(data);
          const frame = new WebsocketFrameSend(value);
          const buffer = frame.createFrame(opcodes.TEXT);
          this.#bufferedAmount += value.byteLength;
          socket.write(buffer, () => {
            this.#bufferedAmount -= value.byteLength;
          });
        } else if (types.isArrayBuffer(data)) {
          const value = Buffer.from(data);
          const frame = new WebsocketFrameSend(value);
          const buffer = frame.createFrame(opcodes.BINARY);
          this.#bufferedAmount += value.byteLength;
          socket.write(buffer, () => {
            this.#bufferedAmount -= value.byteLength;
          });
        } else if (ArrayBuffer.isView(data)) {
          const ab = Buffer.from(data, data.byteOffset, data.byteLength);
          const frame = new WebsocketFrameSend(ab);
          const buffer = frame.createFrame(opcodes.BINARY);
          this.#bufferedAmount += ab.byteLength;
          socket.write(buffer, () => {
            this.#bufferedAmount -= ab.byteLength;
          });
        } else if (isBlobLike(data)) {
          const frame = new WebsocketFrameSend();
          data.arrayBuffer().then((ab) => {
            const value = Buffer.from(ab);
            frame.frameData = value;
            const buffer = frame.createFrame(opcodes.BINARY);
            this.#bufferedAmount += value.byteLength;
            socket.write(buffer, () => {
              this.#bufferedAmount -= value.byteLength;
            });
          });
        }
      }
      get readyState() {
        webidl.brandCheck(this, WebSocket);
        return this[kReadyState];
      }
      get bufferedAmount() {
        webidl.brandCheck(this, WebSocket);
        return this.#bufferedAmount;
      }
      get url() {
        webidl.brandCheck(this, WebSocket);
        return URLSerializer(this[kWebSocketURL]);
      }
      get extensions() {
        webidl.brandCheck(this, WebSocket);
        return this.#extensions;
      }
      get protocol() {
        webidl.brandCheck(this, WebSocket);
        return this.#protocol;
      }
      get onopen() {
        webidl.brandCheck(this, WebSocket);
        return this.#events.open;
      }
      set onopen(fn) {
        webidl.brandCheck(this, WebSocket);
        if (this.#events.open) {
          this.removeEventListener("open", this.#events.open);
        }
        if (typeof fn === "function") {
          this.#events.open = fn;
          this.addEventListener("open", fn);
        } else {
          this.#events.open = null;
        }
      }
      get onerror() {
        webidl.brandCheck(this, WebSocket);
        return this.#events.error;
      }
      set onerror(fn) {
        webidl.brandCheck(this, WebSocket);
        if (this.#events.error) {
          this.removeEventListener("error", this.#events.error);
        }
        if (typeof fn === "function") {
          this.#events.error = fn;
          this.addEventListener("error", fn);
        } else {
          this.#events.error = null;
        }
      }
      get onclose() {
        webidl.brandCheck(this, WebSocket);
        return this.#events.close;
      }
      set onclose(fn) {
        webidl.brandCheck(this, WebSocket);
        if (this.#events.close) {
          this.removeEventListener("close", this.#events.close);
        }
        if (typeof fn === "function") {
          this.#events.close = fn;
          this.addEventListener("close", fn);
        } else {
          this.#events.close = null;
        }
      }
      get onmessage() {
        webidl.brandCheck(this, WebSocket);
        return this.#events.message;
      }
      set onmessage(fn) {
        webidl.brandCheck(this, WebSocket);
        if (this.#events.message) {
          this.removeEventListener("message", this.#events.message);
        }
        if (typeof fn === "function") {
          this.#events.message = fn;
          this.addEventListener("message", fn);
        } else {
          this.#events.message = null;
        }
      }
      get binaryType() {
        webidl.brandCheck(this, WebSocket);
        return this[kBinaryType];
      }
      set binaryType(type) {
        webidl.brandCheck(this, WebSocket);
        if (type !== "blob" && type !== "arraybuffer") {
          this[kBinaryType] = "blob";
        } else {
          this[kBinaryType] = type;
        }
      }
      /**
       * @see https://websockets.spec.whatwg.org/#feedback-from-the-protocol
       */
      #onConnectionEstablished(response) {
        this[kResponse] = response;
        const parser = new ByteParser(this);
        parser.on("drain", function onParserDrain() {
          this.ws[kResponse].socket.resume();
        });
        response.socket.ws = this;
        this[kByteParser] = parser;
        this[kReadyState] = states.OPEN;
        const extensions = response.headersList.get("sec-websocket-extensions");
        if (extensions !== null) {
          this.#extensions = extensions;
        }
        const protocol = response.headersList.get("sec-websocket-protocol");
        if (protocol !== null) {
          this.#protocol = protocol;
        }
        fireEvent("open", this);
      }
    };
    WebSocket.CONNECTING = WebSocket.prototype.CONNECTING = states.CONNECTING;
    WebSocket.OPEN = WebSocket.prototype.OPEN = states.OPEN;
    WebSocket.CLOSING = WebSocket.prototype.CLOSING = states.CLOSING;
    WebSocket.CLOSED = WebSocket.prototype.CLOSED = states.CLOSED;
    Object.defineProperties(WebSocket.prototype, {
      CONNECTING: staticPropertyDescriptors,
      OPEN: staticPropertyDescriptors,
      CLOSING: staticPropertyDescriptors,
      CLOSED: staticPropertyDescriptors,
      url: kEnumerableProperty,
      readyState: kEnumerableProperty,
      bufferedAmount: kEnumerableProperty,
      onopen: kEnumerableProperty,
      onerror: kEnumerableProperty,
      onclose: kEnumerableProperty,
      close: kEnumerableProperty,
      onmessage: kEnumerableProperty,
      binaryType: kEnumerableProperty,
      send: kEnumerableProperty,
      extensions: kEnumerableProperty,
      protocol: kEnumerableProperty,
      [Symbol.toStringTag]: {
        value: "WebSocket",
        writable: false,
        enumerable: false,
        configurable: true
      }
    });
    Object.defineProperties(WebSocket, {
      CONNECTING: staticPropertyDescriptors,
      OPEN: staticPropertyDescriptors,
      CLOSING: staticPropertyDescriptors,
      CLOSED: staticPropertyDescriptors
    });
    webidl.converters["sequence<DOMString>"] = webidl.sequenceConverter(
      webidl.converters.DOMString
    );
    webidl.converters["DOMString or sequence<DOMString>"] = function(V) {
      if (webidl.util.Type(V) === "Object" && Symbol.iterator in V) {
        return webidl.converters["sequence<DOMString>"](V);
      }
      return webidl.converters.DOMString(V);
    };
    webidl.converters.WebSocketInit = webidl.dictionaryConverter([
      {
        key: "protocols",
        converter: webidl.converters["DOMString or sequence<DOMString>"],
        get defaultValue() {
          return [];
        }
      },
      {
        key: "dispatcher",
        converter: (V) => V,
        get defaultValue() {
          return getGlobalDispatcher();
        }
      },
      {
        key: "headers",
        converter: webidl.nullableConverter(webidl.converters.HeadersInit)
      }
    ]);
    webidl.converters["DOMString or sequence<DOMString> or WebSocketInit"] = function(V) {
      if (webidl.util.Type(V) === "Object" && !(Symbol.iterator in V)) {
        return webidl.converters.WebSocketInit(V);
      }
      return { protocols: webidl.converters["DOMString or sequence<DOMString>"](V) };
    };
    webidl.converters.WebSocketSendData = function(V) {
      if (webidl.util.Type(V) === "Object") {
        if (isBlobLike(V)) {
          return webidl.converters.Blob(V, { strict: false });
        }
        if (ArrayBuffer.isView(V) || types.isAnyArrayBuffer(V)) {
          return webidl.converters.BufferSource(V);
        }
      }
      return webidl.converters.USVString(V);
    };
    module2.exports = {
      WebSocket
    };
  }
});

// index-fetch.js
var fetchImpl = require_fetch().fetch;
module.exports.fetch = async function fetch(resource, init = void 0) {
  try {
    return await fetchImpl(resource, init);
  } catch (err) {
    Error.captureStackTrace(err, this);
    throw err;
  }
};
module.exports.FormData = require_formdata().FormData;
module.exports.Headers = require_headers().Headers;
module.exports.Response = require_response().Response;
module.exports.Request = require_request().Request;
module.exports.WebSocket = require_websocket().WebSocket;
/*! formdata-polyfill. MIT License. Jimmy Wärting <https://jimmy.warting.se/opensource> */
/*! ws. MIT License. Einar Otto Stangvik <einaros@gmail.com> */
