<%
'#################################################################################
'## Copyright (C) 2000  Michael Anderson and Pierre Gorissen
'## 
'## This program is free software; you can redistribute it and/or
'## modify it under the terms of the GNU General Public License
'## as published by the Free Software Foundation; either version 2
'## of the License, or any later version.
'##
'## All copyright notices regarding Snitz Forums 2000
'## must remain intact in the scripts and in the outputted HTML
'## The "powered by" text/logo with a link back to 
'## http://forum.snitz.com in the footer of the pages MUST
'## remain visible when the pages are viewed on the internet or intranet.
'## 
'## This program is distributed in the hope that it will be useful,
'## but WITHOUT ANY WARRANTY; without even the implied warranty of
'## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'## GNU General Public License for more details.
'## 
'## You should have received a copy of the GNU General Public License
'## along with this program; if not, write to the Free Software
'## Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'## 
'## Support can be obtained from support forums at:
'## http://forum.snitz.com 
'##
'## Correspondence and Marketing Questions can be sent to:
'## reinhold@bigfoot.com
'## 
'## or
'## 
'## Snitz Communications 
'## C/O: Michael Anderson
'## PO Box 200
'## Harpswell, ME 04079
'#################################################################################
'#################################################################################
'# Photo Album Mod by Wesley Brown
'# Copyright 2002 (C) Wesley Brown
'# This program is free software; you can redistribute it and/or
'# modify it under the terms of the GNU General Public License
'# as published by the Free Software Foundation; either version 2
'# of the License, or any later version.
'#
'# This program is distributed in the hope that it will be useful,
'# but WITHOUT ANY WARRANTY; without even the implied warranty of
'# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'# GNU General Public License for more details.
'# 
'# You should have received a copy of the GNU General Public License
'# along with this program; if not, write to the Free Software
'# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'#
'# This is a spin off of my stand alone photo album
'# just copy this file into your forums directory
'# This is the admin page
'# E-Mail me at: burthold@yahoo.com if you have any questions
'#################################################################################
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
':::                                                             :::
':::  This routine will attempt to identify any filespec passed  :::
':::  as a graphic file (regardless of the extension). This will :::
':::  work with BMP, GIF, JPG and PNG files.                     :::
':::                                                             :::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
':::          Based on ideas presented by David Crowell          :::
':::                   (credit where due)                        :::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
'::: blah blah blah blah blah blah blah blah blah blah blah blah :::
'::: blah blah blah blah blah blah blah blah blah blah blah blah :::
'::: blah blah     Copyright *c* MM,  Mike Shaffer     blah blah :::
'::: blah blah      ALL RIGHTS RESERVED WORLDWIDE      blah blah :::
'::: blah blah  Permission is granted to use this code blah blah :::
'::: blah blah   in your projects, as long as this     blah blah :::
'::: blah blah      copyright notice is included       blah blah :::
'::: blah blah blah blah blah blah blah blah blah blah blah blah :::
'::: blah blah blah blah blah blah blah blah blah blah blah blah :::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
':::                                                             :::
':::  This function gets a specified number of bytes from any    :::
':::  file, starting at the offset (base 1)                      :::
':::                                                             :::
':::  Passed:                                                    :::
':::       flnm        => Filespec of file to read               :::
':::       offset      => Offset at which to start reading       :::
':::       bytes       => How many bytes to read                 :::
':::                                                             :::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
function GetBytes(flnm, offset, bytes)
	Dim objFSO
	Dim objFTemp
	Dim objTextStream
	Dim lngSize
	'on error resume next
	
	Set objFSO = CreateObject("Scripting.FileSystemObject") 
	' First, we get the filesize
	
	Set objFTemp = objFSO.GetFile(flnm)
	lngSize = objFTemp.Size
	
	set objFTemp = nothing
	
	fsoForReading = 1
	
	Set objTextStream = objFSO.OpenTextFile(flnm, fsoForReading)
	if offset > 0 then
		strBuff = objTextStream.Read(offset - 1)
	end if
	
	if bytes = -1 then
	' Get All!
		GetBytes = objTextStream.Read(lngSize)
	'ReadAll
	else
		GetBytes = objTextStream.Read(bytes)
	end if
	
	objTextStream.Close 
	
	set objTextStream = nothing 
	set objFSO = nothing
	
end function 

':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
':::                                                             :::
':::  Functions to convert two bytes to a numeric value (long)   :::
':::  (both little-endian and big-endian)                        :::
':::                                                             :::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
function lngConvert(strTemp)
	lngConvert = clng(asc(left(strTemp, 1)) + ((asc(right(strTemp, 1)) * 256)))
end function

function lngConvert2(strTemp)
	lngConvert2 = clng(asc(right(strTemp, 1)) + ((asc(left(strTemp, 1)) * 256)))
end function

':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
':::                                                             :::
':::  This function does most of the real work. It will attempt  :::
':::  to read any file, regardless of the extension, and will    :::
':::  identify if it is a graphical image.                       :::
':::                                                             :::
':::  Passed:                                                    :::
':::       flnm        => Filespec of file to read               :::
':::       width       => width of image                         :::
':::       height      => height of image                        :::
':::       depth       => color depth (in number of colors)      :::
':::       strImageType=> type of image (e.g. GIF, BMP, etc.)    :::
':::                                                             :::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
function gfxSpex(flnm, width, height, depth, strImageType)
	dim strPNG
	dim strGIF
	dim strBMP
	dim strType
	strType = ""
	strImageType = "(unknown)"
	gfxSpex = False
	strPNG = chr(137) & chr(80) & chr(78)
	strGIF = "GIF"
	strBMP = chr(66) & chr(77)
	strType = GetBytes(flnm,0, 3)
	
	if strType = strGIF then
		' is GIF
		strImageType = "GIF"
		Width = lngConvert(GetBytes(flnm, 7, 2))
		Height = lngConvert(GetBytes(flnm, 9, 2))
		Depth = 2 ^ ((asc(GetBytes(flnm, 11, 1)) and 7) + 1)
		gfxSpex = True
	elseif left(strType, 2) = strBMP then
		' is BMP
		strImageType = "BMP"
		Width = lngConvert(GetBytes(flnm, 19, 2))
		Height = lngConvert(GetBytes(flnm, 23, 2))
		Depth = 2 ^ (asc(GetBytes(flnm, 29, 1)))
		gfxSpex = True
	elseif strType = strPNG then
		' Is PNG
		strImageType = "PNG"
		Width = lngConvert2(GetBytes(flnm, 19, 2))
		Height = lngConvert2(GetBytes(flnm, 23, 2))
		Depth = getBytes(flnm, 25, 2)
		select case asc(right(Depth,1))
		case 0
		Depth = 2 ^ (asc(left(Depth, 1)))
		gfxSpex = True
		case 2
		Depth = 2 ^ (asc(left(Depth, 1)) * 3)
		gfxSpex = True
		case 3
		Depth = 2 ^ (asc(left(Depth, 1)))
		'8
		gfxSpex = True
		case 4
		Depth = 2 ^ (asc(left(Depth, 1)) * 2)
		gfxSpex = True
		case 6
		Depth = 2 ^ (asc(left(Depth, 1)) * 4)
		gfxSpex = True
		case else
		Depth = -1
		end select
		else
		strBuff = GetBytes(flnm, 0, -1)
		' Get all bytes from file
		lngSize = len(strBuff)
		flgFound = 0
		strTarget = chr(255) & chr(216) & chr(255)
		flgFound = instr(strBuff, strTarget)
		if flgFound = 0 then
		exit function
	end if
	strImageType = "JPG"
	lngPos = flgFound + 2
	ExitLoop = false
	do while ExitLoop = False and lngPos < lngSize
	do while asc(mid(strBuff, lngPos, 1)) = 255 and lngPos < lngSize
	lngPos = lngPos + 1
	loop
	if asc(mid(strBuff, lngPos, 1)) < 192 or asc(mid(strBuff, lngPos, 1)) > 195 then
	lngMarkerSize = lngConvert2(mid(strBuff, lngPos + 1, 2))
	lngPos = lngPos + lngMarkerSize  + 1
	else
	ExitLoop = True
	end if
	loop
	'
	if ExitLoop = False then
	Width = -1
	Height = -1
	Depth = -1
	else
	Height = lngConvert2(mid(strBuff, lngPos + 4, 2))
	Width = lngConvert2(mid(strBuff, lngPos + 6, 2))
	Depth = 2 ^ (asc(mid(strBuff, lngPos + 8, 1)) * 8)
	gfxSpex = True
	end if
	end if
end function

function SQLparse(s)
'*********************************************
'* This just does a charater replacement on my
'* insert and update sections
'* so I don't blow up the database.
'*********************************************
	dim tmp
	
	tmp = s
	
	tmp = replace(tmp, "", "'")
	tmp = replace(tmp, "`", "'")
	tmp = replace(tmp, "''", "'")
	tmp = replace(tmp, "'", "''")
	SQLparse = tmp
'SQLparse end
end function

function MySQLinsert(s)
'*********************************************
'* This just does a charater replacement on my
'* insert and update sections
'* so I don't blow up the database for MySQL.
'*********************************************
	dim tmp
	
	tmp = s
	
	tmp = replace(tmp, "\", "/")

	MySQLinsert = tmp
end function

function MySQLread(s)
'**********************************************
'* This just does a charater replacement on my
'* reads from a MySQL database to correct for 
'* the insert string. Effects things like paths
'**********************************************
	dim tmp
	
	tmp = s
	
	tmp = replace(tmp, "/", "\")

	MySQLread = tmp
end function

function validate_input( input )
'**********************************************
'*This looks at the string provided and sees if 
'*there are any illegal characters. This is to
'*keep mean people from using common attacks
'*on your database. This by no means makes this
'*application completely secure.
'**********************************************
	good_chars =" ._-':/\!@#$%abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"
	validate_input = true
	for i = 1 to len( input )
		c = mid( input, i, 1 )
		if ( InStr( good_chars, c ) = 0 ) then
			validate_input = false
			exit function
		end if
	next
end function

function validate_string( input )
'***************************************************
'*This looks at the string provided and sees if 
'*there are any illegal words or strings. This is to
'* is to keep mean people from using common attacks
'*on your database. This by no means makes this
'*application completely secure.
'***************************************************
	known_bad = array("delete","--",";")
	validate_string = true
	for i = lbound( known_bad ) to ubound( known_bad )
		if ( instr( 1, input, known_bad(i), vbtextcompare ) <> 0 ) then
			validate_string = false
			exit function
		end if
	next
end function
%>