﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.Azure.WebJobs.Host;

namespace TestAzureFunction
{
    internal class AzureFunctionService : IFunctionInvocationFilter, IFunctionExceptionFilter
    {
        readonly IHttpContextAccessor                                       httpContextAccessor_;

        public AzureFunctionService (IHttpContextAccessor httpContextAccessor)
        {
            httpContextAccessor_ = httpContextAccessor;
        }

        public Task OnExecutingAsync (FunctionExecutingContext context, CancellationToken cancellationToken)
        {
            //context.Logger.LogInformation ($"---- LOG: Executing function {context.FunctionName} ----");
            return Task.CompletedTask;
        }

        // This is called even on exception
        public Task OnExecutedAsync (FunctionExecutedContext context, CancellationToken cancellationToken)
        {
            //context.Logger.LogInformation ($"---- LOG: Executed function {context.FunctionName} ----");
            return Task.CompletedTask;
        }

        public Task OnExceptionAsync (FunctionExceptionContext exceptionContext, System.Threading.CancellationToken cancellationToken)
        {
            HttpContext http = httpContextAccessor_.HttpContext;

            http.Response.StatusCode  = StatusCodes.Status401Unauthorized;
            http.Response.ContentType = "text/html; charset=UTF-8";

            return http.Response.WriteAsync ("UnAuthorized");
        }
    }
}
