#pragma once

#include <cassert>
#include <Windows.h>

namespace Keyboard
{
	bool																	keyPressed_ [256] = { false };	// to track if Input is pressed

	class KeyboardInput
	{
	public:

		//@@ Call once per game loop
		static void															ReadKeyboardPerFrame ()
		{
			bool keyCurrent [256] = { 0 };

			//VK_ESCAPE;

			// retrieve all the keys
			for (int i = 0; i < 256; ++i)
				keyCurrent [i] = 0 != GetAsyncKeyState (i);


			for (int i = 0; i < 256; ++i)
				if (keyPressed_ [i])
					keyPressed_ [i] = keyCurrent [i];
		}

		//@@ Invalidates held keys. Useful when entering a new game state or before playing cut scenes
		static void															ResetKeyboard ()
		{
			memset (keyPressed_, false, sizeof (keyPressed_));
		}

		// keyboard control
		//@@ Returns true if any key is pressed
		static bool															IsAnyKeyPressedOnce ()
		{
			for (int i = 0; i < 256; ++i)
			{
				if (!keyPressed_ [i] && GetAsyncKeyState (i))
				{
					keyPressed_ [i] = true;
					return true;
				}
			}
			return false;
		}

		//@@ Returns true only once until the user releases the key. Use with Reset to invalidate.
		static bool															IsKeyPressedOnce (char key)
		{
			assert (0 <= key);
			assert (255 >= key);

			if (!keyPressed_ [key] && GetAsyncKeyState (key))
			{
				keyPressed_ [key] = true;
				return true;
			}
			return false;
		}

		static bool															IsKeyPressDown (char key) { return GetAsyncKeyState (key); }
	};
}