﻿Var strInstallerCustomVersionPreInstall

!macro CustomCodePreInstall
	${If} ${FileExists} "$INSTDIR\App\AppInfo\appinfo.ini" 
		ReadINIStr $strInstallerCustomVersionPreInstall "$INSTDIR\App\AppInfo\appinfo.ini" "Version" "PackageVersion"
		${If} ${FileExists} "$INSTDIR\Data\profile\*.*"
			${VersionCompare} $strInstallerCustomVersionPreInstall "116.0.0.0" $R0
			${If} $R0 == 2
				ReadRegStr $0 HKLM "Software\Microsoft\Windows NT\CurrentVersion" "CurrentBuild"
				${If} $0 < 10000
					;Windows 7/8/8.1
					${GetParent} $INSTDIR $1
					${IfNot} ${FileExists} "$1\ThunderbirdPortableLegacy115\*.*"
						CreateDirectory "$1\ThunderbirdPortableLegacy115"
						CopyFiles /SILENT "$INSTDIR\*.*" "$1\ThunderbirdPortableLegacy115"
						WriteINIStr "$1\ThunderbirdPortableLegacy115\App\AppInfo\AppInfo.ini" "Details" "AppID" "ThunderbirdPortableLegacy115"
						WriteINIStr "$1\ThunderbirdPortableLegacy115\App\AppInfo\AppInfo.ini" "Details" "Name" "Thunderbird, Portable Edition (Legacy 115)"
						WriteINIStr "$1\ThunderbirdPortableLegacy115\App\AppInfo\AppInfo.ini" "Control" "BaseAppID" "ThunderbirdPortableLegacy115"
					${EndIf}
				${EndIf}	
			${EndIf}
		${EndIf}
	${EndIf}
!macroend

!macro CustomCodePostInstall
	CreateDirectory "$INSTDIR\Data\settings"
	WriteINIStr "$INSTDIR\Data\settings\ThunderbirdPortableSettings.ini" "ThunderbirdPortableSettings" "AgreedToLicense" "YES"
	
	${If} ${FileExists} "$INSTDIR\Data\profile\*.*"
		${VersionCompare} $strInstallerCustomVersionPreInstall "78.6.1.0" $R0
		${If} $R0 == 2
			Delete "$INSTDIR\Data\settings\update-config.json"
			CopyFiles /SILENT "$INSTDIR\App\DefaultData\settings\update-config.json" "$INSTDIR\Data\settings"
		${EndIf}
	${EndIf}
!macroend